/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SolutionSetStatserator;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.sparql.ast.explainhints.ExplainHints;
import com.bigdata.rdf.sparql.ast.optimizers.ASTBottomUpOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTWildcardProjectionOptimizer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.HashSet;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTBottomUpOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTBottomUpOptimizer() {
    }

    public TestASTBottomUpOptimizer(String name) {
        super(name);
    }

    public void test_bottomUpOptimizer_nested_optionals_1() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    :x1 :p ?v . \n    OPTIONAL {      :x3 :q ?w . \n      OPTIONAL { :x2 :p ?v  } \n    } \n}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI x1 = f.createURI("http://example/x1");
        BigdataURI x2 = f.createURI("http://example/x2");
        BigdataURI x3 = f.createURI("http://example/x3");
        BigdataURI p = f.createURI("http://example/p");
        BigdataURI q = f.createURI("http://example/q");
        BigdataValue[] values = new BigdataValue[]{x1, x2, x3, p, q};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    :x1 :p ?v . \n    OPTIONAL {      :x3 :q ?w . \n      OPTIONAL { :x2 :p ?v  } \n    } \n}", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        TestASTBottomUpOptimizer.assertNotNull((String)"did not rewrite query", (Object)namedSubqueries);
        TestASTBottomUpOptimizer.assertEquals((int)1, (int)namedSubqueries.size());
        String namedSet = ASTBottomUpOptimizer.NAMED_SET_PREFIX + "0";
        NamedSubqueryRoot expectedNSR = new NamedSubqueryRoot(QueryType.SELECT, namedSet);
        JoinGroupNode modifiedClause = new JoinGroupNode();
        ProjectionNode projection = new ProjectionNode();
        expectedNSR.setProjection(projection);
        projection.addProjectionVar(new VarNode("w"));
        projection.addProjectionVar(new VarNode("v"));
        JoinGroupNode liftedClause = new JoinGroupNode(true);
        JoinGroupNode innerClause = new JoinGroupNode(true);
        liftedClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((Object)x3.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)q.getIV())), (TermNode)new VarNode("w"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        liftedClause.addChild((IGroupMemberNode)innerClause);
        innerClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((Object)x2.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new VarNode("v"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expectedNSR.setWhereClause((GraphPatternGroup)liftedClause);
        modifiedClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((Object)x1.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new VarNode("v"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        modifiedClause.addChild((IGroupMemberNode)new JoinGroupNode(true, (IGroupMemberNode)new NamedSubqueryInclude(namedSet)));
        NamedSubqueryRoot nsr = (NamedSubqueryRoot)namedSubqueries.get(0);
        TestASTBottomUpOptimizer.assertEquals((String)"liftedClause", (Object)expectedNSR, (Object)nsr);
        TestASTBottomUpOptimizer.assertEquals((String)"modifiedClause", (Object)modifiedClause, (Object)queryRoot.getWhereClause());
    }

    public void test_bottomUpOptimizer_nested_optionals_1_correctRejection() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    :x1 :p ?v . \n    OPTIONAL {      :x3 :q ?w . \n      OPTIONAL { :x2 :p ?v  } \n    } \n}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI x1 = f.createURI("http://example/x1");
        BigdataURI x2 = f.createURI("http://example/x2");
        BigdataURI x3 = f.createURI("http://example/x3");
        BigdataURI p = f.createURI("http://example/p");
        BigdataURI q = f.createURI("http://example/q");
        BigdataURI c1 = f.createURI("http://example/c1");
        BigdataURI c2 = f.createURI("http://example/c2");
        BigdataValue[] values = new BigdataValue[]{x1, x2, x3, p, q, c1, c2};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    :x1 :p ?v . \n    OPTIONAL {      :x3 :q ?w . \n      OPTIONAL { :x2 :p ?v  } \n    } \n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        Var v = Var.var((String)"v");
        IBindingSet[] bindingSets = new IBindingSet[]{new ListBindingSet(new IVariable[]{v}, new IConstant[]{new Constant((Object)c1.getIV())}), new ListBindingSet(new IVariable[]{v}, new IConstant[]{new Constant((Object)c1.getIV())})};
        QueryRoot queryRoot = astContainer.getOriginalAST();
        context.setSolutionSetStats(SolutionSetStatserator.get((IBindingSet[])bindingSets));
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, bindingSets)).getQueryNode();
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, bindingSets)).getQueryNode();
        TestASTBottomUpOptimizer.assertNull((String)"should not have rewritten the query", (Object)queryRoot.getNamedSubqueries());
    }

    public void test_bottomUpOptimizer_filter_scope_1() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    :x :p ?v . \n    { :x :q ?w \n      OPTIONAL {  :x :p ?v2 FILTER(?v = 1) } \n    } \n}";
        String unboundVarName = "-unbound-var-v-1";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI x = f.createURI("http://example/x");
        BigdataURI p = f.createURI("http://example/p");
        BigdataURI q = f.createURI("http://example/q");
        BigdataLiteral ONE = f.createLiteral("1", XSD.INTEGER);
        BigdataValue[] values = new BigdataValue[]{x, p, q, ONE};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    :x :p ?v . \n    { :x :q ?w \n      OPTIONAL {  :x :p ?v2 FILTER(?v = 1) } \n    } \n}", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        ExplainHints.removeExplainHintAnnotationsFromBOp((BOp)queryRoot);
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        TestASTBottomUpOptimizer.assertNotNull((String)"did not rewrite query", (Object)namedSubqueries);
        TestASTBottomUpOptimizer.assertEquals((int)1, (int)namedSubqueries.size());
        String namedSet = ASTBottomUpOptimizer.NAMED_SET_PREFIX + "0";
        NamedSubqueryRoot expectedNSR = new NamedSubqueryRoot(QueryType.SELECT, namedSet);
        JoinGroupNode modifiedClause = new JoinGroupNode();
        ProjectionNode projection = new ProjectionNode();
        expectedNSR.setProjection(projection);
        projection.addProjectionVar(new VarNode("w"));
        projection.addProjectionVar(new VarNode("v2"));
        JoinGroupNode liftedClause = new JoinGroupNode();
        JoinGroupNode innerClause = new JoinGroupNode(true);
        liftedClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((Object)x.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)q.getIV())), (TermNode)new VarNode("w"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        liftedClause.addChild((IGroupMemberNode)innerClause);
        innerClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((Object)x.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new VarNode("v2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        FilterNode filterNode = new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("-unbound-var-v-1"), new ConstantNode((IConstant)new Constant((Object)ONE.getIV()))}));
        GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
        AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)filterNode.getValueExpressionNode());
        innerClause.addChild((IGroupMemberNode)filterNode);
        expectedNSR.setWhereClause((GraphPatternGroup)liftedClause);
        modifiedClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((Object)x.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new VarNode("v"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        modifiedClause.addChild((IGroupMemberNode)new NamedSubqueryInclude(namedSet));
        NamedSubqueryRoot nsr = (NamedSubqueryRoot)namedSubqueries.get(0);
        TestASTBottomUpOptimizer.diff((BOp)expectedNSR, (BOp)nsr);
        TestASTBottomUpOptimizer.diff((BOp)modifiedClause, (BOp)queryRoot.getWhereClause());
    }

    public void test_bottomUpOptimizer_join_scope_1() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    {?Y :name \"george\" . OPTIONAL { ?X :email ?Z } } \n}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI name = f.createURI("http://example/name");
        BigdataURI email = f.createURI("http://example/email");
        BigdataLiteral paul = f.createLiteral("paul");
        BigdataLiteral george = f.createLiteral("george");
        BigdataValue[] values = new BigdataValue[]{name, email, paul, george};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    {?Y :name \"george\" . OPTIONAL { ?X :email ?Z } } \n}", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
        TestASTBottomUpOptimizer.assertNotNull((Object)namedSubqueries);
        TestASTBottomUpOptimizer.assertEquals((int)1, (int)namedSubqueries.size());
        String namedSet = ASTBottomUpOptimizer.NAMED_SET_PREFIX + "0";
        NamedSubqueryRoot expectedNSR = new NamedSubqueryRoot(QueryType.SELECT, namedSet);
        JoinGroupNode modifiedClause = new JoinGroupNode();
        ProjectionNode projection = new ProjectionNode();
        expectedNSR.setProjection(projection);
        projection.addProjectionVar(new VarNode("Y"));
        projection.addProjectionVar(new VarNode("X"));
        projection.addProjectionVar(new VarNode("Z"));
        JoinGroupNode liftedClause = new JoinGroupNode();
        JoinGroupNode innerClause = new JoinGroupNode(true);
        liftedClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("Y"), (TermNode)new ConstantNode((IConstant)new Constant((Object)name.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)george.getIV())), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        liftedClause.addChild((IGroupMemberNode)innerClause);
        innerClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("X"), (TermNode)new ConstantNode((IConstant)new Constant((Object)email.getIV())), (TermNode)new VarNode("Z"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expectedNSR.setWhereClause((GraphPatternGroup)liftedClause);
        modifiedClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("X"), (TermNode)new ConstantNode((IConstant)new Constant((Object)name.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)paul.getIV())), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        modifiedClause.addChild((IGroupMemberNode)new NamedSubqueryInclude(namedSet));
        NamedSubqueryRoot nsr = (NamedSubqueryRoot)namedSubqueries.get(0);
        TestASTBottomUpOptimizer.assertEquals((String)"liftedClause", (Object)expectedNSR, (Object)nsr);
        TestASTBottomUpOptimizer.assertEquals((String)"modifiedClause", (Object)modifiedClause, (Object)queryRoot.getWhereClause());
    }

    public void test_wellDesigned01() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    {?X :name \"george\" . OPTIONAL { ?X :email ?Z } } \n}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI name = f.createURI("http://example/name");
        BigdataURI email = f.createURI("http://example/email");
        BigdataLiteral paul = f.createLiteral("paul");
        BigdataLiteral george = f.createLiteral("george");
        BigdataValue[] values = new BigdataValue[]{name, email, paul, george};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    {?X :name \"george\" . OPTIONAL { ?X :email ?Z } } \n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        QueryRoot expected = (QueryRoot)BOpUtility.deepCopy((BOp)queryRoot);
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTBottomUpOptimizer.assertEquals((Object)expected, (Object)queryRoot);
    }

    public void test_wellDesigned02() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    OPTIONAL {?X :name \"george\" . ?X :email ?Z } \n}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI name = f.createURI("http://example/name");
        BigdataURI email = f.createURI("http://example/email");
        BigdataLiteral paul = f.createLiteral("paul");
        BigdataLiteral george = f.createLiteral("george");
        BigdataValue[] values = new BigdataValue[]{name, email, paul, george};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    OPTIONAL {?X :name \"george\" . ?X :email ?Z } \n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        QueryRoot expected = (QueryRoot)BOpUtility.deepCopy((BOp)queryRoot);
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTBottomUpOptimizer.assertEquals((Object)expected, (Object)queryRoot);
    }

    public void test_wellDesigned03() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    OPTIONAL {?X :name \"george\" } OPTIONAL { ?X :email ?Z } \n}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI name = f.createURI("http://example/name");
        BigdataURI email = f.createURI("http://example/email");
        BigdataLiteral paul = f.createLiteral("paul");
        BigdataLiteral george = f.createLiteral("george");
        BigdataValue[] values = new BigdataValue[]{name, email, paul, george};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    OPTIONAL {?X :name \"george\" } OPTIONAL { ?X :email ?Z } \n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        QueryRoot expected = (QueryRoot)BOpUtility.deepCopy((BOp)queryRoot);
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTBottomUpOptimizer.assertEquals((Object)expected, (Object)queryRoot);
    }

    public void test_illDesignedOptUnionCombo() throws MalformedQueryException {
        String queryStr = "SELECT * WHERE {  ?s <http://example/p1> ?o1 .   { ?s <http://p2> ?o2 }   UNION   {     ?s <http://p3> ?o3 .     OPTIONAL { ?s <http://p1> ?o1 }   }}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI p1 = f.createURI("http://example/p1");
        BigdataURI p2 = f.createURI("http://example/p2");
        BigdataURI p3 = f.createURI("http://example/p3");
        BigdataValue[] values = new BigdataValue[]{p1, p2, p3};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(queryStr, this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        Iterator itr = BOpUtility.visitAll((BOp)queryRoot.getWhereClause(), NamedSubqueryInclude.class);
        TestASTBottomUpOptimizer.assertTrue((boolean)itr.hasNext());
        Assert.assertThat(null, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not(itr.next())));
        TestASTBottomUpOptimizer.assertFalse((boolean)itr.hasNext());
    }

    public void test_bottomUpOptimizer_filter_nested_2() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . { FILTER(?v = 1) } }";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI x = f.createURI("http://example/x");
        BigdataURI p = f.createURI("http://example/p");
        BigdataLiteral ONE = f.createLiteral("1", XSD.INTEGER);
        BigdataValue[] values = new BigdataValue[]{x, p, ONE};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . { FILTER(?v = 1) } }", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        ExplainHints.removeExplainHintAnnotationsFromBOp((BOp)queryRoot);
        JoinGroupNode expectedWhereClause = new JoinGroupNode();
        expectedWhereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((Object)x.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new VarNode("v"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode innerGroup = new JoinGroupNode();
        expectedWhereClause.addChild((IGroupMemberNode)innerGroup);
        String anonvar = "-unbound-var-v-0";
        FilterNode filterNode = new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("-unbound-var-v-0"), new ConstantNode(ONE.getIV())}));
        GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
        AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)filterNode.getValueExpressionNode());
        innerGroup.addChild((IGroupMemberNode)filterNode);
        TestASTBottomUpOptimizer.diff((BOp)expectedWhereClause, (BOp)queryRoot.getWhereClause());
    }

    public void test_bottomUpOptimizer_filter_nested_2_withBindings() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . { FILTER(?v = \"x\") } }";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI x = f.createURI("http://example/x");
        BigdataURI p = f.createURI("http://example/p");
        BigdataValue[] values = new BigdataValue[]{x, p};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . { FILTER(?v = \"x\") } }", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        QueryRoot expected = (QueryRoot)BOpUtility.deepCopy((BOp)queryRoot);
        IBindingSet[] bindingSets = new IBindingSet[]{new ListBindingSet(new IVariable[]{Var.var((String)"v")}, new IConstant[]{new Constant((Object)x.getIV())})};
        HashSet<Var> globallyScopedVars = new HashSet<Var>();
        globallyScopedVars.add(Var.var((String)"v"));
        context.setSolutionSetStats(SolutionSetStatserator.get((IBindingSet[])bindingSets));
        context.setGloballyScopedVariables(globallyScopedVars);
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, bindingSets)).getQueryNode();
        TestASTBottomUpOptimizer.diff((BOp)expected, (BOp)queryRoot);
    }

    public void test_bottomUpOptimizer_filter_unboundVar() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . FILTER(?w = 1) }";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI x = f.createURI("http://example/x");
        BigdataURI p = f.createURI("http://example/p");
        BigdataLiteral ONE = f.createLiteral("1", XSD.INTEGER);
        BigdataValue[] values = new BigdataValue[]{x, p, ONE};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . FILTER(?w = 1) }", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        ExplainHints.removeExplainHintAnnotationsFromBOp((BOp)queryRoot);
        JoinGroupNode expectedWhereClause = new JoinGroupNode();
        expectedWhereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((Object)x.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new VarNode("v"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        String anonvar = "-unbound-var-w-0";
        FilterNode filterNode = new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("-unbound-var-w-0"), new ConstantNode(ONE.getIV())}));
        GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
        AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)filterNode.getValueExpressionNode());
        expectedWhereClause.addChild((IGroupMemberNode)filterNode);
        TestASTBottomUpOptimizer.diff((BOp)expectedWhereClause, (BOp)queryRoot.getWhereClause());
    }

    public void test_opt_filter_1() throws Exception {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    :x :p ?v . \n    OPTIONAL \n    {      :y :q ?w . \n      FILTER(?v=2) \n    } \n}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI x = f.createURI("http://example/x");
        BigdataURI y = f.createURI("http://example/y");
        BigdataURI p = f.createURI("http://example/p");
        BigdataURI q = f.createURI("http://example/q");
        BigdataValue[] values = new BigdataValue[]{x, y, p, q};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    :x :p ?v . \n    OPTIONAL \n    {      :y :q ?w . \n      FILTER(?v=2) \n    } \n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        QueryRoot expected = (QueryRoot)BOpUtility.deepCopy((BOp)queryRoot);
        queryRoot = (QueryRoot)new ASTBottomUpOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTBottomUpOptimizer.diff((BOp)expected, (BOp)queryRoot);
    }

    public void test_minus_sharedVariables() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("n"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("n")));
        JoinGroupNode minusGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)minusGroup);
        minusGroup.setMinus(true);
        minusGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("n")));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("a"));
        projection2.addProjectionVar(new VarNode("n"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("n")));
        JoinGroupNode minusGroup2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)minusGroup2);
        minusGroup2.setMinus(true);
        minusGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("n")));
        ASTBottomUpOptimizer rewriter = new ASTBottomUpOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTBottomUpOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_minus_noSharedVariables() {
        IBindingSet[] bsets = new IBindingSet[]{};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        JoinGroupNode minusGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)minusGroup);
        minusGroup.setMinus(true);
        minusGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("z"), (TermNode)new VarNode("x"), (TermNode)new VarNode("y")));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        ASTBottomUpOptimizer rewriter = new ASTBottomUpOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        ExplainHints.removeExplainHintAnnotationsFromBOp((BOp)actual);
        TestASTBottomUpOptimizer.assertSameAST((IQueryNode)expected, actual);
    }
}

