/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataStatementImpl;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTConstructOptimizer;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import java.util.Arrays;
import org.openrdf.model.Statement;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTConstructOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTConstructOptimizer() {
    }

    public TestASTConstructOptimizer(String name) {
        super(name);
    }

    public void test_construct_rewrite() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataURI dcURI = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel, dcURI};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode = new ConstructNode();
        queryRoot.setConstruct(constructNode);
        ConstantNode term0 = new ConstantNode(dcURI.getIV());
        VarNode p0a = new VarNode("p0a");
        VarNode p0b = new VarNode("p0b");
        VarNode o0 = new VarNode("o0");
        VarNode s0 = new VarNode("s0");
        constructNode.addChild(new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0));
        constructNode.addChild(new StatementPatternNode((TermNode)s0, (TermNode)p0b, (TermNode)term0));
        VarNode term1 = new VarNode("x");
        VarNode p1a = new VarNode("p1a");
        VarNode p1b = new VarNode("p1b");
        VarNode o1 = new VarNode("o1");
        VarNode s1 = new VarNode("s1");
        constructNode.addChild(new StatementPatternNode((TermNode)term1, (TermNode)p1a, (TermNode)o1));
        constructNode.addChild(new StatementPatternNode((TermNode)s1, (TermNode)p1b, (TermNode)term1));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s0, (TermNode)p0b, (TermNode)term0)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term1, (TermNode)p1a, (TermNode)o1)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s1, (TermNode)p1b, (TermNode)term1)));
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode2 = new ConstructNode();
        expected.setConstruct(constructNode2);
        ConstantNode term02 = new ConstantNode(dcURI.getIV());
        VarNode p0a2 = new VarNode("p0a");
        VarNode p0b2 = new VarNode("p0b");
        VarNode o02 = new VarNode("o0");
        VarNode s02 = new VarNode("s0");
        constructNode2.addChild(new StatementPatternNode((TermNode)term02, (TermNode)p0a2, (TermNode)o02));
        constructNode2.addChild(new StatementPatternNode((TermNode)s02, (TermNode)p0b2, (TermNode)term02));
        VarNode term12 = new VarNode("x");
        VarNode p1a2 = new VarNode("p1a");
        VarNode p1b2 = new VarNode("p1b");
        VarNode o12 = new VarNode("o1");
        VarNode s12 = new VarNode("s1");
        constructNode2.addChild(new StatementPatternNode((TermNode)term12, (TermNode)p1a2, (TermNode)o12));
        constructNode2.addChild(new StatementPatternNode((TermNode)s12, (TermNode)p1b2, (TermNode)term12));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        UnionNode union2 = new UnionNode();
        whereClause2.addChild((IGroupMemberNode)union2);
        union2.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term02, (TermNode)p0a2, (TermNode)o02)));
        union2.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s02, (TermNode)p0b2, (TermNode)term02)));
        union2.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term12, (TermNode)p1a2, (TermNode)o12)));
        union2.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s12, (TermNode)p1b2, (TermNode)term12)));
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.setReduced(true);
        projection.addProjectionVar(p0a2);
        projection.addProjectionVar(p0b2);
        projection.addProjectionVar(s02);
        projection.addProjectionVar(o02);
        projection.addProjectionVar(term12);
        projection.addProjectionVar(p1a2);
        projection.addProjectionVar(p1b2);
        projection.addProjectionVar(s12);
        projection.addProjectionVar(o12);
        Object[] args = projection.args().toArray(new BOp[0]);
        Arrays.sort(args);
        projection.setArgs((BOp[])args);
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot actual = (QueryRoot)new ASTConstructOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        ProjectionNode projection2 = actual.getProjection();
        TestASTConstructOptimizer.assertNotNull((Object)projection2);
        Object[] args2 = projection2.args().toArray(new BOp[0]);
        Arrays.sort(args2);
        projection2.setArgs((BOp[])args2);
        TestASTConstructOptimizer.assertSameAST((IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_construct_withSolutionModifiers_none() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataURI dcURI = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel, dcURI};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode = new ConstructNode();
        queryRoot.setConstruct(constructNode);
        constructNode.addChild(new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV())));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode2 = new ConstructNode();
        expected.setConstruct(constructNode2);
        constructNode2.addChild(new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV())));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.setReduced(true);
        projection.addProjectionVar(new VarNode("x"));
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot actual = (QueryRoot)new ASTConstructOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTConstructOptimizer.assertSameAST((IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_construct_withSolutionModifiers_offsetLimit() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataURI dcURI = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel, dcURI};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode = new ConstructNode();
        queryRoot.setConstruct(constructNode);
        constructNode.addChild(new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV())));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        queryRoot.setSlice(new SliceNode(1L, 1L));
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode2 = new ConstructNode();
        expected.setConstruct(constructNode2);
        constructNode2.addChild(new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV())));
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        subqueryRoot.setSlice(new SliceNode(1L, 1L));
        ProjectionNode projection = new ProjectionNode();
        subqueryRoot.setProjection(projection);
        projection.setReduced(true);
        projection.addProjectionVar(new VarNode("x"));
        whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)subqueryRoot);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setReduced(true);
        projection2.addProjectionVar(new VarNode("x"));
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot actual = (QueryRoot)new ASTConstructOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTConstructOptimizer.assertSameAST((IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_construct_withSolutionModifiers_offsetLimit_orderBy() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataURI dcURI = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel, dcURI};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode = new ConstructNode();
        queryRoot.setConstruct(constructNode);
        constructNode.addChild(new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV())));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        queryRoot.setSlice(new SliceNode(1L, 1L));
        OrderByNode orderBy = new OrderByNode();
        orderBy.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("x"), true));
        queryRoot.setOrderBy(orderBy);
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode2 = new ConstructNode();
        expected.setConstruct(constructNode2);
        constructNode2.addChild(new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV())));
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        subqueryRoot.setSlice(new SliceNode(1L, 1L));
        OrderByNode orderBy2 = new OrderByNode();
        orderBy2.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("x"), true));
        subqueryRoot.setOrderBy(orderBy2);
        ProjectionNode projection = new ProjectionNode();
        subqueryRoot.setProjection(projection);
        projection.setReduced(true);
        projection.addProjectionVar(new VarNode("x"));
        whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)subqueryRoot);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setReduced(true);
        projection2.addProjectionVar(new VarNode("x"));
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot actual = (QueryRoot)new ASTConstructOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTConstructOptimizer.assertSameAST((IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_construct_withSolutionModifiers_orderBy() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataURI dcURI = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel, dcURI};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode = new ConstructNode();
        queryRoot.setConstruct(constructNode);
        constructNode.addChild(new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV())));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        OrderByNode orderBy = new OrderByNode();
        orderBy.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("x"), true));
        queryRoot.setOrderBy(orderBy);
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ConstructNode constructNode2 = new ConstructNode();
        expected.setConstruct(constructNode2);
        constructNode2.addChild(new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV())));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ProjectionNode projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.setReduced(true);
        projection.addProjectionVar(new VarNode("x"));
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot actual = (QueryRoot)new ASTConstructOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTConstructOptimizer.assertSameAST((IQueryNode)expected, (IQueryNode)actual);
    }
}

