/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataStatementImpl;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.DescribeModeEnum;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTDescribeOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTWildcardProjectionOptimizer;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTDescribeOptimizer
extends AbstractASTEvaluationTestCase {
    private static final Logger log = Logger.getLogger(TestASTDescribeOptimizer.class);

    public TestASTDescribeOptimizer() {
    }

    public TestASTDescribeOptimizer(String name) {
        super(name);
    }

    public void test_describeOptimizer_iri_only() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.DESCRIBE);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        VarNode anonvar = new VarNode("-iri-1");
        anonvar.setAnonymous(true);
        projection.addProjectionExpression(new AssignmentNode(anonvar, (IValueExpressionNode)new ConstantNode(mikeURI.getIV())));
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setReduced(true);
        VarNode anonvar2 = new VarNode("-iri-1");
        anonvar2.setAnonymous(true);
        projection2.addProjectionExpression(new AssignmentNode(anonvar2, (IValueExpressionNode)new ConstantNode(mikeURI.getIV())));
        VarNode p0a = new VarNode("p0a");
        VarNode p0b = new VarNode("p0b");
        VarNode o0 = new VarNode("o0");
        VarNode s0 = new VarNode("s0");
        ConstantNode term0 = new ConstantNode(mikeURI.getIV());
        ConstructNode constructNode = new ConstructNode();
        expected.setConstruct(constructNode);
        constructNode.addChild(new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0));
        constructNode.addChild(new StatementPatternNode((TermNode)s0, (TermNode)p0b, (TermNode)term0));
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s0, (TermNode)p0b, (TermNode)term0)));
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        IQueryNode actual = new ASTDescribeOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTDescribeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_describeOptimizer_iri_only_describeMode_forwardOneStep() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.DESCRIBE);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        VarNode anonvar = new VarNode("-iri-1");
        anonvar.setAnonymous(true);
        projection.addProjectionExpression(new AssignmentNode(anonvar, (IValueExpressionNode)new ConstantNode(mikeURI.getIV())));
        projection.setDescribeMode(DescribeModeEnum.ForwardOneStep);
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setReduced(true);
        VarNode anonvar2 = new VarNode("-iri-1");
        anonvar2.setAnonymous(true);
        projection2.addProjectionExpression(new AssignmentNode(anonvar2, (IValueExpressionNode)new ConstantNode(mikeURI.getIV())));
        projection2.setDescribeMode(DescribeModeEnum.ForwardOneStep);
        VarNode p0a = new VarNode("p0a");
        VarNode o0 = new VarNode("o0");
        ConstantNode term0 = new ConstantNode(mikeURI.getIV());
        ConstructNode constructNode = new ConstructNode();
        expected.setConstruct(constructNode);
        constructNode.addChild(new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0));
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0)));
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        IQueryNode actual = new ASTDescribeOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTDescribeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_describeOptimizer_iri_only_describeMode_CBD() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataURI rdfSubject = f.createURI(RDF.SUBJECT.toString());
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel, rdfSubject};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.DESCRIBE);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        VarNode anonvar = new VarNode("-iri-1");
        anonvar.setAnonymous(true);
        projection.addProjectionExpression(new AssignmentNode(anonvar, (IValueExpressionNode)new ConstantNode(mikeURI.getIV())));
        projection.setDescribeMode(DescribeModeEnum.CBD);
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setReduced(true);
        VarNode anonvar2 = new VarNode("-iri-1");
        anonvar2.setAnonymous(true);
        projection2.addProjectionExpression(new AssignmentNode(anonvar2, (IValueExpressionNode)new ConstantNode(mikeURI.getIV())));
        projection2.setDescribeMode(DescribeModeEnum.CBD);
        VarNode p0a = new VarNode("p0a");
        VarNode o0 = new VarNode("o0");
        ConstantNode term0 = new ConstantNode(mikeURI.getIV());
        VarNode stmtVar = new VarNode("stmt0");
        ConstantNode termRdfSubject = new ConstantNode(rdfSubject.getIV());
        ConstructNode constructNode = new ConstructNode();
        expected.setConstruct(constructNode);
        constructNode.addChild(new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0));
        constructNode.addChild(new StatementPatternNode((TermNode)stmtVar, (TermNode)termRdfSubject, (TermNode)term0));
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)stmtVar, (TermNode)termRdfSubject, (TermNode)term0)));
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        IQueryNode actual = new ASTDescribeOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTDescribeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_describeOptimizer_iri_and_var() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataURI dcURI = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel, dcURI};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.DESCRIBE);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        VarNode anonvar = new VarNode("-iri-1");
        anonvar.setAnonymous(true);
        projection.addProjectionExpression(new AssignmentNode(anonvar, (IValueExpressionNode)new ConstantNode(dcURI.getIV())));
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setReduced(true);
        VarNode anonvar2 = new VarNode("-iri-1");
        anonvar2.setAnonymous(true);
        projection2.addProjectionExpression(new AssignmentNode(anonvar2, (IValueExpressionNode)new ConstantNode(dcURI.getIV())));
        projection2.addProjectionVar(new VarNode("x"));
        ConstructNode constructNode = new ConstructNode();
        expected.setConstruct(constructNode);
        ConstantNode term0 = new ConstantNode(dcURI.getIV());
        VarNode p0a = new VarNode("p0a");
        VarNode p0b = new VarNode("p0b");
        VarNode o0 = new VarNode("o0");
        VarNode s0 = new VarNode("s0");
        constructNode.addChild(new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0));
        constructNode.addChild(new StatementPatternNode((TermNode)s0, (TermNode)p0b, (TermNode)term0));
        VarNode term1 = new VarNode("x");
        VarNode p1a = new VarNode("p1a");
        VarNode p1b = new VarNode("p1b");
        VarNode o1 = new VarNode("o1");
        VarNode s1 = new VarNode("s1");
        constructNode.addChild(new StatementPatternNode((TermNode)term1, (TermNode)p1a, (TermNode)o1));
        constructNode.addChild(new StatementPatternNode((TermNode)s1, (TermNode)p1b, (TermNode)term1));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        UnionNode union = new UnionNode();
        whereClause2.addChild((IGroupMemberNode)union);
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s0, (TermNode)p0b, (TermNode)term0)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term1, (TermNode)p1a, (TermNode)o1)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s1, (TermNode)p1b, (TermNode)term1)));
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        IQueryNode actual = new ASTDescribeOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTDescribeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_describeOptimizer_star() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI g = f.createURI("http://www.bigdata.com");
        BigdataStatement[] stmts = new BigdataStatement[]{new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDF.TYPE.toString()), (BigdataValue)f.createURI(FOAFVocabularyDecl.Person.toString()), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Mike"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Mike"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/Bryan"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("Bryan"), (BigdataResource)g, StatementEnum.Explicit, false), new BigdataStatementImpl((BigdataResource)f.createURI("http://www.bigdata.com/DC"), f.createURI(RDFS.LABEL.toString()), (BigdataValue)f.createLiteral("DC"), (BigdataResource)g, StatementEnum.Explicit, false)};
        StatementBuffer buf = new StatementBuffer(this.store, 10);
        for (BigdataStatement stmt : stmts) {
            buf.add((Statement)stmt);
        }
        buf.flush();
        BigdataURI rdfType = f.createURI(RDF.TYPE.toString());
        BigdataURI rdfsLabel = f.createURI(RDFS.LABEL.toString());
        BigdataURI foafPerson = f.createURI(FOAFVocabularyDecl.Person.toString());
        BigdataURI mikeURI = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryanURI = f.createURI("http://www.bigdata.com/Bryan");
        BigdataLiteral mikeLabel = f.createLiteral("Mike");
        BigdataLiteral bryanLabel = f.createLiteral("Bryan");
        BigdataURI dcURI = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{rdfType, rdfsLabel, foafPerson, mikeURI, bryanURI, mikeLabel, bryanLabel, dcURI};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        QueryRoot queryRoot = new QueryRoot(QueryType.DESCRIBE);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.CONSTRUCT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setReduced(true);
        projection2.addProjectionVar(new VarNode("x"));
        ConstructNode constructNode = new ConstructNode();
        expected.setConstruct(constructNode);
        VarNode term0 = new VarNode("x");
        VarNode p0a = new VarNode("p0a");
        VarNode p0b = new VarNode("p0b");
        VarNode o0 = new VarNode("o0");
        VarNode s0 = new VarNode("s0");
        constructNode.addChild(new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0));
        constructNode.addChild(new StatementPatternNode((TermNode)s0, (TermNode)p0b, (TermNode)term0));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType.getIV()), (TermNode)new ConstantNode(foafPerson.getIV()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        UnionNode union = new UnionNode();
        whereClause2.addChild((IGroupMemberNode)union);
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)term0, (TermNode)p0a, (TermNode)o0)));
        union.addChild(new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)s0, (TermNode)p0b, (TermNode)term0)));
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        IQueryNode actual = new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        actual = new ASTDescribeOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        TestASTDescribeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_describeOptimizer_star_no_vars() {
        block2: {
            QueryRoot queryRoot = new QueryRoot(QueryType.DESCRIBE);
            ProjectionNode projection = new ProjectionNode();
            queryRoot.setProjection(projection);
            projection.addProjectionVar(new VarNode("*"));
            ASTContainer astContainer = new ASTContainer(queryRoot);
            AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
            IQueryNode tmp = new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
            try {
                new ASTDescribeOptimizer().optimize(context, new QueryNodeWithBindingSet(tmp, null));
                TestASTDescribeOptimizer.fail((String)("Expecting " + RuntimeException.class));
            }
            catch (RuntimeException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
    }
}

