/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IPredicate;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.optimizers.ASTDistinctTermScanOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTFastRangeCountOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTOptimizerList;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractOptimizerTestCase;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Ignore;

public class TestASTDistinctTermScanOptimizer
extends AbstractOptimizerTestCase {
    public TestASTDistinctTermScanOptimizer() {
    }

    public TestASTDistinctTermScanOptimizer(String name) {
        super(name);
    }

    @Override
    IASTOptimizer newOptimizer() {
        return new ASTOptimizerList(new IASTOptimizer[]{new ASTDistinctTermScanOptimizer()});
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ASTFastRangeCountOptimizer.class.getSimpleName());
        suite.addTestSuite(TestQuadsModeAPs.class);
        suite.addTestSuite(TestTriplesModeAPs.class);
        return suite;
    }

    public static class TestTriplesModeAPs
    extends AbstractASTDistinctTermScanTest {
    }

    public static class TestQuadsModeAPs
    extends AbstractASTDistinctTermScanTest {
        public void test_distinctTermScanOptimizer_variable_context_not_projected() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    long rangeCount_sp1 = 1000L;
                    this.given = this.select(this.projection(this.varNode("s")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.varNode("z"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1000L))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                    long newRangeCount = (long)(1.0 / (double)(TestQuadsModeAPs.this.store.isQuads() ? 4 : 3) * 1000.0);
                    StatementPatternNode sp = this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.varNode("z"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, newRangeCount), this.property("distinctTermScanVar", this.varNode("s")));
                    sp.setQueryHint(IPredicate.Annotations.KEY_ORDER, "SPOC");
                    this.expected = this.select(this.projection(this.varNode("s")), this.where(new IGroupMemberNode[]{sp}), AbstractOptimizerTestCase.HelperFlag.NOT_DISTINCT, AbstractOptimizerTestCase.HelperFlag.NOT_REDUCED);
                }
            }.test();
        }

        public void test_distinctTermScanOptimizer_variable_context_projected() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    long rangeCount_sp1 = 1000L;
                    this.given = this.select(this.projection(this.varNode("z")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.varNode("z"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1000L))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                    long newRangeCount = (long)(1.0 / (double)(TestQuadsModeAPs.this.store.isQuads() ? 4 : 3) * 1000.0);
                    StatementPatternNode sp = this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.varNode("z"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, newRangeCount), this.property("distinctTermScanVar", this.varNode("z")));
                    sp.setQueryHint(IPredicate.Annotations.KEY_ORDER, "CSPO");
                    this.expected = this.select(this.projection(this.varNode("z")), this.where(new IGroupMemberNode[]{sp}), AbstractOptimizerTestCase.HelperFlag.NOT_DISTINCT, AbstractOptimizerTestCase.HelperFlag.NOT_REDUCED);
                }
            }.test();
        }

        @Ignore(value="edge case, not implemented yet")
        public void test_distinctTermScanOptimizer_bound_context() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    long rangeCount_sp1 = 1000L;
                    this.given = this.select(this.projection(this.varNode("s")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.constantNode(this.a), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1000L))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                    long newRangeCount = (long)(1.0 / (double)(TestQuadsModeAPs.this.store.isQuads() ? 4 : 3) * 1000.0);
                    this.expected = this.select(this.projection(this.varNode("s")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.constantNode(this.a), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, newRangeCount), this.property("distinctTermScanVar", this.varNode("s")))}), AbstractOptimizerTestCase.HelperFlag.NOT_DISTINCT, AbstractOptimizerTestCase.HelperFlag.NOT_REDUCED);
                }
            };
        }

        public void test_distinctTermScanOptimizer_reject_quads_constant_in_sp() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    long rangeCount_sp1 = 1000L;
                    this.given = this.select(this.projection(this.varNode("s")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), this.constantNode(this.a), (TermNode)this.varNode("o"), this.varNode("y"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1000L))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                    this.expected = new QueryRoot(this.given);
                }
            };
        }

        public void test_distinctTermScanOptimizer_reject_constant_context() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    long rangeCount_sp1 = 1000L;
                    this.given = this.select(this.projection(this.varNode("s")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.constantNode(this.a), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1000L))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                    this.expected = new QueryRoot(this.given);
                }
            };
        }
    }

    protected static abstract class AbstractASTDistinctTermScanTest
    extends TestASTDistinctTermScanOptimizer {
        protected AbstractASTDistinctTermScanTest() {
        }

        public void test_distinctTermScanOptimizer_01() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    long rangeCount_sp1 = 1000L;
                    StatementPatternNode sp1 = AbstractASTDistinctTermScanTest.this.newStatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"));
                    sp1.setProperty(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, (Object)1000L);
                    ProjectionNode projection = this.projection(this.varNode("s"));
                    projection.setDistinct(true);
                    this.given = this.select(projection, this.where(new IGroupMemberNode[]{sp1}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    sp1 = AbstractASTDistinctTermScanTest.this.newStatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"));
                    VarNode distinctTermScanVar = new VarNode("s");
                    sp1.setDistinctTermScanVar(distinctTermScanVar);
                    long newRangeCount = (long)(1.0 / (double)(AbstractASTDistinctTermScanTest.this.store.isQuads() ? 4 : 3) * 1000.0);
                    sp1.setProperty(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, (Object)newRangeCount);
                    sp1.setQueryHint(IPredicate.Annotations.KEY_ORDER, "SPOC");
                    ProjectionNode projection2 = this.projection(this.varNode("s"));
                    projection2.setDistinct(false);
                    projection2.setReduced(false);
                    this.expected = this.select(projection2, this.where(new IGroupMemberNode[]{sp1}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
        }

        public void test_distinctTermScanOptimizer_optional_pattern() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    long rangeCount_sp1 = 1000L;
                    this.given = this.select(this.projection(this.varNode("s")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), new Object[]{this.varNode("z"), AbstractOptimizerTestCase.HelperFlag.OPTIONAL, this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1000L)})}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                    long newRangeCount = (long)(1.0 / (double)(AbstractASTDistinctTermScanTest.this.store.isQuads() ? 4 : 3) * 1000.0);
                    StatementPatternNode sp = this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), new Object[]{this.varNode("z"), AbstractOptimizerTestCase.HelperFlag.OPTIONAL, this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, newRangeCount), this.property("distinctTermScanVar", this.varNode("s"))});
                    sp.setQueryHint(IPredicate.Annotations.KEY_ORDER, "SPOC");
                    this.expected = this.select(this.projection(this.varNode("s")), this.where(new IGroupMemberNode[]{sp}), AbstractOptimizerTestCase.HelperFlag.NOT_DISTINCT, AbstractOptimizerTestCase.HelperFlag.NOT_REDUCED);
                }
            }.test();
        }

        public void test_distinctTermScanOptimizer_reject_constant_in_sp() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    long rangeCount_sp1 = 1000L;
                    this.given = this.select(this.projection(this.varNode("s")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), this.constantNode(this.a), (TermNode)this.varNode("o"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1000L))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                    this.expected = new QueryRoot(this.given);
                }
            };
        }
    }
}

