/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.optimizers.ASTEmptyGroupOptimizer;
import com.bigdata.rdf.store.BDS;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTEmptyGroupOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTEmptyGroupOptimizer() {
    }

    public TestASTEmptyGroupOptimizer(String name) {
        super(name);
    }

    public void test_eliminateJoinGroup01() {
        IBindingSet[] bsets = new IBindingSet[]{};
        TermId bdSearchIV = TermId.mockIV((VTE)VTE.URI);
        bdSearchIV.setValue((BigdataValue)this.store.getValueFactory().createURI(BDS.SEARCH.toString()));
        TermId mikeIV = TermId.mockIV((VTE)VTE.LITERAL);
        mikeIV.setValue((BigdataValue)this.store.getValueFactory().createLiteral("mike"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode graphGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)graphGroup);
        graphGroup.setContext((TermNode)new VarNode("g"));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.setContext((TermNode)new VarNode("g"));
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup02() {
        IBindingSet[] bsets = new IBindingSet[]{};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        JoinGroupNode whereClause = new JoinGroupNode(new JoinGroupNode());
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup03() {
        IBindingSet[] bsets = new IBindingSet[]{};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        JoinGroupNode whereClause = new JoinGroupNode(new JoinGroupNode(new JoinGroupNode()));
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup04() {
        IBindingSet[] bsets = new IBindingSet[]{};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode graphGroup = new JoinGroupNode(new JoinGroupNode());
        graphGroup.setContext((TermNode)new VarNode("g"));
        whereClause.addChild((IGroupMemberNode)graphGroup);
        System.err.println("given:" + given);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        graphGroup = new JoinGroupNode(new JoinGroupNode());
        graphGroup.setContext((TermNode)new VarNode("g"));
        expected.setWhereClause((GraphPatternGroup)graphGroup);
        System.err.println("expected:" + expected);
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup05() throws Exception {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.setDistinct(true);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        JoinGroupNode joinGroup1 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup2 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)union);
        union.addChild(joinGroup1);
        union.addChild(joinGroup2);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setDistinct(true);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        union = new UnionNode();
        joinGroup1 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        joinGroup2 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)union);
        union.addChild(joinGroup1);
        union.addChild(joinGroup2);
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup06() throws Exception {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        IV x = this.makeIV((Value)new URIImpl("http://example/x"));
        IV y = this.makeIV((Value)new URIImpl("http://example/y"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.setDistinct(true);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        JoinGroupNode joinGroup1 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup2 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        union.addChild(joinGroup1);
        union.addChild(joinGroup2);
        JoinGroupNode emptyJoinGroup = new JoinGroupNode();
        emptyJoinGroup.addChild((IGroupMemberNode)union);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(x), (TermNode)new ConstantNode(y), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)emptyJoinGroup);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setDistinct(true);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        UnionNode union2 = new UnionNode();
        JoinGroupNode joinGroup12 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup22 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        union2.addChild(joinGroup12);
        union2.addChild(joinGroup22);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(x), (TermNode)new ConstantNode(y), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)union2);
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup07() throws Exception {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV rdfsLabel = this.makeIV((Value)RDFS.LABEL);
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        subqueryRoot.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        projection = new ProjectionNode();
        given.setProjection(projection);
        projection.setDistinct(true);
        projection.addProjectionVar(new VarNode("x"));
        projection.addProjectionVar(new VarNode("o"));
        whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)joinGroup);
        joinGroup.addChild((IGroupMemberNode)subqueryRoot);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        SubqueryRoot subqueryRoot2 = new SubqueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        subqueryRoot2.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subqueryRoot2.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setDistinct(true);
        projection2.addProjectionVar(new VarNode("x"));
        projection2.addProjectionVar(new VarNode("o"));
        whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)subqueryRoot2);
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_emptyGroupOptimizer_doNotLiftFilter() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV x = this.makeIV((Value)new URIImpl("http://example/x"));
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV ONE = this.makeIV((Value)new LiteralImpl("1", XSD.INTEGER));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.setDistinct(true);
        projection.addProjectionVar(new VarNode("v"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(x), (TermNode)new ConstantNode(p), (TermNode)new VarNode("v"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)joinGroup);
        joinGroup.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("v"), new ConstantNode(ONE)})));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setDistinct(true);
        projection2.addProjectionVar(new VarNode("v"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(x), (TermNode)new ConstantNode(p), (TermNode)new VarNode("v"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup2 = new JoinGroupNode(true);
        whereClause2.addChild((IGroupMemberNode)joinGroup2);
        joinGroup2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("v"), new ConstantNode(ONE)})));
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_emptyGroupOptimizer_doNotLiftFromOptionalGroup() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV rdfsLabel = this.makeIV((Value)RDFS.LABEL);
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.setDistinct(true);
        projection.addProjectionVar(new VarNode("x"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)joinGroup);
        joinGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setDistinct(true);
        projection2.addProjectionVar(new VarNode("x"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup2 = new JoinGroupNode(true);
        whereClause2.addChild((IGroupMemberNode)joinGroup2);
        joinGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup08() throws Exception {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV c = this.makeIV((Value)new URIImpl("http://example/c"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        NamedSubqueryRoot namedSubquery = new NamedSubqueryRoot(QueryType.SELECT, "_set1");
        ProjectionNode projection = new ProjectionNode();
        namedSubquery.setProjection(projection);
        projection.addProjectionExpression(new AssignmentNode(new VarNode("_var1"), (IValueExpressionNode)new VarNode("_var1")));
        JoinGroupNode joinGroup1 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("_var1"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(b), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        namedSubquery.setWhereClause((GraphPatternGroup)joinGroup1);
        projection = new ProjectionNode();
        given.setProjection(projection);
        projection.setDistinct(true);
        projection.addProjectionVar(new VarNode("_var1"));
        projection.addProjectionVar(new VarNode("_var2"));
        projection.addProjectionVar(new VarNode("_var4"));
        joinGroup1 = new JoinGroupNode();
        JoinGroupNode joinGroup2 = new JoinGroupNode();
        JoinGroupNode joinGroup3 = new JoinGroupNode();
        JoinGroupNode joinGroup4 = new JoinGroupNode();
        joinGroup4.addChild((IGroupMemberNode)joinGroup3);
        joinGroup3.addChild((IGroupMemberNode)joinGroup2);
        joinGroup2.addChild((IGroupMemberNode)joinGroup1);
        joinGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("_var1"), (TermNode)new ConstantNode(c), (TermNode)new VarNode("_var2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        joinGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("_var12"), (TermNode)new ConstantNode(d), (TermNode)new VarNode("_var1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        joinGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("_var12"), (TermNode)new ConstantNode(e), (TermNode)new VarNode("_var4"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        joinGroup1.addChild((IGroupMemberNode)new NamedSubqueryInclude("_set1"));
        given.setWhereClause((GraphPatternGroup)joinGroup4);
        given.getNamedSubqueriesNotNull().add((IQueryNode)namedSubquery);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        NamedSubqueryRoot namedSubquery2 = new NamedSubqueryRoot(QueryType.SELECT, "_set1");
        ProjectionNode projection2 = new ProjectionNode();
        namedSubquery2.setProjection(projection2);
        projection2.addProjectionExpression(new AssignmentNode(new VarNode("_var1"), (IValueExpressionNode)new VarNode("_var1")));
        JoinGroupNode joinGroup12 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("_var1"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(b), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        namedSubquery2.setWhereClause((GraphPatternGroup)joinGroup12);
        projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setDistinct(true);
        projection2.addProjectionVar(new VarNode("_var1"));
        projection2.addProjectionVar(new VarNode("_var2"));
        projection2.addProjectionVar(new VarNode("_var4"));
        joinGroup12 = new JoinGroupNode();
        joinGroup12.addChild((IGroupMemberNode)new NamedSubqueryInclude("_set1"));
        joinGroup12.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("_var1"), (TermNode)new ConstantNode(c), (TermNode)new VarNode("_var2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        joinGroup12.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("_var12"), (TermNode)new ConstantNode(d), (TermNode)new VarNode("_var1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        joinGroup12.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("_var12"), (TermNode)new ConstantNode(e), (TermNode)new VarNode("_var4"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)joinGroup12);
        expected.getNamedSubqueriesNotNull().add((IQueryNode)namedSubquery2);
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup09() {
        IBindingSet[] bsets = new IBindingSet[]{};
        TermId bdSearchIV = TermId.mockIV((VTE)VTE.URI);
        bdSearchIV.setValue((BigdataValue)this.store.getValueFactory().createURI(BDS.SEARCH.toString()));
        TermId mikeIV = TermId.mockIV((VTE)VTE.LITERAL);
        mikeIV.setValue((BigdataValue)this.store.getValueFactory().createLiteral("mike"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("subj"));
        JoinGroupNode graphGroup = new JoinGroupNode();
        graphGroup.addChild((IGroupMemberNode)new JoinGroupNode());
        graphGroup.addChild((IGroupMemberNode)new JoinGroupNode(new JoinGroupNode()));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        given.setWhereClause((GraphPatternGroup)graphGroup);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_ticket416() throws Exception {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV type = this.makeIV((Value)RDF.TYPE);
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("r"));
        projection.addProjectionVar(new VarNode("l"));
        projection.setDistinct(true);
        UnionNode union = new UnionNode();
        JoinGroupNode left = new JoinGroupNode();
        left.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(a)));
        left.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("r")));
        left.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("r"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("type")));
        JoinGroupNode right = new JoinGroupNode();
        right.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(a)));
        right.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("l"), (TermNode)new VarNode("p"), (TermNode)new VarNode("s")));
        right.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("l"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("type")));
        union.addChild(left);
        union.addChild(right);
        JoinGroupNode where = new JoinGroupNode();
        where.addChild((IGroupMemberNode)union);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)where);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("r"));
        projection2.addProjectionVar(new VarNode("l"));
        projection2.setDistinct(true);
        UnionNode union2 = new UnionNode();
        JoinGroupNode left2 = new JoinGroupNode();
        left2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(a)));
        left2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("r")));
        left2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("r"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("type")));
        JoinGroupNode right2 = new JoinGroupNode();
        right2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(a)));
        right2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("l"), (TermNode)new VarNode("p"), (TermNode)new VarNode("s")));
        right2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("l"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("type")));
        union2.addChild(left2);
        union2.addChild(right2);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)union2);
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup10_minus() {
        IBindingSet[] bsets = new IBindingSet[]{};
        TermId bdSearchIV = TermId.mockIV((VTE)VTE.URI);
        bdSearchIV.setValue((BigdataValue)this.store.getValueFactory().createURI(BDS.SEARCH.toString()));
        TermId mikeIV = TermId.mockIV((VTE)VTE.LITERAL);
        mikeIV.setValue((BigdataValue)this.store.getValueFactory().createLiteral("mike"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)minusGroup);
        minusGroup.setMinus(true);
        minusGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)minusGroup2);
        minusGroup2.setMinus(true);
        minusGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup11_minus() {
        IBindingSet[] bsets = new IBindingSet[]{};
        TermId bdSearchIV = TermId.mockIV((VTE)VTE.URI);
        bdSearchIV.setValue((BigdataValue)this.store.getValueFactory().createURI(BDS.SEARCH.toString()));
        TermId mikeIV = TermId.mockIV((VTE)VTE.LITERAL);
        mikeIV.setValue((BigdataValue)this.store.getValueFactory().createLiteral("mike"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)minusGroup);
        minusGroup.setMinus(true);
        JoinGroupNode graphGroup = new JoinGroupNode();
        minusGroup.addChild((IGroupMemberNode)graphGroup);
        graphGroup.setContext((TermNode)new VarNode("g"));
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)minusGroup2);
        minusGroup2.setMinus(true);
        JoinGroupNode graphGroup2 = new JoinGroupNode();
        minusGroup2.addChild((IGroupMemberNode)graphGroup2);
        graphGroup2.setContext((TermNode)new VarNode("g"));
        graphGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.NAMED_CONTEXTS));
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup12_minus() {
        IBindingSet[] bsets = new IBindingSet[]{};
        TermId bdSearchIV = TermId.mockIV((VTE)VTE.URI);
        bdSearchIV.setValue((BigdataValue)this.store.getValueFactory().createURI(BDS.SEARCH.toString()));
        TermId mikeIV = TermId.mockIV((VTE)VTE.LITERAL);
        mikeIV.setValue((BigdataValue)this.store.getValueFactory().createLiteral("mike"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)minusGroup);
        minusGroup.setMinus(true);
        JoinGroupNode minusGroup2 = new JoinGroupNode();
        minusGroup.addChild((IGroupMemberNode)minusGroup2);
        minusGroup2.setMinus(true);
        minusGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup3 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)minusGroup3);
        minusGroup3.setMinus(true);
        JoinGroupNode minusGroup22 = new JoinGroupNode();
        minusGroup3.addChild((IGroupMemberNode)minusGroup22);
        minusGroup22.setMinus(true);
        minusGroup22.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_eliminateJoinGroup13_minus() {
        IBindingSet[] bsets = new IBindingSet[]{};
        TermId bdSearchIV = TermId.mockIV((VTE)VTE.URI);
        bdSearchIV.setValue((BigdataValue)this.store.getValueFactory().createURI(BDS.SEARCH.toString()));
        TermId mikeIV = TermId.mockIV((VTE)VTE.LITERAL);
        mikeIV.setValue((BigdataValue)this.store.getValueFactory().createLiteral("mike"));
        TermId rdfIV = TermId.mockIV((VTE)VTE.LITERAL);
        rdfIV.setValue((BigdataValue)this.store.getValueFactory().createLiteral("rdf"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)minusGroup);
        minusGroup.setMinus(true);
        minusGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)rdfIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup2 = new JoinGroupNode();
        minusGroup.addChild((IGroupMemberNode)minusGroup2);
        minusGroup2.setMinus(true);
        minusGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("subj"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)mikeIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup3 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)minusGroup3);
        minusGroup3.setMinus(true);
        minusGroup3.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode((IV)bdSearchIV), (TermNode)new ConstantNode((IV)rdfIV), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode minusGroup22 = new JoinGroupNode();
        minusGroup3.addChild((IGroupMemberNode)minusGroup22);
        minusGroup22.setMinus(true);
        minusGroup22.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), (TermNode)new VarNode("g"), StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_union_01() {
        IBindingSet[] bsets = new IBindingSet[]{};
        TermId dcTitle = TermId.mockIV((VTE)VTE.URI);
        dcTitle.setValue((BigdataValue)this.store.getValueFactory().createURI(DC.TITLE.stringValue()));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("book"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        JoinGroupNode emptyGroup = new JoinGroupNode();
        JoinGroupNode otherGroup = new JoinGroupNode();
        otherGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IV)dcTitle), (TermNode)new VarNode("title")));
        union.addChild(emptyGroup);
        union.addChild(otherGroup);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("book"));
        union = new UnionNode();
        expected.setWhereClause((GraphPatternGroup)union);
        emptyGroup = new JoinGroupNode();
        otherGroup = new JoinGroupNode();
        otherGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new ConstantNode((IV)dcTitle), (TermNode)new VarNode("title")));
        union.addChild(emptyGroup);
        union.addChild(otherGroup);
        ASTEmptyGroupOptimizer rewriter = new ASTEmptyGroupOptimizer();
        IQueryNode actual = rewriter.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTEmptyGroupOptimizer.assertSameAST((IQueryNode)expected, actual);
    }
}

