/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.optimizers.ASTFastRangeCountOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTOptimizerList;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractOptimizerTestCase;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestASTFastRangeCountOptimizer
extends AbstractOptimizerTestCase {
    public TestASTFastRangeCountOptimizer() {
    }

    public TestASTFastRangeCountOptimizer(String name) {
        super(name);
    }

    @Override
    IASTOptimizer newOptimizer() {
        return new ASTOptimizerList(new IASTOptimizer[]{new ASTFastRangeCountOptimizer()});
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ASTFastRangeCountOptimizer.class.getSimpleName());
        suite.addTestSuite(TestQuadsModeAPs.class);
        suite.addTestSuite(TestTriplesModeAPs.class);
        return suite;
    }

    public static class TestTriplesModeAPs
    extends TestASTFastRangeCountOptimizer {
        public TestTriplesModeAPs() {
        }

        public TestTriplesModeAPs(String name) {
            super(name);
        }

        @Override
        public Properties getProperties() {
            Properties properties = new Properties(super.getProperties());
            properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
            properties.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
            return properties;
        }

        public void test_fastRangeCountOptimizer_triplesMode_explicitVarNames_01() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{new VarNode("s"), new VarNode("p"), new VarNode("o")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{TestTriplesModeAPs.this.newStatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    StatementPatternNode sp1 = TestTriplesModeAPs.this.newStatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"));
                    sp1.setFastRangeCount(new VarNode("w"));
                    sp1.setProperty(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, (Object)1L);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{sp1}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
        }

        public void test_fastRangeCountOptimizer_triplesMode_wildcard() {
            class WildCardHelper
            extends AbstractOptimizerTestCase.Helper {
                public WildCardHelper(AbstractOptimizerTestCase.HelperFlag ... flags) {
                    super(TestTriplesModeAPs.this);
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.wildcard()}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), new Object[0])}), flags);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }
            new WildCardHelper(new AbstractOptimizerTestCase.HelperFlag[0]).test();
            new WildCardHelper(AbstractOptimizerTestCase.HelperFlag.DISTINCT).test();
            new WildCardHelper(AbstractOptimizerTestCase.HelperFlag.REDUCED).test();
        }

        public void test_fastRangeCountOptimizer_triplesMode_wildcard_with_constraint() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.wildcard()}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode(this.constantNode(this.a), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{this.statementPatternNode(this.constantNode(this.a), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.wildcard()}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), this.constantNode(this.a), (TermNode)this.varNode("o"), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), this.constantNode(this.a), (TermNode)this.varNode("o"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.wildcard()}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), this.constantNode(this.a), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), this.constantNode(this.a), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.wildcard()}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode(this.constantNode(this.b), (TermNode)this.varNode("p"), this.constantNode(this.a), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{this.statementPatternNode(this.constantNode(this.b), (TermNode)this.varNode("p"), this.constantNode(this.a), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
        }

        public void test_fastRangeCountOptimizer_triplesMode_wildcard_with_constraint_projection() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.varNode("s")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), this.constantNode(this.a), this.constantNode(this.b), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), this.constantNode(this.a), this.constantNode(this.b), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            };
        }

        public void test_fastRangeCountOptimizer_triplesMode_wildcard_subquery_withot_projection01() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.wildcard()), this.where(new IGroupMemberNode[]{this.selectSubQuery(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.varNode("s")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.wildcard()), this.where(new IGroupMemberNode[]{this.selectSubQuery(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.varNode("s")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            };
        }

        public void test_fastRangeCountOptimizer_triplesMode_wildcard_subquery_without_projection_02() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.wildcard()), this.where(new IGroupMemberNode[]{this.selectSubQuery(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.varNode("s")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]), this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), this.constantNode(this.c), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.wildcard()), this.where(new IGroupMemberNode[]{this.selectSubQuery(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.varNode("s")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0]), this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), this.constantNode(this.c), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            };
        }

        public void test_fastRangeCountOptimizer_triplesMode_wildcard_rejection() {
            class WildCardHelper
            extends AbstractOptimizerTestCase.Helper {
                public WildCardHelper(AbstractOptimizerTestCase.HelperFlag ... flags) {
                    super(TestTriplesModeAPs.this);
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.varNode("p")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode(this.constantNode(this.a), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), new Object[0])}), flags);
                    this.expected = new QueryRoot(this.given);
                }
            }
            new WildCardHelper(new AbstractOptimizerTestCase.HelperFlag[0]).test();
            new WildCardHelper(AbstractOptimizerTestCase.HelperFlag.DISTINCT).test();
            new WildCardHelper(AbstractOptimizerTestCase.HelperFlag.REDUCED).test();
        }
    }

    public static class TestQuadsModeAPs
    extends TestASTFastRangeCountOptimizer {
        public void test_fastRangeCountOptimizer_quads_mode_01() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT.stringValue(), new ValueExpressionNode[]{new VarNode("*")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{TestQuadsModeAPs.this.newStatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    StatementPatternNode sp1 = TestQuadsModeAPs.this.newStatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"));
                    sp1.setFastRangeCount(new VarNode("w"));
                    sp1.setProperty(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, (Object)1L);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{sp1}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
        }

        public void test_fastRangeCountOptimizer_quadsMode_optional_pattern() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.wildcard()}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), new Object[]{AbstractOptimizerTestCase.HelperFlag.OPTIONAL})}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), new Object[]{AbstractOptimizerTestCase.HelperFlag.OPTIONAL, this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w"))})}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
        }

        public void test_fastRangeCountOptimizer_quadsMode_simple_case() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.wildcard()}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.varNodes("z"))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.varNode("z"), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
        }

        public void test_fastRangeCountOptimizer_quadsMode_constrained_case() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT, new ValueExpressionNode[]{this.wildcard()}), this.varNode("w"))), this.where(new IGroupMemberNode[]{this.statementPatternNode(this.constantNode(this.b), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.constantNode(this.a))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.varNode("w")), this.where(new IGroupMemberNode[]{this.statementPatternNode(this.constantNode(this.b), (TermNode)this.varNode("p"), (TermNode)this.varNode("o"), this.constantNode(this.a), this.property(AbstractOptimizerTestCase.Annotations.ESTIMATED_CARDINALITY, 1L), this.property("fastRangeCountVar", this.varNode("w")))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
        }

        public void test_fastRangeCountOptimizer_quadsMode_correctRejection_1() {
            new AbstractOptimizerTestCase.Helper(){
                {
                    this.given = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT.stringValue(), new ValueExpressionNode[]{new VarNode("s"), new VarNode("p"), new VarNode("o")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{TestQuadsModeAPs.this.newStatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                    this.expected = this.select(this.projection(this.bind(this.functionNode(FunctionRegistry.COUNT.stringValue(), new ValueExpressionNode[]{new VarNode("s"), new VarNode("p"), new VarNode("o")}), this.varNode("w"))), this.where(new IGroupMemberNode[]{TestQuadsModeAPs.this.newStatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                }
            }.test();
        }
    }
}

