/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTFilterNormalizationOptimizer;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTFilterNormalizationOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTFilterNormalizationOptimizer() {
    }

    public TestASTFilterNormalizationOptimizer(String name) {
        super(name);
    }

    public void testExtractTopLevelConjunctsMethod() {
        FunctionNode bound1 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode bound2 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode not1 = FunctionNode.NOT((ValueExpressionNode)bound2);
        FunctionNode bound3 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound4 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound5 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FunctionNode or1 = FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound3, (ValueExpressionNode)bound4), (ValueExpressionNode)bound5);
        FunctionNode bound6 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s6")});
        FunctionNode toCheck = FunctionNode.AND((ValueExpressionNode)bound1, (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)not1, (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)or1, (ValueExpressionNode)bound6)));
        List actual = StaticAnalysis.extractToplevelConjuncts((IValueExpressionNode)toCheck, new ArrayList());
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((IValueExpressionNode)toCheck));
        TestASTFilterNormalizationOptimizer.assertEquals((int)actual.size(), (int)4);
        TestASTFilterNormalizationOptimizer.assertEquals(actual.get(0), (Object)bound1);
        TestASTFilterNormalizationOptimizer.assertEquals(actual.get(1), (Object)not1);
        TestASTFilterNormalizationOptimizer.assertEquals(actual.get(2), (Object)or1);
        TestASTFilterNormalizationOptimizer.assertEquals(actual.get(3), (Object)bound6);
    }

    public void testConstructFiltersForValueExpressionNodeMethod() {
        FunctionNode bound3 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound4 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound5 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FunctionNode or1 = FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound3, (ValueExpressionNode)bound4), (ValueExpressionNode)bound5);
        FunctionNode bound2 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode not1 = FunctionNode.NOT((ValueExpressionNode)bound2);
        FunctionNode bound6 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s6")});
        FunctionNode bound1 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode base = FunctionNode.AND((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)or1, (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)not1, (ValueExpressionNode)bound6)), (ValueExpressionNode)bound1);
        ASTFilterNormalizationOptimizer filterOptimizer = new ASTFilterNormalizationOptimizer();
        List filters = filterOptimizer.constructFiltersForValueExpressionNode((IValueExpressionNode)base, new ArrayList());
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((IValueExpressionNode)base));
        TestASTFilterNormalizationOptimizer.assertEquals((int)filters.size(), (int)4);
        TestASTFilterNormalizationOptimizer.assertEquals(filters.get(0), (Object)new FilterNode((IValueExpressionNode)or1));
        TestASTFilterNormalizationOptimizer.assertEquals(filters.get(1), (Object)new FilterNode((IValueExpressionNode)not1));
        TestASTFilterNormalizationOptimizer.assertEquals(filters.get(2), (Object)new FilterNode((IValueExpressionNode)bound6));
        TestASTFilterNormalizationOptimizer.assertEquals(filters.get(3), (Object)new FilterNode((IValueExpressionNode)bound1));
    }

    public void testToConjunctiveValueExpressionMethod() {
        FunctionNode bound1 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode bound2 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode not1 = FunctionNode.NOT((ValueExpressionNode)bound2);
        FunctionNode bound3 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound4 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound5 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FunctionNode or1 = FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound3, (ValueExpressionNode)bound4), (ValueExpressionNode)bound5);
        FunctionNode bound6 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s6")});
        ArrayList<FunctionNode> baseConjuncts = new ArrayList<FunctionNode>();
        baseConjuncts.add(bound1);
        baseConjuncts.add(not1);
        baseConjuncts.add(or1);
        baseConjuncts.add(bound6);
        FunctionNode expected = FunctionNode.AND((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound1, (ValueExpressionNode)not1), (ValueExpressionNode)or1), (ValueExpressionNode)bound6);
        IValueExpressionNode actual = StaticAnalysis.toConjunctiveValueExpression(baseConjuncts);
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((IValueExpressionNode)actual));
        TestASTFilterNormalizationOptimizer.assertEquals((Object)expected, (Object)actual);
    }

    public void testFilterDecompositionNoOp() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"))));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o")));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause2.addChild((IGroupMemberNode)filterNode);
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testSimpleConjunctiveFilter() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI testUri = f.createURI("http://www.test.com");
        IV test = this.makeIV((Value)testUri);
        BigdataValue[] values = new BigdataValue[]{testUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o")), (ValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new ConstantNode(test))));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"))));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new ConstantNode(test))));
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testSimpleDisjunctiveFilter() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.LT((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o")), (ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o")}))));
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        StatementPatternNode spn = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        spn.setOptional(true);
        whereClause.addChild((IGroupMemberNode)spn);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        spn = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        spn.setOptional(true);
        whereClause2.addChild((IGroupMemberNode)spn);
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.GE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"))));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o")}))));
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testNegationLeafRewriting01() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        FunctionNode filterEq = FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterNeq = FunctionNode.NE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterLe = FunctionNode.LE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterLt = FunctionNode.LT((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterGe = FunctionNode.GE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterGt = FunctionNode.GT((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode comb1 = FunctionNode.AND((ValueExpressionNode)filterEq, (ValueExpressionNode)filterNeq);
        FunctionNode comb2 = FunctionNode.AND((ValueExpressionNode)filterLe, (ValueExpressionNode)filterLt);
        FunctionNode comb3 = FunctionNode.AND((ValueExpressionNode)filterGt, (ValueExpressionNode)filterGe);
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)comb1, (ValueExpressionNode)comb2), (ValueExpressionNode)comb3)));
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        FunctionNode filterEqInv = FunctionNode.NE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterNeqInv = FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterLeInv = FunctionNode.GT((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterLtInv = FunctionNode.GE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterGeInv = FunctionNode.LT((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterGtInv = FunctionNode.LE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode comb12 = FunctionNode.OR((ValueExpressionNode)filterEqInv, (ValueExpressionNode)filterNeqInv);
        FunctionNode comb22 = FunctionNode.OR((ValueExpressionNode)filterLeInv, (ValueExpressionNode)filterLtInv);
        FunctionNode comb32 = FunctionNode.OR((ValueExpressionNode)filterGtInv, (ValueExpressionNode)filterGeInv);
        FilterNode filterNode2 = new FilterNode((IValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)comb12, (ValueExpressionNode)comb22), (ValueExpressionNode)comb32));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((FilterNode)filterNode2));
        whereClause2.addChild((IGroupMemberNode)filterNode2);
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testNegationLeafRewriting02() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        FunctionNode filterEq = FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterNeq = FunctionNode.NE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterLe = FunctionNode.LE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterLt = FunctionNode.LT((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterGe = FunctionNode.GE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterGt = FunctionNode.GT((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode comb1 = FunctionNode.AND((ValueExpressionNode)filterEq, (ValueExpressionNode)filterNeq);
        FunctionNode comb2 = FunctionNode.AND((ValueExpressionNode)filterLe, (ValueExpressionNode)filterLt);
        FunctionNode comb3 = FunctionNode.AND((ValueExpressionNode)filterGt, (ValueExpressionNode)filterGe);
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)comb1, (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)comb2, (ValueExpressionNode)comb3))));
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        FunctionNode filterEqInv = FunctionNode.NE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterNeqInv = FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterLeInv = FunctionNode.GT((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterLtInv = FunctionNode.GE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterGeInv = FunctionNode.LT((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode filterGtInv = FunctionNode.LE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"));
        FunctionNode comb12 = FunctionNode.OR((ValueExpressionNode)filterEqInv, (ValueExpressionNode)filterNeqInv);
        FunctionNode comb22 = FunctionNode.OR((ValueExpressionNode)filterLeInv, (ValueExpressionNode)filterLtInv);
        FunctionNode comb32 = FunctionNode.OR((ValueExpressionNode)filterGtInv, (ValueExpressionNode)filterGeInv);
        FilterNode filterNode2 = new FilterNode((IValueExpressionNode)FunctionNode.OR((ValueExpressionNode)comb12, (ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)comb22, (ValueExpressionNode)comb32)));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((FilterNode)filterNode2));
        whereClause2.addChild((IGroupMemberNode)filterNode2);
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testNestedNegationRewriting() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        FunctionNode filterANot1 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o")}));
        FunctionNode filterANot2 = FunctionNode.NOT((ValueExpressionNode)filterANot1);
        FunctionNode filterANot3 = FunctionNode.NOT((ValueExpressionNode)filterANot2);
        FunctionNode filterBNot1 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")}));
        FunctionNode filterBNot2 = FunctionNode.NOT((ValueExpressionNode)filterBNot1);
        FunctionNode filterBNot3 = FunctionNode.NOT((ValueExpressionNode)filterBNot2);
        FunctionNode filterBNot4 = FunctionNode.NOT((ValueExpressionNode)filterBNot3);
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)filterANot3, (ValueExpressionNode)filterBNot4)));
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        FunctionNode bound = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o")});
        FunctionNode neq = new FunctionNode(FunctionRegistry.NE, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")});
        FilterNode filterNode2 = new FilterNode((IValueExpressionNode)FunctionNode.OR((ValueExpressionNode)bound, (ValueExpressionNode)neq));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((FilterNode)filterNode2));
        whereClause2.addChild((IGroupMemberNode)filterNode2);
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testNestedNegationRewritingAndSplit() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        FunctionNode filterANot1 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o")}));
        FunctionNode filterANot2 = FunctionNode.NOT((ValueExpressionNode)filterANot1);
        FunctionNode filterANot3 = FunctionNode.NOT((ValueExpressionNode)filterANot2);
        FunctionNode filterBNot1 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.EQ, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")}));
        FunctionNode filterBNot2 = FunctionNode.NOT((ValueExpressionNode)filterBNot1);
        FunctionNode filterBNot3 = FunctionNode.NOT((ValueExpressionNode)filterBNot2);
        FunctionNode filterBNot4 = FunctionNode.NOT((ValueExpressionNode)filterBNot3);
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)filterANot3, (ValueExpressionNode)filterBNot4)));
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        FunctionNode bound = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o")});
        FunctionNode neq = new FunctionNode(FunctionRegistry.NE, null, new ValueExpressionNode[]{new VarNode("s"), new VarNode("o")});
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)bound));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)neq));
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testSimpleOrAndSwitch() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode spn = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)spn);
        FunctionNode bound1 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode bound2 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode bound3 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound4 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound5 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound1, (ValueExpressionNode)bound2), (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound3, (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound4, (ValueExpressionNode)bound5))));
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        StatementPatternNode spn2 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause2.addChild((IGroupMemberNode)spn2);
        FunctionNode bound12 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode bound22 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode bound32 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound42 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound52 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FunctionNode and1 = FunctionNode.OR((ValueExpressionNode)bound12, (ValueExpressionNode)bound32);
        FunctionNode and2 = FunctionNode.OR((ValueExpressionNode)bound12, (ValueExpressionNode)bound42);
        FunctionNode and3 = FunctionNode.OR((ValueExpressionNode)bound12, (ValueExpressionNode)bound52);
        FunctionNode and4 = FunctionNode.OR((ValueExpressionNode)bound22, (ValueExpressionNode)bound32);
        FunctionNode and5 = FunctionNode.OR((ValueExpressionNode)bound22, (ValueExpressionNode)bound42);
        FunctionNode and6 = FunctionNode.OR((ValueExpressionNode)bound22, (ValueExpressionNode)bound52);
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)and1));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)and2));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)and3));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)and4));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)and5));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)and6));
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testOrAndSwitchWithNegation() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setQueryHint("normalizeFilterExpressions", "true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode spn = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)spn);
        FunctionNode notBound1 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")}));
        FunctionNode notBound2 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")}));
        FunctionNode notBound3 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")}));
        FunctionNode notBound4 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")}));
        FunctionNode notBound5 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")}));
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)notBound1, (ValueExpressionNode)notBound2), (ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)notBound3, (ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)notBound4, (ValueExpressionNode)notBound5)))));
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setQueryHint("normalizeFilterExpressions", "true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        StatementPatternNode spn2 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause2.addChild((IGroupMemberNode)spn2);
        FunctionNode bound1 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode bound2 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode bound3 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound4 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound5 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FunctionNode or1 = FunctionNode.OR((ValueExpressionNode)bound1, (ValueExpressionNode)bound3);
        FunctionNode or2 = FunctionNode.OR((ValueExpressionNode)bound1, (ValueExpressionNode)bound4);
        FunctionNode or3 = FunctionNode.OR((ValueExpressionNode)bound1, (ValueExpressionNode)bound5);
        FunctionNode or4 = FunctionNode.OR((ValueExpressionNode)bound2, (ValueExpressionNode)bound3);
        FunctionNode or5 = FunctionNode.OR((ValueExpressionNode)bound2, (ValueExpressionNode)bound4);
        FunctionNode or6 = FunctionNode.OR((ValueExpressionNode)bound2, (ValueExpressionNode)bound5);
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)or1));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)or2));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)or3));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)or4));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)or5));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)or6));
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testOrAndSwitchRecursive() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode spn = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)spn);
        FunctionNode bound1 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode bound2 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode bound3 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound4 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound5 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FunctionNode bound6 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s6")});
        FunctionNode bound7 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s7")});
        FunctionNode bound8 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s8")});
        FunctionNode bound9 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s9")});
        FunctionNode bound10 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s10")});
        FunctionNode bound11 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s11")});
        FunctionNode bound12 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s12")});
        FunctionNode bound13 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s13")});
        FunctionNode bound14 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s14")});
        FunctionNode bound15 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s15")});
        FunctionNode bound16 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s16")});
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound1, (ValueExpressionNode)bound2), (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound3, (ValueExpressionNode)bound4)), (ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound5, (ValueExpressionNode)bound6), (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound7, (ValueExpressionNode)bound8))), (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound9, (ValueExpressionNode)bound10), (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound11, (ValueExpressionNode)bound12)), (ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound13, (ValueExpressionNode)bound14), (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound15, (ValueExpressionNode)bound16)))));
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        StatementPatternNode spn2 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause2.addChild((IGroupMemberNode)spn2);
        FunctionNode bound17 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode bound22 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode bound32 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound42 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound52 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FunctionNode bound62 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s6")});
        FunctionNode bound72 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s7")});
        FunctionNode bound82 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s8")});
        FunctionNode bound92 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s9")});
        FunctionNode bound102 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s10")});
        FunctionNode bound112 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s11")});
        FunctionNode bound122 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s12")});
        FunctionNode bound132 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s13")});
        FunctionNode bound142 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s14")});
        FunctionNode bound152 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s15")});
        FunctionNode bound162 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s16")});
        ArrayList<FunctionNode> lefts = new ArrayList<FunctionNode>();
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound17, (ValueExpressionNode)bound32));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound17, (ValueExpressionNode)bound42));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound22, (ValueExpressionNode)bound32));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound22, (ValueExpressionNode)bound42));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound52, (ValueExpressionNode)bound72));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound52, (ValueExpressionNode)bound82));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound62, (ValueExpressionNode)bound72));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound62, (ValueExpressionNode)bound82));
        ArrayList<FunctionNode> rights = new ArrayList<FunctionNode>();
        rights.add(FunctionNode.OR((ValueExpressionNode)bound92, (ValueExpressionNode)bound112));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound92, (ValueExpressionNode)bound122));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound102, (ValueExpressionNode)bound112));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound102, (ValueExpressionNode)bound122));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound132, (ValueExpressionNode)bound152));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound132, (ValueExpressionNode)bound162));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound142, (ValueExpressionNode)bound152));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound142, (ValueExpressionNode)bound162));
        for (FunctionNode left : lefts) {
            for (FunctionNode right : rights) {
                whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.OR((ValueExpressionNode)left, (ValueExpressionNode)right)));
            }
        }
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testOrOrAndSwitch() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode spn = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause.addChild((IGroupMemberNode)spn);
        FunctionNode bound1 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode bound2 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode bound3 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound4 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound5 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FunctionNode bound6 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s6")});
        FunctionNode bound7 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s7")});
        FunctionNode bound8 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s8")});
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound1, (ValueExpressionNode)bound2), (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound3, (ValueExpressionNode)bound4)), (ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound5, (ValueExpressionNode)bound6), (ValueExpressionNode)FunctionNode.AND((ValueExpressionNode)bound7, (ValueExpressionNode)bound8))));
        TestASTFilterNormalizationOptimizer.assertFalse((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        StatementPatternNode spn2 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        whereClause2.addChild((IGroupMemberNode)spn2);
        FunctionNode bound12 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")});
        FunctionNode bound22 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s2")});
        FunctionNode bound32 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s3")});
        FunctionNode bound42 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s4")});
        FunctionNode bound52 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s5")});
        FunctionNode bound62 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s6")});
        FunctionNode bound72 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s7")});
        FunctionNode bound82 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s8")});
        ArrayList<FunctionNode> lefts = new ArrayList<FunctionNode>();
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound12, (ValueExpressionNode)bound32));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound12, (ValueExpressionNode)bound42));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound22, (ValueExpressionNode)bound32));
        lefts.add(FunctionNode.OR((ValueExpressionNode)bound22, (ValueExpressionNode)bound42));
        ArrayList<FunctionNode> rights = new ArrayList<FunctionNode>();
        rights.add(FunctionNode.OR((ValueExpressionNode)bound52, (ValueExpressionNode)bound72));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound52, (ValueExpressionNode)bound82));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound62, (ValueExpressionNode)bound72));
        rights.add(FunctionNode.OR((ValueExpressionNode)bound62, (ValueExpressionNode)bound82));
        for (FunctionNode left : lefts) {
            for (FunctionNode right : rights) {
                whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.OR((ValueExpressionNode)left, (ValueExpressionNode)right)));
            }
        }
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testRemoveDuplicateFilter() {
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s1"), (TermNode)new VarNode("p1"), (TermNode)new VarNode("o1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        FunctionNode simpleFunctionNode1 = FunctionNode.NE((ValueExpressionNode)new VarNode("s1"), (ValueExpressionNode)new VarNode("s2"));
        FunctionNode simpleFunctionNode2 = FunctionNode.NE((ValueExpressionNode)new VarNode("s1"), (ValueExpressionNode)new VarNode("s2"));
        FunctionNode complexFunctionNode1 = FunctionNode.OR((ValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new VarNode("s1"), (ValueExpressionNode)new VarNode("s2")), (ValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")})));
        FunctionNode complexFunctionNode2 = FunctionNode.OR((ValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new VarNode("s1"), (ValueExpressionNode)new VarNode("s2")), (ValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")})));
        FunctionNode complexFunctionNode3 = FunctionNode.OR((ValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new VarNode("s1"), (ValueExpressionNode)new VarNode("s2")), (ValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")})));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)simpleFunctionNode1));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)simpleFunctionNode2));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)complexFunctionNode1));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)complexFunctionNode2));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s2"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)complexFunctionNode3));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((IValueExpressionNode)simpleFunctionNode1));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((IValueExpressionNode)simpleFunctionNode2));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((IValueExpressionNode)complexFunctionNode1));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((IValueExpressionNode)complexFunctionNode2));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((IValueExpressionNode)complexFunctionNode3));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s1"), (TermNode)new VarNode("p1"), (TermNode)new VarNode("o1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        FunctionNode simpleFunctionNode = FunctionNode.NE((ValueExpressionNode)new VarNode("s1"), (ValueExpressionNode)new VarNode("s2"));
        FunctionNode complexFunctionNode = FunctionNode.OR((ValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new VarNode("s1"), (ValueExpressionNode)new VarNode("s2")), (ValueExpressionNode)FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("s1")})));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)simpleFunctionNode));
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s2"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)complexFunctionNode));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((IValueExpressionNode)simpleFunctionNode));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((IValueExpressionNode)complexFunctionNode));
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testRemoveDuplicateGeneratedFilter() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI testUri = f.createURI("http://www.test.com");
        IV test = this.makeIV((Value)testUri);
        BigdataValue[] values = new BigdataValue[]{testUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o")), (ValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new ConstantNode(test))));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"))));
        TestASTFilterNormalizationOptimizer.assertTrue((boolean)StaticAnalysis.isCNF((FilterNode)filterNode));
        whereClause.addChild((IGroupMemberNode)filterNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"))));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new ConstantNode(test))));
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testRemoveUnsatisfiableFilters() {
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.setProperty("normalizeFilterExpressions", (Object)"true");
        given.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode spo1 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        StatementPatternNode spo2 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        JoinGroupNode jgn = new JoinGroupNode((IGroupMemberNode)spo2);
        StatementPatternNode spo3 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o3"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        spo3.setOptional(true);
        whereClause.addChild((IGroupMemberNode)spo1);
        whereClause.addChild((IGroupMemberNode)jgn);
        whereClause.addChild((IGroupMemberNode)spo3);
        FunctionNode filterBound1 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o1")});
        FunctionNode filterBound2 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o2")});
        FunctionNode filterBound3 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o3")});
        FunctionNode filterNotBound1 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o1")}));
        FunctionNode filterNotBound2 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o2")}));
        FunctionNode filterNotBound3 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o3")}));
        FunctionNode filterNotBound4 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o4")}));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterBound1));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterBound2));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterBound3));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterNotBound1));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterNotBound2));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterNotBound3));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterNotBound4));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterNotBound2));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterNotBound3));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.setProperty("normalizeFilterExpressions", (Object)"true");
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        StatementPatternNode spo12 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        StatementPatternNode spo22 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        JoinGroupNode jgn2 = new JoinGroupNode((IGroupMemberNode)spo22);
        StatementPatternNode spo32 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o3"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        spo32.setOptional(true);
        whereClause2.addChild((IGroupMemberNode)spo12);
        whereClause2.addChild((IGroupMemberNode)jgn2);
        whereClause2.addChild((IGroupMemberNode)spo32);
        FunctionNode filterBound32 = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o3")});
        FunctionNode filterNotBound12 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o1")}));
        FunctionNode filterNotBound22 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o2")}));
        FunctionNode filterNotBound32 = FunctionNode.NOT((ValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("o3")}));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterBound32));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterNotBound12));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterNotBound22));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)filterNotBound32));
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        ASTFilterNormalizationOptimizer rewriter = new ASTFilterNormalizationOptimizer();
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTFilterNormalizationOptimizer.assertSameAST((IQueryNode)expected, actual);
    }
}

