/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.sparql.ast.optimizers.ASTGraphGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSetValueExpressionsOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.InvalidGraphContextException;
import com.bigdata.rdf.store.AbstractTripleStore;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTGraphGroupOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTGraphGroupOptimizer() {
    }

    public TestASTGraphGroupOptimizer(String name) {
        super(name);
    }

    public void test_graphGroupOptimizer_01() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example.org/>\nSELECT ?s\nWHERE {\n  GRAPH ?g {\n    ?s :p :o .\n    OPTIONAL { ?g :p2 ?s }\n  }\n}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI p = f.createURI("http://example.org/p");
        BigdataURI p2 = f.createURI("http://example.org/p2");
        BigdataURI o = f.createURI("http://example.org/o");
        BigdataValue[] values = new BigdataValue[]{p, p2, o};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example.org/>\nSELECT ?s\nWHERE {\n  GRAPH ?g {\n    ?s :p :o .\n    OPTIONAL { ?g :p2 ?s }\n  }\n}", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        queryRoot = (QueryRoot)BOpUtility.deepCopy((BOp)queryRoot);
        queryRoot = (QueryRoot)new ASTGraphGroupOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        JoinGroupNode expectedClause = new JoinGroupNode();
        VarNode g = new VarNode("g");
        VarNode s = new VarNode("s");
        JoinGroupNode graphGroup = new JoinGroupNode();
        graphGroup.setContext((TermNode)g);
        expectedClause.addChild((IGroupMemberNode)graphGroup);
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)o.getIV())), (TermNode)g, StatementPattern.Scope.NAMED_CONTEXTS));
        JoinGroupNode optionalGroup = new JoinGroupNode(true);
        graphGroup.addChild((IGroupMemberNode)optionalGroup);
        optionalGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)g, (TermNode)new ConstantNode((IConstant)new Constant((Object)p2.getIV())), (TermNode)s, (TermNode)g, StatementPattern.Scope.NAMED_CONTEXTS));
        TestASTGraphGroupOptimizer.assertSameAST((IQueryNode)expectedClause, (IQueryNode)queryRoot.getWhereClause());
    }

    public void test_graphGroupOptimizer_02() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example.org/>\nSELECT ?s\nWHERE {\n  GRAPH ?g {\n    ?s :p :o .\n    GRAPH ?g1 { ?g :p2 ?s }\n  }\n}";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI p = f.createURI("http://example.org/p");
        BigdataURI p2 = f.createURI("http://example.org/p2");
        BigdataURI o = f.createURI("http://example.org/o");
        BigdataValue[] values = new BigdataValue[]{p, p2, o};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example.org/>\nSELECT ?s\nWHERE {\n  GRAPH ?g {\n    ?s :p :o .\n    GRAPH ?g1 { ?g :p2 ?s }\n  }\n}", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        queryRoot = (QueryRoot)BOpUtility.deepCopy((BOp)queryRoot);
        queryRoot = (QueryRoot)new ASTGraphGroupOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        JoinGroupNode expectedClause = new JoinGroupNode();
        VarNode g = new VarNode("g");
        VarNode g1 = new VarNode("g1");
        VarNode s = new VarNode("s");
        JoinGroupNode graphGroup = new JoinGroupNode();
        expectedClause.addChild((IGroupMemberNode)graphGroup);
        graphGroup.setContext((TermNode)g);
        graphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)s, (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new ConstantNode((IConstant)new Constant((Object)o.getIV())), (TermNode)g, StatementPattern.Scope.NAMED_CONTEXTS));
        JoinGroupNode innerGraphGroup = new JoinGroupNode();
        graphGroup.addChild((IGroupMemberNode)innerGraphGroup);
        innerGraphGroup.setContext((TermNode)g1);
        innerGraphGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)g, (TermNode)new ConstantNode((IConstant)new Constant((Object)p2.getIV())), (TermNode)s, (TermNode)g1, StatementPattern.Scope.NAMED_CONTEXTS));
        FilterNode filterNode = new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)g, (ValueExpressionNode)g1));
        GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
        AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)filterNode.getValueExpressionNode());
        innerGraphGroup.addChild((IGroupMemberNode)filterNode);
        TestASTGraphGroupOptimizer.assertSameAST((IQueryNode)expectedClause, (IQueryNode)queryRoot.getWhereClause());
    }

    public void test_graphContexts_constants_legal() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example.org/>\nSELECT ?s\nWHERE {\n  GRAPH :foo {\n    ?s :p :o .\n    GRAPH :foo { ?o :p2 ?s }\n  }\n}";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example.org/>\nSELECT ?s\nWHERE {\n  GRAPH :foo {\n    ?s :p :o .\n    GRAPH :foo { ?o :p2 ?s }\n  }\n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        new ASTGraphGroupOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)astContainer.getOriginalAST(), null));
    }

    public void test_graphContexts_constants_illegal() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example.org/>\nSELECT ?s\nWHERE {\n  GRAPH :foo {\n    ?s :p :o .\n    GRAPH :bar { ?o :p2 ?s }\n  }\n}";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example.org/>\nSELECT ?s\nWHERE {\n  GRAPH :foo {\n    ?s :p :o .\n    GRAPH :bar { ?o :p2 ?s }\n  }\n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        try {
            new ASTGraphGroupOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)astContainer.getOriginalAST(), null));
            TestASTGraphGroupOptimizer.fail((String)("Expecting: " + InvalidGraphContextException.class));
        }
        catch (InvalidGraphContextException ex) {
            // empty catch block
        }
    }
}

