/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.BigdataStatics;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTHashJoinOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSetValueExpressionsOptimizer;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTHashJoinOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTHashJoinOptimizer() {
    }

    public TestASTHashJoinOptimizer(String name) {
        super(name);
    }

    public void test_hashJoinOptimizer_BSBM_Q5() {
        BigdataValueFactory valueFactory = this.store.getLexiconRelation().getValueFactory();
        String rdfs = "http://www.w3.org/2000/01/rdf-schema#";
        String bsbm = "http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/";
        String productInstance = "http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/instances/dataFromProducer1/Product22";
        BigdataURI rdfsLabel = valueFactory.createURI("http://www.w3.org/2000/01/rdf-schema#label");
        BigdataURI productFeature = valueFactory.createURI("http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/productFeature");
        BigdataURI productPropertyNumeric1 = valueFactory.createURI("http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/productPropertyNumeric1");
        BigdataURI productPropertyNumeric2 = valueFactory.createURI("http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/productPropertyNumeric2");
        BigdataURI product53999 = valueFactory.createURI("http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/instances/dataFromProducer1/Product22");
        BigdataLiteral _120 = valueFactory.createLiteral("120", XSD.INTEGER);
        BigdataLiteral _170 = valueFactory.createLiteral("170", XSD.INTEGER);
        BigdataValue[] terms = new BigdataValue[]{rdfsLabel, productFeature, productPropertyNumeric1, productPropertyNumeric2, product53999, _120, _170};
        this.store.getLexiconRelation().addTerms(terms, terms.length, false);
        for (BigdataValue bv : terms) {
            bv.getIV().setValue(bv);
        }
        IBindingSet[] bsets = new IBindingSet[]{};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("product"));
        projection.addProjectionVar(new VarNode("productLabel"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(rdfsLabel.getIV()), (TermNode)new VarNode("productLabel"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new ConstantNode(product53999.getIV()), (ValueExpressionNode)new VarNode("product"))));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(product53999.getIV()), (TermNode)new ConstantNode(productFeature.getIV()), (TermNode)new VarNode("prodFeature"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(productFeature.getIV()), (TermNode)new VarNode("prodFeature"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(product53999.getIV()), (TermNode)new ConstantNode(productPropertyNumeric1.getIV()), (TermNode)new VarNode("origProperty1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(productPropertyNumeric1.getIV()), (TermNode)new VarNode("simProperty1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        FunctionNode left = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("simProperty1"), new FunctionNode(FunctionRegistry.ADD, null, new ValueExpressionNode[]{new VarNode("origProperty1"), new ConstantNode(_120.getIV())})});
        FunctionNode right = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("simProperty1"), new FunctionNode(FunctionRegistry.SUBTRACT, null, new ValueExpressionNode[]{new VarNode("origProperty1"), new ConstantNode(_120.getIV())})});
        FunctionNode expr = new FunctionNode(FunctionRegistry.AND, null, new ValueExpressionNode[]{left, right});
        FilterNode filter = new FilterNode((IValueExpressionNode)expr);
        whereClause.addChild((IGroupMemberNode)filter);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(product53999.getIV()), (TermNode)new ConstantNode(productPropertyNumeric2.getIV()), (TermNode)new VarNode("origProperty2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(productPropertyNumeric2.getIV()), (TermNode)new VarNode("simProperty2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        left = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("simProperty2"), new FunctionNode(FunctionRegistry.ADD, null, new ValueExpressionNode[]{new VarNode("origProperty2"), new ConstantNode(_170.getIV())})});
        right = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("simProperty2"), new FunctionNode(FunctionRegistry.SUBTRACT, null, new ValueExpressionNode[]{new VarNode("origProperty2"), new ConstantNode(_170.getIV())})});
        expr = new FunctionNode(FunctionRegistry.AND, null, new ValueExpressionNode[]{left, right});
        filter = new FilterNode((IValueExpressionNode)expr);
        whereClause.addChild((IGroupMemberNode)filter);
        OrderByNode orderByNode = new OrderByNode();
        given.setOrderBy(orderByNode);
        orderByNode.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("productLabel"), true));
        given.setSlice(new SliceNode(0L, 5L));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("product"));
        projection2.addProjectionVar(new VarNode("productLabel"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(product53999.getIV()), (TermNode)new ConstantNode(productFeature.getIV()), (TermNode)new VarNode("prodFeature"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(productFeature.getIV()), (TermNode)new VarNode("prodFeature"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new ConstantNode(product53999.getIV()), (ValueExpressionNode)new VarNode("product"))));
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(rdfsLabel.getIV()), (TermNode)new VarNode("productLabel"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode subGroup = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)subGroup);
        subGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(product53999.getIV()), (TermNode)new ConstantNode(productPropertyNumeric1.getIV()), (TermNode)new VarNode("origProperty1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        subGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(productPropertyNumeric1.getIV()), (TermNode)new VarNode("simProperty1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        FunctionNode left2 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("simProperty1"), new FunctionNode(FunctionRegistry.ADD, null, new ValueExpressionNode[]{new VarNode("origProperty1"), new ConstantNode(_120.getIV())})});
        FunctionNode right2 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("simProperty1"), new FunctionNode(FunctionRegistry.SUBTRACT, null, new ValueExpressionNode[]{new VarNode("origProperty1"), new ConstantNode(_120.getIV())})});
        FunctionNode expr2 = new FunctionNode(FunctionRegistry.AND, null, new ValueExpressionNode[]{left2, right2});
        FilterNode filter2 = new FilterNode((IValueExpressionNode)expr2);
        subGroup.addChild((IGroupMemberNode)filter2);
        subGroup = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)subGroup);
        subGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(product53999.getIV()), (TermNode)new ConstantNode(productPropertyNumeric2.getIV()), (TermNode)new VarNode("origProperty2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        subGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(productPropertyNumeric2.getIV()), (TermNode)new VarNode("simProperty2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        left2 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("simProperty2"), new FunctionNode(FunctionRegistry.ADD, null, new ValueExpressionNode[]{new VarNode("origProperty2"), new ConstantNode(_170.getIV())})});
        right2 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("simProperty2"), new FunctionNode(FunctionRegistry.SUBTRACT, null, new ValueExpressionNode[]{new VarNode("origProperty2"), new ConstantNode(_170.getIV())})});
        expr2 = new FunctionNode(FunctionRegistry.AND, null, new ValueExpressionNode[]{left2, right2});
        filter2 = new FilterNode((IValueExpressionNode)expr2);
        subGroup.addChild((IGroupMemberNode)filter2);
        OrderByNode orderByNode2 = new OrderByNode();
        expected.setOrderBy(orderByNode2);
        orderByNode2.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("productLabel"), true));
        expected.setSlice(new SliceNode(0L, 5L));
        ASTHashJoinOptimizer rewriter = new ASTHashJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets));
        new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)expected, bsets));
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        if (!BigdataStatics.runKnownBadTests) {
            return;
        }
        TestASTHashJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }
}

