/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupOrderOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTOptimizerList;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractOptimizerTestCase;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractOptimizerTestCaseWithUtilityMethods;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;

public class TestASTJoinGroupOrderOptimizer
extends AbstractOptimizerTestCaseWithUtilityMethods {
    public TestASTJoinGroupOrderOptimizer() {
    }

    public TestASTJoinGroupOrderOptimizer(String name) {
        super(name);
    }

    @Override
    IASTOptimizer newOptimizer() {
        return new ASTOptimizerList(new IASTOptimizer[]{new ASTJoinGroupOrderOptimizer()});
    }

    public void testFilterPlacement01() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.filterWithVars("x1", "x2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.filterWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testFilterPlacement02() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x1"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x2"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x1", "x3"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("x4"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.filterNotExistsWithVars("x3", new String[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.filterWithVar("x4"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x1"), TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x2"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x1", "x3"), TestASTJoinGroupOrderOptimizer.this.filterNotExistsWithVars("x3", new String[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testFilterPlacement03() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), this.joinGroupNode(TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("x1"))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), this.joinGroupNode(TestASTJoinGroupOrderOptimizer.this.filterWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"))}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testFilterPlacement04() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVars("x2", "x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y2"), TestASTJoinGroupOrderOptimizer.this.filterWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("y2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.filterWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVars("x2", "x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y2"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("y2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testBindPlacement01() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.assignmentWithConst("x1"), TestASTJoinGroupOrderOptimizer.this.assignmentWithConst("x4"), TestASTJoinGroupOrderOptimizer.this.assignmentWithConst("x2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.assignmentWithConst("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.assignmentWithConst("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.assignmentWithConst("x4")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testBindPlacement02() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("x2", "x1"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("x2", "x3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("x2", "x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("x2", "x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testBindPlacement03() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVars("y1", "z1"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("z1", "y1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("z1", "y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVars("y1", "z1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testValuesPlacement01() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("x1"), TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("x1", "x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("x1"), TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("x1", "x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testValuesPlacement02() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("s"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVars("s", "o"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("o", "reused"), TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("reused")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("s"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("reused"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("o", "reused"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVars("s", "o")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testServicePlacementSparql11a() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithVariable("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithVariable("x3", "x4", "x5")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithVariable("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithVariable("x3", "x4", "x5"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testServicePlacementSparql11b() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithVariable("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithVariable("x2", "x1", "x3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithVariable("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithVariable("x2", "x1", "x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testServicePlacementSparql11c() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithConstant("x1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4"), TestASTJoinGroupOrderOptimizer.this.serviceSparql11WithConstant("x1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testServicePlacementServiceBDS() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4"), TestASTJoinGroupOrderOptimizer.this.serviceBDSWithVariable("x2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.serviceBDSWithVariable("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x4")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testServicePlacementServiceFTS01() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inSearch"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inEndpoint"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inParams"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outRes"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outScore"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outSnippet"), TestASTJoinGroupOrderOptimizer.this.serviceFTSWithVariable("outRes", "outScore", "outSnippet", "inSearch", "inEndpoint", "inParams")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inSearch"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inEndpoint"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inParams"), TestASTJoinGroupOrderOptimizer.this.serviceFTSWithVariable("outRes", "outScore", "outSnippet", "inSearch", "inEndpoint", "inParams"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outRes"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outScore"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outSnippet")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testServicePlacementServiceFTS02() {
        final JoinGroupNode jgnOpt = this.joinGroupWithVars("inParams2", "z");
        jgnOpt.setOptional(true);
        new AbstractOptimizerTestCase.Helper(){
            {
                super(TestASTJoinGroupOrderOptimizer.this);
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.serviceFTSWithVariable("outRes", "outScore", "outSnippet", "inSearch", "inEndpoint", "inParams"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inSearch"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inEndpoint"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outRes"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inParams"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outScore"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outSnippet"), jgnOpt, TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("z"), TestASTJoinGroupOrderOptimizer.this.serviceFTSWithVariable("outRes", "outScore", "outSnippet", "inSearch", "inEndpoint", "inParams2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inSearch"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inEndpoint"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outRes"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inParams"), TestASTJoinGroupOrderOptimizer.this.serviceFTSWithVariable("outRes", "outScore", "outSnippet", "inSearch", "inEndpoint", "inParams"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outScore"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outSnippet"), jgnOpt, TestASTJoinGroupOrderOptimizer.this.serviceFTSWithVariable("outRes", "outScore", "outSnippet", "inSearch", "inEndpoint", "inParams2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("z")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testServiceBindDependencyOrdering() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("X"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inEndpoint"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inParams"), TestASTJoinGroupOrderOptimizer.this.serviceFTSWithVariable("outRes", "outScore", "outSnippet", "inSearch", "inEndpoint", "inParams"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outRes"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outScore"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outSnippet"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("inSearch", "X"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("dummy", "Y")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("X"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inEndpoint"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("inParams"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outRes"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outScore"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("outSnippet"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("inSearch", "X"), TestASTJoinGroupOrderOptimizer.this.serviceFTSWithVariable("outRes", "outScore", "outSnippet", "inSearch", "inEndpoint", "inParams"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("dummy", "Y")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testPlacementInContextOfUnions() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.unionWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("x1", "x1", "x2"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("x3", "x3"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("bound", "x3"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("bound", "x1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.unionWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("x1", "x1", "x2"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("x3", "x3"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("bound", "x1"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("bound", "x3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testPlacementInContextOfSubquery() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("boundVar", "x3"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x2", "x3"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x3", "x4"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x4", "boundVar")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x2", "x3"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x3", "x4"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("boundVar", "x3"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x4", "boundVar")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testPlacementInContextOfNamedSubquery() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.namedSubQuery("_set1", this.varNode("x1"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("x1"), (TermNode)this.varNode("inner"), this.constantNode(this.b), new Object[0])}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("boundVar", "x1"), this.namedSubQueryInclude("_set1", new AbstractOptimizerTestCase.ApplyAnnotation[0]), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("boundVar")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.namedSubQuery("_set1", this.varNode("x1"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("x1"), (TermNode)this.varNode("inner"), this.constantNode(this.b), new Object[0])}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_set1", new AbstractOptimizerTestCase.ApplyAnnotation[0]), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("boundVar", "x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("boundVar")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testPlacementInContextOfOptional() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("bound"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("bound", "x1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("bound"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("bound", "x1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testComplexOptimization01() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.alpNodeWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("y2", "y1", "y2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("y1", "y4", "y5"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("z1"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("a1", "a2"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("z1", "z2"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.filterWithVars("x1", "y1"), TestASTJoinGroupOrderOptimizer.this.filterWithVars("x1", "z1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("a1", "a2"), TestASTJoinGroupOrderOptimizer.this.alpNodeWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), TestASTJoinGroupOrderOptimizer.this.filterWithVars("x1", "y1"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("y2", "y1", "y2"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("y1", "y4", "y5"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("z1"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("z1", "z2"), TestASTJoinGroupOrderOptimizer.this.filterWithVars("x1", "z1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testOptional01() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarsOptional("x1", "y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVars("x1", "z1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVars("x1", "z1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarsOptional("x1", "y1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testOptional02() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarsOptional("x1", "y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarsOptional("x1", "y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testComplexOptimization02() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.alpNodeWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("y2", "y1", "y2"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("y1", "y4", "y5"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("x1", "z1"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("bound", "y1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.bindingsClauseWithVars("x1", "z1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.alpNodeWithVars("x1", "x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), TestASTJoinGroupOrderOptimizer.this.unionWithVars("y2", "y1", "y2"), TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("y1", "y4", "y5"), TestASTJoinGroupOrderOptimizer.this.assignmentWithVar("bound", "y1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testNamedSubqueryPlacement01() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.namedSubQuery("_set1", this.varNode("y1"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("y1"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), this.namedSubQueryInclude("_set1", new AbstractOptimizerTestCase.ApplyAnnotation[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.namedSubQuery("_set1", this.varNode("y1"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("y1"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), this.namedSubQueryInclude("_set1", new AbstractOptimizerTestCase.ApplyAnnotation[0]), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testNamedSubqueryPlacement02() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.namedSubQuery("_set1", this.varNode("x1"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("x1"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), this.namedSubQueryInclude("_set1", new AbstractOptimizerTestCase.ApplyAnnotation[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.namedSubQuery("_set1", this.varNode("x1"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("x1"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_set1", new AbstractOptimizerTestCase.ApplyAnnotation[0]), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testAskSubquery01() {
        String anonFilterVar1 = "--exists-1";
        final String[] filterVars1 = new String[]{"x1"};
        String anonFilterVar2 = "--not-exists-1";
        final String[] filterVars2 = new String[]{"y1", "y2", "y3"};
        new AbstractOptimizerTestCase.Helper(){
            {
                super(TestASTJoinGroupOrderOptimizer.this);
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--not-exists-1", filterVars2), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--not-exists-1", filterVars2), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("y3"), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--not-exists-1", filterVars2), TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--not-exists-1", filterVars2)}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testAskSubquery02() {
        String anonFilterVar1 = "--exists-1";
        final String[] filterVars1 = new String[]{"x1"};
        String anonFilterVar2 = "--not-exists-1";
        final String[] filterVars2 = new String[]{"y1", "y2", "y3"};
        final JoinGroupNode optJG = this.joinGroupWithVars("y1", "y3");
        optJG.setOptional(true);
        new AbstractOptimizerTestCase.Helper(){
            {
                super(TestASTJoinGroupOrderOptimizer.this);
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--not-exists-1", filterVars2), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--not-exists-1", filterVars2), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("y1", "y2"), optJG, TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("y1", "y3"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("y2", "y3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVarOptional("y1"), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("y1", "y2"), optJG, TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("y1", "y3"), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--not-exists-1", filterVars2), TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--not-exists-1", filterVars2), TestASTJoinGroupOrderOptimizer.this.joinGroupWithVars("y2", "y3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void testAskSubquery03() {
        String anonFilterVar1 = "--exists-1";
        final String[] filterVars1 = new String[]{"x1"};
        new AbstractOptimizerTestCase.Helper(){
            {
                super(TestASTJoinGroupOrderOptimizer.this);
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.filterWithVar("x1"), TestASTJoinGroupOrderOptimizer.this.filterExistsOrNotExistsSubqueryWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.filterExistsWithVars("--exists-1", filterVars1), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x2"), TestASTJoinGroupOrderOptimizer.this.stmtPatternWithVar("x3")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testTicket1363a() {
        JoinGroupNode jgn1a = new JoinGroupNode();
        JoinGroupNode jgn1b = new JoinGroupNode();
        jgn1a.addChild((IGroupMemberNode)this.stmtPatternWithVar("y1"));
        jgn1b.addChild((IGroupMemberNode)this.stmtPatternWithVar("y1"));
        JoinGroupNode jgn2a = new JoinGroupNode();
        JoinGroupNode jgn2b = new JoinGroupNode();
        jgn2a.addChild((IGroupMemberNode)this.stmtPatternWithVar("y2"));
        jgn2b.addChild((IGroupMemberNode)this.stmtPatternWithVar("y2"));
        final UnionNode unA = new UnionNode();
        unA.addChild(jgn1a);
        unA.addChild(jgn2a);
        final UnionNode unB = new UnionNode();
        unB.addChild(jgn1b);
        unB.addChild(jgn2b);
        new AbstractOptimizerTestCase.Helper(){
            {
                super(TestASTJoinGroupOrderOptimizer.this);
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{unA, TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x1", "x2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{unB, TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x1", "x2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testTicket1363b() {
        JoinGroupNode jgn1a = new JoinGroupNode();
        JoinGroupNode jgn1b = new JoinGroupNode();
        jgn1a.addChild((IGroupMemberNode)this.assignmentWithVar("z", "x1"));
        jgn1b.addChild((IGroupMemberNode)this.assignmentWithVar("z", "x1"));
        JoinGroupNode jgn2a = new JoinGroupNode();
        JoinGroupNode jgn2b = new JoinGroupNode();
        jgn2a.addChild((IGroupMemberNode)this.stmtPatternWithVar("y1"));
        jgn2b.addChild((IGroupMemberNode)this.stmtPatternWithVar("y1"));
        final UnionNode unA = new UnionNode();
        unA.addChild(jgn1a);
        unA.addChild(jgn2a);
        final UnionNode unB = new UnionNode();
        unB.addChild(jgn1b);
        unB.addChild(jgn2b);
        new AbstractOptimizerTestCase.Helper(){
            {
                super(TestASTJoinGroupOrderOptimizer.this);
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{unA, TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x1", "x2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x1", "x2"), unB}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public void testTicket1363c() {
        JoinGroupNode jgn1a = new JoinGroupNode();
        jgn1a.addChild((IGroupMemberNode)this.assignmentWithVar("z", "x1"));
        jgn1a.addChild((IGroupMemberNode)this.stmtPatternWithVar("x1"));
        JoinGroupNode jgn1b = new JoinGroupNode();
        jgn1b.addChild((IGroupMemberNode)this.stmtPatternWithVar("x1"));
        jgn1b.addChild((IGroupMemberNode)this.assignmentWithVar("z", "x1"));
        JoinGroupNode jgn2a = new JoinGroupNode();
        JoinGroupNode jgn2b = new JoinGroupNode();
        jgn2a.addChild((IGroupMemberNode)this.stmtPatternWithVar("x1"));
        jgn2b.addChild((IGroupMemberNode)this.stmtPatternWithVar("x1"));
        final UnionNode unA = new UnionNode();
        unA.addChild(jgn1a);
        unA.addChild(jgn2a);
        final UnionNode unB = new UnionNode();
        unB.addChild(jgn1b);
        unB.addChild(jgn2b);
        new AbstractOptimizerTestCase.Helper(){
            {
                super(TestASTJoinGroupOrderOptimizer.this);
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{unA, TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x1", "x2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{unB, TestASTJoinGroupOrderOptimizer.this.subqueryWithVars("x1", "x2")}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }
}

