/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.Var;
import com.bigdata.rdf.sparql.ast.GroupNodeVarBindingInfoMap;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupPartition;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupPartitions;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractOptimizerTestCaseWithUtilityMethods;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.ArrayList;
import java.util.HashSet;

public class TestASTJoinGroupPartitioning
extends AbstractOptimizerTestCaseWithUtilityMethods {
    public TestASTJoinGroupPartitioning() {
    }

    public TestASTJoinGroupPartitioning(String name) {
        super(name);
    }

    @Override
    IASTOptimizer newOptimizer() {
        return null;
    }

    public void testEmptyPartitions() {
        HashSet external;
        ArrayList<IGroupMemberNode> nodes = new ArrayList<IGroupMemberNode>();
        GroupNodeVarBindingInfoMap bindingInfo = new GroupNodeVarBindingInfoMap(nodes, this.statisAnalysisForNodes(nodes), null);
        ASTJoinGroupPartitions partitions = new ASTJoinGroupPartitions(nodes, bindingInfo, external = new HashSet());
        TestASTJoinGroupPartitioning.assertTrue((partitions.getPartitionList().size() == 1 ? 1 : 0) != 0);
        TestASTJoinGroupPartitioning.assertTrue((boolean)((ASTJoinGroupPartition)partitions.getPartitionList().get((int)0)).nonOptionalNonMinusNodes.isEmpty());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partitions.extractNodeList(true).isEmpty());
    }

    public void testSinglePartitionWithOneStatementPattern() {
        StatementPatternNode spn = this.stmtPatternWithVar("x");
        ArrayList<IGroupMemberNode> nodes = new ArrayList<IGroupMemberNode>();
        nodes.add((IGroupMemberNode)spn);
        GroupNodeVarBindingInfoMap bindingInfo = new GroupNodeVarBindingInfoMap(nodes, this.statisAnalysisForNodes(nodes), null);
        HashSet<Var> external = new HashSet<Var>();
        external.add(Var.var((String)"y"));
        external.add(Var.var((String)"z"));
        ASTJoinGroupPartitions partitions = new ASTJoinGroupPartitions(nodes, bindingInfo, external);
        TestASTJoinGroupPartitioning.assertEquals((int)1, (int)partitions.getPartitionList().size());
        TestASTJoinGroupPartitioning.assertEquals((int)1, (int)partitions.extractNodeList(true).size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partitions.extractNodeList(true).contains(spn));
        ASTJoinGroupPartition partition = (ASTJoinGroupPartition)partitions.getPartitionList().get(0);
        TestASTJoinGroupPartitioning.assertEquals((int)1, (int)partition.extractNodeList(true).size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.extractNodeList(true).contains(spn));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.externallyBound.equals(external));
        TestASTJoinGroupPartitioning.assertEquals((int)1, (int)partition.nonOptionalNonMinusNodes.size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.nonOptionalNonMinusNodes.contains(spn));
        TestASTJoinGroupPartitioning.assertTrue((partition.optionalOrMinus == null ? 1 : 0) != 0);
        TestASTJoinGroupPartitioning.assertEquals((int)3, (int)partition.definitelyProduced.size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.definitelyProduced.contains(Var.var((String)"x")));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.definitelyProduced.contains(Var.var((String)"y")));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.definitelyProduced.contains(Var.var((String)"z")));
    }

    public void testSinglePartitionWithTwoStatementPattern() {
        StatementPatternNode spn1 = this.stmtPatternWithVar("x1");
        StatementPatternNode spn2 = this.stmtPatternWithVar("x2");
        ArrayList<IGroupMemberNode> nodes = new ArrayList<IGroupMemberNode>();
        nodes.add((IGroupMemberNode)spn1);
        nodes.add((IGroupMemberNode)spn2);
        GroupNodeVarBindingInfoMap bindingInfo = new GroupNodeVarBindingInfoMap(nodes, this.statisAnalysisForNodes(nodes), null);
        HashSet<Var> external = new HashSet<Var>();
        external.add(Var.var((String)"y"));
        ASTJoinGroupPartitions partitions = new ASTJoinGroupPartitions(nodes, bindingInfo, external);
        TestASTJoinGroupPartitioning.assertEquals((int)1, (int)partitions.getPartitionList().size());
        TestASTJoinGroupPartitioning.assertEquals((int)2, (int)partitions.extractNodeList(true).size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partitions.extractNodeList(true).contains(spn1));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partitions.extractNodeList(true).contains(spn2));
        ASTJoinGroupPartition partition = (ASTJoinGroupPartition)partitions.getPartitionList().get(0);
        TestASTJoinGroupPartitioning.assertEquals((int)2, (int)partition.extractNodeList(true).size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.extractNodeList(true).contains(spn1));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.extractNodeList(true).contains(spn2));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.externallyBound.equals(external));
        TestASTJoinGroupPartitioning.assertEquals((int)2, (int)partition.nonOptionalNonMinusNodes.size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.nonOptionalNonMinusNodes.contains(spn1));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.nonOptionalNonMinusNodes.contains(spn2));
        TestASTJoinGroupPartitioning.assertNull((Object)partition.optionalOrMinus);
        TestASTJoinGroupPartitioning.assertEquals((int)3, (int)partition.definitelyProduced.size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.definitelyProduced.contains(Var.var((String)"x1")));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.definitelyProduced.contains(Var.var((String)"x2")));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.definitelyProduced.contains(Var.var((String)"y")));
    }

    public void testSinglePartitionWithThreeStatementPattern() {
        StatementPatternNode spn1 = this.stmtPatternWithVar("x1");
        StatementPatternNode spn2 = this.stmtPatternWithVar("x2");
        StatementPatternNode spn3Opt = this.stmtPatternWithVarOptional("x3");
        ArrayList<IGroupMemberNode> nodes = new ArrayList<IGroupMemberNode>();
        nodes.add((IGroupMemberNode)spn1);
        nodes.add((IGroupMemberNode)spn2);
        nodes.add((IGroupMemberNode)spn3Opt);
        GroupNodeVarBindingInfoMap bindingInfo = new GroupNodeVarBindingInfoMap(nodes, this.statisAnalysisForNodes(nodes), null);
        ASTJoinGroupPartitions partitions = new ASTJoinGroupPartitions(nodes, bindingInfo, new HashSet());
        TestASTJoinGroupPartitioning.assertEquals((int)1, (int)partitions.getPartitionList().size());
        TestASTJoinGroupPartitioning.assertEquals((int)3, (int)partitions.extractNodeList(true).size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partitions.extractNodeList(true).contains(spn1));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partitions.extractNodeList(true).contains(spn2));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partitions.extractNodeList(true).contains(spn3Opt));
        ASTJoinGroupPartition partition = (ASTJoinGroupPartition)partitions.getPartitionList().get(0);
        TestASTJoinGroupPartitioning.assertEquals((int)3, (int)partition.extractNodeList(true).size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.extractNodeList(true).contains(spn1));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.extractNodeList(true).contains(spn2));
        TestASTJoinGroupPartitioning.assertEquals((int)2, (int)partition.nonOptionalNonMinusNodes.size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.nonOptionalNonMinusNodes.contains(spn1));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.nonOptionalNonMinusNodes.contains(spn2));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.optionalOrMinus.equals(spn3Opt));
        TestASTJoinGroupPartitioning.assertEquals((int)2, (int)partition.definitelyProduced.size());
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.definitelyProduced.contains(Var.var((String)"x1")));
        TestASTJoinGroupPartitioning.assertTrue((boolean)partition.definitelyProduced.contains(Var.var((String)"x2")));
    }

    public void testMultiplePartitionsWithStatementPattern() {
        StatementPatternNode spn1 = this.stmtPatternWithVar("x1");
        StatementPatternNode spn2 = this.stmtPatternWithVar("x2");
        StatementPatternNode spn3Opt = this.stmtPatternWithVarOptional("x3");
        StatementPatternNode spn4 = this.stmtPatternWithVar("x4");
        StatementPatternNode spn5Opt = this.stmtPatternWithVarOptional("x5");
        StatementPatternNode spn6 = this.stmtPatternWithVar("x6");
        StatementPatternNode spn7Opt = this.stmtPatternWithVarOptional("x7");
        StatementPatternNode spn8 = this.stmtPatternWithVar("x8");
        ArrayList<IGroupMemberNode> nodes = new ArrayList<IGroupMemberNode>();
        nodes.add((IGroupMemberNode)spn1);
        nodes.add((IGroupMemberNode)spn2);
        nodes.add((IGroupMemberNode)spn3Opt);
        nodes.add((IGroupMemberNode)spn4);
        nodes.add((IGroupMemberNode)spn5Opt);
        nodes.add((IGroupMemberNode)spn6);
        nodes.add((IGroupMemberNode)spn7Opt);
        nodes.add((IGroupMemberNode)spn8);
        GroupNodeVarBindingInfoMap bindingInfo = new GroupNodeVarBindingInfoMap(nodes, this.statisAnalysisForNodes(nodes), null);
        HashSet<Var> external = new HashSet<Var>();
        external.add(Var.var((String)"y"));
        ASTJoinGroupPartitions partitions = new ASTJoinGroupPartitions(nodes, bindingInfo, external);
        TestASTJoinGroupPartitioning.assertEquals((int)4, (int)partitions.getPartitionList().size());
        TestASTJoinGroupPartitioning.assertEquals(nodes, (Object)partitions.extractNodeList(true));
        ASTJoinGroupPartition p1 = (ASTJoinGroupPartition)partitions.getPartitionList().get(0);
        ArrayList<StatementPatternNode> p1Exp = new ArrayList<StatementPatternNode>();
        p1Exp.add(spn1);
        p1Exp.add(spn2);
        p1Exp.add(spn3Opt);
        TestASTJoinGroupPartitioning.assertEquals(p1Exp, (Object)p1.extractNodeList(true));
        TestASTJoinGroupPartitioning.assertEquals((Object)spn3Opt, (Object)p1.optionalOrMinus);
        TestASTJoinGroupPartitioning.assertEquals(this.varSet("y", "x1", "x2"), (Object)p1.definitelyProduced);
        ASTJoinGroupPartition p2 = (ASTJoinGroupPartition)partitions.getPartitionList().get(1);
        ArrayList<StatementPatternNode> p2Exp = new ArrayList<StatementPatternNode>();
        p2Exp.add(spn4);
        p2Exp.add(spn5Opt);
        TestASTJoinGroupPartitioning.assertEquals(p2Exp, (Object)p2.extractNodeList(true));
        TestASTJoinGroupPartitioning.assertEquals((Object)spn5Opt, (Object)p2.optionalOrMinus);
        TestASTJoinGroupPartitioning.assertEquals(this.varSet("y", "x1", "x2", "x4"), (Object)p2.definitelyProduced);
        ASTJoinGroupPartition p3 = (ASTJoinGroupPartition)partitions.getPartitionList().get(2);
        ArrayList<StatementPatternNode> p3Exp = new ArrayList<StatementPatternNode>();
        p3Exp.add(spn6);
        p3Exp.add(spn7Opt);
        TestASTJoinGroupPartitioning.assertEquals(p3Exp, (Object)p3.extractNodeList(true));
        TestASTJoinGroupPartitioning.assertEquals((Object)spn7Opt, (Object)p3.optionalOrMinus);
        TestASTJoinGroupPartitioning.assertEquals(this.varSet("y", "x1", "x2", "x4", "x6"), (Object)p3.definitelyProduced);
        ASTJoinGroupPartition p4 = (ASTJoinGroupPartition)partitions.getPartitionList().get(3);
        ArrayList<StatementPatternNode> p4Exp = new ArrayList<StatementPatternNode>();
        p4Exp.add(spn8);
        TestASTJoinGroupPartitioning.assertEquals(p4Exp, (Object)p4.extractNodeList(true));
        TestASTJoinGroupPartitioning.assertNull((Object)p4.optionalOrMinus);
        TestASTJoinGroupPartitioning.assertEquals(this.varSet("y", "x1", "x2", "x4", "x6", "x8"), (Object)p4.definitelyProduced);
    }

    public void testComplexMultiplePartitions() {
        StatementPatternNode n1 = this.stmtPatternWithVar("x1");
        StatementPatternNode n2 = this.stmtPatternWithVar("x2");
        JoinGroupNode n3 = this.joinGroupWithVars("x2", "x4");
        JoinGroupNode n4 = this.joinGroupWithVars("x5");
        n4.setOptional(true);
        JoinGroupNode n5 = this.joinGroupWithVars("x2", "x6");
        SubqueryRoot n6 = this.subqueryWithVars("x5", "x1");
        JoinGroupNode n7 = this.joinGroupWithVars("x3", "x4");
        n7.setMinus(true);
        ServiceNode n8 = this.serviceSparql11WithConstant("x7", "x1");
        UnionNode n9 = this.unionWithVars("x2", "x3");
        UnionNode n10 = this.unionWithVars("x8", "x8", "x7");
        ArrayList<IGroupMemberNode> nodes = new ArrayList<IGroupMemberNode>();
        nodes.add((IGroupMemberNode)n1);
        nodes.add((IGroupMemberNode)n2);
        nodes.add((IGroupMemberNode)n3);
        nodes.add((IGroupMemberNode)n4);
        nodes.add((IGroupMemberNode)n5);
        nodes.add((IGroupMemberNode)n6);
        nodes.add((IGroupMemberNode)n7);
        nodes.add((IGroupMemberNode)n8);
        nodes.add((IGroupMemberNode)n9);
        nodes.add((IGroupMemberNode)n10);
        GroupNodeVarBindingInfoMap bindingInfo = new GroupNodeVarBindingInfoMap(nodes, this.statisAnalysisForNodes(nodes), null);
        ASTJoinGroupPartitions partitions = new ASTJoinGroupPartitions(nodes, bindingInfo, new HashSet());
        TestASTJoinGroupPartitioning.assertEquals((int)3, (int)partitions.getPartitionList().size());
        TestASTJoinGroupPartitioning.assertEquals(nodes, (Object)partitions.extractNodeList(true));
        ASTJoinGroupPartition p1 = (ASTJoinGroupPartition)partitions.getPartitionList().get(0);
        ArrayList<Object> p1Exp = new ArrayList<Object>();
        p1Exp.add(n1);
        p1Exp.add(n2);
        p1Exp.add(n3);
        p1Exp.add(n4);
        TestASTJoinGroupPartitioning.assertEquals(p1Exp, (Object)p1.extractNodeList(true));
        TestASTJoinGroupPartitioning.assertEquals((Object)n4, (Object)p1.optionalOrMinus);
        TestASTJoinGroupPartitioning.assertEquals(this.varSet("x1", "x2", "x4"), (Object)p1.definitelyProduced);
        ASTJoinGroupPartition p2 = (ASTJoinGroupPartition)partitions.getPartitionList().get(1);
        ArrayList<Object> p2Exp = new ArrayList<Object>();
        p2Exp.add(n5);
        p2Exp.add(n6);
        p2Exp.add(n7);
        TestASTJoinGroupPartitioning.assertEquals(p2Exp, (Object)p2.extractNodeList(true));
        TestASTJoinGroupPartitioning.assertEquals((Object)n7, (Object)p2.optionalOrMinus);
        TestASTJoinGroupPartitioning.assertEquals(this.varSet("x1", "x2", "x4", "x5", "x6"), (Object)p2.definitelyProduced);
        ASTJoinGroupPartition p3 = (ASTJoinGroupPartition)partitions.getPartitionList().get(2);
        ArrayList<Object> p3Exp = new ArrayList<Object>();
        p3Exp.add(n8);
        p3Exp.add(n9);
        p3Exp.add(n10);
        TestASTJoinGroupPartitioning.assertEquals(p3Exp, (Object)p3.extractNodeList(true));
        TestASTJoinGroupPartitioning.assertNull((Object)p3.optionalOrMinus);
        TestASTJoinGroupPartitioning.assertEquals(this.varSet("x1", "x2", "x4", "x5", "x6", "x7", "x8"), (Object)p3.definitelyProduced);
    }
}

