/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTNamedSubqueryOptimizer;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import java.util.LinkedHashSet;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTNamedSubqueryOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTNamedSubqueryOptimizer() {
    }

    public TestASTNamedSubqueryOptimizer(String name) {
        super(name);
    }

    public void test_static_analysis_join_vars() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)RDF.TYPE);
        IV rdfsLabel = this.makeIV((Value)RDFS.LABEL);
        IV person = this.makeIV((Value)FOAFVocabularyDecl.Person);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        String namedSet1 = "namedSet1";
        VarNode[] joinVars = new VarNode[]{new VarNode("x")};
        NamedSubqueryRoot nsr = new NamedSubqueryRoot(QueryType.SELECT, "namedSet1");
        given.getNamedSubqueriesNotNull().add((IQueryNode)nsr);
        ProjectionNode projection = new ProjectionNode();
        nsr.setProjection(projection);
        projection.addProjectionVar(new VarNode("x"));
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        nsr.setWhereClause((GraphPatternGroup)new JoinGroupNode((IGroupMemberNode)subqueryRoot));
        ProjectionNode projection2 = new ProjectionNode();
        nsr.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        nsr.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(person), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ProjectionNode projection3 = new ProjectionNode();
        given.setProjection(projection3);
        projection3.addProjectionVar(new VarNode("s"));
        projection3.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new NamedSubqueryInclude("namedSet1"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        NamedSubqueryRoot nsr2 = new NamedSubqueryRoot(QueryType.SELECT, "namedSet1");
        expected.getNamedSubqueriesNotNull().add((IQueryNode)nsr2);
        projection2 = new ProjectionNode();
        nsr2.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("x"));
        SubqueryRoot subqueryRoot2 = new SubqueryRoot(QueryType.SELECT);
        nsr2.setWhereClause((GraphPatternGroup)new JoinGroupNode((IGroupMemberNode)subqueryRoot2));
        ProjectionNode projection4 = new ProjectionNode();
        nsr2.setProjection(projection4);
        projection4.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause3 = new JoinGroupNode();
        nsr2.setWhereClause((GraphPatternGroup)whereClause3);
        whereClause3.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(person), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        nsr2.setDependsOn(new String[0]);
        nsr2.setJoinVars(joinVars);
        projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause4 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause4);
        whereClause4.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        NamedSubqueryInclude nsi = new NamedSubqueryInclude("namedSet1");
        whereClause4.addChild((IGroupMemberNode)nsi);
        nsi.setJoinVars(joinVars);
        ASTNamedSubqueryOptimizer rewriter = new ASTNamedSubqueryOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTNamedSubqueryOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_static_analysis_no_join_vars() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)RDF.TYPE);
        IV rdfsLabel = this.makeIV((Value)RDFS.LABEL);
        IV person = this.makeIV((Value)FOAFVocabularyDecl.Person);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        String namedSet1 = "namedSet1";
        VarNode[] joinVars = new VarNode[]{};
        NamedSubqueryRoot nsr = new NamedSubqueryRoot(QueryType.SELECT, "namedSet1");
        given.getNamedSubqueriesNotNull().add((IQueryNode)nsr);
        ProjectionNode projection = new ProjectionNode();
        nsr.setProjection(projection);
        projection.addProjectionVar(new VarNode("x"));
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        nsr.setWhereClause((GraphPatternGroup)new JoinGroupNode((IGroupMemberNode)subqueryRoot));
        ProjectionNode projection2 = new ProjectionNode();
        nsr.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        nsr.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(person), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ProjectionNode projection3 = new ProjectionNode();
        given.setProjection(projection3);
        projection3.addProjectionVar(new VarNode("s"));
        projection3.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new NamedSubqueryInclude("namedSet1"));
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        NamedSubqueryRoot nsr2 = new NamedSubqueryRoot(QueryType.SELECT, "namedSet1");
        expected.getNamedSubqueriesNotNull().add((IQueryNode)nsr2);
        projection2 = new ProjectionNode();
        nsr2.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("x"));
        SubqueryRoot subqueryRoot2 = new SubqueryRoot(QueryType.SELECT);
        nsr2.setWhereClause((GraphPatternGroup)new JoinGroupNode((IGroupMemberNode)subqueryRoot2));
        ProjectionNode projection4 = new ProjectionNode();
        nsr2.setProjection(projection4);
        projection4.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause3 = new JoinGroupNode();
        nsr2.setWhereClause((GraphPatternGroup)whereClause3);
        whereClause3.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(person), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        nsr2.setDependsOn(new String[0]);
        nsr2.setJoinVars(joinVars);
        projection = new ProjectionNode();
        expected.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause4 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause4);
        NamedSubqueryInclude nsi = new NamedSubqueryInclude("namedSet1");
        whereClause4.addChild((IGroupMemberNode)nsi);
        nsi.setJoinVars(joinVars);
        whereClause4.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTNamedSubqueryOptimizer rewriter = new ASTNamedSubqueryOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTNamedSubqueryOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_govtrack_query10() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)RDF.TYPE);
        IV polititian = this.makeIV((Value)new URIImpl("http://www.rdfabout.com/rdf/schema/politico/Politician"));
        IV name = this.makeIV((Value)new URIImpl("http://www.rdfabout.com/rdf/schema/usgovt/name"));
        IV sponsor = this.makeIV((Value)new URIImpl("http://www.rdfabout.com/rdf/schema/usgovt/sponsor"));
        IV title = this.makeIV((Value)new URIImpl("http://www.rdfabout.com/rdf/schema/usgovt/title"));
        IV N = this.makeIV((Value)new URIImpl("http://www.w3.org/2001/vcard-rdf/3.0#N"));
        IV family = this.makeIV((Value)new URIImpl("http://www.w3.org/2001/vcard-rdf/3.0#Family"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("var1"));
        String set1 = "--nsr-1";
        String set2 = "--nsr-2";
        String set3 = "--nsr-3";
        NamedSubqueriesNode namedSubqueries = new NamedSubqueriesNode();
        given.setNamedSubqueries(namedSubqueries);
        NamedSubqueryRoot nsr = new NamedSubqueryRoot(QueryType.SELECT, "--nsr-1");
        namedSubqueries.add((IQueryNode)nsr);
        ProjectionNode projection2 = new ProjectionNode();
        nsr.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("var1"));
        projection2.addProjectionVar(new VarNode("var6"));
        JoinGroupNode whereClause = new JoinGroupNode();
        nsr.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var1"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(polititian), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        StatementPatternNode sp = new StatementPatternNode((TermNode)new VarNode("var1"), (TermNode)new ConstantNode(name), (TermNode)new VarNode("var6"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp.setOptional(true);
        whereClause.addChild((IGroupMemberNode)sp);
        nsr = new NamedSubqueryRoot(QueryType.SELECT, "--nsr-2");
        namedSubqueries.add((IQueryNode)nsr);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        nsr.setWhereClause((GraphPatternGroup)whereClause2);
        ProjectionNode projection3 = new ProjectionNode();
        nsr.setProjection(projection3);
        projection3.addProjectionVar(new VarNode("var1"));
        projection3.addProjectionVar(new VarNode("var6"));
        projection3.addProjectionVar(new VarNode("var4"));
        whereClause2.addChild((IGroupMemberNode)new NamedSubqueryInclude("--nsr-1"));
        JoinGroupNode optionalGroup1 = new JoinGroupNode(true);
        whereClause2.addChild((IGroupMemberNode)optionalGroup1);
        optionalGroup1.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var12"), (TermNode)new ConstantNode(sponsor), (TermNode)new VarNode("var1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        optionalGroup1.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var12"), (TermNode)new ConstantNode(title), (TermNode)new VarNode("var4"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        nsr = new NamedSubqueryRoot(QueryType.SELECT, "--nsr-3");
        namedSubqueries.add((IQueryNode)nsr);
        whereClause2 = new JoinGroupNode();
        nsr.setWhereClause((GraphPatternGroup)whereClause2);
        projection3 = new ProjectionNode();
        nsr.setProjection(projection3);
        projection3.addProjectionVar(new VarNode("var1"));
        projection3.addProjectionVar(new VarNode("var6"));
        projection3.addProjectionVar(new VarNode("var10"));
        whereClause2.addChild((IGroupMemberNode)new NamedSubqueryInclude("--nsr-1"));
        JoinGroupNode optionalGroup2 = new JoinGroupNode(true);
        whereClause2.addChild((IGroupMemberNode)optionalGroup2);
        optionalGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var1"), (TermNode)new ConstantNode(N), (TermNode)new VarNode("var13"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        optionalGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var13"), (TermNode)new ConstantNode(family), (TermNode)new VarNode("var10"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode whereClause3 = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause3);
        whereClause3.addChild((IGroupMemberNode)new NamedSubqueryInclude("--nsr-2"));
        whereClause3.addChild((IGroupMemberNode)new NamedSubqueryInclude("--nsr-3"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection4 = new ProjectionNode();
        expected.setProjection(projection4);
        projection4.addProjectionVar(new VarNode("var1"));
        String set12 = "--nsr-1";
        String set22 = "--nsr-2";
        String set32 = "--nsr-3";
        NamedSubqueriesNode namedSubqueries2 = new NamedSubqueriesNode();
        expected.setNamedSubqueries(namedSubqueries2);
        NamedSubqueryRoot nsr2 = new NamedSubqueryRoot(QueryType.SELECT, "--nsr-1");
        namedSubqueries2.add((IQueryNode)nsr2);
        nsr2.setJoinVars(new VarNode[0]);
        nsr2.setDependsOn(new String[0]);
        ProjectionNode projection5 = new ProjectionNode();
        nsr2.setProjection(projection5);
        projection5.addProjectionVar(new VarNode("var1"));
        projection5.addProjectionVar(new VarNode("var6"));
        JoinGroupNode whereClause4 = new JoinGroupNode();
        nsr2.setWhereClause((GraphPatternGroup)whereClause4);
        whereClause4.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var1"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(polititian), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("var1"), (TermNode)new ConstantNode(name), (TermNode)new VarNode("var6"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        sp2.setOptional(true);
        whereClause4.addChild((IGroupMemberNode)sp2);
        nsr2 = new NamedSubqueryRoot(QueryType.SELECT, "--nsr-2");
        namedSubqueries2.add((IQueryNode)nsr2);
        nsr2.setJoinVars(new VarNode[0]);
        nsr2.setDependsOn(new String[]{"--nsr-1"});
        JoinGroupNode whereClause5 = new JoinGroupNode();
        nsr2.setWhereClause((GraphPatternGroup)whereClause5);
        ProjectionNode projection6 = new ProjectionNode();
        nsr2.setProjection(projection6);
        projection6.addProjectionVar(new VarNode("var1"));
        projection6.addProjectionVar(new VarNode("var6"));
        projection6.addProjectionVar(new VarNode("var4"));
        NamedSubqueryInclude nsi1 = new NamedSubqueryInclude("--nsr-1");
        nsi1.setJoinVars(new VarNode[0]);
        whereClause5.addChild((IGroupMemberNode)nsi1);
        JoinGroupNode optionalGroup12 = new JoinGroupNode(true);
        whereClause5.addChild((IGroupMemberNode)optionalGroup12);
        optionalGroup12.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var12"), (TermNode)new ConstantNode(sponsor), (TermNode)new VarNode("var1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        optionalGroup12.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var12"), (TermNode)new ConstantNode(title), (TermNode)new VarNode("var4"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode complexOpt1 = optionalGroup12;
        nsr2 = new NamedSubqueryRoot(QueryType.SELECT, "--nsr-3");
        namedSubqueries2.add((IQueryNode)nsr2);
        nsr2.setJoinVars(new VarNode[]{new VarNode("var1")});
        nsr2.setDependsOn(new String[]{"--nsr-1"});
        whereClause5 = new JoinGroupNode();
        nsr2.setWhereClause((GraphPatternGroup)whereClause5);
        projection6 = new ProjectionNode();
        nsr2.setProjection(projection6);
        projection6.addProjectionVar(new VarNode("var1"));
        projection6.addProjectionVar(new VarNode("var6"));
        projection6.addProjectionVar(new VarNode("var10"));
        nsi1 = new NamedSubqueryInclude("--nsr-1");
        nsi1.setJoinVars(new VarNode[0]);
        whereClause5.addChild((IGroupMemberNode)nsi1);
        JoinGroupNode optionalGroup22 = new JoinGroupNode(true);
        whereClause5.addChild((IGroupMemberNode)optionalGroup22);
        optionalGroup22.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var1"), (TermNode)new ConstantNode(N), (TermNode)new VarNode("var13"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        optionalGroup22.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var13"), (TermNode)new ConstantNode(family), (TermNode)new VarNode("var10"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode complexOpt2 = optionalGroup22;
        JoinGroupNode whereClause6 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause6);
        NamedSubqueryInclude nsi2 = new NamedSubqueryInclude("--nsr-2");
        nsi2.setJoinVars(new VarNode[0]);
        whereClause6.addChild((IGroupMemberNode)nsi2);
        NamedSubqueryInclude nsi3 = new NamedSubqueryInclude("--nsr-3");
        nsi3.setJoinVars(new VarNode[]{new VarNode("var1")});
        whereClause6.addChild((IGroupMemberNode)nsi3);
        ASTNamedSubqueryOptimizer rewriter = new ASTNamedSubqueryOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTNamedSubqueryOptimizer.assertSameAST((IQueryNode)expected, actual);
        StaticAnalysis sa = new StaticAnalysis(expected, (IEvaluationContext)context);
        TestASTNamedSubqueryOptimizer.assertEquals(TestASTNamedSubqueryOptimizer.asSet(new Var[]{Var.var((String)"var1")}), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)complexOpt1, new LinkedHashSet()));
        TestASTNamedSubqueryOptimizer.assertEquals(TestASTNamedSubqueryOptimizer.asSet(new Var[]{Var.var((String)"var1")}), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)complexOpt2, new LinkedHashSet()));
    }
}

