/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.Bind;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.rdf.aggregate.COUNT;
import com.bigdata.bop.rdf.aggregate.MAX;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.sparql.ast.optimizers.ASTOrderByAggregateFlatteningOptimizer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Iterator;
import java.util.List;
import org.openrdf.query.MalformedQueryException;

public class TestASTOrderByAggregateFlatteningOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTOrderByAggregateFlatteningOptimizer() {
    }

    public TestASTOrderByAggregateFlatteningOptimizer(String name) {
        super(name);
    }

    public void test_orderByAggregateFlatteningOptimizer_simple_case_1() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT  ?o \nWHERE { ?s :p ?o } \nGROUP BY ?o \nORDER BY (count(?s))";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT  ?o \nWHERE { ?s :p ?o } \nGROUP BY ?o \nORDER BY (count(?s))", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot given = astContainer.getOriginalAST();
        ASTOrderByAggregateFlatteningOptimizer rewriter = new ASTOrderByAggregateFlatteningOptimizer();
        QueryRoot actual = (QueryRoot)rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, new IBindingSet[0])).getQueryNode();
        NamedSubqueriesNode namedSubqueries = actual.getNamedSubqueries();
        TestASTOrderByAggregateFlatteningOptimizer.assertNull((Object)namedSubqueries);
        TestASTOrderByAggregateFlatteningOptimizer.assertSame((Object)QueryType.SELECT, (Object)actual.getQueryType());
        ProjectionNode projection = actual.getProjection();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)projection);
        IValueExpression[] assignments = projection.getValueExpressions();
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((int)2, (int)assignments.length);
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)assignments[0]);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(assignments[0] instanceof Bind));
        IVariable var1 = ((Bind)assignments[0]).getVar();
        IValueExpression expr1 = ((Bind)assignments[0]).getExpr();
        TestASTOrderByAggregateFlatteningOptimizer.assertSame((Object)var1, (Object)expr1);
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"o", (String)var1.getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)projection.excludeFromProjection(var1));
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)assignments[1]);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(assignments[1] instanceof Bind));
        IVariable var2 = ((Bind)assignments[1]).getVar();
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)"s".equals(var2.getName()));
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)"o".equals(var2.getName()));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)projection.excludeFromProjection(var2));
        IValueExpression expr2 = ((Bind)assignments[1]).getExpr();
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(expr2 instanceof COUNT));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(((COUNT)expr2).get(0) instanceof Var));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"s", (String)((Var)((COUNT)expr2).get(0)).getName());
        GroupByNode groupBy = actual.getGroupBy();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)groupBy);
        IValueExpression[] groupByArgs = groupBy.getValueExpressions();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)groupByArgs);
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((int)1, (int)groupByArgs.length);
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)groupByArgs[0]);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(groupByArgs[0] instanceof Bind));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"o", (String)((Bind)groupByArgs[0]).getVar().getName());
        OrderByNode orderBy = actual.getOrderBy();
        Iterator orderByArgs = orderBy.iterator();
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)orderByArgs.hasNext());
        OrderByExpr orderByArg = (OrderByExpr)orderByArgs.next();
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)orderByArgs.hasNext());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(orderByArg.getValueExpression() instanceof Var));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)var2.getName(), (String)((Var)orderByArg.getValueExpression()).getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)orderByArg.isAscending());
        GraphPatternGroup whereClause = actual.getWhereClause();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)whereClause);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(whereClause instanceof JoinGroupNode));
        List patterns = ((JoinGroupNode)whereClause).getStatementPatterns();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)patterns);
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((int)1, (int)patterns.size());
        StatementPatternNode pattern = (StatementPatternNode)patterns.get(0);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(pattern.s() instanceof VarNode));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"s", (String)((VarNode)pattern.s()).getValueExpression().getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(pattern.p() instanceof ConstantNode));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(((ConstantNode)pattern.p()).getValueExpression() instanceof Constant));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(((Constant)((ConstantNode)pattern.p()).getValueExpression()).get() instanceof TermId));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"http://example/p", (String)((TermId)((Constant)((ConstantNode)pattern.p()).getValueExpression()).get()).getValue().stringValue());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(pattern.o() instanceof VarNode));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"o", (String)((VarNode)pattern.o()).getValueExpression().getName());
    }

    public void test_orderByAggregateFlatteningOptimizer_high_coverage_case_1() throws MalformedQueryException {
        String queryStr = "PREFIX ex: <http://example.org/>\nSELECT ?x ?y\nWHERE {\n  ?x ex:r ?y .\n  ?y ex:q ?z }\nGROUP BY ?x ?y\nORDER BY DESC(max(?z)) ?x (count(?z)) DESC(?y)";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX ex: <http://example.org/>\nSELECT ?x ?y\nWHERE {\n  ?x ex:r ?y .\n  ?y ex:q ?z }\nGROUP BY ?x ?y\nORDER BY DESC(max(?z)) ?x (count(?z)) DESC(?y)", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot given = astContainer.getOriginalAST();
        ASTOrderByAggregateFlatteningOptimizer rewriter = new ASTOrderByAggregateFlatteningOptimizer();
        QueryRoot actual = (QueryRoot)rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, new IBindingSet[0])).getQueryNode();
        NamedSubqueriesNode namedSubqueries = actual.getNamedSubqueries();
        TestASTOrderByAggregateFlatteningOptimizer.assertNull((Object)namedSubqueries);
        TestASTOrderByAggregateFlatteningOptimizer.assertSame((Object)QueryType.SELECT, (Object)actual.getQueryType());
        ProjectionNode projection = actual.getProjection();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)projection);
        IValueExpression[] assignments = projection.getValueExpressions();
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((int)4, (int)assignments.length);
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)assignments[0]);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(assignments[0] instanceof Bind));
        IVariable var1 = ((Bind)assignments[0]).getVar();
        IValueExpression expr1 = ((Bind)assignments[0]).getExpr();
        TestASTOrderByAggregateFlatteningOptimizer.assertSame((Object)var1, (Object)expr1);
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"x", (String)var1.getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)projection.excludeFromProjection(var1));
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)assignments[1]);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(assignments[1] instanceof Bind));
        IVariable var2 = ((Bind)assignments[1]).getVar();
        IValueExpression expr2 = ((Bind)assignments[1]).getExpr();
        TestASTOrderByAggregateFlatteningOptimizer.assertSame((Object)var2, (Object)expr2);
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"y", (String)var2.getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)projection.excludeFromProjection(var2));
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)assignments[2]);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(assignments[2] instanceof Bind));
        IVariable var3 = ((Bind)assignments[2]).getVar();
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)"x".equals(var3.getName()));
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)"y".equals(var3.getName()));
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)"z".equals(var3.getName()));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)projection.excludeFromProjection(var3));
        IValueExpression expr3 = ((Bind)assignments[2]).getExpr();
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(expr3 instanceof MAX));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(((MAX)expr3).get(0) instanceof Var));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"z", (String)((Var)((MAX)expr3).get(0)).getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)assignments[3]);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(assignments[3] instanceof Bind));
        IVariable var4 = ((Bind)assignments[3]).getVar();
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)"x".equals(var4.getName()));
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)"y".equals(var4.getName()));
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)"z".equals(var4.getName()));
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)var3.getName().equals(var4.getName()));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)projection.excludeFromProjection(var4));
        IValueExpression expr4 = ((Bind)assignments[3]).getExpr();
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(expr4 instanceof COUNT));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(((COUNT)expr4).get(0) instanceof Var));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"z", (String)((Var)((COUNT)expr4).get(0)).getName());
        GroupByNode groupBy = actual.getGroupBy();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)groupBy);
        IValueExpression[] groupByArgs = groupBy.getValueExpressions();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)groupByArgs);
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((int)2, (int)groupByArgs.length);
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)groupByArgs[0]);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(groupByArgs[0] instanceof Bind));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"x", (String)((Bind)groupByArgs[0]).getVar().getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)groupByArgs[1]);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(groupByArgs[1] instanceof Bind));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"y", (String)((Bind)groupByArgs[1]).getVar().getName());
        OrderByNode orderBy = actual.getOrderBy();
        Iterator orderByArgs = orderBy.iterator();
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)orderByArgs.hasNext());
        OrderByExpr orderByArg1 = (OrderByExpr)orderByArgs.next();
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(orderByArg1.getValueExpression() instanceof Var));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)var3.getName(), (String)((Var)orderByArg1.getValueExpression()).getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)orderByArg1.isAscending());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)orderByArgs.hasNext());
        OrderByExpr orderByArg2 = (OrderByExpr)orderByArgs.next();
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(orderByArg2.getValueExpression() instanceof Var));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"x", (String)((Var)orderByArg2.getValueExpression()).getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)orderByArg2.isAscending());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)orderByArgs.hasNext());
        OrderByExpr orderByArg3 = (OrderByExpr)orderByArgs.next();
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(orderByArg3.getValueExpression() instanceof Var));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)var4.getName(), (String)((Var)orderByArg3.getValueExpression()).getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)orderByArg3.isAscending());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)orderByArgs.hasNext());
        OrderByExpr orderByArg4 = (OrderByExpr)orderByArgs.next();
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(orderByArg4.getValueExpression() instanceof Var));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"y", (String)((Var)orderByArg4.getValueExpression()).getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)orderByArg4.isAscending());
        TestASTOrderByAggregateFlatteningOptimizer.assertFalse((boolean)orderByArgs.hasNext());
        GraphPatternGroup whereClause = actual.getWhereClause();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)whereClause);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(whereClause instanceof JoinGroupNode));
        List patterns = ((JoinGroupNode)whereClause).getStatementPatterns();
        TestASTOrderByAggregateFlatteningOptimizer.assertNotNull((Object)patterns);
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((int)2, (int)patterns.size());
        StatementPatternNode pattern1 = (StatementPatternNode)patterns.get(0);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(pattern1.s() instanceof VarNode));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"x", (String)((VarNode)pattern1.s()).getValueExpression().getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(pattern1.p() instanceof ConstantNode));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(((ConstantNode)pattern1.p()).getValueExpression() instanceof Constant));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(((Constant)((ConstantNode)pattern1.p()).getValueExpression()).get() instanceof TermId));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"http://example.org/r", (String)((TermId)((Constant)((ConstantNode)pattern1.p()).getValueExpression()).get()).getValue().stringValue());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(pattern1.o() instanceof VarNode));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"y", (String)((VarNode)pattern1.o()).getValueExpression().getName());
        StatementPatternNode pattern2 = (StatementPatternNode)patterns.get(1);
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(pattern2.s() instanceof VarNode));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"y", (String)((VarNode)pattern2.s()).getValueExpression().getName());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(pattern2.p() instanceof ConstantNode));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(((ConstantNode)pattern2.p()).getValueExpression() instanceof Constant));
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(((Constant)((ConstantNode)pattern2.p()).getValueExpression()).get() instanceof TermId));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"http://example.org/q", (String)((TermId)((Constant)((ConstantNode)pattern2.p()).getValueExpression()).get()).getValue().stringValue());
        TestASTOrderByAggregateFlatteningOptimizer.assertTrue((boolean)(pattern2.o() instanceof VarNode));
        TestASTOrderByAggregateFlatteningOptimizer.assertEquals((String)"z", (String)((VarNode)pattern2.o()).getValueExpression().getName());
    }
}

