/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTRangeOptimizer;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

public class TestASTRangeOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTRangeOptimizer() {
    }

    public TestASTRangeOptimizer(String name) {
        super(name);
    }

    public void test_SimpleRange() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        XSDNumericIV lower = new XSDNumericIV(25);
        XSDNumericIV upper = new XSDNumericIV(35);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode where = new JoinGroupNode();
        FunctionNode f = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)lower)});
        where.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f));
        f = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)upper)});
        where.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f));
        StatementPatternNode sp = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp.setQueryHint("rangeSafe", "true");
        where.addChild((IGroupMemberNode)sp);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)where);
        AST2BOpContext ctx = new AST2BOpContext(new ASTContainer(given), this.store);
        GlobalAnnotations globals = new GlobalAnnotations(ctx.getLexiconNamespace(), ctx.getTimestamp());
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("*"));
        JoinGroupNode where2 = new JoinGroupNode();
        FunctionNode f2 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)lower)});
        where2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f2));
        f2 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)upper)});
        where2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f2));
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp2.setQueryHint("rangeSafe", "true");
        RangeNode range = new RangeNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode((IV)lower), (IValueExpressionNode)new ConstantNode((IV)upper));
        RangeBOp bop = ASTRangeOptimizer.toRangeBOp((BOpContextBase)this.getBOpContext(), (RangeNode)range, (GlobalAnnotations)globals);
        range.setRangeBOp(bop);
        sp2.setRange(range);
        where2.addChild((IGroupMemberNode)sp2);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)where2);
        ASTRangeOptimizer rewriter = new ASTRangeOptimizer();
        IQueryNode actual = rewriter.optimize(ctx, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTRangeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_SimpleRange_justLower() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        XSDNumericIV lower = new XSDNumericIV(25);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode where = new JoinGroupNode();
        FunctionNode f = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)lower)});
        where.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f));
        StatementPatternNode sp = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp.setQueryHint("rangeSafe", "true");
        where.addChild((IGroupMemberNode)sp);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)where);
        AST2BOpContext ctx = new AST2BOpContext(new ASTContainer(given), this.store);
        GlobalAnnotations globals = new GlobalAnnotations(ctx.getLexiconNamespace(), ctx.getTimestamp());
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("*"));
        JoinGroupNode where2 = new JoinGroupNode();
        FunctionNode f2 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)lower)});
        where2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f2));
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp2.setQueryHint("rangeSafe", "true");
        RangeNode range = new RangeNode(new VarNode("p"));
        range.setFrom((ValueExpressionNode)new ConstantNode((IV)lower));
        range.setRangeBOp(ASTRangeOptimizer.toRangeBOp((BOpContextBase)this.getBOpContext(), (RangeNode)range, (GlobalAnnotations)globals));
        sp2.setRange(range);
        where2.addChild((IGroupMemberNode)sp2);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)where2);
        ASTRangeOptimizer rewriter = new ASTRangeOptimizer();
        IQueryNode actual = rewriter.optimize(ctx, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTRangeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_SimpleRange_justUpper() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        XSDNumericIV upper = new XSDNumericIV(35);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode where = new JoinGroupNode();
        FunctionNode f = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)upper)});
        where.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f));
        StatementPatternNode sp = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp.setQueryHint("rangeSafe", "true");
        where.addChild((IGroupMemberNode)sp);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)where);
        AST2BOpContext ctx = new AST2BOpContext(new ASTContainer(given), this.store);
        GlobalAnnotations globals = new GlobalAnnotations(ctx.getLexiconNamespace(), ctx.getTimestamp());
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("*"));
        JoinGroupNode where2 = new JoinGroupNode();
        FunctionNode f2 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)upper)});
        where2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f2));
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp2.setQueryHint("rangeSafe", "true");
        RangeNode range = new RangeNode(new VarNode("p"));
        range.setTo((ValueExpressionNode)new ConstantNode((IV)upper));
        range.setRangeBOp(ASTRangeOptimizer.toRangeBOp((BOpContextBase)this.getBOpContext(), (RangeNode)range, (GlobalAnnotations)globals));
        sp2.setRange(range);
        where2.addChild((IGroupMemberNode)sp2);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)where2);
        ASTRangeOptimizer rewriter = new ASTRangeOptimizer();
        IQueryNode actual = rewriter.optimize(ctx, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTRangeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_And() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        XSDNumericIV lower = new XSDNumericIV(25);
        XSDNumericIV upper = new XSDNumericIV(35);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode where = new JoinGroupNode();
        FunctionNode f1 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)lower)});
        FunctionNode f2 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)upper)});
        FunctionNode f = FunctionNode.AND((ValueExpressionNode)f1, (ValueExpressionNode)f2);
        where.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f));
        StatementPatternNode sp = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp.setQueryHint("rangeSafe", "true");
        where.addChild((IGroupMemberNode)sp);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)where);
        AST2BOpContext ctx = new AST2BOpContext(new ASTContainer(given), this.store);
        GlobalAnnotations globals = new GlobalAnnotations(ctx.getLexiconNamespace(), ctx.getTimestamp());
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("*"));
        JoinGroupNode where2 = new JoinGroupNode();
        FunctionNode f12 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)lower)});
        FunctionNode f22 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)upper)});
        FunctionNode f3 = FunctionNode.AND((ValueExpressionNode)f12, (ValueExpressionNode)f22);
        where2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f3));
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp2.setQueryHint("rangeSafe", "true");
        RangeNode range = new RangeNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode((IV)lower), (IValueExpressionNode)new ConstantNode((IV)upper));
        range.setRangeBOp(ASTRangeOptimizer.toRangeBOp((BOpContextBase)this.getBOpContext(), (RangeNode)range, (GlobalAnnotations)globals));
        sp2.setRange(range);
        where2.addChild((IGroupMemberNode)sp2);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)where2);
        ASTRangeOptimizer rewriter = new ASTRangeOptimizer();
        IQueryNode actual = rewriter.optimize(ctx, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTRangeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_And2() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        XSDNumericIV lower = new XSDNumericIV(25);
        XSDNumericIV upper = new XSDNumericIV(35);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode where = new JoinGroupNode();
        FunctionNode f1 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)lower)});
        FunctionNode f2 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new ConstantNode((IV)upper), new VarNode("p")});
        FunctionNode f = FunctionNode.AND((ValueExpressionNode)f1, (ValueExpressionNode)f2);
        where.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f));
        StatementPatternNode sp = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp.setQueryHint("rangeSafe", "true");
        where.addChild((IGroupMemberNode)sp);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)where);
        AST2BOpContext ctx = new AST2BOpContext(new ASTContainer(given), this.store);
        GlobalAnnotations globals = new GlobalAnnotations(ctx.getLexiconNamespace(), ctx.getTimestamp());
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("*"));
        JoinGroupNode where2 = new JoinGroupNode();
        FunctionNode f12 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("p"), new ConstantNode((IV)lower)});
        FunctionNode f22 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new ConstantNode((IV)upper), new VarNode("p")});
        FunctionNode f3 = FunctionNode.AND((ValueExpressionNode)f12, (ValueExpressionNode)f22);
        where2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f3));
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("p"));
        sp2.setQueryHint("rangeSafe", "true");
        RangeNode range = new RangeNode(new VarNode("p"));
        range.setFrom((ValueExpressionNode)new ConstantNode((IV)lower));
        range.setTo((ValueExpressionNode)new ConstantNode((IV)upper));
        range.setRangeBOp(ASTRangeOptimizer.toRangeBOp((BOpContextBase)this.getBOpContext(), (RangeNode)range, (GlobalAnnotations)globals));
        sp2.setRange(range);
        where2.addChild((IGroupMemberNode)sp2);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)where2);
        ASTRangeOptimizer rewriter = new ASTRangeOptimizer();
        IQueryNode actual = rewriter.optimize(ctx, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTRangeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_Complex() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV s1 = this.makeIV((Value)new URIImpl("http://example/s1"));
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        XSDNumericIV ten = new XSDNumericIV(10);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode where = new JoinGroupNode();
        FunctionNode f1 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("o2"), FunctionNode.subtract((ValueExpressionNode)new VarNode("o1"), (ValueExpressionNode)new ConstantNode((IV)ten))});
        FunctionNode f2 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("o2"), FunctionNode.add((ValueExpressionNode)new VarNode("o1"), (ValueExpressionNode)new ConstantNode((IV)ten))});
        FunctionNode f = FunctionNode.AND((ValueExpressionNode)f1, (ValueExpressionNode)f2);
        where.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f));
        StatementPatternNode sp = new StatementPatternNode((TermNode)new ConstantNode(s1), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o1"));
        where.addChild((IGroupMemberNode)sp);
        sp = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o2"));
        sp.setQueryHint("rangeSafe", "true");
        where.addChild((IGroupMemberNode)sp);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)where);
        AST2BOpContext ctx = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection2);
        JoinGroupNode where2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)where2);
        FunctionNode f12 = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("o2"), FunctionNode.subtract((ValueExpressionNode)new VarNode("o1"), (ValueExpressionNode)new ConstantNode((IV)ten))});
        FunctionNode f22 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("o2"), FunctionNode.add((ValueExpressionNode)new VarNode("o1"), (ValueExpressionNode)new ConstantNode((IV)ten))});
        FunctionNode f3 = FunctionNode.AND((ValueExpressionNode)f12, (ValueExpressionNode)f22);
        where2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f3));
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new ConstantNode(s1), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o1"));
        where2.addChild((IGroupMemberNode)sp2);
        sp2 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o2"));
        sp2.setQueryHint("rangeSafe", "true");
        where2.addChild((IGroupMemberNode)sp2);
        ASTRangeOptimizer rewriter = new ASTRangeOptimizer();
        IQueryNode actual = rewriter.optimize(ctx, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTRangeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_Complex2() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV s1 = this.makeIV((Value)new URIImpl("http://example/s1"));
        IV s2 = this.makeIV((Value)new URIImpl("http://example/s2"));
        IV s3 = this.makeIV((Value)new URIImpl("http://example/s3"));
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode where = new JoinGroupNode();
        FunctionNode f1 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("o"), new VarNode("o1")});
        FunctionNode f2 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("o"), new VarNode("o2")});
        XSDNumericIV upper = new XSDNumericIV(100);
        FunctionNode f3 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("o"), new ConstantNode((IV)upper)});
        FunctionNode and = FunctionNode.AND((ValueExpressionNode)f1, (ValueExpressionNode)f2);
        where.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)and));
        where.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f3));
        where.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(s1), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o1")));
        where.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(s2), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o2")));
        where.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode(s3), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o3")));
        StatementPatternNode sp = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"));
        sp.setQueryHint("rangeSafe", "true");
        where.addChild((IGroupMemberNode)sp);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)where);
        AST2BOpContext ctx = new AST2BOpContext(new ASTContainer(given), this.store);
        GlobalAnnotations globals = new GlobalAnnotations(ctx.getLexiconNamespace(), ctx.getTimestamp());
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("*"));
        expected.setProjection(projection2);
        JoinGroupNode where2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)where2);
        FunctionNode f12 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("o"), new VarNode("o1")});
        FunctionNode f22 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("o"), new VarNode("o2")});
        XSDNumericIV upper2 = new XSDNumericIV(100);
        FunctionNode f32 = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("o"), new ConstantNode((IV)upper2)});
        FunctionNode and2 = FunctionNode.AND((ValueExpressionNode)f12, (ValueExpressionNode)f22);
        where2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)and2));
        where2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)f32));
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new ConstantNode(s1), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o1"));
        where2.addChild((IGroupMemberNode)sp2);
        sp2 = new StatementPatternNode((TermNode)new ConstantNode(s2), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o2"));
        where2.addChild((IGroupMemberNode)sp2);
        sp2 = new StatementPatternNode((TermNode)new ConstantNode(s3), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o3"));
        where2.addChild((IGroupMemberNode)sp2);
        sp2 = new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"));
        sp2.setQueryHint("rangeSafe", "true");
        XSDNumericIV upper3 = new XSDNumericIV(100);
        RangeNode range = new RangeNode(new VarNode("o"));
        range.setTo((ValueExpressionNode)new ConstantNode((IV)upper3));
        range.setRangeBOp(ASTRangeOptimizer.toRangeBOp((BOpContextBase)this.getBOpContext(), (RangeNode)range, (GlobalAnnotations)globals));
        sp2.setRange(range);
        where2.addChild((IGroupMemberNode)sp2);
        ASTRangeOptimizer rewriter = new ASTRangeOptimizer();
        IQueryNode actual = rewriter.optimize(ctx, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTRangeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }
}

