/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTServiceNodeOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BDS;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTServiceNodeOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTServiceNodeOptimizer() {
    }

    public TestASTServiceNodeOptimizer(String name) {
        super(name);
    }

    public void test_serviceNodeOptimizer_01() {
        IV searchIV = this.makeIV((Value)BDS.SEARCH);
        IV relevanceIV = this.makeIV((Value)BDS.RELEVANCE);
        IV mikeIV = this.makeIV((Value)this.store.getValueFactory().createLiteral("mike"));
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("subj"));
        projection.addProjectionVar(new VarNode("score"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode serviceGraphPattern = new JoinGroupNode();
        serviceGraphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode(searchIV), (TermNode)new ConstantNode(mikeIV), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        serviceGraphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode(relevanceIV), (TermNode)new VarNode("score"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(searchIV), (GraphPatternGroup)serviceGraphPattern);
        whereClause.addChild((IGroupMemberNode)serviceNode);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        String namedSubqueryName = "%-anon-service-call-0";
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("subj"));
        projection2.addProjectionVar(new VarNode("score"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new NamedSubqueryInclude("%-anon-service-call-0"));
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("subj"), (TermNode)new VarNode("p"), (TermNode)new VarNode("lit"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        NamedSubqueryRoot nsr = new NamedSubqueryRoot(QueryType.SELECT, "%-anon-service-call-0");
        expected.getNamedSubqueriesNotNull().add((IQueryNode)nsr);
        ProjectionNode projection3 = new ProjectionNode();
        nsr.setProjection(projection3);
        projection3.addProjectionVar(new VarNode("lit"));
        projection3.addProjectionVar(new VarNode("score"));
        JoinGroupNode whereClause3 = new JoinGroupNode();
        nsr.setWhereClause((GraphPatternGroup)whereClause3);
        JoinGroupNode serviceGraphPattern2 = new JoinGroupNode();
        serviceGraphPattern2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode(searchIV), (TermNode)new ConstantNode(mikeIV), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        serviceGraphPattern2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("lit"), (TermNode)new ConstantNode(relevanceIV), (TermNode)new VarNode("score"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ServiceNode serviceNode2 = new ServiceNode((TermNode)new ConstantNode(searchIV), (GraphPatternGroup)serviceGraphPattern2);
        whereClause3.addChild((IGroupMemberNode)serviceNode2);
        ASTServiceNodeOptimizer rewriter = new ASTServiceNodeOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTServiceNodeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_serviceNodeOptimizer_02() {
        IV serviceUriIV = this.makeIV((Value)this.store.getValueFactory().createURI("http://localhost:18080/openrdf/repositories/endpoint1"));
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o1"));
        projection.addProjectionVar(new VarNode("o2"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p1"), (TermNode)new VarNode("o1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode serviceGraphPattern = new JoinGroupNode();
        serviceGraphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(serviceUriIV), (GraphPatternGroup)serviceGraphPattern);
        whereClause.addChild((IGroupMemberNode)serviceNode);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o1"));
        projection2.addProjectionVar(new VarNode("o2"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p1"), (TermNode)new VarNode("o1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode serviceGraphPattern2 = new JoinGroupNode();
        serviceGraphPattern2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p2"), (TermNode)new VarNode("o2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ServiceNode serviceNode2 = new ServiceNode((TermNode)new ConstantNode(serviceUriIV), (GraphPatternGroup)serviceGraphPattern2);
        whereClause2.addChild((IGroupMemberNode)serviceNode2);
        ASTServiceNodeOptimizer rewriter = new ASTServiceNodeOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTServiceNodeOptimizer.assertSameAST((IQueryNode)expected, actual);
    }
}

