/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSetValueExpressionsOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSimpleOptionalOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTWildcardProjectionOptimizer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Iterator;
import java.util.LinkedList;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTSimpleOptionalOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTSimpleOptionalOptimizer() {
    }

    public TestASTSimpleOptionalOptimizer(String name) {
        super(name);
    }

    public void test_simpleOptional() throws MalformedQueryException {
        String queryStr = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX dc: <http://purl.org/dc/terms/> \nPREFIX p1: <http://www.bigdata.com/> \nSELECT * \nWHERE { \n  ?_var1 rdf:type <http://suawa.org/mediadb#Album>. \n  ?_var1 p1:genre ?_var8.  \n  ?_var8 dc:title ?_var9.  \n  FILTER ((?_var9 in(\"Folk\", \"Hip-Hop\"))) . \n  OPTIONAL { \n    ?_var1 dc:title ?_var10 \n  }.  \n  OPTIONAL { \n    ?_var1 p1:mainArtist ?_var12. \n    ?_var12 dc:title ?_var11 \n  } \n}";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX dc: <http://purl.org/dc/terms/> \nPREFIX p1: <http://www.bigdata.com/> \nSELECT * \nWHERE { \n  ?_var1 rdf:type <http://suawa.org/mediadb#Album>. \n  ?_var1 p1:genre ?_var8.  \n  ?_var8 dc:title ?_var9.  \n  FILTER ((?_var9 in(\"Folk\", \"Hip-Hop\"))) . \n  OPTIONAL { \n    ?_var1 dc:title ?_var10 \n  }.  \n  OPTIONAL { \n    ?_var1 p1:mainArtist ?_var12. \n    ?_var12 dc:title ?_var11 \n  } \n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        queryRoot = (QueryRoot)new ASTSimpleOptionalOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        int nstmts = 0;
        for (IGroupMemberNode child : whereClause) {
            if (!(child instanceof StatementPatternNode)) continue;
            ++nstmts;
        }
        TestASTSimpleOptionalOptimizer.assertEquals((String)"#statements", (int)4, (int)nstmts);
        Iterator itr = BOpUtility.visitAll((BOp)whereClause, JoinGroupNode.class);
        int ngroups = 0;
        int noptionalGroups = 0;
        while (itr.hasNext()) {
            JoinGroupNode tmp = (JoinGroupNode)itr.next();
            ++ngroups;
            if (!tmp.isOptional()) continue;
            ++noptionalGroups;
        }
        TestASTSimpleOptionalOptimizer.assertEquals((String)"#ngroups", (int)2, (int)ngroups);
        TestASTSimpleOptionalOptimizer.assertEquals((String)"#optionalGroups", (int)1, (int)noptionalGroups);
    }

    public void test_sparql_bev_5() throws Exception {
        String queryStr = "PREFIX  xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX  : <http://example.org/ns#>SELECT ?a \nWHERE    { ?a :p ?v . \n      OPTIONAL \n        { ?a :q ?w } . \n      FILTER (?w) . \n    }\n";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI p = f.createURI("http://example.org/ns#p");
        BigdataURI q = f.createURI("http://example.org/ns#q");
        BigdataValue[] values = new BigdataValue[]{p, q};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX  xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX  : <http://example.org/ns#>SELECT ?a \nWHERE    { ?a :p ?v . \n      OPTIONAL \n        { ?a :q ?w } . \n      FILTER (?w) . \n    }\n", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTSimpleOptionalOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        JoinGroupNode expectedClause = new JoinGroupNode();
        expectedClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new VarNode("v"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        StatementPatternNode liftedSp = new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode((IConstant)new Constant((Object)q.getIV())), (TermNode)new VarNode("w"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        expectedClause.addChild((IGroupMemberNode)liftedSp);
        liftedSp.setOptional(true);
        expectedClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new VarNode("w")));
        TestASTSimpleOptionalOptimizer.assertSameAST((IQueryNode)expectedClause, (IQueryNode)queryRoot.getWhereClause());
    }

    public void test_sparql_bev_5_withFilterInOptionalGroup() throws Exception {
        String queryStr = "PREFIX  xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX  : <http://example.org/ns#>SELECT ?a \nWHERE    { ?a :p ?v . \n      OPTIONAL \n        { ?a :q ?w .          FILTER (BOUND(?w)) \n        } \n    }\n";
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI p = f.createURI("http://example.org/ns#p");
        BigdataURI q = f.createURI("http://example.org/ns#q");
        BigdataValue[] values = new BigdataValue[]{p, q};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX  xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX  : <http://example.org/ns#>SELECT ?a \nWHERE    { ?a :p ?v . \n      OPTIONAL \n        { ?a :q ?w .          FILTER (BOUND(?w)) \n        } \n    }\n", this.baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        queryRoot = (QueryRoot)BOpUtility.deepCopy((BOp)queryRoot);
        queryRoot = (QueryRoot)new ASTSimpleOptionalOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        JoinGroupNode expectedClause = new JoinGroupNode();
        expectedClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode((IConstant)new Constant((Object)p.getIV())), (TermNode)new VarNode("v"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        StatementPatternNode liftedSp = new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode((IConstant)new Constant((Object)q.getIV())), (TermNode)new VarNode("w"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        expectedClause.addChild((IGroupMemberNode)liftedSp);
        liftedSp.setOptional(true);
        LinkedList<FilterNode> filters = new LinkedList<FilterNode>();
        FilterNode filterNode = new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{new VarNode("w")}));
        GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
        AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)filterNode.getValueExpressionNode());
        filters.add(filterNode);
        liftedSp.setAttachedJoinFilters(filters);
        TestASTSimpleOptionalOptimizer.assertSameAST((IQueryNode)expectedClause, (IQueryNode)queryRoot.getWhereClause());
    }
}

