/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.BigdataStatics;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSparql11SubqueryOptimizer;
import java.util.Collections;
import java.util.LinkedList;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTSparql11SubqueryOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTSparql11SubqueryOptimizer() {
    }

    public TestASTSparql11SubqueryOptimizer(String name) {
        super(name);
    }

    public void test_subSelectWithLimitAndOrderBy() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://www.example.org/p"));
        IV a = this.makeIV((Value)RDF.TYPE);
        IV ty = this.makeIV((Value)new URIImpl("http://www.example.org/ty"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode subGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)subGroup);
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        subGroup.addChild((IGroupMemberNode)subqueryRoot);
        projection = new ProjectionNode();
        subqueryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        whereClause = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        subqueryRoot.setSlice(new SliceNode(0L, 3L));
        OrderByNode orderByNode = new OrderByNode();
        subqueryRoot.setOrderBy(orderByNode);
        orderByNode.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("s"), true));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        String name = "-subSelect-1";
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        NamedSubqueryInclude nsi = new NamedSubqueryInclude("-subSelect-1");
        nsi.setAttachedJoinFilters(new LinkedList());
        whereClause2.addChild((IGroupMemberNode)nsi);
        NamedSubqueryRoot subqueryRoot2 = new NamedSubqueryRoot(QueryType.SELECT, "-subSelect-1");
        NamedSubqueriesNode namedSubqueries = new NamedSubqueriesNode();
        expected.setNamedSubqueries(namedSubqueries);
        namedSubqueries.add((IQueryNode)subqueryRoot2);
        projection2 = new ProjectionNode();
        subqueryRoot2.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        whereClause2 = new JoinGroupNode();
        subqueryRoot2.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        subqueryRoot2.setSlice(new SliceNode(0L, 3L));
        OrderByNode orderByNode2 = new OrderByNode();
        subqueryRoot2.setOrderBy(orderByNode2);
        orderByNode2.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("s"), true));
        ASTSparql11SubqueryOptimizer rewriter = new ASTSparql11SubqueryOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTSparql11SubqueryOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_subSelectWithAggregation() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://www.example.org/p"));
        IV a = this.makeIV((Value)RDF.TYPE);
        IV ty = this.makeIV((Value)new URIImpl("http://www.example.org/ty"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o"));
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode subGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)subGroup);
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        subGroup.addChild((IGroupMemberNode)subqueryRoot);
        projection = new ProjectionNode();
        subqueryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.COUNT, Collections.singletonMap(AggregateBase.Annotations.DISTINCT, Boolean.TRUE), new ValueExpressionNode[]{new VarNode("s")})));
        whereClause = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        GroupByNode groupByNode = new GroupByNode();
        subqueryRoot.setGroupBy(groupByNode);
        groupByNode.addGroupByVar(new VarNode("s"));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        String name = "-subSelect-1";
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        NamedSubqueryInclude nsi = new NamedSubqueryInclude("-subSelect-1");
        nsi.setAttachedJoinFilters(new LinkedList());
        whereClause2.addChild((IGroupMemberNode)nsi);
        NamedSubqueryRoot subqueryRoot2 = new NamedSubqueryRoot(QueryType.SELECT, "-subSelect-1");
        NamedSubqueriesNode namedSubqueries = new NamedSubqueriesNode();
        expected.setNamedSubqueries(namedSubqueries);
        namedSubqueries.add((IQueryNode)subqueryRoot2);
        GroupByNode groupByNode2 = new GroupByNode();
        subqueryRoot2.setGroupBy(groupByNode2);
        groupByNode2.addGroupByVar(new VarNode("s"));
        projection2 = new ProjectionNode();
        subqueryRoot2.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionExpression(new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new FunctionNode(FunctionRegistry.COUNT, Collections.singletonMap(AggregateBase.Annotations.DISTINCT, Boolean.TRUE), new ValueExpressionNode[]{new VarNode("s")})));
        whereClause2 = new JoinGroupNode();
        subqueryRoot2.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTSparql11SubqueryOptimizer rewriter = new ASTSparql11SubqueryOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTSparql11SubqueryOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_subSelectNotLifted() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://www.example.org/p"));
        IV a = this.makeIV((Value)RDF.TYPE);
        IV ty = this.makeIV((Value)new URIImpl("http://www.example.org/ty"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode subGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)subGroup);
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        subGroup.addChild((IGroupMemberNode)subqueryRoot);
        projection = new ProjectionNode();
        subqueryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        whereClause = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode subGroup2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)subGroup2);
        SubqueryRoot subqueryRoot2 = new SubqueryRoot(QueryType.SELECT);
        subGroup2.addChild((IGroupMemberNode)subqueryRoot2);
        projection2 = new ProjectionNode();
        subqueryRoot2.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        whereClause2 = new JoinGroupNode();
        subqueryRoot2.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTSparql11SubqueryOptimizer rewriter = new ASTSparql11SubqueryOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTSparql11SubqueryOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_subSelectWithRunOnceAnnotation() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://www.example.org/p"));
        IV a = this.makeIV((Value)RDF.TYPE);
        IV ty = this.makeIV((Value)new URIImpl("http://www.example.org/ty"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode subGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)subGroup);
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        subGroup.addChild((IGroupMemberNode)subqueryRoot);
        projection = new ProjectionNode();
        subqueryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        whereClause = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        subqueryRoot.setRunOnce(true);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        String name = "-subSelect-1";
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        NamedSubqueryInclude nsi = new NamedSubqueryInclude("-subSelect-1");
        nsi.setAttachedJoinFilters(new LinkedList());
        whereClause2.addChild((IGroupMemberNode)nsi);
        NamedSubqueryRoot subqueryRoot2 = new NamedSubqueryRoot(QueryType.SELECT, "-subSelect-1");
        NamedSubqueriesNode namedSubqueries = new NamedSubqueriesNode();
        expected.setNamedSubqueries(namedSubqueries);
        namedSubqueries.add((IQueryNode)subqueryRoot2);
        projection2 = new ProjectionNode();
        subqueryRoot2.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        whereClause2 = new JoinGroupNode();
        subqueryRoot2.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTSparql11SubqueryOptimizer rewriter = new ASTSparql11SubqueryOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTSparql11SubqueryOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_subSelectWithNoJoinVars() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://www.example.org/p"));
        IV a = this.makeIV((Value)RDF.TYPE);
        IV ty = this.makeIV((Value)new URIImpl("http://www.example.org/ty"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode subGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)subGroup);
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        subGroup.addChild((IGroupMemberNode)subqueryRoot);
        projection = new ProjectionNode();
        subqueryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("s1"));
        whereClause = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s1"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        String name = "-subSelect-1";
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new NamedSubqueryInclude("-subSelect-1"));
        NamedSubqueryRoot subqueryRoot2 = new NamedSubqueryRoot(QueryType.SELECT, "-subSelect-1");
        NamedSubqueriesNode namedSubqueries = new NamedSubqueriesNode();
        expected.setNamedSubqueries(namedSubqueries);
        namedSubqueries.add((IQueryNode)subqueryRoot2);
        projection2 = new ProjectionNode();
        subqueryRoot2.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s1"));
        whereClause2 = new JoinGroupNode();
        subqueryRoot2.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s1"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(ty), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTSparql11SubqueryOptimizer rewriter = new ASTSparql11SubqueryOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        if (!BigdataStatics.runKnownBadTests) {
            return;
        }
        TestASTSparql11SubqueryOptimizer.assertSameAST((IQueryNode)expected, actual);
    }
}

