/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.PathNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.PropertyPathNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTStaticBindingsOptimizer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTStaticBindingsOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTStaticBindingsOptimizer() {
    }

    public TestASTStaticBindingsOptimizer(String name) {
        super(name);
    }

    public void testInlineFromExogeneousBindings() {
        TermId mockIV = TermId.mockIV((VTE)VTE.URI);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet(new IVariable[]{Var.var((String)"p")}, new IConstant[]{new Constant((Object)mockIV)})};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)mockIV)), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testMultiInlineFromExogeneousBindings() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataLiteral c12Lit = f.createLiteral(12);
        IV c12 = this.makeIV((Value)c12Lit);
        BigdataValue[] values = new BigdataValue[]{c12Lit};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet(new IVariable[]{Var.var((String)"s")}, new IConstant[]{new Constant((Object)c12)})};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("p"));
        given.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("s"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("p"));
        expected.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"s"), (Object)c12)), (TermNode)new VarNode("p"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"s"), (Object)c12)), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testInlineFromBind() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.test.com");
        IV cTest = this.makeIV((Value)cTestUri);
        BigdataValue[] values = new BigdataValue[]{cTestUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTest)));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest)), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"p")).equals((IVariableOrConstant)new Constant((Object)cTest)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testInlineFromBindNested1() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.test.com");
        IV cTest = this.makeIV((Value)cTestUri);
        BigdataValue[] values = new BigdataValue[]{cTestUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode jgn = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)jgn);
        jgn.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTest)));
        jgn.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        JoinGroupNode jgn2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)jgn2);
        jgn2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest)), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"p")).equals((IVariableOrConstant)new Constant((Object)cTest)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testInlineFromBindNested2() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.test.com");
        IV cTest = this.makeIV((Value)cTestUri);
        BigdataValue[] values = new BigdataValue[]{cTestUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode jgn = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)jgn);
        jgn.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTest)));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        JoinGroupNode jgn2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)jgn2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest)), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"p")).equals((IVariableOrConstant)new Constant((Object)cTest)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testInlineFromTopLevelValues() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.test.com");
        IV cTest = this.makeIV((Value)cTestUri);
        BigdataValue[] values = new BigdataValue[]{cTestUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        Var var = Var.var((String)"p");
        LinkedHashSet<Var> declaredVars = new LinkedHashSet<Var>();
        declaredVars.add(var);
        ArrayList<ListBindingSet> bindingSets = new ArrayList<ListBindingSet>();
        ListBindingSet bs = new ListBindingSet();
        bs.set((IVariable)var, (IConstant)new Constant((Object)cTest));
        bindingSets.add(bs);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        BindingsClause bc = new BindingsClause(declaredVars, bindingSets);
        given.setBindingsClause(bc);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest)), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"p")).equals((IVariableOrConstant)new Constant((Object)cTest)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testInlineFromValues() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.test.com");
        IV cTest = this.makeIV((Value)cTestUri);
        BigdataValue[] values = new BigdataValue[]{cTestUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        Var var = Var.var((String)"p");
        LinkedHashSet<Var> declaredVars = new LinkedHashSet<Var>();
        declaredVars.add(var);
        ArrayList<ListBindingSet> bindingSets = new ArrayList<ListBindingSet>();
        ListBindingSet bs = new ListBindingSet();
        bs.set((IVariable)var, (IConstant)new Constant((Object)cTest));
        bindingSets.add(bs);
        BindingsClause bc = new BindingsClause(declaredVars, bindingSets);
        whereClause.addChild((IGroupMemberNode)bc);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest)), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"p")).equals((IVariableOrConstant)new Constant((Object)cTest)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testMergeWithSimpleExogeneousMapping() {
        BigdataLiteral cTrueLit = this.store.getValueFactory().createLiteral(true);
        BigdataLiteral cFalseLit = this.store.getValueFactory().createLiteral(false);
        IV cTrue = this.makeIV((Value)cTrueLit);
        IV cFalse = this.makeIV((Value)cFalseLit);
        BigdataValue[] values = new BigdataValue[]{cTrueLit, cFalseLit};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet(new IVariable[]{Var.var((String)"s")}, new IConstant[]{new Constant((Object)cFalse)})};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("p"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTrue)));
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("p"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 2 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"s")).equals((IVariableOrConstant)new Constant((Object)cFalse)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"p")).equals((IVariableOrConstant)new Constant((Object)cTrue)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testMergeWithComplexExogeneousMapping() {
    }

    public void testInliningForComplexExogeneousMapping() {
        BigdataLiteral a1LitBD = this.store.getValueFactory().createLiteral("a1");
        BigdataLiteral a2LitBD = this.store.getValueFactory().createLiteral("a2");
        BigdataLiteral a3LitBD = this.store.getValueFactory().createLiteral("a3");
        BigdataLiteral bLitBD = this.store.getValueFactory().createLiteral("b");
        BigdataLiteral c1LitBD = this.store.getValueFactory().createLiteral("c1");
        BigdataLiteral c2LitBD = this.store.getValueFactory().createLiteral("c2");
        BigdataLiteral c3LitBD = this.store.getValueFactory().createLiteral("c3");
        BigdataLiteral d1LitBD = this.store.getValueFactory().createLiteral("d1");
        BigdataLiteral d2LitBD = this.store.getValueFactory().createLiteral("d2");
        BigdataLiteral eLitBD = this.store.getValueFactory().createLiteral("e");
        IV a1Lit = this.makeIV((Value)a1LitBD);
        IV a2Lit = this.makeIV((Value)a2LitBD);
        IV a3Lit = this.makeIV((Value)a3LitBD);
        IV bLit = this.makeIV((Value)bLitBD);
        IV c1Lit = this.makeIV((Value)c1LitBD);
        IV c2Lit = this.makeIV((Value)c2LitBD);
        IV c3Lit = this.makeIV((Value)c3LitBD);
        IV d1Lit = this.makeIV((Value)d1LitBD);
        IV d2Lit = this.makeIV((Value)d2LitBD);
        IV eLit = this.makeIV((Value)eLitBD);
        BigdataValue[] values = new BigdataValue[]{a1LitBD, a2LitBD, a3LitBD, bLitBD, c1LitBD, c2LitBD, c3LitBD, d1LitBD, d2LitBD, eLitBD};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ListBindingSet exogeneousIn1 = new ListBindingSet();
        exogeneousIn1.set((IVariable)Var.var((String)"a"), (IConstant)new Constant((Object)a1Lit));
        exogeneousIn1.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c1Lit));
        ListBindingSet exogeneousIn2 = new ListBindingSet();
        exogeneousIn2.set((IVariable)Var.var((String)"a"), (IConstant)new Constant((Object)a2Lit));
        exogeneousIn2.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c2Lit));
        ListBindingSet exogeneousIn3 = new ListBindingSet();
        exogeneousIn3.set((IVariable)Var.var((String)"a"), (IConstant)new Constant((Object)a3Lit));
        exogeneousIn3.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c3Lit));
        IBindingSet[] bsetsGiven = new IBindingSet[]{exogeneousIn1, exogeneousIn2, exogeneousIn3};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("p"));
        AssignmentNode bAss = new AssignmentNode(new VarNode("b"), (IValueExpressionNode)new ConstantNode(bLit));
        LinkedHashSet<Var> declaredVarsE = new LinkedHashSet<Var>();
        declaredVarsE.add(Var.var((String)"e"));
        ArrayList<ListBindingSet> bindingSetsE = new ArrayList<ListBindingSet>();
        ListBindingSet bsE = new ListBindingSet();
        bsE.set((IVariable)Var.var((String)"e"), (IConstant)new Constant((Object)eLit));
        bindingSetsE.add(bsE);
        BindingsClause eBindings = new BindingsClause(declaredVarsE, bindingSetsE);
        LinkedHashSet declaredVarsBcd = new LinkedHashSet();
        declaredVarsE.add(Var.var((String)"b"));
        declaredVarsE.add(Var.var((String)"c"));
        declaredVarsE.add(Var.var((String)"d"));
        ArrayList<ListBindingSet> bindingSetsCd = new ArrayList<ListBindingSet>();
        ListBindingSet bsCd1 = new ListBindingSet();
        bsCd1.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c1Lit));
        bsCd1.set((IVariable)Var.var((String)"d"), (IConstant)new Constant((Object)d1Lit));
        bindingSetsCd.add(bsCd1);
        ListBindingSet bsCd2 = new ListBindingSet();
        bsCd2.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c2Lit));
        bsCd2.set((IVariable)Var.var((String)"d"), (IConstant)new Constant((Object)d2Lit));
        bindingSetsCd.add(bsCd2);
        BindingsClause bcdBindings = new BindingsClause(declaredVarsBcd, bindingSetsCd);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)bAss);
        whereClause.addChild((IGroupMemberNode)bcdBindings);
        given.setBindingsClause(eBindings);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("p"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        IBindingSet bs1 = resBs[0];
        TestASTStaticBindingsOptimizer.assertTrue((bs1.size() == 5 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"a")).equals((IVariableOrConstant)new Constant((Object)a1Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"b")).equals((IVariableOrConstant)new Constant((Object)bLit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"c")).equals((IVariableOrConstant)new Constant((Object)c1Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"d")).equals((IVariableOrConstant)new Constant((Object)d1Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"e")).equals((IVariableOrConstant)new Constant((Object)eLit)));
        IBindingSet bs2 = resBs[1];
        TestASTStaticBindingsOptimizer.assertTrue((bs2.size() == 5 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"a")).equals((IVariableOrConstant)new Constant((Object)a2Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"b")).equals((IVariableOrConstant)new Constant((Object)bLit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"c")).equals((IVariableOrConstant)new Constant((Object)c2Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"d")).equals((IVariableOrConstant)new Constant((Object)d2Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"e")).equals((IVariableOrConstant)new Constant((Object)eLit)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testSimpleSameTermFilter() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataLiteral c12Lit = f.createLiteral(12);
        IV c12 = this.makeIV((Value)c12Lit);
        BigdataValue[] values = new BigdataValue[]{c12Lit};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        given.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("o"), (ValueExpressionNode)new ConstantNode(c12))));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"o"), (Object)c12)), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"o"), (Object)c12)), (ValueExpressionNode)new ConstantNode(c12))));
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testInlineSimpleFilterEqURI() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI fooLit = f.createURI(":foo");
        IV foo = this.makeIV((Value)fooLit);
        BigdataValue[] values = new BigdataValue[]{fooLit};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        given.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("o"), (ValueExpressionNode)new ConstantNode(foo))));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"o"), (Object)foo)), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"o"), (Object)foo)), (ValueExpressionNode)new ConstantNode(foo))));
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testInlineSimpleFilterINURI() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI fooLit = f.createURI(":foo");
        IV foo = this.makeIV((Value)fooLit);
        BigdataValue[] values = new BigdataValue[]{fooLit};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        given.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.IN, null, new ValueExpressionNode[]{new VarNode("o"), new ConstantNode(foo)})));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"o"), (Object)foo)), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.IN, null, new ValueExpressionNode[]{new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"o"), (Object)foo)), new ConstantNode(foo)})));
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testInlineSimpleFilterEqURIRev() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI fooLit = f.createURI(":foo");
        IV foo = this.makeIV((Value)fooLit);
        BigdataValue[] values = new BigdataValue[]{fooLit};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        given.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new ConstantNode(foo), (ValueExpressionNode)new VarNode("o"))));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"o"), (Object)foo)), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new ConstantNode(foo), (ValueExpressionNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"o"), (Object)foo)))));
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testNotInlineSimpleFilterEqLiteral() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataLiteral fooLit = f.createLiteral("foo");
        IV foo = this.makeIV((Value)fooLit);
        BigdataValue[] values = new BigdataValue[]{fooLit};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        given.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("o"), (ValueExpressionNode)new ConstantNode(foo))));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("o"), (ValueExpressionNode)new ConstantNode(foo))));
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testNotInlineSimpleFilterEqLiteralRev() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataLiteral fooLit = f.createLiteral("foo");
        IV foo = this.makeIV((Value)fooLit);
        BigdataValue[] values = new BigdataValue[]{fooLit};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        given.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new ConstantNode(foo), (ValueExpressionNode)new VarNode("o"))));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection2);
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new ConstantNode(foo), (ValueExpressionNode)new VarNode("o"))));
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void testFilterAndBindInlinedBindAddedToExogeneous() {
    }

    public void testValuesComplexExogeneousMappingInSubquery() {
        BigdataLiteral a1LitBD = this.store.getValueFactory().createLiteral("a1");
        BigdataLiteral a2LitBD = this.store.getValueFactory().createLiteral("a2");
        BigdataLiteral a3LitBD = this.store.getValueFactory().createLiteral("a3");
        BigdataLiteral bLitBD = this.store.getValueFactory().createLiteral("b");
        BigdataLiteral c1LitBD = this.store.getValueFactory().createLiteral("c1");
        BigdataLiteral c2LitBD = this.store.getValueFactory().createLiteral("c2");
        BigdataLiteral c3LitBD = this.store.getValueFactory().createLiteral("c3");
        BigdataLiteral d1LitBD = this.store.getValueFactory().createLiteral("d1");
        BigdataLiteral d2LitBD = this.store.getValueFactory().createLiteral("d2");
        BigdataLiteral eLitBD = this.store.getValueFactory().createLiteral("e");
        IV a1Lit = this.makeIV((Value)a1LitBD);
        IV a2Lit = this.makeIV((Value)a2LitBD);
        IV a3Lit = this.makeIV((Value)a3LitBD);
        IV bLit = this.makeIV((Value)bLitBD);
        IV c1Lit = this.makeIV((Value)c1LitBD);
        IV c2Lit = this.makeIV((Value)c2LitBD);
        IV c3Lit = this.makeIV((Value)c3LitBD);
        IV d1Lit = this.makeIV((Value)d1LitBD);
        IV d2Lit = this.makeIV((Value)d2LitBD);
        IV eLit = this.makeIV((Value)eLitBD);
        BigdataValue[] values = new BigdataValue[]{a1LitBD, a2LitBD, a3LitBD, bLitBD, c1LitBD, c2LitBD, c3LitBD, d1LitBD, d2LitBD, eLitBD};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ListBindingSet exogeneousIn1 = new ListBindingSet();
        exogeneousIn1.set((IVariable)Var.var((String)"a"), (IConstant)new Constant((Object)a1Lit));
        exogeneousIn1.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c1Lit));
        ListBindingSet exogeneousIn2 = new ListBindingSet();
        exogeneousIn2.set((IVariable)Var.var((String)"a"), (IConstant)new Constant((Object)a2Lit));
        exogeneousIn2.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c2Lit));
        ListBindingSet exogeneousIn3 = new ListBindingSet();
        exogeneousIn3.set((IVariable)Var.var((String)"a"), (IConstant)new Constant((Object)a3Lit));
        exogeneousIn3.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c3Lit));
        IBindingSet[] bsetsGiven = new IBindingSet[]{exogeneousIn1, exogeneousIn2, exogeneousIn3};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("p"));
        AssignmentNode bAss = new AssignmentNode(new VarNode("b"), (IValueExpressionNode)new ConstantNode(bLit));
        LinkedHashSet<Var> declaredVarsE = new LinkedHashSet<Var>();
        declaredVarsE.add(Var.var((String)"e"));
        ArrayList<ListBindingSet> bindingSetsE = new ArrayList<ListBindingSet>();
        ListBindingSet bsE = new ListBindingSet();
        bsE.set((IVariable)Var.var((String)"e"), (IConstant)new Constant((Object)eLit));
        bindingSetsE.add(bsE);
        BindingsClause eBindings = new BindingsClause(declaredVarsE, bindingSetsE);
        LinkedHashSet declaredVarsBcd = new LinkedHashSet();
        declaredVarsE.add(Var.var((String)"b"));
        declaredVarsE.add(Var.var((String)"c"));
        declaredVarsE.add(Var.var((String)"d"));
        ArrayList<ListBindingSet> bindingSetsCd = new ArrayList<ListBindingSet>();
        ListBindingSet bsCd1 = new ListBindingSet();
        bsCd1.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c1Lit));
        bsCd1.set((IVariable)Var.var((String)"d"), (IConstant)new Constant((Object)d1Lit));
        bindingSetsCd.add(bsCd1);
        ListBindingSet bsCd2 = new ListBindingSet();
        bsCd2.set((IVariable)Var.var((String)"c"), (IConstant)new Constant((Object)c2Lit));
        bsCd2.set((IVariable)Var.var((String)"d"), (IConstant)new Constant((Object)d2Lit));
        bindingSetsCd.add(bsCd2);
        BindingsClause bcdBindings = new BindingsClause(declaredVarsBcd, bindingSetsCd);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)bAss);
        whereClause.addChild((IGroupMemberNode)bcdBindings);
        given.setBindingsClause(eBindings);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("p"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        IBindingSet bs1 = resBs[0];
        TestASTStaticBindingsOptimizer.assertTrue((bs1.size() == 5 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"a")).equals((IVariableOrConstant)new Constant((Object)a1Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"b")).equals((IVariableOrConstant)new Constant((Object)bLit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"c")).equals((IVariableOrConstant)new Constant((Object)c1Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"d")).equals((IVariableOrConstant)new Constant((Object)d1Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs1.get((IVariable)Var.var((String)"e")).equals((IVariableOrConstant)new Constant((Object)eLit)));
        IBindingSet bs2 = resBs[1];
        TestASTStaticBindingsOptimizer.assertTrue((bs2.size() == 5 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"a")).equals((IVariableOrConstant)new Constant((Object)a2Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"b")).equals((IVariableOrConstant)new Constant((Object)bLit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"c")).equals((IVariableOrConstant)new Constant((Object)c2Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"d")).equals((IVariableOrConstant)new Constant((Object)d2Lit)));
        TestASTStaticBindingsOptimizer.assertTrue((boolean)bs2.get((IVariable)Var.var((String)"e")).equals((IVariableOrConstant)new Constant((Object)eLit)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testInlineFromBindInFilter() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.test.com");
        IV cTest = this.makeIV((Value)cTestUri);
        BigdataValue[] values = new BigdataValue[]{cTestUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("p"), (ValueExpressionNode)new ConstantNode(cTest))));
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTest)));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest)), (ValueExpressionNode)new ConstantNode(cTest))));
        whereClause2.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTest)));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 0 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testInlineFromBindInComplexFilter() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.test.com");
        BigdataURI cTestUri2 = f.createURI("http://www.test2.com");
        IV cTest = this.makeIV((Value)cTestUri);
        IV cTest2 = this.makeIV((Value)cTestUri2);
        BigdataValue[] values = new BigdataValue[]{cTestUri, cTestUri2};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new VarNode("p"), (ValueExpressionNode)new ConstantNode(cTest)), (ValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new VarNode("p"), (ValueExpressionNode)new ConstantNode(cTest2)))));
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTest)));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest)), (ValueExpressionNode)new ConstantNode(cTest)), (ValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest)), (ValueExpressionNode)new ConstantNode(cTest2)))));
        whereClause2.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTest)));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 0 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testInlineWithSubquery() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.test.com");
        BigdataURI cTestUri2 = f.createURI("http://www.test2.com");
        IV cTest = this.makeIV((Value)cTestUri);
        IV cTest2 = this.makeIV((Value)cTestUri2);
        BigdataValue[] values = new BigdataValue[]{cTestUri, cTestUri2};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTest)));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        SubqueryRoot sq = new SubqueryRoot(QueryType.SELECT);
        JoinGroupNode sqWhereClause = new JoinGroupNode();
        sqWhereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("p"), (IValueExpressionNode)new ConstantNode(cTest2)));
        sqWhereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        sq.setWhereClause((GraphPatternGroup)sqWhereClause);
        whereClause.addChild((IGroupMemberNode)sq);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest)), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        SubqueryRoot sq2 = new SubqueryRoot(QueryType.SELECT);
        JoinGroupNode sqWhereClause2 = new JoinGroupNode();
        sqWhereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"p"), (Object)cTest2)), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        sq2.setWhereClause((GraphPatternGroup)sqWhereClause2);
        Var var = Var.var((String)"p");
        LinkedHashSet<Var> declaredVars = new LinkedHashSet<Var>();
        declaredVars.add(var);
        ArrayList<ListBindingSet> bindingSets = new ArrayList<ListBindingSet>();
        ListBindingSet bs = new ListBindingSet();
        bs.set((IVariable)var, (IConstant)new Constant((Object)cTest2));
        bindingSets.add(bs);
        BindingsClause sqBC = new BindingsClause(declaredVars, bindingSets);
        sq2.setBindingsClause(sqBC);
        whereClause2.addChild((IGroupMemberNode)sq2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"p")).equals((IVariableOrConstant)new Constant((Object)cTest)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testSubqueryWithValues() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI c1BD = f.createURI("http://www.test.com");
        BigdataLiteral c2BD = f.createLiteral("X");
        BigdataLiteral c3BD = f.createLiteral("Y");
        IV c1 = this.makeIV((Value)c1BD);
        IV c2 = this.makeIV((Value)c2BD);
        IV c3 = this.makeIV((Value)c3BD);
        BigdataValue[] values = new BigdataValue[]{c1BD, c2BD, c3BD};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet(new IVariable[]{Var.var((String)"s")}, new IConstant[]{new Constant((Object)c3)})};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        SubqueryRoot sq = new SubqueryRoot(QueryType.SELECT);
        ProjectionNode sqProjection = new ProjectionNode();
        sqProjection.addProjectionVar(new VarNode("x"));
        sq.setProjection(projection);
        JoinGroupNode sqWhereClause = new JoinGroupNode();
        sqWhereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("x"), (IValueExpressionNode)new ConstantNode(c1)));
        sqWhereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        sq.setWhereClause((GraphPatternGroup)sqWhereClause);
        Var var = Var.var((String)"y");
        LinkedHashSet<Var> declaredVars = new LinkedHashSet<Var>();
        declaredVars.add(var);
        ArrayList<ListBindingSet> bindingSets = new ArrayList<ListBindingSet>();
        ListBindingSet bs = new ListBindingSet();
        bs.set((IVariable)var, (IConstant)new Constant((Object)c2));
        bindingSets.add(bs);
        BindingsClause sqBc = new BindingsClause(declaredVars, bindingSets);
        sq.setBindingsClause(sqBc);
        whereClause.addChild((IGroupMemberNode)sq);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"s"), (Object)c3)), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        SubqueryRoot sq2 = new SubqueryRoot(QueryType.SELECT);
        ProjectionNode sqProjection2 = new ProjectionNode();
        sqProjection2.addProjectionVar(new VarNode("x"));
        sq2.setProjection(projection2);
        JoinGroupNode sqWhereClause2 = new JoinGroupNode();
        sqWhereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        sq2.setWhereClause((GraphPatternGroup)sqWhereClause2);
        Var varX = Var.var((String)"x");
        Var varY = Var.var((String)"y");
        LinkedHashSet<Var> declaredVars2 = new LinkedHashSet<Var>();
        declaredVars2.add(varX);
        declaredVars2.add(varY);
        ArrayList<ListBindingSet> bindingSets2 = new ArrayList<ListBindingSet>();
        ListBindingSet bs2 = new ListBindingSet();
        bs2.set((IVariable)varX, (IConstant)new Constant((Object)c1));
        bs2.set((IVariable)varY, (IConstant)new Constant((Object)c2));
        bindingSets2.add(bs2);
        BindingsClause sqBc2 = new BindingsClause(declaredVars2, bindingSets2);
        sq2.setBindingsClause(sqBc2);
        whereClause2.addChild((IGroupMemberNode)sq2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"s")).equals((IVariableOrConstant)new Constant((Object)c3)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testTicket653() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.yso.fi/onto/ysa/Y141994");
        BigdataURI rdfTypeUri = f.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        BigdataURI rdfsLabelUri = f.createURI("http://www.w3.org/2000/01/rdf-schema#label");
        IV cTest = this.makeIV((Value)cTestUri);
        IV rdfType = this.makeIV((Value)cTestUri);
        IV rdfsLabel = this.makeIV((Value)rdfsLabelUri);
        BigdataValue[] values = new BigdataValue[]{cTestUri, rdfTypeUri, rdfsLabelUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("uri"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("uri"), (IValueExpressionNode)new ConstantNode(cTest)));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("uri"), (TermNode)new VarNode("p"), (TermNode)new VarNode("type"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode jgn = new JoinGroupNode();
        jgn.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("uri"), (TermNode)new ConstantNode(rdfType), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        jgn.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("type"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("typeLabel"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        jgn.setOptional(true);
        whereClause.addChild((IGroupMemberNode)jgn);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("uri"));
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"uri"), (Object)cTest)), (TermNode)new VarNode("p"), (TermNode)new VarNode("type"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode jgn2 = new JoinGroupNode();
        jgn2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("uri"), (TermNode)new ConstantNode(rdfType), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        jgn2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("type"), (TermNode)new ConstantNode(rdfsLabel), (TermNode)new VarNode("typeLabel"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        jgn2.setOptional(true);
        whereClause2.addChild((IGroupMemberNode)jgn2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"uri")).equals((IVariableOrConstant)new Constant((Object)cTest)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }

    public void testTicketBLZG2042() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI cTestUri = f.createURI("http://www.test.com");
        BigdataURI bv1 = this.store.getValueFactory().asValue((URI)new URIImpl("http://p1"));
        BigdataURI bv2 = this.store.getValueFactory().asValue((URI)new URIImpl("http://p2"));
        IV cTest = this.makeIV((Value)cTestUri);
        IV iv1 = this.makeIV((Value)bv1);
        IV iv2 = this.makeIV((Value)bv2);
        BigdataValue[] values = new BigdataValue[]{cTestUri};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        IBindingSet[] bsetsGiven = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new AssignmentNode(new VarNode("o"), (IValueExpressionNode)new ConstantNode(cTest)));
        PathNode.PathElt[] elements = new PathNode.PathElt[]{new PathNode.PathElt((BOp)new ConstantNode(iv1), false, PathNode.PathMod.ZERO_OR_MORE), new PathNode.PathElt((BOp)new ConstantNode(iv2), false, PathNode.PathMod.ZERO_OR_MORE)};
        PathNode pn = new PathNode(new PathNode.PathAlternative(new PathNode.PathSequence[]{new PathNode.PathSequence(elements)}));
        whereClause.addChild((IGroupMemberNode)new PropertyPathNode((TermNode)new VarNode("s"), pn, (TermNode)new VarNode("o")));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        PathNode.PathElt[] elements2 = new PathNode.PathElt[]{new PathNode.PathElt((BOp)new ConstantNode(iv1), false, PathNode.PathMod.ZERO_OR_MORE), new PathNode.PathElt((BOp)new ConstantNode(iv2), false, PathNode.PathMod.ZERO_OR_MORE)};
        PathNode pn2 = new PathNode(new PathNode.PathAlternative(new PathNode.PathSequence[]{new PathNode.PathSequence(elements2)}));
        whereClause2.addChild((IGroupMemberNode)new PropertyPathNode((TermNode)new VarNode("s"), pn2, (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"o"), (Object)cTest))));
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticBindingsOptimizer rewriter = new ASTStaticBindingsOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        QueryNodeWithBindingSet res = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsetsGiven));
        IBindingSet[] resBs = res.getBindingSets();
        TestASTStaticBindingsOptimizer.assertTrue((resBs.length == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((resBs[0].size() == 1 ? 1 : 0) != 0);
        TestASTStaticBindingsOptimizer.assertTrue((boolean)resBs[0].get((IVariable)Var.var((String)"o")).equals((IVariableOrConstant)new Constant((Object)cTest)));
        TestASTStaticBindingsOptimizer.assertSameAST((IQueryNode)expected, res.getQueryNode());
    }
}

