/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTStaticJoinOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractOptimizerTestCase;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BDS;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public class TestASTStaticJoinOptimizer
extends AbstractOptimizerTestCase {
    protected ASTStaticJoinOptimizer newOptimizer() {
        return new ASTStaticJoinOptimizer();
    }

    public void test_simpleOptional01A() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.e), this.constantNode(this.e), 5), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.b), this.constantNode(this.b), 2), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.d), this.constantNode(this.d), 4), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.a), this.constantNode(this.a), 1), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.c), 3), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.f), this.constantNode(this.f), new Object[]{1, AbstractOptimizerTestCase.HelperFlag.OPTIONAL}), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.g), this.constantNode(this.g), new Object[]{1, AbstractOptimizerTestCase.HelperFlag.OPTIONAL})}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("x"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.a), this.constantNode(this.a), 1), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.b), this.constantNode(this.b), 2), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.c), 3), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.d), this.constantNode(this.d), 4), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.e), this.constantNode(this.e), 5), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.f), this.constantNode(this.f), new Object[]{1, AbstractOptimizerTestCase.HelperFlag.OPTIONAL}), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.g), this.constantNode(this.g), new Object[]{1, AbstractOptimizerTestCase.HelperFlag.OPTIONAL})}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }

    public TestASTStaticJoinOptimizer() {
    }

    public TestASTStaticJoinOptimizer(String name) {
        super(name);
    }

    public void test_simpleReorder01() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_simpleReorder02() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode());
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause2.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause2.addChild((IGroupMemberNode)new JoinGroupNode());
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_simpleReorder03() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV c = this.makeIV((Value)new URIImpl("http://example/c"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 5L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 5L));
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_simpleReorder04() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV c = this.makeIV((Value)new URIImpl("http://example/c"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 5L));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause2.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause2.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        whereClause2.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause2.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause2.addChild((IGroupMemberNode)new JoinGroupNode());
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 5L));
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_simpleOptional01() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV c = this.makeIV((Value)new URIImpl("http://example/c"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        IV f = this.makeIV((Value)new URIImpl("http://example/f"));
        IV g = this.makeIV((Value)new URIImpl("http://example/g"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 5L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 1L, true));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(g), (TermNode)new ConstantNode(g), 1L, true));
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 5L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 1L, true));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(g), (TermNode)new ConstantNode(g), 1L, true));
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_ServiceNode01() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV search = this.makeIV((Value)BDS.SEARCH);
        IV foo = this.makeIV((Value)new LiteralImpl("foo"));
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV serviceRef = this.makeIV((Value)BDS.SEARCH);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(serviceRef), (GraphPatternGroup)new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(search), (TermNode)new ConstantNode(foo))));
        whereClause.addChild((IGroupMemberNode)serviceNode);
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 1L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new VarNode("y"), 2L));
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        ServiceNode serviceNode2 = new ServiceNode((TermNode)new ConstantNode(serviceRef), (GraphPatternGroup)new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(search), (TermNode)new ConstantNode(foo))));
        whereClause2.addChild((IGroupMemberNode)serviceNode2);
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new VarNode("y"), 2L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 1L));
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_ServiceNode02() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV search = this.makeIV((Value)BDS.SEARCH);
        IV foo = this.makeIV((Value)new LiteralImpl("foo"));
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV c = this.makeIV((Value)new URIImpl("http://example/c"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        IV f = this.makeIV((Value)new URIImpl("http://example/f"));
        IV g = this.makeIV((Value)new URIImpl("http://example/g"));
        IV serviceRef = this.makeIV((Value)BDS.SEARCH);
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(serviceRef), (GraphPatternGroup)new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(search), (TermNode)new ConstantNode(foo))));
        whereClause.addChild((IGroupMemberNode)serviceNode);
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 3L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 2L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 4L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new VarNode("y"), 1000L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 1L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 1L, true));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(g), (TermNode)new ConstantNode(g), 1L, true));
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        ServiceNode serviceNode2 = new ServiceNode((TermNode)new ConstantNode(serviceRef), (GraphPatternGroup)new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(search), (TermNode)new ConstantNode(foo))));
        whereClause2.addChild((IGroupMemberNode)serviceNode2);
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new VarNode("y"), 1000L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 1L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 2L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 3L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 4L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 1L, true));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(g), (TermNode)new ConstantNode(g), 1L, true));
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_nestedOptionals01() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV c = this.makeIV((Value)new URIImpl("http://example/c"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        IV f = this.makeIV((Value)new URIImpl("http://example/f"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        JoinGroupNode subgroup = new JoinGroupNode();
        subgroup.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 5L));
        subgroup.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 4L));
        subgroup.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 10L));
        whereClause.addChild((IGroupMemberNode)subgroup);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        JoinGroupNode subgroup2 = new JoinGroupNode();
        subgroup2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 10L));
        subgroup2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 4L));
        subgroup2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 5L));
        whereClause2.addChild((IGroupMemberNode)subgroup2);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_nestedOptionals02() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        JoinGroupNode subgroup = new JoinGroupNode();
        subgroup.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new VarNode("y"), 10L));
        subgroup.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 4L));
        whereClause.addChild((IGroupMemberNode)subgroup);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        JoinGroupNode subgroup2 = new JoinGroupNode();
        subgroup2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new VarNode("y"), 10L));
        subgroup2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 4L));
        whereClause2.addChild((IGroupMemberNode)subgroup2);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_nestedOptionals03() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        JoinGroupNode subgroup1 = new JoinGroupNode();
        subgroup1.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        subgroup1.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 1L));
        whereClause.addChild((IGroupMemberNode)subgroup1);
        JoinGroupNode subgroup2 = new JoinGroupNode();
        subgroup2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("z"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        subgroup2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("z"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        JoinGroupNode subgroup3 = new JoinGroupNode();
        subgroup3.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 1L));
        subgroup3.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 10L));
        subgroup2.addChild((IGroupMemberNode)subgroup3);
        whereClause.addChild((IGroupMemberNode)subgroup2);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        JoinGroupNode subgroup12 = new JoinGroupNode();
        subgroup12.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        subgroup12.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 1L));
        whereClause2.addChild((IGroupMemberNode)subgroup12);
        JoinGroupNode subgroup22 = new JoinGroupNode();
        subgroup22.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("z"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 1L));
        subgroup22.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("z"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        JoinGroupNode subgroup32 = new JoinGroupNode();
        subgroup32.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("y"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 1L));
        subgroup32.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 10L));
        subgroup22.addChild((IGroupMemberNode)subgroup32);
        whereClause2.addChild((IGroupMemberNode)subgroup22);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_NSI01X() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNodes("x", "y", "z"), this.namedSubQuery("_set1", this.varNode("x"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_set1", new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), (TermNode)this.varNode("y"), new Object[]{1, AbstractOptimizerTestCase.HelperFlag.OPTIONAL}), this.joinGroupNode(new Object[]{this.statementPatternNode((TermNode)this.varNode("w"), this.constantNode(this.e), (TermNode)this.varNode("z"), 10), this.statementPatternNode((TermNode)this.varNode("w"), this.constantNode(this.d), (TermNode)this.varNode("x"), 100), AbstractOptimizerTestCase.HelperFlag.OPTIONAL})}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                this.expected = this.select(this.varNodes("x", "y", "z"), this.namedSubQuery("_set1", this.varNode("x"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_set1", new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), (TermNode)this.varNode("y"), new Object[]{1, AbstractOptimizerTestCase.HelperFlag.OPTIONAL}), this.joinGroupNode(new Object[]{this.statementPatternNode((TermNode)this.varNode("w"), this.constantNode(this.d), (TermNode)this.varNode("x"), 100), this.statementPatternNode((TermNode)this.varNode("w"), this.constantNode(this.e), (TermNode)this.varNode("z"), 10), AbstractOptimizerTestCase.HelperFlag.OPTIONAL})}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
            }
        }.test();
    }

    public void test_NSI01() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV c = this.makeIV((Value)new URIImpl("http://example/c"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        NamedSubqueryRoot namedSubquery = new NamedSubqueryRoot(QueryType.SELECT, "_set1");
        ProjectionNode projection = new ProjectionNode();
        namedSubquery.setProjection(projection);
        projection.addProjectionExpression(new AssignmentNode(new VarNode("_var1"), (IValueExpressionNode)new VarNode("_var1")));
        JoinGroupNode joinGroup1 = new JoinGroupNode((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("_var1"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(b), 1L));
        namedSubquery.setWhereClause((GraphPatternGroup)joinGroup1);
        projection = new ProjectionNode();
        given.setProjection(projection);
        projection.setDistinct(true);
        projection.addProjectionVar(new VarNode("_var1"));
        projection.addProjectionVar(new VarNode("_var2"));
        projection.addProjectionVar(new VarNode("_var4"));
        joinGroup1 = new JoinGroupNode();
        joinGroup1.addChild((IGroupMemberNode)new NamedSubqueryInclude("_set1"));
        joinGroup1.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("_var1"), (TermNode)new ConstantNode(c), (TermNode)new VarNode("_var2"), 1L, true));
        JoinGroupNode joinGroup2 = new JoinGroupNode(true);
        joinGroup2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("_var12"), (TermNode)new ConstantNode(e), (TermNode)new VarNode("_var4"), 10L));
        joinGroup2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("_var12"), (TermNode)new ConstantNode(d), (TermNode)new VarNode("_var1"), 100L));
        joinGroup1.addChild((IGroupMemberNode)joinGroup2);
        given.setWhereClause((GraphPatternGroup)joinGroup1);
        given.getNamedSubqueriesNotNull().add((IQueryNode)namedSubquery);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        NamedSubqueryRoot namedSubquery2 = new NamedSubqueryRoot(QueryType.SELECT, "_set1");
        ProjectionNode projection2 = new ProjectionNode();
        namedSubquery2.setProjection(projection2);
        projection2.addProjectionExpression(new AssignmentNode(new VarNode("_var1"), (IValueExpressionNode)new VarNode("_var1")));
        JoinGroupNode joinGroup12 = new JoinGroupNode((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("_var1"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(b), 1L));
        namedSubquery2.setWhereClause((GraphPatternGroup)joinGroup12);
        projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setDistinct(true);
        projection2.addProjectionVar(new VarNode("_var1"));
        projection2.addProjectionVar(new VarNode("_var2"));
        projection2.addProjectionVar(new VarNode("_var4"));
        joinGroup12 = new JoinGroupNode();
        joinGroup12.addChild((IGroupMemberNode)new NamedSubqueryInclude("_set1"));
        joinGroup12.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("_var1"), (TermNode)new ConstantNode(c), (TermNode)new VarNode("_var2"), 1L, true));
        JoinGroupNode joinGroup22 = new JoinGroupNode(true);
        joinGroup22.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("_var12"), (TermNode)new ConstantNode(d), (TermNode)new VarNode("_var1"), 100L));
        joinGroup22.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("_var12"), (TermNode)new ConstantNode(e), (TermNode)new VarNode("_var4"), 10L));
        joinGroup12.addChild((IGroupMemberNode)joinGroup22);
        expected.setWhereClause((GraphPatternGroup)joinGroup12);
        expected.getNamedSubqueriesNotNull().add((IQueryNode)namedSubquery2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_pessimistic() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV country = this.makeIV((Value)new URIImpl("http://example/country"));
        IV producer = this.makeIV((Value)new URIImpl("http://example/producer"));
        IV reviewFor = this.makeIV((Value)new URIImpl("http://example/reviewFor"));
        IV reviewer = this.makeIV((Value)new URIImpl("http://example/reviewer"));
        IV RU = this.makeIV((Value)new URIImpl("http://example/RU"));
        IV US = this.makeIV((Value)new URIImpl("http://example/US"));
        IV type = this.makeIV((Value)RDF.TYPE);
        IV productType = this.makeIV((Value)new URIImpl("http://example/ProductType"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("productType"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(productType), 2000L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("productType"), 10000000L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(producer), (TermNode)new VarNode("producer"), 280000L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("producer"), (TermNode)new ConstantNode(country), (TermNode)new ConstantNode(RU), 7000L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("review"), (TermNode)new ConstantNode(reviewFor), (TermNode)new VarNode("product"), 2800000L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("review"), (TermNode)new ConstantNode(reviewer), (TermNode)new VarNode("reviewer"), 2800000L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("reviewer"), (TermNode)new ConstantNode(country), (TermNode)new ConstantNode(US), 61000L));
        whereClause.setProperty(ASTStaticJoinOptimizer.Annotations.OPTIMISTIC, (Object)0.67);
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("*"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("producer"), (TermNode)new ConstantNode(country), (TermNode)new ConstantNode(RU), 7000L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(producer), (TermNode)new VarNode("producer"), 280000L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("review"), (TermNode)new ConstantNode(reviewFor), (TermNode)new VarNode("product"), 2800000L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("review"), (TermNode)new ConstantNode(reviewer), (TermNode)new VarNode("reviewer"), 2800000L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("reviewer"), (TermNode)new ConstantNode(country), (TermNode)new ConstantNode(US), 61000L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("productType"), 10000000L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("productType"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(productType), 2000L));
        whereClause2.setProperty(ASTStaticJoinOptimizer.Annotations.OPTIMISTIC, (Object)0.67);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_runFirstRunLast_01() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV c = this.makeIV((Value)new URIImpl("http://example/c"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        IV f = this.makeIV((Value)new URIImpl("http://example/f"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause.addChild((IGroupMemberNode)this.runFirst(this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 100L)));
        whereClause.addChild((IGroupMemberNode)this.runLast(this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 1L)));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 1L, true));
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)this.runFirst(this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 100L)));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause2.addChild((IGroupMemberNode)this.runLast(this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 1L)));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 1L, true));
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_union_trac684_A() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("z"), this.namedSubQuery("_bds", this.varNode("z"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("z"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_bds", new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053), this.propertyPathUnionNode(this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.e), (TermNode)this.varNode("z"), 960191)), this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.f), (TermNode)this.varNode("z"), 615502)))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                this.expected = this.select(this.varNode("z"), this.namedSubQuery("_bds", this.varNode("z"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("z"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_bds", new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.propertyPathUnionNode(this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.e), (TermNode)this.varNode("z"), 960191)), this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.f), (TermNode)this.varNode("z"), 615502))), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053)}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
            }
        }.test();
    }

    public void test_union_trac684_B() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("z"), this.namedSubQuery("_bds", this.varNode("z"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("z"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_bds", new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.unionNode(this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.e), (TermNode)this.varNode("z"), 960191)), this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.f), (TermNode)this.varNode("z"), 615502), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053)))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                this.expected = this.select(this.varNode("z"), this.namedSubQuery("_bds", this.varNode("z"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("z"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_bds", new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.unionNode(this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.e), (TermNode)this.varNode("z"), 960191), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053)), this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.f), (TermNode)this.varNode("z"), 615502), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053)))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
            }
        }.test();
    }

    public void test_union_trac684_C() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("z"), this.namedSubQuery("_bds", this.varNode("z"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("z"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_bds", new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.g), this.constantNode(this.h), 960191), this.unionNode(this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.e), (TermNode)this.varNode("z"), 960191)), this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.f), (TermNode)this.varNode("z"), 615502), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053)))}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
                this.expected = this.select(this.varNode("z"), this.namedSubQuery("_bds", this.varNode("z"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("z"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{this.namedSubQueryInclude("_bds", new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.unionNode(this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.e), (TermNode)this.varNode("z"), 960191), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053)), this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.f), (TermNode)this.varNode("z"), 615502), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), this.constantNode(this.d), 81053))), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.g), this.constantNode(this.h), 960191)}), AbstractOptimizerTestCase.HelperFlag.DISTINCT);
            }
        }.test();
    }

    public void test_runFirstRunLast_02() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV b = this.makeIV((Value)new URIImpl("http://example/b"));
        IV c = this.makeIV((Value)new URIImpl("http://example/c"));
        IV d = this.makeIV((Value)new URIImpl("http://example/d"));
        IV e = this.makeIV((Value)new URIImpl("http://example/e"));
        IV f = this.makeIV((Value)new URIImpl("http://example/f"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause.addChild((IGroupMemberNode)this.runFirst(this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 100L)));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        whereClause.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 1L, true));
        whereClause.addChild((IGroupMemberNode)this.runLast(this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 1L, true)));
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)this.runFirst(this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(a), 100L)));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(b), (TermNode)new ConstantNode(b), 2L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(c), (TermNode)new ConstantNode(c), 3L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(d), (TermNode)new ConstantNode(d), 4L));
        whereClause2.addChild((IGroupMemberNode)this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(e), (TermNode)new ConstantNode(e), 1L, true));
        whereClause2.addChild((IGroupMemberNode)this.runLast(this.newStatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(f), (TermNode)new ConstantNode(f), 1L, true)));
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        ASTStaticJoinOptimizer rewriter = new ASTStaticJoinOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTStaticJoinOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    private StatementPatternNode runFirst(StatementPatternNode sp) {
        sp.setProperty("runFirst", (Object)true);
        return sp;
    }

    private StatementPatternNode runLast(StatementPatternNode sp) {
        sp.setProperty("runLast", (Object)true);
        return sp;
    }
}

