/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.optimizers.ASTBottomUpOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTEmptyGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTOptimizerList;
import com.bigdata.rdf.sparql.ast.optimizers.ASTUnionFiltersOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractOptimizerTestCase;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public class TestASTUnionFiltersOptimizer
extends AbstractOptimizerTestCase {
    public TestASTUnionFiltersOptimizer() {
    }

    public TestASTUnionFiltersOptimizer(String name) {
        super(name);
    }

    public void test_ticket416() throws Exception {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV type = this.makeIV((Value)RDF.TYPE);
        IV a = this.makeIV((Value)new URIImpl("http://example/a"));
        IV t1 = this.makeIV((Value)new URIImpl("http://example/t1"));
        IV t2 = this.makeIV((Value)new URIImpl("http://example/t2"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("r"));
        projection.addProjectionVar(new VarNode("l"));
        projection.setDistinct(true);
        UnionNode union = new UnionNode();
        JoinGroupNode left = new JoinGroupNode();
        left.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(a)));
        left.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("r")));
        left.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("r"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("type")));
        JoinGroupNode right = new JoinGroupNode();
        right.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(a)));
        right.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("l"), (TermNode)new VarNode("p"), (TermNode)new VarNode("s")));
        right.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("l"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("type")));
        union.addChild(left);
        union.addChild(right);
        JoinGroupNode where = new JoinGroupNode();
        where.addChild((IGroupMemberNode)union);
        where.addChild((IGroupMemberNode)new FilterNode(new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.OR, null, new ValueExpressionNode[]{new FunctionNode(FunctionRegistry.SAME_TERM, null, new ValueExpressionNode[]{new VarNode("type"), new ConstantNode(t1)}), new FunctionNode(FunctionRegistry.SAME_TERM, null, new ValueExpressionNode[]{new VarNode("type"), new ConstantNode(t2)})}))));
        given.setProjection(projection);
        given.setWhereClause((GraphPatternGroup)where);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("r"));
        projection2.addProjectionVar(new VarNode("l"));
        projection2.setDistinct(true);
        UnionNode union2 = new UnionNode();
        JoinGroupNode left2 = new JoinGroupNode();
        left2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(a)));
        left2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("r")));
        left2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("r"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("type")));
        left2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.OR, null, new ValueExpressionNode[]{new FunctionNode(FunctionRegistry.SAME_TERM, null, new ValueExpressionNode[]{new VarNode("type"), new ConstantNode(t1)}), new FunctionNode(FunctionRegistry.SAME_TERM, null, new ValueExpressionNode[]{new VarNode("type"), new ConstantNode(t2)})})));
        JoinGroupNode right2 = new JoinGroupNode();
        right2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(type), (TermNode)new ConstantNode(a)));
        right2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("l"), (TermNode)new VarNode("p"), (TermNode)new VarNode("s")));
        right2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("l"), (TermNode)new ConstantNode(type), (TermNode)new VarNode("type")));
        right2.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)new FunctionNode(FunctionRegistry.OR, null, new ValueExpressionNode[]{new FunctionNode(FunctionRegistry.SAME_TERM, null, new ValueExpressionNode[]{new VarNode("type"), new ConstantNode(t1)}), new FunctionNode(FunctionRegistry.SAME_TERM, null, new ValueExpressionNode[]{new VarNode("type"), new ConstantNode(t2)})})));
        union2.addChild(left2);
        union2.addChild(right2);
        expected.setProjection(projection2);
        expected.setWhereClause((GraphPatternGroup)union2);
        ASTUnionFiltersOptimizer opt1 = new ASTUnionFiltersOptimizer();
        ASTEmptyGroupOptimizer opt2 = new ASTEmptyGroupOptimizer();
        IQueryNode actual = opt2.optimize(null, new QueryNodeWithBindingSet(opt1.optimize(null, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode(), bsets)).getQueryNode();
        TestASTUnionFiltersOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    @Override
    IASTOptimizer newOptimizer() {
        return new ASTOptimizerList(new IASTOptimizer[]{new ASTUnionFiltersOptimizer(), new ASTBottomUpOptimizer()});
    }

    public void test_ticket767_case2() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.select(this.varNode("w"), this.where(new IGroupMemberNode[]{this.joinGroupNode(this.unionNode(this.joinGroupNode(this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), (TermNode)this.varNode("w"), new Object[0])), this.joinGroupNode(new Object[0])), this.filter((IValueExpressionNode)this.bound(this.varNode("w"))))}), new AbstractOptimizerTestCase.HelperFlag[0]);
                this.expected = this.select(this.varNode("w"), this.where(new IGroupMemberNode[]{this.joinGroupNode(this.unionNode(this.joinGroupNode(this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), (TermNode)this.varNode("w"), new Object[0]), this.filter((IValueExpressionNode)this.bound(this.varNode("w")))), this.joinGroupNode(this.filter((IValueExpressionNode)this.knownUnbound(this.varNode("w"))))))}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.testWhileIgnoringExplainHints();
    }

    public void test_ticket905() {
        new AbstractOptimizerTestCase.Helper(){
            {
                this.given = this.unchanged();
                this.expected = this.unchanged();
            }

            QueryRoot unchanged() {
                return this.select(this.varNode("w"), this.where(new IGroupMemberNode[]{this.joinGroupNode(this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), (TermNode)this.varNode("w"), new Object[0]), this.filter((IValueExpressionNode)this.bound(this.varNode("w"))), this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.b), (TermNode)this.varNode("w"), new Object[0]), this.unionNode(this.joinGroupNode(this.bind((IValueExpressionNode)this.constantNode(this.a), this.varNode("x"))), this.joinGroupNode(this.bind((IValueExpressionNode)this.constantNode(this.b), this.varNode("x")))))}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.test();
    }
}

