/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTWildcardProjectionOptimizer;
import java.util.Collections;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTWildcardProjectionOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTWildcardProjectionOptimizer() {
    }

    public TestASTWildcardProjectionOptimizer(String name) {
        super(name);
    }

    public void test_wildcardProjectionOptimizer00() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        JoinGroupNode joinGroup1 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup2 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)union);
        union.addChild(joinGroup1);
        union.addChild(joinGroup2);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        UnionNode union2 = new UnionNode();
        JoinGroupNode joinGroup12 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup22 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)union2);
        union2.addChild(joinGroup12);
        union2.addChild(joinGroup22);
        ASTWildcardProjectionOptimizer rewriter = new ASTWildcardProjectionOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTWildcardProjectionOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_wildcardProjectionOptimizer01() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.setDistinct(true);
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        JoinGroupNode joinGroup1 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup2 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)union);
        union.addChild(joinGroup1);
        union.addChild(joinGroup2);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setDistinct(true);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        UnionNode union2 = new UnionNode();
        JoinGroupNode joinGroup12 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup22 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)union2);
        union2.addChild(joinGroup12);
        union2.addChild(joinGroup22);
        ASTWildcardProjectionOptimizer rewriter = new ASTWildcardProjectionOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTWildcardProjectionOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_wildcardProjectionOptimizer02() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.setReduced(true);
        projection.addProjectionVar(new VarNode("*"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        JoinGroupNode joinGroup1 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup2 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)union);
        union.addChild(joinGroup1);
        union.addChild(joinGroup2);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        projection2.setReduced(true);
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        UnionNode union2 = new UnionNode();
        JoinGroupNode joinGroup12 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode joinGroup22 = new JoinGroupNode((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause2.addChild((IGroupMemberNode)union2);
        union2.addChild(joinGroup12);
        union2.addChild(joinGroup22);
        ASTWildcardProjectionOptimizer rewriter = new ASTWildcardProjectionOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTWildcardProjectionOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_wildcard_nestedSubquery() {
        IBindingSet[] bsets = new IBindingSet[]{};
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection1 = new ProjectionNode();
        given.setProjection(projection1);
        projection1.addProjectionVar(new VarNode("*"));
        JoinGroupNode whereClause1 = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause1);
        SubqueryRoot subSelect = new SubqueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        subSelect.setProjection(projection2);
        projection2.addProjectionVar(new VarNode("*"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        subSelect.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause1.addChild((IGroupMemberNode)subSelect);
        whereClause1.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("x"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection12 = new ProjectionNode();
        expected.setProjection(projection12);
        projection12.addProjectionVar(new VarNode("s"));
        projection12.addProjectionVar(new VarNode("o"));
        projection12.addProjectionVar(new VarNode("x"));
        JoinGroupNode whereClause12 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause12);
        SubqueryRoot subSelect2 = new SubqueryRoot(QueryType.SELECT);
        ProjectionNode projection22 = new ProjectionNode();
        subSelect2.setProjection(projection22);
        projection22.addProjectionVar(new VarNode("s"));
        projection22.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause22 = new JoinGroupNode();
        subSelect2.setWhereClause((GraphPatternGroup)whereClause22);
        whereClause22.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause12.addChild((IGroupMemberNode)subSelect2);
        whereClause12.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("x"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTWildcardProjectionOptimizer rewriter = new ASTWildcardProjectionOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTWildcardProjectionOptimizer.assertSameAST((IQueryNode)expected, actual);
    }

    public void test_wildcardProjectionOptimizer03() {
        IBindingSet[] bsets = new IBindingSet[]{};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        SubqueryRoot sliceQuery = new SubqueryRoot(QueryType.SELECT);
        SubqueryRoot selectQuery = new SubqueryRoot(QueryType.SELECT);
        given.setIncludeInferred(true);
        FunctionNode countNode = new FunctionNode(FunctionRegistry.COUNT, Collections.emptyMap(), new ValueExpressionNode[]{new VarNode("*")});
        ProjectionNode countProjection = new ProjectionNode();
        given.setProjection(countProjection);
        countProjection.addProjectionExpression(new AssignmentNode(new VarNode("c"), (IValueExpressionNode)countNode));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode childJoinGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)childJoinGroup);
        childJoinGroup.addChild((IGroupMemberNode)sliceQuery);
        ProjectionNode p = new ProjectionNode();
        sliceQuery.setProjection(p);
        p.addProjectionVar(new VarNode("*"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        sliceQuery.setWhereClause((GraphPatternGroup)whereClause2);
        JoinGroupNode childJoinGroup2 = new JoinGroupNode();
        whereClause2.addChild((IGroupMemberNode)childJoinGroup2);
        childJoinGroup2.addChild((IGroupMemberNode)selectQuery);
        sliceQuery.setSlice(new SliceNode(0L, 21L));
        p = new ProjectionNode();
        selectQuery.setProjection(p);
        p.addProjectionVar(new VarNode("*"));
        whereClause2 = new JoinGroupNode();
        selectQuery.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        SubqueryRoot sliceQuery2 = new SubqueryRoot(QueryType.SELECT);
        SubqueryRoot selectQuery2 = new SubqueryRoot(QueryType.SELECT);
        expected.setIncludeInferred(true);
        FunctionNode countNode2 = new FunctionNode(FunctionRegistry.COUNT, Collections.emptyMap(), new ValueExpressionNode[]{new VarNode("*")});
        ProjectionNode countProjection2 = new ProjectionNode();
        expected.setProjection(countProjection2);
        countProjection2.addProjectionExpression(new AssignmentNode(new VarNode("c"), (IValueExpressionNode)countNode2));
        JoinGroupNode whereClause3 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause3);
        JoinGroupNode childJoinGroup3 = new JoinGroupNode();
        whereClause3.addChild((IGroupMemberNode)childJoinGroup3);
        childJoinGroup3.addChild((IGroupMemberNode)sliceQuery2);
        ProjectionNode p2 = new ProjectionNode();
        sliceQuery2.setProjection(p2);
        p2.addProjectionVar(new VarNode("s"));
        p2.addProjectionVar(new VarNode("p"));
        p2.addProjectionVar(new VarNode("o"));
        whereClause = new JoinGroupNode();
        sliceQuery2.setWhereClause((GraphPatternGroup)whereClause);
        childJoinGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)childJoinGroup);
        childJoinGroup.addChild((IGroupMemberNode)selectQuery2);
        sliceQuery2.setSlice(new SliceNode(0L, 21L));
        p2 = new ProjectionNode();
        selectQuery2.setProjection(p2);
        p2.addProjectionVar(new VarNode("s"));
        p2.addProjectionVar(new VarNode("p"));
        p2.addProjectionVar(new VarNode("o"));
        whereClause = new JoinGroupNode();
        selectQuery2.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        ASTWildcardProjectionOptimizer rewriter = new ASTWildcardProjectionOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTWildcardProjectionOptimizer.assertSameAST((IQueryNode)expected, actual);
    }
}

