/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractOptimizerTestCase;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BDS;
import com.bigdata.service.fts.FTS;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.openrdf.model.Value;

public class TestIVariableBindingRequirements
extends AbstractOptimizerTestCase {
    public TestIVariableBindingRequirements() {
    }

    public TestIVariableBindingRequirements(String name) {
        super(name);
    }

    @Override
    IASTOptimizer newOptimizer() {
        throw new RuntimeException("Not optimizer specific, don't call this method.");
    }

    public void testStatementPatternNode() {
        StatementPatternNode spn1 = this.store.isQuads() ? (StatementPatternNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.statementPatternNode((TermNode)this.varNode("x"), (TermNode)this.varNode("y"), (TermNode)this.varNode("z"), this.varNode("w"));
            }
        }.getTmp() : (StatementPatternNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.statementPatternNode((TermNode)this.varNode("x"), (TermNode)this.varNode("y"), (TermNode)this.varNode("z"), new Object[0]);
            }
        }.getTmp();
        StatementPatternNode spn2 = (StatementPatternNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), this.constantNode(this.c), new Object[0]);
            }
        }.getTmp();
        StatementPatternNode spn3 = (StatementPatternNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.b), (TermNode)this.varNode("z"), new Object[0]);
            }
        }.getTmp();
        HashSet requiredBoundSpn123 = new HashSet();
        HashSet<IVariable<?>> desiredBoundSpn1 = this.store.isQuads() ? new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
                this.add(Var.var((String)"z"));
                this.add(Var.var((String)"w"));
            }
        } : new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
                this.add(Var.var((String)"z"));
            }
        };
        HashSet desiredBoundSpn2 = new HashSet();
        HashSet desiredBoundSpn3 = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"z"));
            }
        };
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals(requiredBoundSpn123, (Object)spn1.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBoundSpn1, (Object)spn1.getDesiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(requiredBoundSpn123, (Object)spn2.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(desiredBoundSpn2, (Object)spn2.getDesiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(requiredBoundSpn123, (Object)spn3.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBoundSpn3, (Object)spn3.getDesiredBound(sa));
    }

    public void testAssignmentNode() {
        AssignmentNode an1 = (AssignmentNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.bind((IValueExpressionNode)this.constantNode(this.a), this.varNode("x"));
            }
        }.getTmp();
        AssignmentNode an2 = (AssignmentNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.bind((IValueExpressionNode)this.varNode("y"), this.varNode("x"));
            }
        }.getTmp();
        AssignmentNode an3 = (AssignmentNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.bind((IValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)this.varNode("x"), (ValueExpressionNode)this.varNode("y")), (ValueExpressionNode)this.constantNode("z")), (ValueExpressionNode)this.varNode("z")), this.varNode("w"));
            }
        }.getTmp();
        HashSet requiredBoundAn1 = new HashSet();
        HashSet requiredBoundAn2 = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"y"));
            }
        };
        HashSet requiredBoundAn3 = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
                this.add(Var.var((String)"z"));
            }
        };
        HashSet desiredBoundAn1 = new HashSet();
        HashSet desiredBoundAn2 = new HashSet();
        HashSet desiredBoundAn3 = new HashSet();
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals(requiredBoundAn1, (Object)an1.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(desiredBoundAn1, (Object)an1.getDesiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)requiredBoundAn2, (Object)an2.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(desiredBoundAn2, (Object)an2.getDesiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)requiredBoundAn3, (Object)an3.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(desiredBoundAn3, (Object)an3.getDesiredBound(sa));
    }

    public void testBindingsClause() {
        LinkedHashSet declaredVars = new LinkedHashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
            }
        };
        ArrayList<IBindingSet> bindingSets = new ArrayList<IBindingSet>(){
            {
                this.add(new ListBindingSet(){
                    {
                        this.set((IVariable)Var.var((String)"x"), (IConstant)new Constant((Object)TermId.mockIV((VTE)VTE.URI)));
                        this.set((IVariable)Var.var((String)"y"), (IConstant)new Constant((Object)TermId.mockIV((VTE)VTE.URI)));
                    }
                });
            }
        };
        BindingsClause bc = new BindingsClause(declaredVars, (List)bindingSets);
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals(new HashSet(), (Object)bc.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(new HashSet(), (Object)bc.getDesiredBound(sa));
    }

    public void testUnion() {
        UnionNode un1 = (UnionNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.unionNode(this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), (TermNode)this.varNode("y"), new Object[0])), this.joinGroupNode(this.bind((IValueExpressionNode)this.varNode("y"), this.varNode("x"))));
            }
        }.getTmp();
        UnionNode un2 = (UnionNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.unionNode(this.joinGroupNode(this.bind((IValueExpressionNode)this.varNode("y"), this.varNode("x"))), this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), (TermNode)this.varNode("y"), new Object[0])));
            }
        }.getTmp();
        HashSet requiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"y"));
            }
        };
        HashSet desiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
            }
        };
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals((Object)requiredBound, (Object)un1.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBound, (Object)un1.getDesiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)requiredBound, (Object)un2.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBound, (Object)un2.getDesiredBound(sa));
    }

    public void testSubquery() {
        final SubqueryRoot subquery = (SubqueryRoot)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.selectSubQuery(this.projection(this.bind((IValueExpressionNode)this.varNode("s"), this.varNode("s"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("s"), this.constantNode(this.c), (TermNode)this.varNode("o"), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.getTmp();
        QueryRoot query = (QueryRoot)new AbstractOptimizerTestCase.Helper(){
            {
                super(TestIVariableBindingRequirements.this);
                this.tmp = this.select(this.projection(this.wildcard()), this.where(new IGroupMemberNode[]{subquery}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.getTmp();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(query), this.store);
        StaticAnalysis sa = new StaticAnalysis(query, (IEvaluationContext)context);
        HashSet requiredBound = new HashSet();
        HashSet desiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"s"));
            }
        };
        TestIVariableBindingRequirements.assertEquals(requiredBound, (Object)subquery.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBound, (Object)subquery.getDesiredBound(sa));
    }

    public void testNamedSubquery() {
        final NamedSubqueryInclude nsi = (NamedSubqueryInclude)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.namedSubQueryInclude("_set1", new AbstractOptimizerTestCase.ApplyAnnotation[0]);
            }
        }.getTmp();
        QueryRoot query = (QueryRoot)new AbstractOptimizerTestCase.Helper(){
            {
                super(TestIVariableBindingRequirements.this);
                this.tmp = this.select(this.varNodes("x", "y", "y"), this.namedSubQuery("_set1", this.varNode("x"), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.a), this.constantNode(this.b), 1)}), new AbstractOptimizerTestCase.ApplyAnnotation[0]), this.where(new IGroupMemberNode[]{nsi, this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.c), (TermNode)this.varNode("y"), new Object[]{1, AbstractOptimizerTestCase.HelperFlag.OPTIONAL})}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.getTmp();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(query), this.store);
        StaticAnalysis sa = new StaticAnalysis(query, (IEvaluationContext)context);
        HashSet requiredBound = new HashSet();
        HashSet desiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
            }
        };
        TestIVariableBindingRequirements.assertEquals(requiredBound, (Object)nsi.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBound, (Object)nsi.getDesiredBound(sa));
    }

    public void testSimpleALPNode() {
        ArbitraryLengthPathNode alpNode = (ArbitraryLengthPathNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.arbitartyLengthPropertyPath((TermNode)this.varNode("x"), this.constantNode(this.b), AbstractOptimizerTestCase.HelperFlag.ZERO_OR_MORE, this.joinGroupNode(this.statementPatternNode((TermNode)this.leftVar(), this.constantNode(this.c), (TermNode)this.rightVar(), 26)));
            }
        }.getTmp();
        HashSet requiredBoundAlpNode = new HashSet();
        HashSet desiredBoundAlpNode = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
            }
        };
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals(requiredBoundAlpNode, (Object)alpNode.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBoundAlpNode, (Object)alpNode.getDesiredBound(sa));
    }

    public void testComplexALPNode() {
        ArbitraryLengthPathNode alpNode = (ArbitraryLengthPathNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.arbitartyLengthPropertyPath((TermNode)this.varNode("x"), this.constantNode(this.b), AbstractOptimizerTestCase.HelperFlag.ZERO_OR_MORE, this.joinGroupNode(this.statementPatternNode((TermNode)this.leftVar(), this.constantNode(this.c), (TermNode)this.varNode("y"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("y"), this.constantNode(this.d), (TermNode)this.rightVar(), new Object[0])));
            }
        }.getTmp();
        HashSet requiredBoundAlpNode = new HashSet();
        HashSet desiredBoundAlpNode = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
            }
        };
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals(requiredBoundAlpNode, (Object)alpNode.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBoundAlpNode, (Object)alpNode.getDesiredBound(sa));
    }

    public void testFilter() {
        FilterNode fn = (FilterNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.filter((IValueExpressionNode)FunctionNode.AND((ValueExpressionNode)this.varNode("w"), (ValueExpressionNode)FunctionNode.OR((ValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)this.constantNode("w"), (ValueExpressionNode)this.varNode("y")), (ValueExpressionNode)FunctionNode.LT((ValueExpressionNode)this.varNode("x"), (ValueExpressionNode)this.varNode("z")))));
            }
        }.getTmp();
        QueryRoot query = new QueryRoot(QueryType.SELECT);
        JoinGroupNode jgn = new JoinGroupNode((IGroupMemberNode)fn);
        query.setWhereClause((GraphPatternGroup)jgn);
        HashSet requiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"w"));
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
                this.add(Var.var((String)"z"));
            }
        };
        HashSet desiredBound = new HashSet();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(query), this.store);
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), (IEvaluationContext)context);
        GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
        AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)fn.getValueExpressionNode());
        TestIVariableBindingRequirements.assertEquals((Object)requiredBound, (Object)fn.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(desiredBound, (Object)fn.getDesiredBound(sa));
    }

    public void testFilterExistsAndNotExists() {
        FilterNode exists = (FilterNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.filter((IValueExpressionNode)this.exists(this.varNode("x"), (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), (TermNode)this.varNode("y"), new Object[0]), this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), (TermNode)this.varNode("z"), new Object[0]))));
            }
        }.getTmp();
        FilterNode notExists = (FilterNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.filter((IValueExpressionNode)this.exists(this.varNode("x"), (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), (TermNode)this.varNode("y"), new Object[0]), this.statementPatternNode(this.constantNode(this.a), this.constantNode(this.b), (TermNode)this.varNode("z"), new Object[0]))));
            }
        }.getTmp();
        QueryRoot query = new QueryRoot(QueryType.SELECT);
        JoinGroupNode jgn = new JoinGroupNode();
        jgn.addChild((IGroupMemberNode)exists);
        jgn.addChild((IGroupMemberNode)notExists);
        query.setWhereClause((GraphPatternGroup)jgn);
        HashSet requiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
            }
        };
        HashSet desiredBound = new HashSet();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(query), this.store);
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), (IEvaluationContext)context);
        GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
        AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)exists.getValueExpressionNode());
        AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)notExists.getValueExpressionNode());
        TestIVariableBindingRequirements.assertEquals((Object)requiredBound, (Object)exists.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(desiredBound, (Object)exists.getDesiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)requiredBound, (Object)notExists.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(desiredBound, (Object)notExists.getDesiredBound(sa));
    }

    public void testSimpleJoinGroup() {
        JoinGroupNode jgn = (JoinGroupNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.b), this.constantNode(this.c), new Object[0]), this.statementPatternNode(this.constantNode(this.a), (TermNode)this.varNode("y"), this.constantNode(this.c), new Object[0]), this.statementPatternNode(this.constantNode(this.a), (TermNode)this.varNode("y"), (TermNode)this.varNode("z"), new Object[]{AbstractOptimizerTestCase.HelperFlag.OPTIONAL}));
            }
        }.getTmp();
        HashSet requiredBound = new HashSet();
        HashSet desiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
                this.add(Var.var((String)"z"));
            }
        };
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals(requiredBound, (Object)jgn.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBound, (Object)jgn.getDesiredBound(sa));
    }

    public void testComplexJoinGroup01() {
        JoinGroupNode jgn = (JoinGroupNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.b), this.constantNode(this.c), new Object[0]), this.bind((IValueExpressionNode)this.varNode("y"), this.varNode("x")), this.selectSubQuery(this.projection(this.bind((IValueExpressionNode)this.varNode("z"), this.varNode("z"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("z"), this.constantNode(this.c), (TermNode)this.varNode("o"), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]));
            }
        }.getTmp();
        HashSet requiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"y"));
            }
        };
        HashSet desiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"z"));
            }
        };
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals((Object)requiredBound, (Object)jgn.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBound, (Object)jgn.getDesiredBound(sa));
    }

    public void testComplexJoinGroup02() {
        JoinGroupNode jgn = (JoinGroupNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("y"), this.constantNode(this.b), this.constantNode(this.c), new Object[0]), this.bind((IValueExpressionNode)this.varNode("y"), this.varNode("x")), this.selectSubQuery(this.projection(this.bind((IValueExpressionNode)this.varNode("z"), this.varNode("z"))), this.where(new IGroupMemberNode[]{this.statementPatternNode((TermNode)this.varNode("z"), this.constantNode(this.c), (TermNode)this.varNode("o"), new Object[0])}), new AbstractOptimizerTestCase.HelperFlag[0]));
            }
        }.getTmp();
        HashSet requiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"y"));
            }
        };
        HashSet desiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"y"));
                this.add(Var.var((String)"z"));
            }
        };
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals((Object)requiredBound, (Object)jgn.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBound, (Object)jgn.getDesiredBound(sa));
    }

    public void testServiceSparql11Constant() {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI serviceEndpoint = f.createURI("http://custom.endpoint");
        final IV serviceEndpointIV = this.makeIV((Value)serviceEndpoint);
        BigdataValue[] values = new BigdataValue[]{serviceEndpoint};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ServiceNode serviceNode = (ServiceNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(TestIVariableBindingRequirements.this);
                this.tmp = this.service(this.constantNode(serviceEndpointIV), (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.a), (TermNode)this.varNode("y"), new Object[0])));
            }
        }.getTmp();
        HashSet requiredBound = new HashSet();
        HashSet desiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
            }
        };
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals(requiredBound, (Object)serviceNode.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBound, (Object)serviceNode.getDesiredBound(sa));
    }

    public void testServiceSparql11Variable() {
        ServiceNode serviceNode = (ServiceNode)new AbstractOptimizerTestCase.Helper(){
            {
                this.tmp = this.service((TermNode)this.varNode("z"), (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("x"), this.constantNode(this.a), (TermNode)this.varNode("y"), new Object[0])));
            }
        }.getTmp();
        HashSet requiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"z"));
            }
        };
        HashSet desiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"x"));
                this.add(Var.var((String)"y"));
            }
        };
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals((Object)requiredBound, (Object)serviceNode.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals((Object)desiredBound, (Object)serviceNode.getDesiredBound(sa));
    }

    public void testServiceBDS() {
        BigdataValueFactory f = this.store.getValueFactory();
        final BigdataURI bdsSearch = f.createURI("http://www.bigdata.com/rdf/search#search");
        final BigdataURI predSearch = f.createURI(BDS.SEARCH.toString());
        final BigdataURI predSearchTimeout = f.createURI(BDS.SEARCH_TIMEOUT.toString());
        final BigdataURI predMatchExact = f.createURI(BDS.MATCH_EXACT.toString());
        BigdataValue[] values = new BigdataValue[]{bdsSearch, predSearch, predSearchTimeout, predMatchExact};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ServiceNode serviceNode = (ServiceNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(TestIVariableBindingRequirements.this);
                this.tmp = this.service(this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)bdsSearch)), (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predSearch)), this.constantNode("search"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predSearchTimeout)), this.constantNode("1000"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predMatchExact)), this.constantNode("false"), new Object[0])));
            }
        }.getTmp();
        HashSet requiredBound = new HashSet();
        HashSet desiredBound = new HashSet();
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals(requiredBound, (Object)serviceNode.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(desiredBound, (Object)serviceNode.getDesiredBound(sa));
    }

    public void testServiceFTS() {
        BigdataValueFactory f = this.store.getValueFactory();
        final BigdataURI ftsSearch = f.createURI("http://www.bigdata.com/rdf/fts#search");
        final BigdataURI predSearch = f.createURI(FTS.SEARCH.toString());
        final BigdataURI predEndpoint = f.createURI(FTS.ENDPOINT.toString());
        final BigdataURI predEndpointType = f.createURI(FTS.ENDPOINT_TYPE.toString());
        final BigdataURI predParams = f.createURI(FTS.PARAMS.toString());
        final BigdataURI predScore = f.createURI(FTS.SCORE.toString());
        final BigdataURI predScoreField = f.createURI(FTS.SCORE_FIELD.toString());
        final BigdataURI predSearchField = f.createURI(FTS.SEARCH_FIELD.toString());
        final BigdataURI predSnippet = f.createURI(FTS.SNIPPET.toString());
        final BigdataURI predSnippetField = f.createURI(FTS.SNIPPET_FIELD.toString());
        final BigdataURI predTimeout = f.createURI(FTS.TIMEOUT.toString());
        final BigdataURI predSearchResultType = f.createURI(FTS.SEARCH_RESULT_TYPE.toString());
        BigdataValue[] values = new BigdataValue[]{ftsSearch, predSearch, predEndpoint, predEndpointType, predParams, predScore, predScoreField, predSearchField, predSnippet, predSnippetField, predTimeout, predSearchResultType};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ServiceNode serviceNode = (ServiceNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(TestIVariableBindingRequirements.this);
                this.tmp = this.service(this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)ftsSearch)), (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predSearch)), (TermNode)this.varNode("search"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predEndpoint)), (TermNode)this.varNode("endpoint"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predEndpointType)), (TermNode)this.varNode("endpointType"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predParams)), (TermNode)this.varNode("params"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predScore)), (TermNode)this.varNode("score"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predScoreField)), (TermNode)this.varNode("scoreField"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predSearchField)), (TermNode)this.varNode("searchField"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predSnippet)), (TermNode)this.varNode("snippet"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predSnippetField)), (TermNode)this.varNode("snippetField"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predTimeout)), (TermNode)this.varNode("timeout"), new Object[0]), this.statementPatternNode((TermNode)this.varNode("res"), this.constantNode(TestIVariableBindingRequirements.this.makeIV((Value)predSearchResultType)), (TermNode)this.varNode("searchResultType"), new Object[0])));
            }
        }.getTmp();
        HashSet requiredBound = new HashSet<IVariable<?>>(){
            {
                this.add(Var.var((String)"search"));
                this.add(Var.var((String)"endpoint"));
                this.add(Var.var((String)"endpointType"));
                this.add(Var.var((String)"params"));
                this.add(Var.var((String)"scoreField"));
                this.add(Var.var((String)"searchField"));
                this.add(Var.var((String)"snippetField"));
                this.add(Var.var((String)"timeout"));
                this.add(Var.var((String)"searchResultType"));
            }
        };
        HashSet desiredBound = new HashSet();
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT), null);
        TestIVariableBindingRequirements.assertEquals((Object)requiredBound, (Object)serviceNode.getRequiredBound(sa));
        TestIVariableBindingRequirements.assertEquals(desiredBound, (Object)serviceNode.getDesiredBound(sa));
    }
}

