/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service.storedquery;

import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.BigdataSailTupleQuery;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.sparql.ast.service.storedquery.SimpleStoredQueryService;
import com.bigdata.rdf.sparql.ast.service.storedquery.StoredQueryService;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;

public class TestStoredQueryService
extends AbstractDataDrivenSPARQLTestCase {
    private static final String NAMESPACE = "http://www.bigdata.com/rdf/stored-query#";

    public TestStoredQueryService() {
    }

    public TestStoredQueryService(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_stored_query_001() throws Exception {
        URIImpl serviceURI = new URIImpl(NAMESPACE + this.getName());
        try {
            class MyStoredQueryService
            extends SimpleStoredQueryService {
                MyStoredQueryService() {
                }

                public String getQuery(ServiceCallCreateParams createParams, ServiceParams serviceParams) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("PREFIX dc:   <http://purl.org/dc/elements/1.1/> \n");
                    sb.append("PREFIX :     <http://example.org/book/> \n");
                    sb.append("PREFIX ns:   <http://example.org/ns#> \n");
                    sb.append("SELECT ?book ?title ?price { \n");
                    sb.append("  ?book dc:title ?title ; \n");
                    sb.append("  ns:price ?price . \n");
                    sb.append("} \n");
                    return sb.toString();
                }
            }
            ServiceRegistry.getInstance().add((URI)serviceURI, (ServiceFactory)new MyStoredQueryService());
            AbstractDataDrivenSPARQLTestCase.TestHelper h = (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("stored-query-001", "stored-query-001.rq", "stored-query-001.ttl", "stored-query-001.srx");
            h.runTest();
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_stored_query_002() throws Exception {
        URIImpl serviceURI = new URIImpl(NAMESPACE + this.getName());
        try {
            class MyStoredQueryService
            extends SimpleStoredQueryService {
                MyStoredQueryService() {
                }

                public String getQuery(ServiceCallCreateParams createParams, ServiceParams serviceParams) {
                    URI val = serviceParams.getAsURI((URI)new URIImpl("http://example.org/book/book"));
                    StringBuilder sb = new StringBuilder();
                    sb.append("PREFIX dc:   <http://purl.org/dc/elements/1.1/> \n");
                    sb.append("PREFIX :     <http://example.org/book/> \n");
                    sb.append("PREFIX ns:   <http://example.org/ns#> \n");
                    sb.append("SELECT ?book ?title ?price { \n");
                    sb.append("  BIND( <" + val.stringValue() + "> as ?book ) . \n");
                    sb.append("  ?book dc:title ?title ; \n");
                    sb.append("  ns:price ?price . \n");
                    sb.append("} \n");
                    return sb.toString();
                }
            }
            ServiceRegistry.getInstance().add((URI)serviceURI, (ServiceFactory)new MyStoredQueryService());
            AbstractDataDrivenSPARQLTestCase.TestHelper h = (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("stored-query-002", "stored-query-002.rq", "stored-query-001.ttl", "stored-query-001.srx");
            h.runTest();
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_stored_query_003() throws Exception {
        URIImpl serviceURI = new URIImpl(NAMESPACE + this.getName());
        try {
            class MyStoredQueryService
            extends StoredQueryService {
                MyStoredQueryService() {
                }

                protected TupleQueryResult doQuery(BigdataSailRepositoryConnection cxn, ServiceCallCreateParams createParams, ServiceParams serviceParams) throws Exception {
                    URI val = serviceParams.getAsURI((URI)new URIImpl("http://example.org/book/book"));
                    StringBuilder sb = new StringBuilder();
                    sb.append("PREFIX dc:   <http://purl.org/dc/elements/1.1/> \n");
                    sb.append("PREFIX :     <http://example.org/book/> \n");
                    sb.append("PREFIX ns:   <http://example.org/ns#> \n");
                    sb.append("SELECT ?book ?title ?price { \n");
                    sb.append("  BIND( <" + val.stringValue() + "> as ?book ) . \n");
                    sb.append("  ?book dc:title ?title ; \n");
                    sb.append("  ns:price ?price . \n");
                    sb.append("} \n");
                    String queryStr = sb.toString();
                    String baseURI = createParams.getServiceURI().stringValue();
                    BigdataSailTupleQuery query = cxn.prepareTupleQuery(QueryLanguage.SPARQL, queryStr, baseURI);
                    return query.evaluate();
                }
            }
            ServiceRegistry.getInstance().add((URI)serviceURI, (ServiceFactory)new MyStoredQueryService());
            AbstractDataDrivenSPARQLTestCase.TestHelper h = (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("stored-query-003", "stored-query-003.rq", "stored-query-001.ttl", "stored-query-001.srx");
            h.runTest();
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI);
        }
    }
}

