/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.ssets;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.ssets.ISolutionSetManager;
import com.bigdata.rdf.sparql.ast.ssets.SolutionSetManager;
import com.bigdata.striterator.CloseableIteratorWrapper;
import com.bigdata.striterator.Dechunkerator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase2;

public class TestSolutionSetManager
extends TestCase2 {
    protected Journal journal;
    protected QueryEngine queryEngine;
    protected ISolutionSetManager solutionSetsManager;
    protected IEvaluationContext ctx = null;
    protected String namespace = this.getName();
    protected BigdataValueFactory valueFactory = BigdataValueFactoryImpl.getInstance((String)this.namespace);
    protected TermId<BigdataLiteral> termId;
    protected TermId<BigdataLiteral> termId2;
    protected BlobIV<BigdataLiteral> blobIV;
    protected TermId<BigdataValue> mockIV1;
    protected TermId<BigdataValue> mockIV2;
    protected TermId<BigdataValue> mockIV3;
    protected XSDIntegerIV<BigdataLiteral> inlineIV;
    protected IV<?, ?> inlineIV2;

    public TestSolutionSetManager() {
    }

    public TestSolutionSetManager(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Properties properties = new Properties();
        properties.put(Journal.Options.BUFFER_MODE, BufferMode.MemStore.toString());
        properties.put(Journal.Options.CREATE_TEMP_FILE, "true");
        properties.put(Journal.Options.INITIAL_EXTENT, "1048576");
        this.journal = new Journal(properties);
        this.queryEngine = QueryEngineFactory.getInstance().getQueryController((IIndexManager)this.journal);
        this.solutionSetsManager = new SolutionSetManager((IBTreeManager)this.journal, this.namespace, 0L);
        this.termId = new TermId(VTE.LITERAL, 12L);
        this.termId.setValue((BigdataValue)this.valueFactory.createLiteral("abc"));
        this.termId2 = new TermId(VTE.LITERAL, 36L);
        this.termId2.setValue((BigdataValue)this.valueFactory.createLiteral("xyz"));
        this.blobIV = new BlobIV(VTE.LITERAL, 912, 0);
        this.blobIV.setValue((BigdataValue)this.valueFactory.createLiteral("bigfoo"));
        this.mockIV1 = TermId.mockIV((VTE)VTE.LITERAL);
        this.mockIV1.setValue((BigdataValue)this.valueFactory.createLiteral("red"));
        this.mockIV2 = TermId.mockIV((VTE)VTE.LITERAL);
        this.mockIV2.setValue((BigdataValue)this.valueFactory.createLiteral("blue"));
        this.mockIV3 = TermId.mockIV((VTE)VTE.LITERAL);
        this.mockIV3.setValue((BigdataValue)this.valueFactory.createLiteral("green"));
        this.inlineIV = new XSDIntegerIV(BigInteger.valueOf(100L));
        this.inlineIV.setValue((BigdataValue)this.valueFactory.createLiteral("100", XSD.INTEGER));
        this.inlineIV2 = XSDBooleanIV.valueOf((boolean)true);
    }

    protected void tearDown() throws Exception {
        if (this.solutionSetsManager != null) {
            this.solutionSetsManager.close();
            this.solutionSetsManager = null;
        }
        if (this.queryEngine != null) {
            this.queryEngine.shutdownNow();
            this.queryEngine = null;
        }
        if (this.journal != null) {
            this.journal.destroy();
            this.journal = null;
        }
        this.valueFactory.remove();
        this.valueFactory = null;
        this.namespace = null;
        this.termId2 = null;
        this.termId = null;
        this.blobIV = null;
        this.mockIV3 = null;
        this.mockIV2 = null;
        this.mockIV1 = null;
        this.inlineIV = null;
        this.inlineIV2 = null;
        super.tearDown();
    }

    public void test_putGet() {
        String solutionSet;
        LinkedList<IBindingSet[]> in;
        block2: {
            in = new LinkedList<IBindingSet[]>();
            LinkedList<ListBindingSet> t = new LinkedList<ListBindingSet>();
            t.add(new ListBindingSet());
            in.add(t.toArray(new IBindingSet[0]));
            solutionSet = this.getName();
            try {
                this.solutionSetsManager.getSolutions(solutionSet);
                TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
            }
            catch (IllegalStateException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
        TestSolutionSetManager.assertFalse((boolean)this.solutionSetsManager.existsSolutions(solutionSet));
        this.solutionSetsManager.putSolutions(solutionSet, (ICloseableIterator)new CloseableIteratorWrapper(in.iterator()));
        TestSolutionSetManager.assertTrue((boolean)this.solutionSetsManager.existsSolutions(solutionSet));
        ICloseableIterator out = this.solutionSetsManager.getSolutions(solutionSet);
        TestSolutionSetManager.assertSameSolutionsAnyOrder(TestSolutionSetManager.flatten(in.iterator()), (ICloseableIterator<IBindingSet[]>)out);
    }

    public void test_putGet2() {
        String solutionSet;
        LinkedList<IBindingSet[]> in;
        block2: {
            in = new LinkedList<IBindingSet[]>();
            LinkedList<ListBindingSet> t = new LinkedList<ListBindingSet>();
            ListBindingSet b = new ListBindingSet();
            t.add(b);
            b = new ListBindingSet();
            t.add(b);
            in.add(t.toArray(new IBindingSet[0]));
            solutionSet = this.getName();
            try {
                this.solutionSetsManager.getSolutions(solutionSet);
                TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
            }
            catch (IllegalStateException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
        this.solutionSetsManager.putSolutions(solutionSet, (ICloseableIterator)new CloseableIteratorWrapper(in.iterator()));
        ICloseableIterator out = this.solutionSetsManager.getSolutions(solutionSet);
        TestSolutionSetManager.assertSameSolutionsAnyOrder(TestSolutionSetManager.flatten(in.iterator()), (ICloseableIterator<IBindingSet[]>)out);
    }

    public void test_putGet3() {
        String solutionSet;
        LinkedList<IBindingSet[]> in;
        block2: {
            in = new LinkedList<IBindingSet[]>();
            Var x = Var.var((String)"x");
            Var y = Var.var((String)"y");
            Var z = Var.var((String)"z");
            LinkedList<ListBindingSet> t = new LinkedList<ListBindingSet>();
            ListBindingSet b = new ListBindingSet();
            b.set((IVariable)x, (IConstant)new Constant(this.termId));
            b.set((IVariable)y, (IConstant)new Constant(this.termId2));
            t.add(b);
            b = new ListBindingSet();
            b.set((IVariable)x, (IConstant)new Constant(this.termId2));
            b.set((IVariable)y, (IConstant)new Constant(this.inlineIV));
            b.set((IVariable)z, (IConstant)new Constant(this.blobIV));
            t.add(b);
            in.add(t.toArray(new IBindingSet[0]));
            solutionSet = this.getName();
            try {
                this.solutionSetsManager.getSolutions(solutionSet);
                TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
            }
            catch (IllegalStateException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
        this.solutionSetsManager.putSolutions(solutionSet, (ICloseableIterator)new CloseableIteratorWrapper(in.iterator()));
        ICloseableIterator out = this.solutionSetsManager.getSolutions(solutionSet);
        TestSolutionSetManager.assertSameSolutionsAnyOrder(TestSolutionSetManager.flatten(in.iterator()), (ICloseableIterator<IBindingSet[]>)out);
    }

    public void test_putGet4() {
        String solutionSet;
        LinkedList<IBindingSet[]> in;
        block2: {
            in = new LinkedList<IBindingSet[]>();
            Var x = Var.var((String)"x");
            Var y = Var.var((String)"y");
            Var z = Var.var((String)"z");
            LinkedList<ListBindingSet> t = new LinkedList<ListBindingSet>();
            ListBindingSet b = new ListBindingSet();
            b.set((IVariable)x, (IConstant)new Constant(this.termId2));
            b.set((IVariable)y, (IConstant)new Constant(this.inlineIV));
            b.set((IVariable)z, (IConstant)new Constant(this.blobIV));
            t.add(b);
            in.add(t.toArray(new IBindingSet[0]));
            t = new LinkedList();
            b = new ListBindingSet();
            b.set((IVariable)x, (IConstant)new Constant(this.termId));
            b.set((IVariable)y, (IConstant)new Constant(this.termId2));
            t.add(b);
            in.add(t.toArray(new IBindingSet[0]));
            t = new LinkedList();
            b = new ListBindingSet();
            t.add(b);
            in.add(t.toArray(new IBindingSet[0]));
            solutionSet = this.getName();
            try {
                this.solutionSetsManager.getSolutions(solutionSet);
                TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
            }
            catch (IllegalStateException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
        this.solutionSetsManager.putSolutions(solutionSet, (ICloseableIterator)new CloseableIteratorWrapper(in.iterator()));
        ICloseableIterator out = this.solutionSetsManager.getSolutions(solutionSet);
        TestSolutionSetManager.assertSameSolutionsAnyOrder(TestSolutionSetManager.flatten(in.iterator()), (ICloseableIterator<IBindingSet[]>)out);
    }

    public void test_clearSolutionSet() {
        block5: {
            String solutionSet;
            LinkedList<IBindingSet[]> in;
            block4: {
                in = new LinkedList<IBindingSet[]>();
                Var x = Var.var((String)"x");
                Var y = Var.var((String)"y");
                Var z = Var.var((String)"z");
                LinkedList<ListBindingSet> t = new LinkedList<ListBindingSet>();
                ListBindingSet b = new ListBindingSet();
                b.set((IVariable)x, (IConstant)new Constant(this.termId2));
                b.set((IVariable)y, (IConstant)new Constant(this.inlineIV));
                b.set((IVariable)z, (IConstant)new Constant(this.blobIV));
                t.add(b);
                in.add(t.toArray(new IBindingSet[0]));
                t = new LinkedList();
                b = new ListBindingSet();
                b.set((IVariable)x, (IConstant)new Constant(this.termId));
                b.set((IVariable)y, (IConstant)new Constant(this.termId2));
                t.add(b);
                in.add(t.toArray(new IBindingSet[0]));
                t = new LinkedList();
                b = new ListBindingSet();
                t.add(b);
                in.add(t.toArray(new IBindingSet[0]));
                solutionSet = this.getName();
                try {
                    this.solutionSetsManager.getSolutions(solutionSet);
                    TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
                }
                catch (IllegalStateException ex) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
            this.solutionSetsManager.putSolutions(solutionSet, (ICloseableIterator)new CloseableIteratorWrapper(in.iterator()));
            ICloseableIterator out = this.solutionSetsManager.getSolutions(solutionSet);
            TestSolutionSetManager.assertSameSolutionsAnyOrder(TestSolutionSetManager.flatten(in.iterator()), (ICloseableIterator<IBindingSet[]>)out);
            out = this.solutionSetsManager.getSolutions(solutionSet);
            TestSolutionSetManager.assertSameSolutionsAnyOrder(TestSolutionSetManager.flatten(in.iterator()), (ICloseableIterator<IBindingSet[]>)out);
            this.solutionSetsManager.clearSolutions(solutionSet);
            try {
                this.solutionSetsManager.getSolutions(solutionSet);
                TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
            }
            catch (IllegalStateException ex) {
                if (!log.isInfoEnabled()) break block5;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_clearAllSolutionSets() {
        String solutionSet2;
        block15: {
            String solutionSet1;
            block14: {
                LinkedList in2;
                LinkedList<IBindingSet[]> in1;
                block12: {
                    block11: {
                        in1 = new LinkedList<IBindingSet[]>();
                        LinkedList<ListBindingSet> t = new LinkedList<ListBindingSet>();
                        ListBindingSet b = new ListBindingSet();
                        t.add(b);
                        in1.add(t.toArray(new IBindingSet[0]));
                        in2 = new LinkedList();
                        LinkedList<ListBindingSet> t2 = new LinkedList<ListBindingSet>();
                        ListBindingSet b2 = new ListBindingSet();
                        t2.add(b2);
                        b2 = new ListBindingSet();
                        t2.add(b2);
                        in1.add(t2.toArray(new IBindingSet[0]));
                        solutionSet1 = this.getName() + 1;
                        solutionSet2 = this.getName() + 2;
                        try {
                            this.solutionSetsManager.getSolutions(solutionSet1);
                            TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
                        }
                        catch (IllegalStateException ex) {
                            if (!log.isInfoEnabled()) break block11;
                            log.info((Object)("Ignoring expected exception: " + ex));
                        }
                    }
                    try {
                        this.solutionSetsManager.getSolutions(solutionSet2);
                        TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
                    }
                    catch (IllegalStateException ex) {
                        if (!log.isInfoEnabled()) break block12;
                        log.info((Object)("Ignoring expected exception: " + ex));
                    }
                }
                this.solutionSetsManager.putSolutions(solutionSet1, (ICloseableIterator)new CloseableIteratorWrapper(in1.iterator()));
                this.solutionSetsManager.putSolutions(solutionSet2, (ICloseableIterator)new CloseableIteratorWrapper(in2.iterator()));
                TestSolutionSetManager.assertSameSolutionsAnyOrder(TestSolutionSetManager.flatten(in1.iterator()), (ICloseableIterator<IBindingSet[]>)this.solutionSetsManager.getSolutions(solutionSet1));
                TestSolutionSetManager.assertSameSolutionsAnyOrder(TestSolutionSetManager.flatten(in2.iterator()), (ICloseableIterator<IBindingSet[]>)this.solutionSetsManager.getSolutions(solutionSet2));
                this.solutionSetsManager.clearAllSolutions();
                try {
                    try (ICloseableIterator itr = this.solutionSetsManager.getSolutions(solutionSet1);){
                        TestSolutionSetManager.assertFalse((boolean)itr.hasNext());
                    }
                    TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
                }
                catch (IllegalStateException ex) {
                    if (!log.isInfoEnabled()) break block14;
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
            TestSolutionSetManager.assertFalse((boolean)this.solutionSetsManager.existsSolutions(solutionSet1));
            try {
                this.solutionSetsManager.getSolutions(solutionSet2);
                TestSolutionSetManager.fail((String)("Expecting: " + IllegalStateException.class));
            }
            catch (IllegalStateException ex) {
                if (!log.isInfoEnabled()) break block15;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
        TestSolutionSetManager.assertFalse((boolean)this.solutionSetsManager.existsSolutions(solutionSet2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IBindingSet[] flatten(Iterator<IBindingSet[]> itr) {
        try {
            LinkedList<IBindingSet> t = new LinkedList<IBindingSet>();
            while (itr.hasNext()) {
                IBindingSet[] a;
                for (IBindingSet b : a = itr.next()) {
                    t.add(b);
                }
            }
            IBindingSet[] iBindingSetArray = t.toArray(new IBindingSet[t.size()]);
            return iBindingSetArray;
        }
        finally {
            if (itr instanceof ICloseableIterator) {
                ((ICloseableIterator)itr).close();
            }
        }
    }

    protected static void assertSameSolutionsAnyOrder(IBindingSet[] expected, ICloseableIterator<IBindingSet[]> itr) {
        TestSolutionSetManager.assertSameSolutionsAnyOrder("", expected, itr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void assertSameSolutionsAnyOrder(String msg, IBindingSet[] expected, ICloseableIterator<IBindingSet[]> itr) {
        try {
            int j;
            Dechunkerator actual = new Dechunkerator(itr);
            int nrange = expected.length;
            LinkedHashMap<IBindingSet, AtomicInteger> range = new LinkedHashMap<IBindingSet, AtomicInteger>();
            for (j = 0; j < nrange; ++j) {
                AtomicInteger count = (AtomicInteger)range.get(expected[j]);
                if (count == null) {
                    count = new AtomicInteger();
                }
                range.put(expected[j], count);
                count.incrementAndGet();
            }
            for (j = 0; j < nrange; ++j) {
                AtomicInteger counter;
                if (!actual.hasNext()) {
                    TestSolutionSetManager.fail((String)(msg + ": Iterator exhausted while expecting more object(s)" + ": index=" + j));
                }
                IBindingSet actualObject = (IBindingSet)actual.next();
                if (log.isInfoEnabled()) {
                    log.info((Object)("visting: " + actualObject));
                }
                if ((counter = (AtomicInteger)range.get(actualObject)) == null || counter.get() == 0) {
                    TestSolutionSetManager.fail((String)("Object not expected: index=" + j + ", object=" + actualObject));
                }
                counter.decrementAndGet();
            }
            if (actual.hasNext()) {
                TestSolutionSetManager.fail((String)"Iterator will deliver too many objects.");
            }
        }
        finally {
            itr.close();
        }
    }
}

