/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NV;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.test.MockTermIdFactory;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestSPOAccessPath
extends AbstractTripleStoreTestCase {
    private MockTermIdFactory factory;

    public TestSPOAccessPath() {
    }

    public TestSPOAccessPath(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new MockTermIdFactory();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getAccessPath() {
        AbstractTripleStore store = this.getStore();
        IV S = this.factory.newTermId(VTE.URI, 1L);
        IV P2 = this.factory.newTermId(VTE.URI, 2L);
        IV O = this.factory.newTermId(VTE.URI, 3L);
        IV C2 = this.factory.newTermId(VTE.URI, 4L);
        IV _ = this.factory.newTermId(VTE.URI, 0L);
        try {
            SPORelation r = store.getSPORelation();
            if (store.isQuads()) {
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SPOC, (Object)r.getAccessPath(_, _, _, _).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SPOC, (Object)r.getAccessPath(S, _, _, _).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SPOC, (Object)r.getAccessPath(S, P2, _, _).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SPOC, (Object)r.getAccessPath(S, P2, O, _).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SPOC, (Object)r.getAccessPath(S, P2, O, C2).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.POCS, (Object)r.getAccessPath(_, P2, _, _).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.POCS, (Object)r.getAccessPath(_, P2, O, _).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.POCS, (Object)r.getAccessPath(_, P2, O, C2).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.OCSP, (Object)r.getAccessPath(_, _, O, _).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.OCSP, (Object)r.getAccessPath(_, _, O, C2).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.OCSP, (Object)r.getAccessPath(S, _, O, C2).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.CSPO, (Object)r.getAccessPath(_, _, _, C2).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.CSPO, (Object)r.getAccessPath(S, _, _, C2).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.CSPO, (Object)r.getAccessPath(S, P2, _, C2).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.PCSO, (Object)r.getAccessPath(_, P2, _, C2).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SOPC, (Object)r.getAccessPath(S, _, O, _).getKeyOrder());
            } else {
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SPO, (Object)r.getAccessPath(this.NULL, this.NULL, this.NULL, this.NULL).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SPO, (Object)r.getAccessPath(S, this.NULL, this.NULL, this.NULL).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SPO, (Object)r.getAccessPath(S, S, this.NULL, this.NULL).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.SPO, (Object)r.getAccessPath(S, S, S, this.NULL).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.POS, (Object)r.getAccessPath(this.NULL, S, this.NULL, this.NULL).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.POS, (Object)r.getAccessPath(this.NULL, S, S, this.NULL).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.OSP, (Object)r.getAccessPath(this.NULL, this.NULL, S, this.NULL).getKeyOrder());
                TestSPOAccessPath.assertEquals((Object)SPOKeyOrder.OSP, (Object)r.getAccessPath(S, this.NULL, S, this.NULL).getKeyOrder());
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_sameVariableConstraint_triples() {
        AbstractTripleStore store = this.getStore();
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI s1 = f.createURI("http://www.bigdata.com/rdf#s1");
            BigdataURI s2 = f.createURI("http://www.bigdata.com/rdf#s2");
            BigdataURI p1 = f.createURI("http://www.bigdata.com/rdf#p1");
            BigdataURI o1 = f.createURI("http://www.bigdata.com/rdf#o1");
            BigdataURI p2 = f.createURI("http://www.bigdata.com/rdf#p2");
            BigdataURI o2 = f.createURI("http://www.bigdata.com/rdf#o2");
            StatementBuffer buffer = new StatementBuffer(store, 10);
            buffer.add((Resource)s1, (URI)p1, (Value)o1);
            buffer.add((Resource)s1, (URI)s1, (Value)o1);
            buffer.add((Resource)s2, (URI)p2, (Value)o2);
            buffer.add((Resource)s1, (URI)p2, (Value)o2);
            buffer.flush();
            SPOPredicate predicate = new SPOPredicate(store.getSPORelation().getNamespace(), (IVariableOrConstant)Var.var((String)"g"), (IVariableOrConstant)Var.var((String)"h"), (IVariableOrConstant)new Constant((Object)o1.getIV()));
            IAccessPath accessPath = store.getSPORelation().getAccessPath((IPredicate)predicate);
            TestSPOAccessPath.assertSameSPOs(new ISPO[]{new SPO(s1.getIV(), p1.getIV(), o1.getIV(), StatementEnum.Explicit), new SPO(s1.getIV(), s1.getIV(), o1.getIV(), StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)accessPath.iterator());
            predicate = new SPOPredicate(store.getSPORelation().getNamespace(), (IVariableOrConstant)Var.var((String)"g"), (IVariableOrConstant)Var.var((String)"g"), (IVariableOrConstant)new Constant((Object)o1.getIV()));
            accessPath = store.getSPORelation().getAccessPath((IPredicate)predicate);
            TestSPOAccessPath.assertSameSPOs(new ISPO[]{new SPO(s1.getIV(), s1.getIV(), o1.getIV(), StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)accessPath.iterator());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_sameVariableConstraint_quads() {
        AbstractTripleStore store = this.getStore();
        try {
            if (!store.isQuads()) {
                log.warn((Object)"Unit test requires quads.");
                return;
            }
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI graphA = f.createURI("http://www.bigdata.com/graphA");
            BigdataURI graphB = f.createURI("http://www.bigdata.com/graphB");
            BigdataURI s = f.createURI("http://www.bigdata.com/rdf#s");
            BigdataURI p1 = f.createURI("http://www.bigdata.com/rdf#p1");
            BigdataURI o1 = f.createURI("http://www.bigdata.com/rdf#o1");
            BigdataURI p2 = f.createURI("http://www.bigdata.com/rdf#p2");
            BigdataURI o2 = f.createURI("http://www.bigdata.com/rdf#o2");
            StatementBuffer buffer = new StatementBuffer(store, 10);
            buffer.add((Resource)graphA, (URI)p1, (Value)o1, (Resource)graphA);
            buffer.add((Resource)graphA, (URI)p2, (Value)o2, (Resource)graphA);
            buffer.add((Resource)s, (URI)p1, (Value)o1, (Resource)graphA);
            buffer.add((Resource)s, (URI)p2, (Value)o2, (Resource)graphB);
            buffer.flush();
            SPOPredicate predicate = new SPOPredicate(new BOp[]{Var.var((String)"g"), new Constant((Object)p1.getIV()), new Constant((Object)o1.getIV()), Var.var((String)"h")}, new NV[]{new NV(IPredicate.Annotations.RELATION_NAME, (Object)new String[]{store.getSPORelation().getNamespace()})});
            IAccessPath accessPath = store.getSPORelation().getAccessPath((IPredicate)predicate);
            TestSPOAccessPath.assertSameSPOs(new ISPO[]{new SPO(graphA.getIV(), p1.getIV(), o1.getIV(), graphA.getIV(), StatementEnum.Explicit), new SPO(s.getIV(), p1.getIV(), o1.getIV(), graphA.getIV(), StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)accessPath.iterator());
            predicate = new SPOPredicate(new BOp[]{Var.var((String)"g"), new Constant((Object)p1.getIV()), new Constant((Object)o1.getIV()), Var.var((String)"g")}, new NV[]{new NV(IPredicate.Annotations.RELATION_NAME, (Object)new String[]{store.getSPORelation().getNamespace()})});
            accessPath = store.getSPORelation().getAccessPath((IPredicate)predicate);
            TestSPOAccessPath.assertSameSPOs(new ISPO[]{new SPO(graphA.getIV(), p1.getIV(), o1.getIV(), graphA.getIV(), StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)accessPath.iterator());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public void test_slice() {
    }
}

