/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.AbstractBTreeTestCase;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.ReadOnlyKeysRaba;
import com.bigdata.btree.raba.codec.CanonicalHuffmanRabaCoder;
import com.bigdata.btree.raba.codec.FrontCodedRabaCoder;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.btree.raba.codec.SimpleRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.FixedByteArrayBuffer;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOComparator;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.test.MockTermIdFactory;
import java.util.Arrays;
import junit.framework.TestCase2;

public class TestSPOKeyCoders
extends TestCase2 {
    private MockTermIdFactory factory;

    public TestSPOKeyCoders() {
    }

    public TestSPOKeyCoders(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new MockTermIdFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
    }

    protected IV<?, ?> getTermId() {
        return this.factory.newTermIdNoSids();
    }

    protected SPO[] getData(int n) {
        SPO[] a = new SPO[n];
        for (int i = 0; i < n; ++i) {
            a[i] = new SPO(this.getTermId(), this.getTermId(), this.getTermId());
        }
        Arrays.sort(a, 0, a.length, SPOComparator.INSTANCE);
        return a;
    }

    public void test_simpleCoder() {
        this.doRoundTripTests((IRabaCoder)SimpleRabaCoder.INSTANCE);
    }

    public void test_frontCoder_int8() {
        this.doRoundTripTests((IRabaCoder)new FrontCodedRabaCoder(8));
    }

    public void test_canonicalHuffmanCoder_int8() {
        this.doRoundTripTests((IRabaCoder)CanonicalHuffmanRabaCoder.INSTANCE);
    }

    protected void doRoundTripTests(IRabaCoder rabaCoder) {
        this.doRoundTripTest(this.getData(0), rabaCoder);
        this.doRoundTripTest(this.getData(1), rabaCoder);
        this.doRoundTripTest(this.getData(10), rabaCoder);
        this.doRoundTripTest(this.getData(100), rabaCoder);
        this.doRoundTripTest(this.getData(1000), rabaCoder);
        this.doRoundTripTest(this.getData(10000), rabaCoder);
    }

    protected void doRoundTripTest(SPO[] a, IRabaCoder rabaCoder) {
        SPOTupleSerializer tupleSer = new SPOTupleSerializer(SPOKeyOrder.SPO, false);
        byte[][] keys = new byte[a.length][];
        for (int i = 0; i < a.length; ++i) {
            keys[i] = tupleSer.serializeKey((ISPO)a[i]);
        }
        ReadOnlyKeysRaba expected = new ReadOnlyKeysRaba((byte[][])keys);
        AbstractFixedByteArrayBuffer originalData = rabaCoder.encode((IRaba)expected, new DataOutputBuffer());
        ICodedRaba actual0 = rabaCoder.decode(originalData);
        AbstractBTreeTestCase.assertSameRaba((IRaba)expected, (IRaba)actual0);
        AbstractBTreeTestCase.assertSameRaba((IRaba)expected, (IRaba)rabaCoder.decode(actual0.data()));
        int off = 10;
        DataOutputBuffer out = new DataOutputBuffer(10, new byte[110]);
        AbstractFixedByteArrayBuffer slice = rabaCoder.encode((IRaba)expected, out);
        TestSPOKeyCoders.assertEquals((byte[])originalData.toByteArray(), (byte[])slice.toByteArray());
        off = 10;
        byte[] tmp = new byte[10 + originalData.len()];
        System.arraycopy(originalData.array(), originalData.off(), tmp, 10, originalData.len());
        slice = new FixedByteArrayBuffer(tmp, 10, originalData.len());
        TestSPOKeyCoders.assertEquals((byte[])originalData.toByteArray(), (byte[])slice.toByteArray());
        ICodedRaba actual = rabaCoder.decode(slice);
        AbstractBTreeTestCase.assertSameRaba((IRaba)expected, (IRaba)actual);
    }
}

