/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.NV;
import com.bigdata.bop.Var;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.io.SerializerUtil;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.test.MockTermIdFactory;
import com.bigdata.util.BytesUtil;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase2;

public class TestSPOKeyOrder
extends TestCase2 {
    private MockTermIdFactory factory;

    public TestSPOKeyOrder() {
    }

    public TestSPOKeyOrder(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new MockTermIdFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
    }

    private IV<?, ?> tid(long tidIsIgnored) {
        return this.factory.newTermId(VTE.URI);
    }

    public void test_serializationSize() {
        if (log.isInfoEnabled()) {
            log.info((Object)("serializedSize=" + SerializerUtil.serialize((Object)SPOKeyOrder.SPO).length + " bytes"));
        }
    }

    public void test_keyOrder_triples() {
        KeyBuilder keyBuilder = new KeyBuilder(32);
        IV<?, ?> S = this.tid(1L);
        IV<?, ?> P2 = this.tid(2L);
        IV<?, ?> O = this.tid(3L);
        IV<?, ?> C2 = this.tid(4L);
        SPO expected = new SPO(S, P2, O, C2);
        this.assertSPOCEquals(new SPO(S, P2, O), SPOKeyOrder.SPO.decodeKey(SPOKeyOrder.SPO.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected)));
        this.assertSPOCEquals(new SPO(P2, O, S), SPOKeyOrder.SPO.decodeKey(SPOKeyOrder.POS.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected)));
        this.assertSPOCEquals(new SPO(O, S, P2), SPOKeyOrder.SPO.decodeKey(SPOKeyOrder.OSP.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected)));
    }

    public void test_keyOrder_quads() {
        KeyBuilder keyBuilder = new KeyBuilder(32);
        IV<?, ?> S = this.tid(1L);
        IV<?, ?> P2 = this.tid(2L);
        IV<?, ?> O = this.tid(3L);
        IV<?, ?> C2 = this.tid(4L);
        SPO expected = new SPO(S, P2, O, C2);
        this.assertSPOCEquals(new SPO(S, P2, O, C2), SPOKeyOrder.SPOC.decodeKey(SPOKeyOrder.SPOC.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected)));
        this.assertSPOCEquals(new SPO(P2, O, C2, S), SPOKeyOrder.SPOC.decodeKey(SPOKeyOrder.POCS.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected)));
        this.assertSPOCEquals(new SPO(O, C2, S, P2), SPOKeyOrder.SPOC.decodeKey(SPOKeyOrder.OCSP.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected)));
        this.assertSPOCEquals(new SPO(C2, S, P2, O), SPOKeyOrder.SPOC.decodeKey(SPOKeyOrder.CSPO.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected)));
        this.assertSPOCEquals(new SPO(P2, C2, S, O), SPOKeyOrder.SPOC.decodeKey(SPOKeyOrder.PCSO.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected)));
        this.assertSPOCEquals(new SPO(S, O, P2, C2), SPOKeyOrder.SPOC.decodeKey(SPOKeyOrder.SOPC.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected)));
    }

    protected void assertSPOCEquals(SPO e, SPO a) {
        TestSPOKeyOrder.assertEquals((String)"s", (Object)e.s(), (Object)a.s());
        TestSPOKeyOrder.assertEquals((String)"p", (Object)e.p(), (Object)a.p());
        TestSPOKeyOrder.assertEquals((String)"o", (Object)e.o(), (Object)a.o());
        TestSPOKeyOrder.assertEquals((String)"c", (Object)e.c(), (Object)a.c());
    }

    public void test_encodeDecode() {
        KeyBuilder keyBuilder = new KeyBuilder(32);
        for (int i = 3; i <= 8; ++i) {
            SPOKeyOrder keyOrder = SPOKeyOrder.valueOf((int)i);
            SPO expected = new SPO(this.tid(1L), this.tid(2L), this.tid(3L), this.tid(4L));
            byte[] key = keyOrder.encodeKey((IKeyBuilder)keyBuilder, (ISPO)expected);
            SPO actual = keyOrder.decodeKey(key);
            this.assertSPOCEquals(expected, actual);
        }
    }

    public void test_getFromKey_getToKey_quads() {
        IV<?, ?> P2 = this.tid(1L);
        SPOPredicate pred = new SPOPredicate(new BOp[]{Var.var((String)"s"), new Constant(P2), Var.var((String)"o"), Var.var((String)"c")}, new NV[]{new NV(IPredicate.Annotations.RELATION_NAME, (Object)new String[]{"testRelation"})});
        KeyBuilder keyBuilder = new KeyBuilder();
        SPOKeyOrder keyOrder = SPOKeyOrder.POCS;
        byte[] fromKey = P2.encode((IKeyBuilder)keyBuilder.reset()).getKey();
        byte[] toKey = SuccessorUtil.successor((byte[])((byte[])fromKey.clone()));
        if (log.isInfoEnabled()) {
            log.info((Object)("fromKey=" + BytesUtil.toString((byte[])fromKey)));
            log.info((Object)("  toKey=" + BytesUtil.toString((byte[])toKey)));
        }
        if (!BytesUtil.bytesEqual((byte[])fromKey, (byte[])keyOrder.getFromKey((IKeyBuilder)keyBuilder, (IPredicate)pred))) {
            TestSPOKeyOrder.fail((String)("fromKey :: expected=" + BytesUtil.toString((byte[])fromKey) + ", actual=" + BytesUtil.toString((byte[])keyOrder.getFromKey((IKeyBuilder)keyBuilder, (IPredicate)pred))));
        }
        if (!BytesUtil.bytesEqual((byte[])toKey, (byte[])keyOrder.getToKey((IKeyBuilder)keyBuilder, (IPredicate)pred))) {
            TestSPOKeyOrder.fail((String)("toKey :: expected=" + BytesUtil.toString((byte[])toKey) + ", actual=" + BytesUtil.toString((byte[])keyOrder.getToKey((IKeyBuilder)keyBuilder, (IPredicate)pred))));
        }
    }

    public void test_getFromKey_getToKey_triples() {
        IV<?, ?> P2 = this.tid(1L);
        SPOPredicate pred = new SPOPredicate(new BOp[]{Var.var((String)"s"), new Constant(P2), Var.var((String)"o")}, new NV[]{new NV(IPredicate.Annotations.RELATION_NAME, (Object)new String[]{"testRelation"})});
        KeyBuilder keyBuilder = new KeyBuilder();
        SPOKeyOrder keyOrder = SPOKeyOrder.POS;
        byte[] fromKey = P2.encode((IKeyBuilder)keyBuilder.reset()).getKey();
        byte[] toKey = SuccessorUtil.successor((byte[])((byte[])fromKey.clone()));
        if (log.isInfoEnabled()) {
            log.info((Object)("fromKey=" + BytesUtil.toString((byte[])fromKey)));
            log.info((Object)("  toKey=" + BytesUtil.toString((byte[])toKey)));
        }
        if (!BytesUtil.bytesEqual((byte[])fromKey, (byte[])keyOrder.getFromKey((IKeyBuilder)keyBuilder, (IPredicate)pred))) {
            TestSPOKeyOrder.fail((String)("fromKey :: expected=" + BytesUtil.toString((byte[])fromKey) + ", actual=" + BytesUtil.toString((byte[])keyOrder.getFromKey((IKeyBuilder)keyBuilder, (IPredicate)pred))));
        }
        if (!BytesUtil.bytesEqual((byte[])toKey, (byte[])keyOrder.getToKey((IKeyBuilder)keyBuilder, (IPredicate)pred))) {
            TestSPOKeyOrder.fail((String)("toKey :: expected=" + BytesUtil.toString((byte[])toKey) + ", actual=" + BytesUtil.toString((byte[])keyOrder.getToKey((IKeyBuilder)keyBuilder, (IPredicate)pred))));
        }
    }

    public void test_spoOnlyKeyOrder_iterator() {
        TestSPOKeyOrder.assertSameIteratorAnyOrder(new SPOKeyOrder[]{SPOKeyOrder.SPO}, SPOKeyOrder.spoOnlyKeyOrderIterator());
    }

    public void test_spocOnlyKeyOrder_iterator() {
        TestSPOKeyOrder.assertSameIteratorAnyOrder(new SPOKeyOrder[]{SPOKeyOrder.SPOC}, SPOKeyOrder.spocOnlyKeyOrderIterator());
    }

    public void test_tripleStoreKeyOrders_iterator() {
        TestSPOKeyOrder.assertSameIteratorAnyOrder(new SPOKeyOrder[]{SPOKeyOrder.SPO, SPOKeyOrder.POS, SPOKeyOrder.OSP}, SPOKeyOrder.tripleStoreKeyOrderIterator());
    }

    public void test_quadStoreKeyOrders_iterator() {
        TestSPOKeyOrder.assertSameIteratorAnyOrder(new SPOKeyOrder[]{SPOKeyOrder.SPOC, SPOKeyOrder.POCS, SPOKeyOrder.OCSP, SPOKeyOrder.CSPO, SPOKeyOrder.PCSO, SPOKeyOrder.SOPC}, SPOKeyOrder.quadStoreKeyOrderIterator());
    }

    public static void assertSameIteratorAnyOrder(Object[] expected, Iterator actual) {
        TestSPOKeyOrder.assertSameIteratorAnyOrder("", expected, actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertSameIteratorAnyOrder(String msg, Object[] expected, Iterator actual) {
        try {
            int j;
            int nrange = expected.length;
            HashMap<Object, Object> range = new HashMap<Object, Object>();
            for (j = 0; j < nrange; ++j) {
                range.put(expected[j], expected[j]);
            }
            for (j = 0; j < nrange; ++j) {
                Object actualObject;
                if (!actual.hasNext()) {
                    TestSPOKeyOrder.fail((String)(msg + ": Index exhausted while expecting more object(s)" + ": index=" + j));
                }
                if (range.remove(actualObject = actual.next()) != null) continue;
                TestSPOKeyOrder.fail((String)("Object not expected: index=" + j + ", object=" + actualObject));
            }
            if (actual.hasNext()) {
                TestSPOKeyOrder.fail((String)"Iterator will deliver too many objects.");
            }
        }
        finally {
            if (actual instanceof ICloseableIterator) {
                ((ICloseableIterator)actual).close();
            }
        }
    }
}

