/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.NV;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.test.MockTermIdFactory;
import junit.framework.TestCase2;

public class TestSPOPredicate
extends TestCase2 {
    private String relation;
    private Constant<IV> rdfsSubClassOf;
    private Constant<IV> rdfsResource;
    private Constant<IV> rdfType;
    private Constant<IV> rdfsClass;
    private Constant<IV> someGraph;
    private MockTermIdFactory factory;

    public TestSPOPredicate() {
    }

    public TestSPOPredicate(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new MockTermIdFactory();
        this.relation = "test";
        this.rdfsSubClassOf = new Constant((Object)this.factory.newTermId(VTE.URI));
        this.rdfsResource = new Constant((Object)this.factory.newTermId(VTE.URI));
        this.rdfType = new Constant((Object)this.factory.newTermId(VTE.URI));
        this.rdfsClass = new Constant((Object)this.factory.newTermId(VTE.URI));
        this.someGraph = new Constant((Object)this.factory.newTermId(VTE.URI));
    }

    protected void tearDown() throws Exception {
        this.factory = null;
        this.relation = null;
        this.someGraph = null;
        this.rdfsClass = null;
        this.rdfType = null;
        this.rdfsResource = null;
        this.rdfsSubClassOf = null;
        super.tearDown();
    }

    public void test_ctor_triples_oneVar() {
        Var u = Var.var((String)"u");
        SPOPredicate p1 = new SPOPredicate(new BOp[]{u, this.rdfsSubClassOf, this.rdfsResource}, new NV[]{new NV(IPredicate.Annotations.RELATION_NAME, (Object)new String[]{this.relation})});
        if (log.isInfoEnabled()) {
            log.info((Object)p1.toString());
        }
        TestSPOPredicate.assertEquals((String)"arity", (int)3, (int)p1.arity());
        TestSPOPredicate.assertEquals((String)"variableCount", (int)1, (int)p1.getVariableCount((IKeyOrder)SPOKeyOrder.SPO));
        TestSPOPredicate.assertEquals((Object)u, (Object)p1.get(0));
        TestSPOPredicate.assertEquals(this.rdfsSubClassOf, (Object)p1.get(1));
        TestSPOPredicate.assertEquals(this.rdfsResource, (Object)p1.get(2));
    }

    public void test_ctor_triples_twoVars() {
        Var u = Var.var((String)"u");
        Var v = Var.var((String)"v");
        SPOPredicate p1 = new SPOPredicate(new BOp[]{u, this.rdfsSubClassOf, v}, new NV[]{new NV(IPredicate.Annotations.RELATION_NAME, (Object)new String[]{this.relation})});
        if (log.isInfoEnabled()) {
            log.info((Object)p1.toString());
        }
        TestSPOPredicate.assertEquals((String)"arity", (int)3, (int)p1.arity());
        TestSPOPredicate.assertEquals((String)"variableCount", (int)2, (int)p1.getVariableCount((IKeyOrder)SPOKeyOrder.SPO));
        TestSPOPredicate.assertEquals((Object)u, (Object)p1.get(0));
        TestSPOPredicate.assertEquals(this.rdfsSubClassOf, (Object)p1.get(1));
        TestSPOPredicate.assertEquals((Object)v, (Object)p1.get(2));
    }

    public void test_ctor_quads_oneVar() {
        Var u = Var.var((String)"u");
        SPOPredicate p1 = new SPOPredicate(new BOp[]{u, this.rdfsSubClassOf, this.rdfsResource, this.someGraph}, new NV[]{new NV(IPredicate.Annotations.RELATION_NAME, (Object)new String[]{this.relation})});
        if (log.isInfoEnabled()) {
            log.info((Object)p1.toString());
        }
        TestSPOPredicate.assertEquals((String)"arity", (int)4, (int)p1.arity());
        TestSPOPredicate.assertEquals((String)"variableCount", (int)1, (int)p1.getVariableCount((IKeyOrder)SPOKeyOrder.SPOC));
        TestSPOPredicate.assertEquals((Object)u, (Object)p1.get(0));
        TestSPOPredicate.assertEquals(this.rdfsSubClassOf, (Object)p1.get(1));
        TestSPOPredicate.assertEquals(this.rdfsResource, (Object)p1.get(2));
        TestSPOPredicate.assertEquals(this.someGraph, (Object)p1.get(3));
    }

    public void test_ctor_quads_twoVars() {
        Var u = Var.var((String)"u");
        Var v = Var.var((String)"v");
        SPOPredicate p1 = new SPOPredicate(new BOp[]{u, this.rdfsSubClassOf, this.rdfsResource, v}, new NV[]{new NV(IPredicate.Annotations.RELATION_NAME, (Object)new String[]{this.relation})});
        if (log.isInfoEnabled()) {
            log.info((Object)p1.toString());
        }
        TestSPOPredicate.assertEquals((String)"arity", (int)4, (int)p1.arity());
        TestSPOPredicate.assertEquals((String)"variableCount", (int)2, (int)p1.getVariableCount((IKeyOrder)SPOKeyOrder.SPOC));
        TestSPOPredicate.assertEquals((Object)u, (Object)p1.get(0));
        TestSPOPredicate.assertEquals(this.rdfsSubClassOf, (Object)p1.get(1));
        TestSPOPredicate.assertEquals(this.rdfsResource, (Object)p1.get(2));
        TestSPOPredicate.assertEquals((Object)v, (Object)p1.get(3));
    }
}

