/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.constraint.BooleanValueExpression;
import com.bigdata.bop.constraint.Constraint;
import com.bigdata.bop.constraint.NE;
import com.bigdata.bop.joinGraph.IEvaluationPlanFactory;
import com.bigdata.bop.joinGraph.fast.DefaultEvaluationPlan2;
import com.bigdata.bop.joinGraph.fast.DefaultEvaluationPlanFactory2;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.Rule;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.RuleState;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.test.MockTermIdFactory;
import java.util.Map;
import java.util.Properties;

public class TestSPORelation
extends AbstractTripleStoreTestCase {
    private Constant<IV> rdfsSubClassOf;
    private Constant<IV> rdfsResource;
    private Constant<IV> rdfType;
    private Constant<IV> rdfsClass;
    private Constant<IV> someGraph;
    private MockTermIdFactory factory;

    public TestSPORelation() {
    }

    public TestSPORelation(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new MockTermIdFactory();
        this.rdfsSubClassOf = new Constant((Object)this.factory.newTermId(VTE.URI));
        this.rdfsResource = new Constant((Object)this.factory.newTermId(VTE.URI));
        this.rdfType = new Constant((Object)this.factory.newTermId(VTE.URI));
        this.rdfsClass = new Constant((Object)this.factory.newTermId(VTE.URI));
        this.someGraph = new Constant((Object)this.factory.newTermId(VTE.URI));
    }

    @Override
    protected void tearDown() throws Exception {
        this.factory = null;
        this.someGraph = null;
        this.rdfsClass = null;
        this.rdfType = null;
        this.rdfsResource = null;
        this.rdfsSubClassOf = null;
        super.tearDown();
    }

    private IV<?, ?> uriId(long ignored) {
        return this.factory.newTermId(VTE.URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ruleState() {
        AbstractTripleStore store = this.getStore();
        try {
            String relationIdentifier = store.getSPORelation().getNamespace();
            IJoinNexus joinNexus = store.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 7, null).newInstance(store.getIndexManager());
            TestRuleRdfs9 rule = new TestRuleRdfs9(relationIdentifier);
            IBindingSet bindingSet = joinNexus.newBindingSet((IRule)rule);
            IPredicate asBound = rule.getTail(0).asBound(bindingSet);
            IRelation relation = joinNexus.getTailRelationView(asBound);
            TestSPORelation.assertEquals((Object)SPOKeyOrder.POS, (Object)joinNexus.getTailAccessPath(relation, asBound).getKeyOrder());
            asBound = rule.getTail(1).asBound(bindingSet);
            relation = joinNexus.getTailRelationView(asBound);
            TestSPORelation.assertEquals((Object)SPOKeyOrder.POS, (Object)joinNexus.getTailAccessPath(relation, asBound).getKeyOrder());
            rule = new Rule("testRule", (IPredicate)new SPOPredicate(relationIdentifier, (IVariableOrConstant)Var.var((String)"x"), (IVariableOrConstant)Var.var((String)"y"), (IVariableOrConstant)Var.var((String)"z")), (IPredicate[])new SPOPredicate[]{new SPOPredicate(relationIdentifier, (IVariableOrConstant)Var.var((String)"x"), (IVariableOrConstant)Var.var((String)"y"), (IVariableOrConstant)Var.var((String)"z"))}, new IConstraint[0]);
            bindingSet = joinNexus.newBindingSet((IRule)rule);
            asBound = rule.getTail(0).asBound(bindingSet);
            relation = joinNexus.getTailRelationView(asBound);
            TestSPORelation.assertEquals((Object)SPOKeyOrder.SPO, (Object)joinNexus.getTailAccessPath(relation, asBound).getKeyOrder());
            rule = new Rule("testRule", (IPredicate)new SPOPredicate(relationIdentifier, (IVariableOrConstant)Var.var((String)"x"), (IVariableOrConstant)Var.var((String)"y"), (IVariableOrConstant)Var.var((String)"z")), (IPredicate[])new SPOPredicate[]{new SPOPredicate(relationIdentifier, (IVariableOrConstant)new Constant(this.uriId(2L)), (IVariableOrConstant)Var.var((String)"y"), (IVariableOrConstant)Var.var((String)"z")), new SPOPredicate(relationIdentifier, (IVariableOrConstant)Var.var((String)"x"), (IVariableOrConstant)Var.var((String)"y"), (IVariableOrConstant)new Constant(this.uriId(1L)))}, new IConstraint[0]);
            bindingSet = joinNexus.newBindingSet((IRule)rule);
            asBound = rule.getTail(0).asBound(bindingSet);
            relation = joinNexus.getTailRelationView(asBound);
            TestSPORelation.assertEquals((Object)SPOKeyOrder.SPO, (Object)joinNexus.getTailAccessPath(relation, asBound).getKeyOrder());
            asBound = rule.getTail(1).asBound(bindingSet);
            relation = joinNexus.getTailRelationView(asBound);
            TestSPORelation.assertEquals((Object)SPOKeyOrder.OSP, (Object)joinNexus.getTailAccessPath(relation, asBound).getKeyOrder());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_insertQuery() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            String relationIdentifier = store.getSPORelation().getNamespace();
            IJoinNexus joinNexus = store.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 7, null).newInstance(store.getIndexManager());
            SPORelation spoRelation = store.getSPORelation();
            Constant U1 = new Constant(this.uriId(11L));
            Constant U2 = new Constant(this.uriId(12L));
            Constant V12 = new Constant(this.uriId(21L));
            Constant V2 = new Constant(this.uriId(22L));
            Constant X1 = new Constant(this.uriId(31L));
            TestRuleRdfs9 rule = new TestRuleRdfs9(relationIdentifier);
            DefaultEvaluationPlan2 plan = new DefaultEvaluationPlan2(joinNexus, (IRule)rule);
            log.info((Object)("original plan=" + plan));
            IBindingSet bindingSet = joinNexus.newBindingSet((IRule)rule);
            for (int i = 0; i < rule.getTailCount(); ++i) {
                IPredicate pred = rule.getTail(i).asBound(bindingSet);
                IRelation relation = joinNexus.getTailRelationView(pred);
                IAccessPath accessPath = joinNexus.getTailAccessPath(relation, pred);
                TestSPORelation.assertEquals((long)0L, (long)accessPath.rangeCount(true));
                TestSPORelation.assertEquals((long)0L, (long)accessPath.rangeCount(false));
            }
            Object[] a = new SPO[]{new SPO((IConstant)U1, this.rdfsSubClassOf, (IConstant)X1, StatementEnum.Explicit), new SPO((IConstant)V12, this.rdfType, (IConstant)U1, StatementEnum.Explicit), new SPO((IConstant)V2, this.rdfType, (IConstant)U2, StatementEnum.Explicit)};
            TestSPORelation.assertEquals((long)3L, (long)spoRelation.insert((IChunkedOrderedIterator)new ChunkedArrayIterator(a.length, a, null)));
            if (log.isInfoEnabled()) {
                log.info((Object)("KB Dump:\n" + spoRelation.dump((IKeyOrder)SPOKeyOrder.SPO)));
            }
            TestSPORelation.assertEquals((long)3L, (long)spoRelation.getAccessPath(this.NULL, this.NULL, this.NULL).rangeCount(true));
            TestSPORelation.assertEquals((long)1L, (long)spoRelation.getAccessPath(rule.getTail(0)).rangeCount(false));
            TestSPORelation.assertEquals((long)2L, (long)spoRelation.getAccessPath(rule.getTail(1)).rangeCount(false));
            plan = new DefaultEvaluationPlan2(joinNexus, (IRule)rule);
            log.info((Object)("updated plan=" + plan));
            TestSPORelation.assertEquals((String)"order", (int[])new int[]{0, 1}, (int[])plan.getOrder());
            IBindingSet bindings = joinNexus.newBindingSet((IRule)rule);
            RuleState ruleState = new RuleState((IRule)rule, joinNexus);
            bindings.set((IVariable)Var.var((String)"u"), (IConstant)U1);
            bindings.set((IVariable)Var.var((String)"x"), (IConstant)X1);
            TestSPORelation.assertTrue((boolean)rule.isFullyBound(0, bindings));
            bindings.set((IVariable)Var.var((String)"v"), (IConstant)V12);
            TestSPORelation.assertTrue((boolean)rule.isFullyBound(1, bindings));
            ISolution solution = joinNexus.newSolution((IRule)rule, bindings);
            TestSPORelation.assertEquals((Object)V12.get(), (Object)((SPO)solution.get()).s);
            TestSPORelation.assertEquals((Object)this.rdfType.get(), (Object)((SPO)solution.get()).p);
            TestSPORelation.assertEquals((Object)X1.get(), (Object)((SPO)solution.get()).o);
            TestSPORelation.assertTrue((rule == solution.getRule() ? 1 : 0) != 0);
            TestSPORelation.assertTrue((boolean)bindings.equals((Object)solution.getBindingSet()));
            TestSPORelation.assertTrue((bindings != solution.getBindingSet() ? 1 : 0) != 0);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_runRule() throws Exception {
        IElementFilter filter = null;
        boolean justify = false;
        boolean backchain = false;
        DefaultEvaluationPlanFactory2 planFactory = DefaultEvaluationPlanFactory2.INSTANCE;
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            String relationIdentifier = store.getSPORelation().getNamespace();
            SPORelation spoRelation = store.getSPORelation();
            Constant U1 = new Constant(this.uriId(11L));
            Constant U2 = new Constant(this.uriId(12L));
            Constant V12 = new Constant(this.uriId(21L));
            Constant V2 = new Constant(this.uriId(22L));
            Constant X1 = new Constant(this.uriId(31L));
            TestRuleRdfs9 rule = new TestRuleRdfs9(relationIdentifier);
            log.info((Object)"\n\nQuery w/o data in KB\n");
            IJoinNexus joinNexus = store.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 7, null).newInstance(store.getIndexManager());
            try (IChunkedOrderedIterator itr = joinNexus.runQuery((IStep)rule);){
                TestSPORelation.assertFalse((boolean)itr.hasNext());
            }
            Object[] a = new SPO[]{new SPO((IConstant)U1, this.rdfsSubClassOf, (IConstant)X1, StatementEnum.Explicit), new SPO((IConstant)V12, this.rdfType, (IConstant)U1, StatementEnum.Explicit), new SPO((IConstant)V2, this.rdfType, (IConstant)U2, StatementEnum.Explicit)};
            TestSPORelation.assertEquals((long)3L, (long)spoRelation.insert((IChunkedOrderedIterator)new ChunkedArrayIterator(a.length, a, null)));
            if (log.isInfoEnabled()) {
                log.info((Object)("KB Dump:\n" + spoRelation.dump((IKeyOrder)SPOKeyOrder.SPO)));
            }
            TestSPORelation.assertEquals((long)3L, (long)spoRelation.getAccessPath(this.NULL, this.NULL, this.NULL).rangeCount(true));
            TestSPORelation.assertEquals((long)1L, (long)spoRelation.getAccessPath(rule.getTail(0)).rangeCount(false));
            TestSPORelation.assertEquals((long)2L, (long)spoRelation.getAccessPath(rule.getTail(1)).rangeCount(false));
            joinNexus = store.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 7, filter, false, false, (IEvaluationPlanFactory)planFactory).newInstance(store.getIndexManager());
            if (log.isInfoEnabled()) {
                log.info((Object)"\n\nQuery with data in KB\n");
            }
            itr = joinNexus.runQuery((IStep)rule);
            SPO expectedSPO = new SPO((IConstant)V12, this.rdfType, (IConstant)X1, StatementEnum.Inferred);
            ListBindingSet expectedBindingSet = new ListBindingSet();
            expectedBindingSet.set((IVariable)Var.var((String)"u"), (IConstant)U1);
            expectedBindingSet.set((IVariable)Var.var((String)"v"), (IConstant)V12);
            expectedBindingSet.set((IVariable)Var.var((String)"x"), (IConstant)X1);
            try {
                TestSPORelation.assertTrue((boolean)itr.hasNext());
                ISolution solution = (ISolution)itr.next();
                if (!solution.get().equals(expectedSPO)) {
                    TestSPORelation.fail((String)("expected: " + expectedSPO + ", actual=" + solution.get()));
                }
                TestSPORelation.assertTrue((solution.getRule() == rule ? 1 : 0) != 0);
                if (!solution.getBindingSet().equals((Object)expectedBindingSet)) {
                    TestSPORelation.fail((String)("expected=" + expectedBindingSet + ", actual=" + solution.getBindingSet()));
                }
                if (itr.hasNext()) {
                    TestSPORelation.fail((String)("Not expecting another solution: " + itr.next()));
                }
            }
            finally {
                itr.close();
            }
            joinNexus = store.newJoinNexusFactory(RuleContextEnum.DatabaseAtOnceClosure, ActionEnum.Insert, 7, filter, false, false, (IEvaluationPlanFactory)planFactory).newInstance(store.getIndexManager());
            if (log.isInfoEnabled()) {
                log.info((Object)"\n\nRun rules as insert operations\n");
            }
            long mutationCount = joinNexus.runMutation((IStep)rule);
            TestSPORelation.assertEquals((String)"mutationCount", (long)1L, (long)mutationCount);
            TestSPORelation.assertEquals((long)1L, (long)spoRelation.getAccessPath(rule.getTail(0)).rangeCount(false));
            TestSPORelation.assertEquals((long)3L, (long)spoRelation.getAccessPath(rule.getTail(1)).rangeCount(false));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    protected static class P
    extends SPOPredicate {
        public P(BOp[] values, Map<String, Object> annotations) {
            super(values, annotations);
        }

        public P(P op) {
            super((SPOPredicate)op);
        }

        public P(String relation, IVariableOrConstant<IV> s, IVariableOrConstant<IV> p, IVariableOrConstant<IV> o) {
            super(relation, s, p, o);
        }
    }

    protected class TestRuleRdfs9
    extends Rule {
        public TestRuleRdfs9(String relation) {
            super("rdfs9", (IPredicate)new P(relation, (IVariableOrConstant<IV>)TestRuleRdfs9.var((String)"v"), (IVariableOrConstant<IV>)TestSPORelation.this.rdfType, (IVariableOrConstant<IV>)TestRuleRdfs9.var((String)"x")), new IPredicate[]{new P(relation, (IVariableOrConstant<IV>)TestRuleRdfs9.var((String)"u"), (IVariableOrConstant<IV>)TestSPORelation.this.rdfsSubClassOf, (IVariableOrConstant<IV>)TestRuleRdfs9.var((String)"x")), new P(relation, (IVariableOrConstant<IV>)TestRuleRdfs9.var((String)"v"), (IVariableOrConstant<IV>)TestSPORelation.this.rdfType, (IVariableOrConstant<IV>)TestRuleRdfs9.var((String)"u"))}, new IConstraint[]{Constraint.wrap((BooleanValueExpression)new NE((IVariable)TestRuleRdfs9.var((String)"u"), (IVariable)TestRuleRdfs9.var((String)"x")))});
        }
    }
}

