/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.AbstractTuple;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.test.MockTermIdFactory;
import com.bigdata.util.BytesUtil;
import junit.framework.TestCase2;

public class TestSPOTupleSerializer
extends TestCase2 {
    private IV<?, ?> _1;
    private IV<?, ?> _2;
    private IV<?, ?> _3;
    private IV<?, ?> _4;
    private MockTermIdFactory factory;

    public TestSPOTupleSerializer() {
    }

    public TestSPOTupleSerializer(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new MockTermIdFactory();
        this._1 = this.tid(1L);
        this._2 = this.tid(2L);
        this._3 = this.tid(3L);
        this._4 = this.tid(4L);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
        this._4 = null;
        this._3 = null;
        this._2 = null;
        this._1 = null;
    }

    private IV<?, ?> tid(long tidIsIgnored) {
        return this.factory.newTermId(VTE.URI);
    }

    public void test_statementOrder() {
        SPOTupleSerializer fixture = new SPOTupleSerializer(SPOKeyOrder.SPO, false);
        byte[] k_1 = fixture.serializeKey((ISPO)new SPO(this._1, this._2, this._3));
        byte[] k_2 = fixture.serializeKey((ISPO)new SPO(this._2, this._2, this._3));
        byte[] k_3 = fixture.serializeKey((ISPO)new SPO(this._2, this._2, this._4));
        if (log.isInfoEnabled()) {
            log.info((Object)("k_1(_1,_2,_2) = " + BytesUtil.toString((byte[])k_1)));
            log.info((Object)("k_2(_2,_2,_3) = " + BytesUtil.toString((byte[])k_2)));
            log.info((Object)("k_3(_2,_2,_4) = " + BytesUtil.toString((byte[])k_3)));
        }
        TestSPOTupleSerializer.assertTrue((BytesUtil.compareBytes((byte[])k_1, (byte[])k_2) < 0 ? 1 : 0) != 0);
        TestSPOTupleSerializer.assertTrue((BytesUtil.compareBytes((byte[])k_2, (byte[])k_3) < 0 ? 1 : 0) != 0);
    }

    public void test_encodeDecodeTriple() {
        this.doEncodeDecodeTest(new SPO(this._1, this._2, this._3, StatementEnum.Axiom), SPOKeyOrder.SPO);
        this.doEncodeDecodeTest(new SPO(this._1, this._2, this._3, StatementEnum.Explicit), SPOKeyOrder.POS);
        this.doEncodeDecodeTest(new SPO(this._1, this._2, this._3, StatementEnum.Inferred), SPOKeyOrder.OSP);
    }

    public void test_encodeDecodeTripleWithSID() {
        SPO spo = new SPO(this._3, this._1, this._2, StatementEnum.Explicit);
        this.doEncodeDecodeTest(spo, SPOKeyOrder.SPO);
        spo = new SPO(this._3, this._1, this._2, StatementEnum.Explicit);
        this.doEncodeDecodeTest(spo, SPOKeyOrder.POS);
        spo = new SPO(this._3, this._1, this._2, StatementEnum.Explicit);
        this.doEncodeDecodeTest(spo, SPOKeyOrder.OSP);
    }

    public void test_encodeDecodeQuad() {
        for (int i = 3; i <= 8; ++i) {
            SPOKeyOrder keyOrder = SPOKeyOrder.valueOf((int)i);
            this.doEncodeDecodeTest(new SPO(this._1, this._2, this._3, this._4, StatementEnum.Axiom), keyOrder);
            this.doEncodeDecodeTest(new SPO(this._1, this._2, this._3, this._4, StatementEnum.Inferred), keyOrder);
            this.doEncodeDecodeTest(new SPO(this._1, this._2, this._3, this._4, StatementEnum.Explicit), keyOrder);
        }
    }

    protected void doEncodeDecodeTest(SPO expected, SPOKeyOrder keyOrder) {
        final SPOTupleSerializer fixture = new SPOTupleSerializer(keyOrder, expected.hasStatementIdentifier());
        byte[] key = fixture.serializeKey((ISPO)expected);
        byte[] val = fixture.serializeVal(expected);
        TestTuple<SPO> tuple = new TestTuple<SPO>(3){

            public ITupleSerializer getTupleSerializer() {
                return fixture;
            }
        };
        tuple.copyTuple(key, val);
        SPO actual = (SPO)tuple.getObject();
        if (!expected.equals((ISPO)actual)) {
            TestSPOTupleSerializer.fail((String)("Expected: " + expected + ", but actual=" + actual));
        }
        TestSPOTupleSerializer.assertEquals((String)"c", (Object)expected.c(), (Object)actual.c());
        if (expected.hasStatementType()) {
            TestSPOTupleSerializer.assertEquals((String)"type", (Object)expected.getStatementType(), (Object)actual.getStatementType());
        }
        TestSPOTupleSerializer.assertEquals((boolean)expected.hasStatementIdentifier(), (boolean)actual.hasStatementIdentifier());
        if (expected.hasStatementIdentifier()) {
            TestSPOTupleSerializer.assertEquals((String)"statementIdentifier", (Object)expected.getStatementIdentifier(), (Object)actual.getStatementIdentifier());
        }
    }

    private static abstract class TestTuple<E>
    extends AbstractTuple<E> {
        public TestTuple(int flags) {
            super(flags);
        }

        public int getSourceIndex() {
            throw new UnsupportedOperationException();
        }

        public void copyTuple(byte[] key, byte[] val) {
            super.copyTuple(key, val);
        }
    }
}

