/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.AbstractBTreeTestCase;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.ReadOnlyValuesRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.btree.raba.codec.SimpleRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.FixedByteArrayBuffer;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.FastRDFValueCoder2;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.test.MockTermIdFactory;
import java.util.Random;
import junit.framework.TestCase2;

public class TestSPOValueCoders
extends TestCase2 {
    private Random r;
    private MockTermIdFactory factory;

    public TestSPOValueCoders() {
    }

    public TestSPOValueCoders(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new MockTermIdFactory();
        this.r = new Random();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
        this.r = null;
    }

    private IV<?, ?> getTermId() {
        return this.factory.newTermId(VTE.URI);
    }

    private IV<?, ?> getTermId(long tidIsIgnored) {
        return this.factory.newTermId(VTE.URI);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected SPO[] getData(int n, boolean SIDs, boolean inference) {
        SPO[] a = new SPO[n];
        int i = 0;
        while (i < n) {
            SPO spo;
            if (SIDs && !inference) {
                spo = new SPO(this.getTermId(), this.getTermId(), this.getTermId(), StatementEnum.Explicit);
            } else if (inference) {
                int tmp = this.r.nextInt(100);
                StatementEnum type = tmp < 4 ? StatementEnum.Axiom : (tmp < 60 ? StatementEnum.Explicit : StatementEnum.Inferred);
                spo = new SPO(this.getTermId(), this.getTermId(), this.getTermId(), type);
                if (SIDs && type == StatementEnum.Explicit && this.r.nextInt(100) >= 20) {
                    // empty if block
                }
            } else {
                spo = new SPO(this.getTermId(), this.getTermId(), this.getTermId(), StatementEnum.Explicit);
            }
            a[i] = spo;
            ++i;
        }
        return a;
    }

    public void test_simpleCoder() {
        this.doRoundTripTests((IRabaCoder)SimpleRabaCoder.INSTANCE, false, false);
        this.doRoundTripTests((IRabaCoder)SimpleRabaCoder.INSTANCE, true, false);
        this.doRoundTripTests((IRabaCoder)SimpleRabaCoder.INSTANCE, false, true);
        this.doRoundTripTests((IRabaCoder)SimpleRabaCoder.INSTANCE, true, true);
    }

    public void test_FastRDFValueCoder2_001() {
        IV<?, ?> _0 = this.getTermId(0L);
        this.doRoundTripTest(new SPO[]{new SPO(_0, _0, _0, StatementEnum.Axiom)}, (IRabaCoder)new FastRDFValueCoder2(), false);
        this.doRoundTripTest(new SPO[]{new SPO(_0, _0, _0, StatementEnum.Explicit)}, (IRabaCoder)new FastRDFValueCoder2(), false);
        this.doRoundTripTest(new SPO[]{new SPO(_0, _0, _0, StatementEnum.Inferred)}, (IRabaCoder)new FastRDFValueCoder2(), false);
        this.doRoundTripTest(new SPO[]{new SPO(_0, _0, _0, StatementEnum.Axiom), new SPO(_0, _0, _0, StatementEnum.Inferred)}, (IRabaCoder)new FastRDFValueCoder2(), false);
        this.doRoundTripTest(new SPO[]{new SPO(_0, _0, _0, StatementEnum.Explicit), new SPO(_0, _0, _0, StatementEnum.Axiom)}, (IRabaCoder)new FastRDFValueCoder2(), false);
    }

    public void test_FastRDFValueCoder2() {
        this.doRoundTripTests((IRabaCoder)new FastRDFValueCoder2(), false, true);
    }

    protected void doRoundTripTests(IRabaCoder rabaCoder, boolean SIDs, boolean inference) {
        this.doRoundTripTest(this.getData(0, SIDs, inference), rabaCoder, SIDs);
        this.doRoundTripTest(this.getData(1, SIDs, inference), rabaCoder, SIDs);
        this.doRoundTripTest(this.getData(2, SIDs, inference), rabaCoder, SIDs);
        this.doRoundTripTest(this.getData(10, SIDs, inference), rabaCoder, SIDs);
        for (int i = 0; i < 1000; ++i) {
            this.doRoundTripTest(this.getData(this.r.nextInt(64), SIDs, inference), rabaCoder, SIDs);
        }
        this.doRoundTripTest(this.getData(100, SIDs, inference), rabaCoder, SIDs);
        this.doRoundTripTest(this.getData(1000, SIDs, inference), rabaCoder, SIDs);
        this.doRoundTripTest(this.getData(10000, SIDs, inference), rabaCoder, SIDs);
    }

    protected void doRoundTripTest(SPO[] a, IRabaCoder rabaCoder, boolean sids) {
        SPOTupleSerializer tupleSer = new SPOTupleSerializer(SPOKeyOrder.SPO, sids);
        byte[][] vals = new byte[a.length][];
        for (int i = 0; i < a.length; ++i) {
            vals[i] = tupleSer.serializeVal(a[i]);
        }
        ReadOnlyValuesRaba expected = new ReadOnlyValuesRaba((byte[][])vals);
        DataOutputBuffer buf = new DataOutputBuffer(0);
        AbstractFixedByteArrayBuffer originalData = rabaCoder.encode((IRaba)expected, buf);
        buf.trim();
        try {
            ICodedRaba actual0 = rabaCoder.decode(originalData);
            AbstractBTreeTestCase.assertSameRaba((IRaba)expected, (IRaba)actual0);
            AbstractBTreeTestCase.assertSameRaba((IRaba)expected, (IRaba)rabaCoder.decode(actual0.data()));
            int off = 10;
            DataOutputBuffer out = new DataOutputBuffer(10, new byte[110]);
            AbstractFixedByteArrayBuffer slice = rabaCoder.encode((IRaba)expected, out);
            TestSPOValueCoders.assertEquals((byte[])originalData.toByteArray(), (byte[])slice.toByteArray());
            off = 10;
            byte[] tmp = new byte[10 + originalData.len()];
            System.arraycopy(originalData.array(), originalData.off(), tmp, 10, originalData.len());
            slice = new FixedByteArrayBuffer(tmp, 10, originalData.len());
            TestSPOValueCoders.assertEquals((byte[])originalData.toByteArray(), (byte[])slice.toByteArray());
            ICodedRaba actual = rabaCoder.decode(slice);
            AbstractBTreeTestCase.assertSameRaba((IRaba)expected, (IRaba)actual);
        }
        catch (Throwable t) {
            TestSPOValueCoders.fail((String)("Cause=" + t + ", expectedRaba=" + expected), (Throwable)t);
        }
    }
}

