/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.BTree;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ISimpleSplitHandler;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentBuilder;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.journal.IJournal;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.XXXCShardSplitHandler;
import com.bigdata.resources.AbstractTestSegSplitter;
import com.bigdata.resources.IPartitionIdFactory;
import com.bigdata.resources.SplitUtility;
import com.bigdata.service.Split;
import com.bigdata.test.MockTermIdFactory;
import com.bigdata.util.BytesUtil;
import java.util.Random;
import java.util.UUID;

public class TestXXXCShardSplitHandler
extends AbstractTestSegSplitter {
    private MockTermIdFactory factory;

    public TestXXXCShardSplitHandler() {
    }

    public TestXXXCShardSplitHandler(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new MockTermIdFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
    }

    private BTree generateQuadsData(IJournal store, String name, int ntuples, LocalPartitionMetadata pmd) {
        int i;
        assert (store != null);
        assert (pmd != null);
        byte[] fromKey = pmd.getLeftSeparatorKey();
        assert (fromKey != null);
        IndexMetadata md = new IndexMetadata(UUID.randomUUID());
        md.setPartitionMetadata(pmd);
        BTree btree = (BTree)store.registerIndex(name, md);
        Random r = new Random();
        IV[] s = new IV[Math.max(ntuples / 200, 4)];
        IV[] p = new IV[Math.max(ntuples / 500, 2)];
        IV[] o = new IV[Math.max(ntuples / 400, 5)];
        IV[] c = new IV[Math.max(ntuples / 10, 200)];
        if (log.isInfoEnabled()) {
            log.info((Object)("ntuples=" + ntuples + ", #s=" + s.length + ", #p=" + p.length + ", #o=" + o.length + ", #c=" + c.length));
        }
        long v = 0L;
        for (i = 0; i < s.length; ++i) {
            s[i] = this.factory.newTermId(VTE.URI, (long)((int)(v += (long)r.nextInt(100))));
        }
        for (i = 0; i < p.length; ++i) {
            p[i] = this.factory.newTermId(VTE.URI, (long)((int)(v += (long)r.nextInt(100))));
        }
        for (i = 0; i < o.length; ++i) {
            o[i] = this.factory.newTermId(VTE.URI, (long)((int)(v += (long)r.nextInt(100))));
        }
        for (i = 0; i < c.length; ++i) {
            c[i] = this.factory.newTermId(VTE.URI, (long)((int)(v += (long)r.nextInt(100))));
        }
        IKeyBuilder keyBuilder = KeyBuilder.newInstance();
        int ninsert = 0;
        int ntries = 0;
        while (ninsert < ntuples) {
            IV S = s[r.nextInt(s.length)];
            IV P2 = p[r.nextInt(p.length)];
            IV O = o[r.nextInt(o.length)];
            for (int i2 = 0; i2 < r.nextInt(10) + 10 && ninsert < ntuples; ++i2) {
                IV C2 = c[r.nextInt(c.length)];
                SPO spo = new SPO(S, P2, O, C2, StatementEnum.Explicit);
                byte[] key = SPOKeyOrder.SPOC.encodeKey(keyBuilder, (ISPO)spo);
                if (btree.contains(key)) continue;
                btree.insert(key, null);
                ++ninsert;
            }
            if (++ntries <= ntuples * 4) continue;
            throw new RuntimeException("Test setup is not terminating: ntuples=" + ntuples + ", ntries=" + ntries + ", ninsert=" + ninsert);
        }
        TestXXXCShardSplitHandler.assertEquals((long)ntuples, (long)btree.getEntryCount());
        store.commit();
        return (BTree)store.getIndex(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_xxxCShardSplitHandler() throws Exception {
        byte[] fromKey = new byte[]{};
        byte[] toKey = null;
        int ntuples = 10000;
        IndexSegmentBuilder builder = null;
        IJournal store = this.getStore();
        try {
            Split[] splits;
            IndexSegment seg;
            long nominalShardSize;
            int expectedSplitCount;
            LocalPartitionMetadata pmd = new LocalPartitionMetadata(this.pidFactory.nextPartitionId(this.getName()), -1, fromKey, toKey, new IResourceMetadata[]{store.getResourceMetadata()}, null);
            BTree src = this.generateQuadsData(store, this.getName(), 10000, pmd);
            builder = TestXXXCShardSplitHandler.doBuild((String)this.getName(), (ILocalBTreeView)src, (long)src.getLastCommitTime(), (byte[])fromKey, toKey);
            try (IndexSegmentStore segStore = new IndexSegmentStore(builder.outFile);){
                expectedSplitCount = 2;
                nominalShardSize = (long)((double)segStore.size() / 1.0);
                seg = segStore.loadIndexSegment();
                splits = SplitUtility.getSplits((IPartitionIdFactory)this.pidFactory, (LocalPartitionMetadata)pmd, (IndexSegment)seg, (long)nominalShardSize, (ISimpleSplitHandler)acceptAllSplits);
                SplitUtility.validateSplits((LocalPartitionMetadata)pmd, (Split[])splits, (boolean)true);
                TestXXXCShardSplitHandler.assertEquals((String)"#splits", (int)2, (int)splits.length);
            }
            try {
                expectedSplitCount = 2;
                nominalShardSize = (long)((double)segStore.size() / 1.0);
                seg = segStore.loadIndexSegment();
                splits = SplitUtility.getSplits((IPartitionIdFactory)this.pidFactory, (LocalPartitionMetadata)pmd, (IndexSegment)seg, (long)nominalShardSize, (ISimpleSplitHandler)new XXXCShardSplitHandler());
                SplitUtility.validateSplits((LocalPartitionMetadata)pmd, (Split[])splits, (boolean)true);
                TestXXXCShardSplitHandler.assertEquals((String)"#splits", (int)2, (int)splits.length);
                byte[] separatorKey = splits[0].pmd.getRightSeparatorKey();
                TestXXXCShardSplitHandler.assertNotNull((Object)separatorKey);
                IV[] terms = IVUtility.decode((byte[])separatorKey, (int)3);
                KeyBuilder keyBuilder = new KeyBuilder();
                IVUtility.encode((IKeyBuilder)keyBuilder, (IV)terms[0]);
                IVUtility.encode((IKeyBuilder)keyBuilder, (IV)terms[1]);
                IVUtility.encode((IKeyBuilder)keyBuilder, (IV)terms[2]);
                byte[] tmp = keyBuilder.getKey();
                TestXXXCShardSplitHandler.assertTrue((boolean)BytesUtil.bytesEqual((byte[])separatorKey, (byte[])tmp));
                long pos = seg.indexOf(separatorKey);
                TestXXXCShardSplitHandler.assertTrue((pos < 0L ? 1 : 0) != 0);
                long index = -pos - 1L;
                if (log.isInfoEnabled()) {
                    log.info((Object)("index=" + index));
                }
            }
            finally {
                segStore.close();
            }
        }
        finally {
            if (builder != null && !builder.outFile.delete()) {
                log.warn((Object)("Could not delete: " + builder.outFile));
            }
            store.destroy();
        }
    }
}

