/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.BatchContains;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.journal.TestHelper;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.BasicRioLoader;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOComparator;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.rdf.store.IRawTripleStore;
import com.bigdata.rdf.store.ProxyTestCase;
import com.bigdata.relation.accesspath.AbstractArrayBuffer;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.Split;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.util.BytesUtil;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestCase2;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.helpers.RDFHandlerBase;

public abstract class AbstractTestCase
extends TestCase2 {
    protected final IV NULL = null;
    private long begin;
    private Properties m_properties;

    public AbstractTestCase() {
    }

    public AbstractTestCase(String name) {
        super(name);
    }

    protected void setUp(ProxyTestCase testCase) throws Exception {
        this.begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("\n\n================:BEGIN:" + testCase.getName() + ":BEGIN:===================="));
        }
    }

    protected void tearDown(ProxyTestCase testCase) throws Exception {
        long elapsed = System.currentTimeMillis() - this.begin;
        if (log.isInfoEnabled()) {
            log.info((Object)("\n================:END:" + testCase.getName() + " (" + elapsed + "ms):END:====================\n"));
        }
        TestHelper.checkJournalsClosed((TestCase)testCase, (TestCase)this);
    }

    public Properties getProperties() {
        if (this.m_properties == null) {
            this.m_properties = super.getProperties();
            this.m_properties.setProperty(IBigdataClient.Options.COLLECT_PLATFORM_STATISTICS, "false");
            this.m_properties.setProperty(IBigdataClient.Options.COLLECT_QUEUE_STATISTICS, "false");
            this.m_properties.setProperty(IBigdataClient.Options.HTTPD_PORT, "-1");
            this.m_properties.setProperty(Journal.Options.COLLECT_PLATFORM_STATISTICS, "false");
            this.m_properties.setProperty(Journal.Options.COLLECT_QUEUE_STATISTICS, "false");
            this.m_properties.setProperty(Journal.Options.HTTPD_PORT, "-1");
            this.m_properties.setProperty(Options.BUFFER_MODE, BufferMode.Disk.toString());
            if (this.m_properties.get(Options.FILE) == null) {
                this.m_properties.setProperty(Options.CREATE_TEMP_FILE, "true");
                this.m_properties.setProperty(Options.DELETE_ON_EXIT, "true");
            }
        }
        return new Properties(this.m_properties);
    }

    protected void checkIfProxy() {
        if (this instanceof ProxyTestCase) {
            throw new AssertionError();
        }
    }

    protected abstract AbstractTripleStore getStore(Properties var1);

    protected abstract AbstractTripleStore reopenStore(AbstractTripleStore var1);

    public void assertEquals(SPO expected, SPO actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String msg, SPO expected, SPO actual) {
        if (!expected.equals((ISPO)actual)) {
            msg = msg == null ? "" : msg + " : ";
            AbstractTestCase.fail((String)(msg + "Expecting: " + expected + " not " + actual));
        }
    }

    public void assertEquals(SPO[] expected, SPO[] actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String msg, SPO[] expected, SPO[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            AbstractTestCase.fail((String)(msg + "Expected a null array."));
        }
        if (expected != null && actual == null) {
            AbstractTestCase.fail((String)(msg + "Not expecting a null array."));
        }
        if (expected.length != actual.length) {
            AbstractTestCase.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            try {
                this.assertEquals(expected[i], actual[i]);
                continue;
            }
            catch (AssertionFailedError ex) {
                AbstractTestCase.fail((String)(msg + "values differ: index=" + i), (Throwable)ex);
            }
        }
    }

    public static void assertSameSPOs(ISPO[] expected, IChunkedOrderedIterator<ISPO> actual) {
        AbstractTestCase.assertSameSPOs("", expected, actual);
    }

    public static void assertSameSPOs(String msg, ISPO[] expected, IChunkedOrderedIterator<ISPO> actual) {
        expected = (ISPO[])expected.clone();
        IKeyOrder keyOrder = actual.getKeyOrder();
        if (keyOrder != null) {
            Arrays.sort(expected, keyOrder.getComparator());
        }
        int i = 0;
        while (actual.hasNext()) {
            ISPO g;
            if (i >= expected.length) {
                Vector<Object> v = new Vector<Object>();
                while (actual.hasNext() && v.size() < 10) {
                    v.add(actual.next());
                }
                AbstractTestCase.fail((String)(msg + ": The iterator is willing to visit more than " + expected.length + " objects.  The next " + v.size() + " objects would be: " + Arrays.toString(v.toArray())));
            }
            if (!expected[i].equals(g = (ISPO)actual.next())) {
                AbstractTestCase.fail((String)(msg + ": Different objects at index=" + i + ": expected=" + expected[i] + ", actual=" + g));
            }
            ++i;
        }
        if (i < expected.length) {
            AbstractTestCase.fail((String)(msg + ": The iterator SHOULD have visited " + expected.length + " objects, but only visited " + i + " objects."));
        }
    }

    public static void assertSameSPOsAnyOrder(AbstractTripleStore store, ISPO[] expected, IChunkedOrderedIterator<ISPO> actual) {
        AbstractTestCase.assertSameSPOsAnyOrder(store, expected, actual, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertSameSPOsAnyOrder(AbstractTripleStore store, ISPO[] expected, IChunkedOrderedIterator<ISPO> actual, boolean ignoreAxioms) {
        try {
            TreeMap<ISPO, ISPO> map = new TreeMap<ISPO, ISPO>(SPOComparator.INSTANCE);
            for (ISPO tmp : expected) {
                map.put(tmp, tmp);
            }
            int i = 0;
            while (actual.hasNext()) {
                StatementEnum actualType;
                ISPO expectedSPO;
                ISPO actualSPO = (ISPO)actual.next();
                if (ignoreAxioms && actualSPO.isAxiom()) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("actual: " + actualSPO.toString((IRawTripleStore)store)));
                }
                if ((expectedSPO = (ISPO)map.remove(actualSPO)) == null) {
                    AbstractTestCase.fail((String)("Not expecting: " + actualSPO.toString((IRawTripleStore)store) + " at index=" + i));
                }
                StatementEnum expectedType = expectedSPO.hasStatementType() ? expectedSPO.getStatementType() : null;
                StatementEnum statementEnum = actualType = actualSPO.hasStatementType() ? actualSPO.getStatementType() : null;
                if (expectedType != actualType) {
                    AbstractTestCase.assertEquals((String)("expected=" + expectedSPO + ",actual=" + actualSPO), (Object)expectedType, (Object)actualType);
                }
                ++i;
            }
            if (!map.isEmpty()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Iterator empty but still expecting: " + map.values()));
                }
                AbstractTestCase.fail((String)("Expecting: " + map.size() + " more statements: " + map.values()));
            }
        }
        finally {
            actual.close();
        }
    }

    public static void assertSameStatements(Statement[] expected, BigdataStatementIterator actual) {
        AbstractTestCase.assertSameStatements("", expected, actual);
    }

    public static void assertSameStatements(String msg, Statement[] expected, BigdataStatementIterator actual) {
        int i = 0;
        while (actual.hasNext()) {
            Statement g;
            if (i >= expected.length) {
                AbstractTestCase.fail((String)(msg + ": The iterator is willing to visit more than " + expected.length + " objects."));
            }
            if (!expected[i].equals((Object)(g = (Statement)actual.next()))) {
                AbstractTestCase.fail((String)(msg + ": Different objects at index=" + i + ": expected=" + expected[i] + ", actual=" + g));
            }
            ++i;
        }
        if (i < expected.length) {
            AbstractTestCase.fail((String)(msg + ": The iterator SHOULD have visited " + expected.length + " objects, but only visited " + i + " objects."));
        }
    }

    public static void assertLexiconIndicesConsistent(AbstractTripleStore store) {
        IIndex t2id = store.getLexiconRelation().getTerm2IdIndex();
        IIndex id2t = store.getLexiconRelation().getId2TermIndex();
        BigdataValueSerializer valSer = store.getValueFactory().getValueSerializer();
        ITupleSerializer t2idTupleSer = t2id.getIndexMetadata().getTupleSerializer();
        IKeyBuilder keyBuilder = id2t.getIndexMetadata().getTupleSerializer().getKeyBuilder();
        ITupleIterator itr = t2id.rangeIterator();
        while (itr.hasNext()) {
            IV iv = (IV)itr.next().getObject();
            keyBuilder.reset();
            byte[] ivAsKey = iv.encode(keyBuilder).getKey();
            byte[] encodedValue = id2t.lookup(ivAsKey);
            AbstractTestCase.assertNotNull((Object)encodedValue);
            BigdataValue decodedValue = (BigdataValue)valSer.deserialize(encodedValue);
            byte[] term2IdKey = t2idTupleSer.serializeKey((Object)decodedValue);
            byte[] encodedIV = t2id.lookup(term2IdKey);
            if (encodedIV == null) {
                AbstractTestCase.fail((String)("No entry in TERMS index: v=" + decodedValue + ", iv=" + iv));
            }
            if (BytesUtil.bytesEqual((byte[])ivAsKey, (byte[])encodedIV)) continue;
            AbstractTestCase.fail((String)("IV: original=" + BytesUtil.toString((byte[])ivAsKey) + ", afterRoundTrip=" + BytesUtil.toString((byte[])encodedIV)));
        }
        t2idTupleSer = t2id.getIndexMetadata().getTupleSerializer();
        keyBuilder = id2t.getIndexMetadata().getTupleSerializer().getKeyBuilder();
        itr = id2t.rangeIterator();
        while (itr.hasNext()) {
            IV decodedIV;
            BigdataValue v = (BigdataValue)itr.next().getObject();
            IV iv = v.getIV();
            AbstractTestCase.assertNotNull((String)v.stringValue(), (Object)iv);
            byte[] term2IdKey = t2idTupleSer.serializeKey((Object)v);
            byte[] encodedIV = t2id.lookup(term2IdKey);
            if (encodedIV == null) {
                AbstractTestCase.fail((String)("No entry in TERMS index: v=" + v + ", iv=" + iv));
            }
            if (iv.equals(decodedIV = IVUtility.decodeFromOffset((byte[])encodedIV, (int)0))) continue;
            AbstractTestCase.fail((String)("IV: original=" + iv + ", afterRoundTrip=" + decodedIV + " for value=" + v));
        }
        long rc1 = t2id.rangeCount();
        long rc2 = id2t.rangeCount();
        AbstractTestCase.assertEquals((String)("lexicon range counts: t2id=" + rc1 + ", id2t=" + rc2), (long)rc1, (long)rc2);
    }

    public static void assertStatementIndicesConsistent(AbstractTripleStore db, int maxerrors) {
        int to;
        int from;
        if (log.isInfoEnabled()) {
            log.info((Object)"Verifying statement indices");
        }
        AtomicInteger nerrs = new AtomicInteger(0);
        if (db.getSPOKeyArity() == 3) {
            from = 0;
            to = 2;
        } else {
            from = 3;
            to = 8;
        }
        for (int i = from; i <= to; ++i) {
            for (int j = from; j <= to; ++j) {
                if (i <= j) continue;
                AbstractTestCase.assertSameStatements(db, SPOKeyOrder.valueOf((int)i), SPOKeyOrder.valueOf((int)j), nerrs, maxerrors);
            }
        }
        AbstractTestCase.assertEquals((int)0, (int)nerrs.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertSameStatements(AbstractTripleStore db, SPOKeyOrder keyOrderExpected, final SPOKeyOrder keyOrderActual, final AtomicInteger nerrs, int maxerrors) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Verifying " + keyOrderExpected + " against " + keyOrderActual));
        }
        IIndex actualIndex = db.getSPORelation().getIndex((IKeyOrder)keyOrderActual);
        SPOTupleSerializer tupleSer = (SPOTupleSerializer)actualIndex.getIndexMetadata().getTupleSerializer();
        try (IChunkedOrderedIterator itre = db.getAccessPath((IKeyOrder)keyOrderExpected).iterator();){
            while (itre.hasNext()) {
                if (nerrs.get() > 10) {
                    throw new RuntimeException("Too many errors");
                }
                final ISPO[] expectedChunk = (ISPO[])itre.nextChunk((IKeyOrder)keyOrderActual);
                boolean fromIndex = false;
                int toIndex = expectedChunk.length;
                byte[][] keys = new byte[expectedChunk.length][];
                byte[][] vals = null;
                for (int i = 0; i < expectedChunk.length; ++i) {
                    keys[i] = tupleSer.serializeKey(expectedChunk[i]);
                }
                final AtomicLong nfound = new AtomicLong();
                IResultHandler<AbstractKeyArrayIndexProcedure.ResultBitBuffer, Long> resultHandler = new IResultHandler<AbstractKeyArrayIndexProcedure.ResultBitBuffer, Long>(){

                    public void aggregate(AbstractKeyArrayIndexProcedure.ResultBitBuffer result, Split split) {
                        int n = result.getResultCount();
                        boolean[] a = result.getResult();
                        int delta = 0;
                        for (int i = 0; i < n; ++i) {
                            if (a[i]) {
                                ++delta;
                                continue;
                            }
                            ISPO expectedSPO = expectedChunk[i];
                            log.error((Object)("Statement not found: index=" + keyOrderActual + ", stmt=" + expectedSPO));
                            nerrs.incrementAndGet();
                        }
                        nfound.addAndGet(delta);
                    }

                    public Long getResult() {
                        return nfound.get();
                    }
                };
                actualIndex.submit(0, toIndex, (byte[][])keys, vals, (AbstractKeyArrayIndexProcedureConstructor)BatchContains.BatchContainsConstructor.INSTANCE, (IResultHandler)resultHandler);
            }
        }
    }

    protected void recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.recursiveDelete(children[i]);
            }
        }
        if (f.exists()) {
            log.warn((Object)("Removing: " + f));
            if (!f.delete()) {
                throw new RuntimeException("Could not remove: " + f);
            }
        }
    }

    protected static class StatementVerifier
    extends BasicRioLoader {
        private final AbstractTripleStore db;
        private final AtomicInteger nerrs;
        private final int maxerrors;
        final IBuffer<Statement> buffer;

        public StatementVerifier(AbstractTripleStore db, int capacity, AtomicInteger nerrs, int maxerrors) {
            super((ValueFactory)db.getValueFactory());
            this.db = db;
            this.nerrs = nerrs;
            this.maxerrors = maxerrors;
            this.buffer = new AbstractArrayBuffer<Statement>(capacity, Statement.class, null){

                protected long flush(int n, Statement[] a) {
                    StatementVerifier.this.verifyStatements(n, a);
                    return n;
                }
            };
        }

        private void error(String msg) {
            log.error((Object)msg);
            if (this.nerrs.incrementAndGet() > this.maxerrors) {
                throw new RuntimeException("Too many errors");
            }
        }

        protected void success() {
            super.success();
            this.buffer.flush();
        }

        public RDFHandler newRDFHandler() {
            return new RDFHandlerBase(){

                public void handleStatement(Statement stmt) {
                    StatementVerifier.this.buffer.add((Object)stmt);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyStatements(int n, Statement[] a) {
            LinkedHashMap<Object, Object> termSet = new LinkedHashMap<Object, Object>(n);
            for (int i = 0; i < n; ++i) {
                Statement stmt = a[i];
                termSet.put(stmt.getSubject(), this.db.getValueFactory().asValue(stmt.getSubject()));
                termSet.put(stmt.getPredicate(), this.db.getValueFactory().asValue(stmt.getPredicate()));
                termSet.put(stmt.getObject(), this.db.getValueFactory().asValue(stmt.getObject()));
            }
            int nterms = termSet.size();
            BigdataValue[] terms = new BigdataValue[nterms];
            int i = 0;
            for (BigdataValue term : termSet.values()) {
                terms[i++] = term;
            }
            this.db.getLexiconRelation().addTerms(terms, nterms, true);
            int nunknown = 0;
            for (BigdataValue term : terms) {
                if (term.getIV() != null) continue;
                this.error("Unknown term: " + term);
                ++nunknown;
            }
            if (nunknown > 0) {
                log.warn((Object)("" + nunknown + " out of " + nterms + " terms were not found."));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("There are " + termSet.size() + " distinct terms in the parsed statements."));
            }
            LinkedHashSet<IV> ivs = new LinkedHashSet<IV>(termSet.size());
            for (BigdataValue term : termSet.values()) {
                IV iv = term.getIV();
                if (iv == null || iv.isNullIV()) continue;
                ivs.add(iv);
            }
            Map reverseMap = this.db.getLexiconRelation().getTerms(ivs);
            for (BigdataValue expectedTerm : termSet.values()) {
                BigdataValue actualTerm;
                IV iv = expectedTerm.getIV();
                if (iv == null || (actualTerm = (BigdataValue)reverseMap.get(iv)) != null && actualTerm.equals(expectedTerm)) continue;
                this.error("expectedTerm=" + expectedTerm + ", assigned termId=" + iv + ", but reverse lookup reports: " + actualTerm);
            }
            SPO[] b = new SPO[n];
            int n2 = 0;
            for (i = 0; i < n; ++i) {
                Statement stmt = a[i];
                BigdataResource s = (BigdataResource)this.db.asValue((Value)termSet.get(stmt.getSubject()));
                BigdataURI p = (BigdataURI)this.db.asValue((Value)termSet.get(stmt.getPredicate()));
                BigdataValue o = this.db.asValue((Value)termSet.get(stmt.getObject()));
                boolean ok = true;
                if (s == null) {
                    log.error((Object)("Subject not found: " + stmt.getSubject()));
                    ok = false;
                }
                if (p == null) {
                    log.error((Object)("Predicate not found: " + stmt.getPredicate()));
                    ok = false;
                }
                if (o == null) {
                    log.error((Object)("Object not found: " + stmt.getObject()));
                    ok = false;
                }
                if (!ok) {
                    log.error((Object)("Unable to resolve statement with unresolvable terms: " + stmt));
                    continue;
                }
                b[n2++] = new SPO(s.getIV(), p.getIV(), o.getIV());
            }
            try (IChunkedOrderedIterator itr = this.db.bulkCompleteStatements(b, n2);){
                int i2 = 0;
                while (itr.hasNext()) {
                    ISPO spo = (ISPO)itr.next();
                    if (!spo.hasStatementType()) {
                        this.error("Statement not found: " + spo.toString((IRawTripleStore)this.db));
                    }
                    ++i2;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Verified " + i2 + " statements parsed from file."));
                }
            }
        }
    }
}

