/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.store.AbstractTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import junit.extensions.proxy.IProxyTest;
import junit.framework.Test;

public abstract class ProxyTestCase
extends AbstractTestCase
implements IProxyTest {
    private Test m_delegate = null;

    public ProxyTestCase() {
    }

    public ProxyTestCase(String name) {
        super(name);
    }

    public void setDelegate(Test delegate) {
        this.m_delegate = delegate;
    }

    public Test getDelegate() throws IllegalStateException {
        return this.m_delegate;
    }

    public AbstractTestCase getOurDelegate() {
        if (this.m_delegate == null) {
            String testClass = System.getProperty("testClass");
            if (testClass == null) {
                throw new IllegalStateException("testClass: property not defined, could not configure delegate.");
            }
            try {
                Class<?> cl = Class.forName(testClass);
                this.m_delegate = (Test)cl.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.m_delegate instanceof AbstractTestCase) {
            return (AbstractTestCase)this.m_delegate;
        }
        throw new IllegalStateException("The delegate MUST extend " + AbstractTestCase.class.getName() + ", not " + this.m_delegate.getClass().getName());
    }

    protected void setUp() throws Exception {
        this.getOurDelegate().setUp(this);
    }

    protected void tearDown() throws Exception {
        this.getOurDelegate().tearDown(this);
    }

    @Override
    public Properties getProperties() {
        return this.getOurDelegate().getProperties();
    }

    protected AbstractTripleStore getStore() {
        return this.getOurDelegate().getStore(this.getProperties());
    }

    @Override
    protected AbstractTripleStore getStore(Properties properties) {
        return this.getOurDelegate().getStore(properties);
    }

    @Override
    protected AbstractTripleStore reopenStore(AbstractTripleStore store) {
        return this.getOurDelegate().reopenStore(store);
    }
}

