/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class StressTestCentos
extends AbstractTripleStoreTestCase {
    @Override
    public Properties getProperties() {
        Properties properties = new Properties(super.getProperties());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.STORE_BLANK_NODES, "true");
        properties.setProperty(AbstractTripleStore.Options.JUSTIFY, "false");
        properties.setProperty(AbstractTripleStore.Options.BLOOM_FILTER, "false");
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_stress() {
        AbstractTripleStore store = this.getStore(this.getProperties());
        try {
            if (!store.isQuads()) {
                return;
            }
            int N = 1000;
            int M = 100;
            for (int k = 0; k < 1000; ++k) {
                StatementBuffer sb = new StatementBuffer(store, 20000);
                BigdataURI g = store.getValueFactory().createURI("http://test/g" + k);
                for (int l = 0; l < 100; ++l) {
                    BigdataURI s = store.getValueFactory().createURI("http://test/s" + l % 99);
                    BigdataURI p = store.getValueFactory().createURI("http://test/p" + l % 37);
                    BigdataURI o = store.getValueFactory().createURI("http://test/o" + l % 399);
                    sb.add((Statement)store.getValueFactory().createStatement((Resource)s, (URI)p, (Value)o, (Resource)g, StatementEnum.Explicit));
                }
                sb.flush();
                store.commit();
                AbstractTripleStore readStore = (AbstractTripleStore)store.getIndexManager().getResourceLocator().locate(store.getNamespace(), TimestampUtility.asHistoricalRead((long)store.getIndexManager().getLastCommitTime()));
                int size = 0;
                BigdataStatementIterator iter = readStore.getStatements(null, null, null, (Resource)g);
                while (iter.hasNext()) {
                    iter.next();
                    ++size;
                }
                System.err.println("Size=" + size);
                StressTestCentos.assertEquals((String)"size", (int)100, (int)size);
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

