/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.btree.IIndex;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import java.util.Properties;

public class TestBlobsConfiguration
extends AbstractTripleStoreTestCase {
    public TestBlobsConfiguration() {
    }

    public TestBlobsConfiguration(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_blobsSupport_defaultConfiguration() {
        AbstractTripleStore store = this.getStore();
        try {
            IIndex blobsIndex = store.getLexiconRelation().getBlobsIndex();
            TestBlobsConfiguration.assertNotNull((Object)blobsIndex);
            TestBlobsConfiguration.assertEquals((int)store.getLexiconRelation().getLexiconConfiguration().getBlobsThreshold(), (int)Integer.valueOf("256"));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_blobsSupport_nonDefaultBlobsIndexThresholdConfiguration() {
        Properties p = new Properties(this.getProperties());
        int overrideThreshold = Integer.valueOf("256") * 2;
        p.setProperty(AbstractTripleStore.Options.BLOBS_THRESHOLD, Integer.toString(overrideThreshold));
        AbstractTripleStore store = this.getStore(p);
        try {
            IIndex blobsIndex = store.getLexiconRelation().getBlobsIndex();
            TestBlobsConfiguration.assertNotNull((Object)blobsIndex);
            TestBlobsConfiguration.assertEquals((int)store.getLexiconRelation().getLexiconConfiguration().getBlobsThreshold(), (int)overrideThreshold);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_blobsSupport_noBlobsIndexConfiguration() {
        Properties p = new Properties(this.getProperties());
        p.setProperty(AbstractTripleStore.Options.BLOBS_THRESHOLD, Integer.toString(Integer.MAX_VALUE));
        AbstractTripleStore store = this.getStore(p);
        try {
            block5: {
                try {
                    store.getLexiconRelation().getBlobsIndex();
                    TestBlobsConfiguration.fail((String)("Expecting: " + IllegalStateException.class));
                }
                catch (IllegalStateException ex) {
                    if (!log.isInfoEnabled()) break block5;
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
            TestBlobsConfiguration.assertEquals((int)store.getLexiconRelation().getLexiconConfiguration().getBlobsThreshold(), (int)Integer.MAX_VALUE);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

