/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.striterator.IChunkedOrderedIterator;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

public class TestBulkFilter
extends AbstractTripleStoreTestCase {
    public TestBulkFilter() {
    }

    public TestBulkFilter(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_filterOut() {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.bigdata.com/A");
            URIImpl B = new URIImpl("http://www.bigdata.com/B");
            URIImpl C2 = new URIImpl("http://www.bigdata.com/C");
            URIImpl D = new URIImpl("http://www.bigdata.com/D");
            URIImpl E = new URIImpl("http://www.bigdata.com/E");
            URIImpl V = new URIImpl("http://www.bigdata.com/V");
            URIImpl W = new URIImpl("http://www.bigdata.com/W");
            URIImpl X = new URIImpl("http://www.bigdata.com/X");
            URIImpl Y = new URIImpl("http://www.bigdata.com/Y");
            URIImpl Z = new URIImpl("http://www.bigdata.com/Z");
            store.addTerm((Value)A);
            store.addTerm((Value)B);
            store.addTerm((Value)C2);
            store.addTerm((Value)D);
            store.addTerm((Value)E);
            store.addTerm((Value)V);
            store.addTerm((Value)W);
            store.addTerm((Value)X);
            store.addTerm((Value)Y);
            store.addTerm((Value)Z);
            store.addStatement((Resource)X, (URI)A, (Value)Y);
            store.addStatement((Resource)X, (URI)A, (Value)Z);
            IV a = store.getIV((Value)A);
            IV v = store.getIV((Value)V);
            IV w = store.getIV((Value)W);
            IV x = store.getIV((Value)X);
            IV y = store.getIV((Value)Y);
            IV z = store.getIV((Value)Z);
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore(true, true, false)));
            }
            SPO[] stmts = new SPO[]{new SPO(x, a, y, StatementEnum.Explicit), new SPO(x, a, z, StatementEnum.Explicit), new SPO(x, a, v, StatementEnum.Explicit), new SPO(x, a, w, StatementEnum.Explicit)};
            int numStmts = stmts.length;
            boolean present = false;
            IChunkedOrderedIterator itr = store.bulkFilterStatements((ISPO[])stmts, numStmts, present);
            TestBulkFilter.assertSameSPOsAnyOrder(store, (ISPO[])new SPO[]{new SPO(x, a, v, StatementEnum.Explicit), new SPO(x, a, w, StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)itr, true);
            present = true;
            itr = store.bulkFilterStatements((ISPO[])stmts, numStmts, present);
            TestBulkFilter.assertSameSPOsAnyOrder(store, (ISPO[])new SPO[]{new SPO(x, a, y, StatementEnum.Explicit), new SPO(x, a, z, StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)itr, true);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompletion() {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.bigdata.com/A");
            URIImpl V = new URIImpl("http://www.bigdata.com/V");
            URIImpl W = new URIImpl("http://www.bigdata.com/W");
            URIImpl X = new URIImpl("http://www.bigdata.com/X");
            URIImpl Y = new URIImpl("http://www.bigdata.com/Y");
            URIImpl Z = new URIImpl("http://www.bigdata.com/Z");
            IV a = store.addTerm((Value)A);
            IV v = store.addTerm((Value)V);
            IV w = store.addTerm((Value)W);
            IV x = store.addTerm((Value)X);
            IV y = store.addTerm((Value)Y);
            IV z = store.addTerm((Value)Z);
            SPO[] stmts = new SPO[]{new SPO(x, a, y, StatementEnum.Explicit), new SPO(x, a, z, StatementEnum.Inferred)};
            int numStmts = stmts.length;
            store.addStatements((ISPO[])stmts, numStmts);
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore(true, true, false)));
            }
            stmts = new SPO[]{new SPO(x, a, y), new SPO(x, a, z), new SPO(x, a, v), new SPO(x, a, w)};
            numStmts = stmts.length;
            IChunkedOrderedIterator itr = store.bulkCompleteStatements(stmts, numStmts);
            TestBulkFilter.assertSameSPOsAnyOrder(store, (ISPO[])new SPO[]{new SPO(x, a, y, StatementEnum.Explicit), new SPO(x, a, z, StatementEnum.Inferred), new SPO(x, a, v, StatementEnum.Inferred), new SPO(x, a, w, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr, true);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

