/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.store.DataLoader;
import com.bigdata.util.InnerCause;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class TestDataLoader
extends AbstractTripleStoreTestCase {
    public TestDataLoader() {
    }

    public TestDataLoader(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_DataLoader_loadResource01() throws IOException {
        AbstractTripleStore store = this.getStore();
        try {
            DataLoader dataLoader = new DataLoader(store);
            String resource = "com/bigdata/rdf/store/sample-data.ttl";
            String baseURL = new File("com/bigdata/rdf/store/sample-data.ttl").toURI().toString();
            dataLoader.loadData(new String[]{"com/bigdata/rdf/store/sample-data.ttl"}, new String[]{baseURL}, new RDFFormat[]{RDFFormat.TURTLE});
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_DataLoader_ignoreFailures01() throws IOException {
        boolean ok = false;
        String resource = "com/bigdata/rdf/store/sample-data-bad.ttl";
        AbstractTripleStore store = this.getStore();
        try {
            DataLoader dataLoader = new DataLoader(store);
            String baseURL = new File("com/bigdata/rdf/store/sample-data-bad.ttl").toURI().toString();
            dataLoader.loadData(new String[]{"com/bigdata/rdf/store/sample-data-bad.ttl"}, new String[]{baseURL}, new RDFFormat[]{RDFFormat.TURTLE});
            ok = true;
        }
        catch (Throwable t) {
            if (!InnerCause.isInnerCause((Throwable)t, RDFParseException.class)) {
                TestDataLoader.fail((String)("Expected inner cause " + RDFParseException.class + " not found in " + t), (Throwable)t);
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
        if (ok) {
            TestDataLoader.fail((String)"Error should have been reported for com/bigdata/rdf/store/sample-data-bad.ttl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_DataLoader_ignoreFailures02() throws IOException {
        AbstractTripleStore store = this.getStore();
        try {
            Properties properties = new Properties(store.getProperties());
            properties.setProperty(DataLoader.Options.IGNORE_INVALID_FILES, "true");
            DataLoader dataLoader = new DataLoader(properties, store);
            String resource = "com/bigdata/rdf/store/sample-data-bad.ttl";
            String baseURL = new File("com/bigdata/rdf/store/sample-data-bad.ttl").toURI().toString();
            dataLoader.loadData(new String[]{"com/bigdata/rdf/store/sample-data-bad.ttl"}, new String[]{baseURL}, new RDFFormat[]{RDFFormat.TURTLE});
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_DataLoader_ignoreFailures03() throws IOException {
        AbstractTripleStore store = this.getStore();
        try {
            Properties properties = new Properties(store.getProperties());
            properties.setProperty(DataLoader.Options.IGNORE_INVALID_FILES, "true");
            DataLoader dataLoader = new DataLoader(properties, store);
            String resource = "com/bigdata/rdf/store/sample-data-DOES-NOT-EXIST.ttl";
            String baseURL = new File("com/bigdata/rdf/store/sample-data-DOES-NOT-EXIST.ttl").toURI().toString();
            try {
                dataLoader.loadData(new String[]{"com/bigdata/rdf/store/sample-data-DOES-NOT-EXIST.ttl"}, new String[]{baseURL}, new RDFFormat[]{RDFFormat.TURTLE});
                TestDataLoader.fail();
            }
            catch (IOException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_durableQueues01_incrementalCommit_noClosure() throws IOException {
        AbstractTripleStore store = this.getStore();
        try {
            Properties properties = new Properties(store.getProperties());
            properties.setProperty(DataLoader.Options.DURABLE_QUEUES, "true");
            properties.setProperty(DataLoader.Options.COMMIT, DataLoader.CommitEnum.Incremental.name());
            properties.setProperty(DataLoader.Options.CLOSURE, DataLoader.ClosureEnum.None.name());
            DataLoader dataLoader = new DataLoader(properties, store);
            this.doDurableQueueTest(dataLoader);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_durableQueues01_incrementalCommit_batchClosure() throws IOException {
        AbstractTripleStore store = this.getStore();
        try {
            Properties properties = new Properties(store.getProperties());
            properties.setProperty(DataLoader.Options.DURABLE_QUEUES, "true");
            properties.setProperty(DataLoader.Options.COMMIT, DataLoader.CommitEnum.Incremental.name());
            properties.setProperty(DataLoader.Options.CLOSURE, DataLoader.ClosureEnum.Batch.name());
            DataLoader dataLoader = new DataLoader(properties, store);
            this.doDurableQueueTest(dataLoader);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_durableQueues02_batchCommit_batchClosure() throws IOException {
        AbstractTripleStore store = this.getStore();
        try {
            Properties properties = new Properties(store.getProperties());
            properties.setProperty(DataLoader.Options.DURABLE_QUEUES, "true");
            properties.setProperty(DataLoader.Options.COMMIT, DataLoader.CommitEnum.Batch.name());
            properties.setProperty(DataLoader.Options.CLOSURE, DataLoader.ClosureEnum.Batch.name());
            DataLoader dataLoader = new DataLoader(properties, store);
            this.doDurableQueueTest(dataLoader);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_durableQueues02_batchCommit_noClosure() throws IOException {
        AbstractTripleStore store = this.getStore();
        try {
            Properties properties = new Properties(store.getProperties());
            properties.setProperty(DataLoader.Options.DURABLE_QUEUES, "true");
            properties.setProperty(DataLoader.Options.COMMIT, DataLoader.CommitEnum.Batch.name());
            properties.setProperty(DataLoader.Options.CLOSURE, DataLoader.ClosureEnum.None.name());
            DataLoader dataLoader = new DataLoader(properties, store);
            this.doDurableQueueTest(dataLoader);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_durableQueues02_batchCommit_incrementalClosure() throws IOException {
        AbstractTripleStore store = this.getStore();
        try {
            Properties properties = new Properties(store.getProperties());
            properties.setProperty(DataLoader.Options.DURABLE_QUEUES, "true");
            properties.setProperty(DataLoader.Options.COMMIT, DataLoader.CommitEnum.Batch.name());
            properties.setProperty(DataLoader.Options.CLOSURE, DataLoader.ClosureEnum.Incremental.name());
            DataLoader dataLoader = new DataLoader(properties, store);
            this.doDurableQueueTest(dataLoader);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDurableQueueTest(DataLoader dataLoader) throws IOException {
        File tmpDir = File.createTempFile(((Object)((Object)this)).getClass().getName(), ".tmp");
        try {
            File tmp;
            tmpDir.delete();
            tmpDir.mkdir();
            File goodFile = new File(tmpDir, "good.ttl");
            File failFile = new File(tmpDir, "fail.ttl");
            String goodData = "@prefix bd: <http://www.bigdata.com/> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix foaf: <http://xmlns.com/foaf/0.1/> .\nbd:Mike rdf:type foaf:Person .\nbd:Bryan rdf:type foaf:Person .\nbd:Martyn rdf:type foaf:Person .\nbd:Mike rdfs:label \"Mike\" .\nbd:Bryan rdfs:label \"Bryan\" .\nbd:DC rdfs:label \"DC\" .\nbd:Mike foaf:knows bd:Bryan .\nbd:Bryan foaf:knows bd:Mike .\nbd:Bryan foaf:knows bd:Martyn .\nbd:Martyn foaf:knows bd:Bryan .\n";
            this.writeOnFile(goodFile, "@prefix bd: <http://www.bigdata.com/> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix foaf: <http://xmlns.com/foaf/0.1/> .\nbd:Mike rdf:type foaf:Person .\nbd:Bryan rdf:type foaf:Person .\nbd:Martyn rdf:type foaf:Person .\nbd:Mike rdfs:label \"Mike\" .\nbd:Bryan rdfs:label \"Bryan\" .\nbd:DC rdfs:label \"DC\" .\nbd:Mike foaf:knows bd:Bryan .\nbd:Bryan foaf:knows bd:Mike .\nbd:Bryan foaf:knows bd:Martyn .\nbd:Martyn foaf:knows bd:Bryan .\n");
            String failData = "@prefix bd: <http://www.bigdata.com/> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix foaf: <http://xmlns.com/foaf/0.1/> .\n\"Mike\" rdf:type foaf:Person .\nbd:Bryan rdf:type foaf:Person .\nbd:Martyn rdf:type foaf:Person .\nbd:Mike rdfs:label \"Mike\" .\nbd:Bryan rdfs:label \"Bryan\" .\nbd:DC rdfs:label \"DC\" .\nbd:Mike foaf:knows bd:Bryan .\nbd:Bryan foaf:knows bd:Mike .\nbd:Bryan foaf:knows bd:Martyn .\nbd:Martyn foaf:knows bd:Bryan .\n";
            this.writeOnFile(failFile, "@prefix bd: <http://www.bigdata.com/> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix foaf: <http://xmlns.com/foaf/0.1/> .\n\"Mike\" rdf:type foaf:Person .\nbd:Bryan rdf:type foaf:Person .\nbd:Martyn rdf:type foaf:Person .\nbd:Mike rdfs:label \"Mike\" .\nbd:Bryan rdfs:label \"Bryan\" .\nbd:DC rdfs:label \"DC\" .\nbd:Mike foaf:knows bd:Bryan .\nbd:Bryan foaf:knows bd:Mike .\nbd:Bryan foaf:knows bd:Martyn .\nbd:Martyn foaf:knows bd:Bryan .\n");
            dataLoader.loadFiles(tmpDir, null, RDFFormat.TURTLE, null, new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".ttl");
                }
            });
            if (goodFile.exists()) {
                TestDataLoader.fail((String)("File was not renamed: " + goodFile));
            }
            if (failFile.exists()) {
                TestDataLoader.fail((String)("File was not renamed: " + failFile));
            }
            if (!(tmp = new File(goodFile.getPath() + ".good")).exists()) {
                TestDataLoader.fail((String)("File not found: " + tmp));
            }
            if (!(tmp = new File(failFile.getPath() + ".fail")).exists()) {
                TestDataLoader.fail((String)("File not found: " + tmp));
            }
        }
        finally {
            this.recursiveDelete(tmpDir);
        }
    }

    private void writeOnFile(File file, String data) throws IOException {
        file.createNewFile();
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            bufferedWriter.write(data);
            bufferedWriter.flush();
        }
    }
}

