/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.InlineLiteralIV;
import com.bigdata.rdf.internal.InlinePrefixedIntegerURIHandler;
import com.bigdata.rdf.internal.InlineSignedIntegerURIHandler;
import com.bigdata.rdf.internal.InlineSuffixedIntegerURIHandler;
import com.bigdata.rdf.internal.InlineURIFactory;
import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.InlineUUIDURIHandler;
import com.bigdata.rdf.internal.InlineUnsignedIntegerURIHandler;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.IPv4AddrIV;
import com.bigdata.rdf.internal.impl.literal.LiteralArrayIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.vocab.BaseVocabularyDecl;
import com.bigdata.rdf.vocab.VocabularyDecl;
import com.bigdata.rdf.vocab.core.BigdataCoreVocabulary_v20151106;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestInlineURIs
extends AbstractTripleStoreTestCase {
    protected static final Logger log = Logger.getLogger(TestInlineURIs.class);
    private static final String CUSTOM_NAMESPACE = "application:id:";
    private static final String SIGNED_INT_NAMESPACE = "http://example.com/int/";
    private static final String UNSIGNED_INT_NAMESPACE = "http://example.com/uint/";
    private static final String SUFFIXED_INT_NAMESPACE = "http://example.com/intsuf/";
    private static final String PREFIXED_INT_NAMESPACE = "http://example.com/intprefix/";
    private static final String PREFIX = "prefix-";
    private static final String SUFFIX = "-suffix";
    private static final String ARRAY = "myapp:array:";

    @Override
    public Properties getProperties() {
        Properties props = new Properties(super.getProperties());
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestInlineURIs() {
    }

    public TestInlineURIs(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInlineUUIDs() throws Exception {
        AbstractTripleStore store = this.getStore(this.getProperties());
        try {
            BigdataValueFactory vf = store.getValueFactory();
            BigdataURI uri1 = vf.createURI("urn:uuid:" + UUID.randomUUID().toString());
            BigdataURI uri2 = vf.createURI("urn:uuid:" + UUID.randomUUID().toString());
            BigdataURI uri3 = vf.createURI("urn:uuid:foo");
            StatementBuffer sb = new StatementBuffer(store, 10);
            sb.add((Resource)uri1, RDF.TYPE, (Value)XSD.UUID);
            sb.add((Resource)uri2, RDF.TYPE, (Value)XSD.UUID);
            sb.add((Resource)uri3, RDF.TYPE, (Value)XSD.UUID);
            sb.flush();
            store.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)store.dumpStore());
            }
            TestInlineURIs.assertTrue((boolean)uri1.getIV().isInline());
            TestInlineURIs.assertTrue((boolean)uri2.getIV().isInline());
            TestInlineURIs.assertFalse((boolean)uri3.getIV().isInline());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInlineIPv4s() throws Exception {
        AbstractTripleStore store = this.getStore(this.getProperties());
        try {
            BigdataValueFactory vf = store.getValueFactory();
            BigdataURI uri1 = vf.createURI("urn:ipv4:10.128.1.2");
            BigdataURI uri2 = vf.createURI("urn:ipv4:10.128.1.2/24");
            BigdataURI uri3 = vf.createURI("urn:ipv4:500.425.1.2");
            BigdataURI uri4 = vf.createURI("urn:ipv4");
            BigdataLiteral l = vf.createLiteral("10.128.1.2", XSD.IPV4);
            StatementBuffer sb = new StatementBuffer(store, 10);
            sb.add((Resource)uri1, RDF.TYPE, (Value)XSD.IPV4);
            sb.add((Resource)uri2, RDF.TYPE, (Value)XSD.IPV4);
            sb.add((Resource)uri3, RDF.TYPE, (Value)XSD.IPV4);
            sb.add((Resource)uri4, RDFS.LABEL, (Value)l);
            sb.flush();
            store.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + store.dumpStore()));
            }
            TestInlineURIs.assertTrue((boolean)uri1.getIV().isInline());
            TestInlineURIs.assertTrue((boolean)uri2.getIV().isInline());
            TestInlineURIs.assertFalse((boolean)uri3.getIV().isInline());
            TestInlineURIs.assertFalse((boolean)uri4.getIV().isInline());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomUUIDNamespace() throws Exception {
        Properties props = new Properties(this.getProperties());
        props.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, CustomVocab.class.getName());
        props.setProperty(AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS, CustomInlineURIFactory.class.getName());
        AbstractTripleStore store = this.getStore(props);
        try {
            BigdataValueFactory vf = store.getValueFactory();
            BigdataURI uri1 = vf.createURI(CUSTOM_NAMESPACE + UUID.randomUUID().toString());
            BigdataURI uri2 = vf.createURI(CUSTOM_NAMESPACE + UUID.randomUUID().toString());
            BigdataURI uri3 = vf.createURI("application:id:foo");
            StatementBuffer sb = new StatementBuffer(store, 10);
            sb.add((Resource)uri1, RDF.TYPE, (Value)XSD.UUID);
            sb.add((Resource)uri2, RDF.TYPE, (Value)XSD.UUID);
            sb.add((Resource)uri3, RDF.TYPE, (Value)XSD.UUID);
            sb.flush();
            store.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)store.dumpStore());
            }
            TestInlineURIs.assertTrue((boolean)uri1.getIV().isInline());
            TestInlineURIs.assertTrue((boolean)uri2.getIV().isInline());
            TestInlineURIs.assertFalse((boolean)uri3.getIV().isInline());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public void testSignedInteger() throws Exception {
        this.uriRoundtripTestCase("http://example.com/int/1", true, "http://example.com/int/-123", true, "http://example.com/int/-123342343214", true, "http://example.com/int/123342343214", true, "http://example.com/int/127", true, "http://example.com/int/-128", true, "http://example.com/int/32767", true, "http://example.com/int/-32768", true, "http://example.com/int/2147483647", true, "http://example.com/int/-2147483648", true, "http://example.com/int/9223372036854775807", true, "http://example.com/int/-9223372036854775808", true, "http://example.com/int/19223372036854775807", true, "http://example.com/int/foo", false);
    }

    public void testUnsignedInteger() throws Exception {
        this.uriRoundtripTestCase("http://example.com/uint/1", true, "http://example.com/uint/-123", false, "http://example.com/uint/-123342343214", false, "http://example.com/uint/123342343214", true, "http://example.com/uint/127", true, "http://example.com/uint/32767", true, "http://example.com/uint/2147483647", true, "http://example.com/uint/9223372036854775807", true, "http://example.com/uint/19223372036854775807", true, "http://example.com/uint/foo", false);
    }

    public void testSuffixedInteger() throws Exception {
        this.uriRoundtripTestCase("http://example.com/intsuf/1-suffix", true, "http://example.com/intsuf/1", false, "http://example.com/intsuf/foo-suffix", false, "http://example.com/intsuf/-suffix", false, "http://example.com/intsuf/foo", false);
    }

    public void testPrefixedInteger() throws Exception {
        this.uriRoundtripTestCase("http://example.com/intprefix/prefix-1", true, "http://example.com/intprefix/1", false, "http://example.com/intprefix/prefix-foo", false, "http://example.com/intprefix/prefix-", false, "http://example.com/intprefix/foo", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uriRoundtripTestCase(Object ... options) throws Exception {
        Properties props = new Properties(this.getProperties());
        props.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, CustomVocab.class.getName());
        props.setProperty(AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS, CustomInlineURIFactory.class.getName());
        AbstractTripleStore store = this.getStore(props);
        try {
            BigdataValueFactory vf = store.getValueFactory();
            ArrayList<BigdataURI> uris = new ArrayList<BigdataURI>();
            StatementBuffer sb = new StatementBuffer(store, 10);
            for (int i = 0; i < options.length; i += 2) {
                BigdataURI uri = vf.createURI((String)options[i]);
                uris.add(uri);
                sb.add((Resource)uri, RDF.TYPE, (Value)vf.createLiteral("doesn't matter"));
            }
            sb.flush();
            store.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)store.dumpStore());
            }
            int i = 0;
            int j = 0;
            while (i < options.length) {
                Object givenOption = options[i];
                boolean isInline = (Boolean)options[i + 1];
                BigdataURI uri = (BigdataURI)uris.get(j);
                TestInlineURIs.assertEquals((String)("String representation different for:  " + givenOption), (Object)givenOption, (Object)uri.stringValue());
                TestInlineURIs.assertEquals((String)("Inline expectation different for:  " + givenOption), (boolean)isInline, (boolean)uri.getIV().isInline());
                i += 2;
                ++j;
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipurposeIDNamespace() throws Exception {
        Properties props = new Properties(this.getProperties());
        props.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, CustomVocab.class.getName());
        props.setProperty(AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS, MultipurposeInlineIDFactory.class.getName());
        AbstractTripleStore store = this.getStore(props);
        try {
            BigdataValueFactory vf = store.getValueFactory();
            BigdataURI uri1 = vf.createURI(CUSTOM_NAMESPACE + UUID.randomUUID().toString());
            BigdataURI uri2 = vf.createURI("application:id:1");
            BigdataURI uri3 = vf.createURI("application:id:32767");
            BigdataURI uri4 = vf.createURI("application:id:2147483647");
            BigdataURI uri5 = vf.createURI("application:id:9223372036854775807");
            BigdataURI uri6 = vf.createURI("application:id:2.3");
            BigdataURI uri7 = vf.createURI("application:id:foo");
            StatementBuffer sb = new StatementBuffer(store, 10);
            sb.add((Resource)uri1, RDF.TYPE, (Value)RDFS.RESOURCE);
            sb.add((Resource)uri2, RDF.TYPE, (Value)RDFS.RESOURCE);
            sb.add((Resource)uri3, RDF.TYPE, (Value)RDFS.RESOURCE);
            sb.add((Resource)uri4, RDF.TYPE, (Value)RDFS.RESOURCE);
            sb.add((Resource)uri5, RDF.TYPE, (Value)RDFS.RESOURCE);
            sb.add((Resource)uri6, RDF.TYPE, (Value)RDFS.RESOURCE);
            sb.add((Resource)uri7, RDF.TYPE, (Value)RDFS.RESOURCE);
            sb.flush();
            store.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)store.dumpStore());
            }
            for (BigdataURI uri : new BigdataURI[]{uri1, uri2, uri3, uri4, uri5, uri6, uri7}) {
                TestInlineURIs.assertTrue((boolean)uri.getIV().isInline());
            }
            TestInlineURIs.assertEquals((Object)DTE.UUID, (Object)uri1.getIV().getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDByte, (Object)uri2.getIV().getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDShort, (Object)uri3.getIV().getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDInt, (Object)uri4.getIV().getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDLong, (Object)uri5.getIV().getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDDouble, (Object)uri6.getIV().getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDString, (Object)uri7.getIV().getDTE());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInlineArray() throws Exception {
        Properties props = new Properties(this.getProperties());
        props.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, CustomVocab.class.getName());
        props.setProperty(AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS, InlineArrayFactory.class.getName());
        AbstractTripleStore store = this.getStore(props);
        try {
            BigdataValueFactory vf = store.getValueFactory();
            Object[] array = new Object[]{UUID.randomUUID(), "1", (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, "2.3", "foo"};
            StringBuilder sb = new StringBuilder();
            sb.append(ARRAY);
            for (Object o : array) {
                sb.append(o);
                sb.append(':');
            }
            sb.setLength(sb.length() - 1);
            BigdataURI uri1 = vf.createURI(sb.toString());
            StatementBuffer buf = new StatementBuffer(store, 10);
            buf.add((Resource)uri1, RDF.TYPE, (Value)RDFS.RESOURCE);
            buf.flush();
            store.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)store.dumpStore());
            }
            for (BigdataURI uri : new BigdataURI[]{uri1}) {
                TestInlineURIs.assertTrue((boolean)uri.getIV().isInline());
            }
            TestInlineURIs.assertEquals((Object)DTE.Extension, (Object)uri1.getIV().getDTE());
            InlineLiteralIV[] ivs = ((LiteralArrayIV)((URIExtensionIV)uri1.getIV()).getLocalNameIV()).getIVs();
            TestInlineURIs.assertEquals((Object)DTE.UUID, (Object)ivs[0].getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDByte, (Object)ivs[1].getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDShort, (Object)ivs[2].getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDInt, (Object)ivs[3].getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDLong, (Object)ivs[4].getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDDouble, (Object)ivs[5].getDTE());
            TestInlineURIs.assertEquals((Object)DTE.XSDString, (Object)ivs[6].getDTE());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public static class InlineArrayHandler
    extends MultipurposeInlineIDHandler {
        public InlineArrayHandler(String namespace) {
            super(namespace);
        }

        @Override
        protected AbstractLiteralIV createInlineIV(String localName) {
            LinkedList<AbstractLiteralIV> list = new LinkedList<AbstractLiteralIV>();
            StringTokenizer st = new StringTokenizer(localName, ":");
            while (st.hasMoreTokens()) {
                list.add(super.createInlineIV(st.nextToken()));
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException();
            }
            return new LiteralArrayIV((InlineLiteralIV[])list.toArray(new AbstractLiteralIV[list.size()]));
        }

        public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
            StringBuilder sb = new StringBuilder();
            LiteralArrayIV array = (LiteralArrayIV)delegate;
            for (InlineLiteralIV iv : array.getIVs()) {
                sb.append(iv.getInlineValue());
                sb.append(':');
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    }

    public static class InlineArrayFactory
    extends InlineURIFactory {
        public InlineArrayFactory() {
            this.addHandler(new InlineArrayHandler(TestInlineURIs.ARRAY));
        }
    }

    public static class MultipurposeInlineIDHandler
    extends InlineURIHandler {
        public MultipurposeInlineIDHandler(String namespace) {
            super(namespace);
        }

        protected AbstractLiteralIV createInlineIV(String localName) {
            try {
                return new IPv4AddrIV(localName);
            }
            catch (Exception ex) {
                try {
                    return new UUIDLiteralIV(UUID.fromString(localName));
                }
                catch (Exception ex2) {
                    try {
                        return new XSDNumericIV(Byte.parseByte(localName));
                    }
                    catch (Exception ex3) {
                        try {
                            return new XSDNumericIV(Short.parseShort(localName));
                        }
                        catch (Exception ex4) {
                            try {
                                return new XSDNumericIV(Integer.parseInt(localName));
                            }
                            catch (Exception ex5) {
                                try {
                                    return new XSDNumericIV(Long.parseLong(localName));
                                }
                                catch (Exception ex6) {
                                    try {
                                        return new XSDNumericIV(Double.parseDouble(localName));
                                    }
                                    catch (Exception exception) {
                                        return new FullyInlineTypedLiteralIV(localName);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static class MultipurposeInlineIDFactory
    extends InlineURIFactory {
        public MultipurposeInlineIDFactory() {
            this.addHandler(new MultipurposeInlineIDHandler(TestInlineURIs.CUSTOM_NAMESPACE));
        }
    }

    public static class CustomInlineURIFactory
    extends InlineURIFactory {
        public CustomInlineURIFactory() {
            this.addHandler((InlineURIHandler)new InlineUUIDURIHandler(TestInlineURIs.CUSTOM_NAMESPACE));
            this.addHandler((InlineURIHandler)new InlineSignedIntegerURIHandler(TestInlineURIs.SIGNED_INT_NAMESPACE));
            this.addHandler((InlineURIHandler)new InlineUnsignedIntegerURIHandler(TestInlineURIs.UNSIGNED_INT_NAMESPACE));
            this.addHandler((InlineURIHandler)new InlineSuffixedIntegerURIHandler(TestInlineURIs.SUFFIXED_INT_NAMESPACE, TestInlineURIs.SUFFIX));
            this.addHandler((InlineURIHandler)new InlinePrefixedIntegerURIHandler(TestInlineURIs.PREFIXED_INT_NAMESPACE, TestInlineURIs.PREFIX));
        }
    }

    public static class CustomVocab
    extends BigdataCoreVocabulary_v20151106 {
        public CustomVocab() {
        }

        public CustomVocab(String namespace) {
            super(namespace);
        }

        protected void addValues() {
            super.addValues();
            this.addDecl((VocabularyDecl)new BaseVocabularyDecl(new Object[]{TestInlineURIs.CUSTOM_NAMESPACE}));
            this.addDecl((VocabularyDecl)new BaseVocabularyDecl(new Object[]{TestInlineURIs.SIGNED_INT_NAMESPACE}));
            this.addDecl((VocabularyDecl)new BaseVocabularyDecl(new Object[]{TestInlineURIs.UNSIGNED_INT_NAMESPACE}));
            this.addDecl((VocabularyDecl)new BaseVocabularyDecl(new Object[]{TestInlineURIs.SUFFIXED_INT_NAMESPACE}));
            this.addDecl((VocabularyDecl)new BaseVocabularyDecl(new Object[]{TestInlineURIs.PREFIXED_INT_NAMESPACE}));
            this.addDecl((VocabularyDecl)new BaseVocabularyDecl(new Object[]{TestInlineURIs.ARRAY}));
        }
    }
}

