/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestInsertRate
extends AbstractTripleStoreTestCase {
    public TestInsertRate() {
    }

    public TestInsertRate(String name) {
        super(name);
    }

    public static void main(String[] args) throws Exception {
        int nclass = 5000;
        int nproperty = 20;
        int nliteral = 30;
        int litsize = 300;
        TestInsertRate test = new TestInsertRate("TestInsertRate");
        test.setUp();
        test.doTest(nclass, nproperty, nliteral, litsize);
        test.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(int nclass, int nproperty, int nliteral, int litsize) throws IOException {
        AbstractTripleStore store = this.getStore();
        try {
            this.doTest(store, nclass, nproperty, nliteral, litsize);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    private void doTest(AbstractTripleStore store, int nclass, int nproperty, int nliteral, int litsize) throws IOException {
        long begin;
        int i;
        int i2;
        URI[] cspace = new URI[nclass];
        URI[] pspace = new URI[nproperty];
        URI[] tspace = new URI[]{};
        String[] langSpace = new String[]{};
        int nliteral2 = nliteral + nliteral * tspace.length + nliteral * langSpace.length;
        Literal[] lspace = new Literal[nliteral2];
        int nvalues = nclass + nproperty + nliteral2;
        long begin2 = System.currentTimeMillis();
        BigdataValueFactory fac = store.getValueFactory();
        log.info((Object)("\nCreating " + nvalues + " values..."));
        for (i2 = 0; i2 < cspace.length; ++i2) {
            cspace[i2] = fac.createURI("http://class/" + i2);
        }
        for (i2 = 0; i2 < pspace.length; ++i2) {
            pspace[i2] = fac.createURI("http://property/" + i2);
        }
        int index = 0;
        for (int i3 = 0; i3 < nliteral; ++i3) {
            int j;
            lspace[index++] = fac.createLiteral(this.getRandomString(litsize, index));
            for (j = 0; j < langSpace.length; ++j) {
                lspace[index++] = fac.createLiteral(this.getRandomString(litsize, index), langSpace[j]);
            }
            for (j = 0; j < tspace.length; ++j) {
                lspace[index++] = fac.createLiteral(this.getRandomType(tspace[j], index), tspace[j]);
            }
        }
        long elapsed = System.currentTimeMillis() - begin2;
        log.info((Object)("\nCreated " + nvalues + " values" + ": elapsed=" + elapsed + ", value/sec=" + TestInsertRate.perSec(nvalues, elapsed)));
        int nobject = lspace.length + cspace.length;
        Value[] ospace = new Value[nobject];
        int index2 = 0;
        for (i = 0; i < cspace.length; ++i) {
            ospace[index2++] = cspace[i];
        }
        for (i = 0; i < lspace.length; ++i) {
            ospace[index2++] = lspace[i];
        }
        int nstmts = nclass * nproperty * nobject;
        Writer w = this.getWriter(".out");
        w.write("Test: " + this.getName() + ", #class=" + nclass + ", #property=" + nproperty + ", #literal=" + nliteral + ", #languages=" + langSpace.length + ", #datatypes=" + tspace.length + ", #maxlitsize=" + litsize + ", #literals(all)=" + nliteral2 + ", #objects=" + nobject + ", #statements=" + nstmts + "\n");
        w.write("#stmts\t#stmts(interval)\telapsed(interval)\tstmts/sec(interval)\n");
        w.flush();
        log.info((Object)("\nTest: " + this.getName() + ", #class=" + nclass + ", #property=" + nproperty + ", #literal=" + nliteral + ", #languages=" + langSpace.length + ", #datatypes=" + tspace.length + ", #maxlitsize=" + litsize + ", #literals(all)=" + nliteral2 + ", #objects=" + nobject + ", #statements=" + nstmts));
        boolean randomOrder = false;
        int[] corder = TestInsertRate.getRandomOrder((int)cspace.length);
        int[] porder = TestInsertRate.getRandomOrder((int)pspace.length);
        int[] oorder = TestInsertRate.getRandomOrder((int)ospace.length);
        long begin22 = begin = System.currentTimeMillis();
        int index3 = 0;
        int index22 = 0;
        StatementBuffer sbuf = new StatementBuffer(store, 10000);
        for (int i4 = 0; i4 < cspace.length; ++i4) {
            for (int j = 0; j < pspace.length; ++j) {
                for (int k = 0; k < ospace.length; ++k) {
                    URI s = randomOrder ? cspace[corder[i4]] : cspace[i4];
                    URI p = randomOrder ? pspace[porder[j]] : pspace[j];
                    Value o = randomOrder ? ospace[oorder[k]] : ospace[k];
                    sbuf.add((Resource)s, p, o);
                    if (index3 > 0 && index3 % 10000 == 0) {
                        System.err.print(".");
                        if (index3 % 100000 == 0) {
                            long now = System.currentTimeMillis();
                            long elapsed2 = now - begin22;
                            begin22 = now;
                            w.write("" + index3 + "\t" + index22 + "\t" + elapsed2 + "\t" + TestInsertRate.perSec(index22, elapsed2) + "\n");
                            w.flush();
                            log.info((Object)("\nCurrent insert rate: #statements(so far)=" + index3 + ": #statements(interval)=" + index22 + ", elapsed(interval)=" + elapsed2 + ", stmts/sec=" + TestInsertRate.perSec(index22, elapsed2)));
                            index22 = 0;
                        }
                    }
                    ++index3;
                    ++index22;
                }
            }
        }
        sbuf.flush();
        long elapsed3 = System.currentTimeMillis() - begin;
        w.write("Sustained insert rate: #statements=" + index3 + ", elapsed=" + elapsed3 + ", stmts/sec=" + TestInsertRate.perSec(index3, elapsed3) + "\n");
        log.info((Object)("\nSustained insert rate: #statements=" + index3 + ", elapsed=" + elapsed3 + ", stmts/sec=" + TestInsertRate.perSec(index3, elapsed3)));
        w.flush();
        w.close();
    }

    private String getRandomType(URI t, int id) {
        return "" + id;
    }

    public static final String perSec(int n, long elapsed) {
        if (n == 0) {
            return "0";
        }
        return elapsed == 0L ? "N/A" : "" + (int)((double)n / ((double)elapsed / 1000.0));
    }

    public Writer getWriter(String ext) throws IOException {
        return new BufferedWriter(new FileWriter(this.getName() + ext));
    }

    public void test_tiny() throws IOException {
        int nclass = 3;
        int nproperty = 2;
        int nliteral = 2;
        int litsize = 100;
        this.doTest(nclass, nproperty, nliteral, litsize);
    }

    public void test_small() throws IOException {
        int nclass = 30;
        int nproperty = 20;
        int nliteral = 20;
        int litsize = 100;
        this.doTest(nclass, nproperty, nliteral, litsize);
    }

    public static class XMLSchema {
        public static final String NAMESPACE_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
        public static final String NAMESPACE_RDFS = "http://www.w3.org/2000/01/rdf-schema#";
        public static final String RDF_XMLLiteral = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
        public static final String NAMESPACE_XSD = "http://www.w3.org/2001/XMLSchema#";
        public static final String xsBoolean = "http://www.w3.org/2001/XMLSchema#boolean";
        public static final String xsByte = "http://www.w3.org/2001/XMLSchema#byte";
        public static final String xsShort = "http://www.w3.org/2001/XMLSchema#short";
        public static final String xsInt = "http://www.w3.org/2001/XMLSchema#int";
        public static final String xsLong = "http://www.w3.org/2001/XMLSchema#long";
        public static final String xsFloat = "http://www.w3.org/2001/XMLSchema#float";
        public static final String xsDouble = "http://www.w3.org/2001/XMLSchema#double";
        public static final String xsInteger = "http://www.w3.org/2001/XMLSchema#integer";
        public static final String xsDecimal = "http://www.w3.org/2001/XMLSchema#decimal";
        public static final String xsString = "http://www.w3.org/2001/XMLSchema#string";
        public static final String xsAnyURI = "http://www.w3.org/2001/XMLSchema#anyURI";
    }
}

