/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestIsModified
extends AbstractTripleStoreTestCase {
    public TestIsModified() {
    }

    public TestIsModified(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_reportMutation() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory valueFactory = store.getValueFactory();
            BigdataURI x = valueFactory.createURI("http://www.foo.org/x");
            BigdataURI y = valueFactory.createURI("http://www.foo.org/y");
            BigdataURI z = valueFactory.createURI("http://www.foo.org/z");
            BigdataURI A = valueFactory.createURI("http://www.foo.org/A");
            BigdataURI B = valueFactory.createURI("http://www.foo.org/B");
            BigdataURI C2 = valueFactory.createURI("http://www.foo.org/C");
            BigdataURI rdfType = valueFactory.createURI(RDF.TYPE.stringValue());
            BigdataURI rdfsSubClassOf = valueFactory.createURI(RDFS.SUBCLASSOF.stringValue());
            store.addTerms(new BigdataValue[]{x, y, z, A, B, C2, rdfType, rdfsSubClassOf});
            BigdataStatement s1 = valueFactory.createStatement((Resource)x, (URI)rdfType, (Value)C2, null, StatementEnum.Explicit);
            BigdataStatement s2 = valueFactory.createStatement((Resource)y, (URI)rdfType, (Value)B, null, StatementEnum.Explicit);
            BigdataStatement s3 = valueFactory.createStatement((Resource)z, (URI)rdfType, (Value)A, null, StatementEnum.Explicit);
            BigdataStatement s4 = valueFactory.createStatement((Resource)B, (URI)rdfsSubClassOf, (Value)A, null, StatementEnum.Explicit);
            BigdataStatement s5 = valueFactory.createStatement((Resource)C2, (URI)rdfsSubClassOf, (Value)B, null, StatementEnum.Explicit);
            TestIsModified.assertFalse((boolean)s1.isModified());
            TestIsModified.assertFalse((boolean)s2.isModified());
            TestIsModified.assertFalse((boolean)s3.isModified());
            TestIsModified.assertFalse((boolean)s4.isModified());
            TestIsModified.assertFalse((boolean)s5.isModified());
            store.getSPORelation().insert(new ISPO[]{s1, s2, s3, s4, s5}, 5, null);
            TestIsModified.assertTrue((boolean)s1.isModified());
            TestIsModified.assertTrue((boolean)s2.isModified());
            TestIsModified.assertTrue((boolean)s3.isModified());
            TestIsModified.assertTrue((boolean)s4.isModified());
            TestIsModified.assertTrue((boolean)s5.isModified());
            s1 = valueFactory.createStatement((Resource)x, (URI)rdfType, (Value)C2, null, StatementEnum.Explicit);
            s2 = valueFactory.createStatement((Resource)x, (URI)x, (Value)x, null, StatementEnum.Explicit);
            TestIsModified.assertFalse((boolean)store.hasStatement(s2.s(), s2.p(), s2.o(), s2.c()));
            TestIsModified.assertFalse((boolean)s1.isModified());
            TestIsModified.assertFalse((boolean)s2.isModified());
            TestIsModified.assertEquals((long)1L, (long)store.getSPORelation().delete(new ISPO[]{s1, s2}, 2));
            TestIsModified.assertTrue((boolean)s1.isModified());
            TestIsModified.assertFalse((boolean)s2.isModified());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

