/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.store.AbstractTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.TestLocalTripleStoreTransactionSemantics;
import com.bigdata.rdf.store.TestTripleStoreBasics;
import java.io.File;
import java.util.Properties;
import junit.extensions.proxy.ProxyTestSuite;
import junit.framework.Test;

public class TestLocalQuadStore
extends AbstractTestCase {
    public TestLocalQuadStore() {
    }

    public TestLocalQuadStore(String name) {
        super(name);
    }

    public static Test suite() {
        TestLocalQuadStore delegate = new TestLocalQuadStore();
        ProxyTestSuite suite = new ProxyTestSuite((Test)delegate, "Local Quad Store Test Suite");
        suite.addTestSuite(TestLocalTripleStoreTransactionSemantics.class);
        suite.addTest(TestTripleStoreBasics.suite());
        return suite;
    }

    @Override
    public Properties getProperties() {
        Properties properties = (Properties)super.getProperties().clone();
        properties.setProperty(AbstractTripleStore.Options.QUADS, "true");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        return properties;
    }

    @Override
    protected AbstractTripleStore getStore(Properties properties) {
        return LocalTripleStore.getInstance((Properties)properties);
    }

    @Override
    protected AbstractTripleStore reopenStore(AbstractTripleStore store) {
        store.close();
        if (!store.isStable()) {
            throw new UnsupportedOperationException("The backing store is not stable");
        }
        Properties properties = (Properties)this.getProperties().clone();
        properties.setProperty(Options.CREATE_TEMP_FILE, "false");
        File file = ((LocalTripleStore)store).getIndexManager().getFile();
        TestLocalQuadStore.assertNotNull((Object)file);
        properties.setProperty(Options.FILE, file.toString());
        return LocalTripleStore.getInstance((Properties)properties);
    }
}

