/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Options;
import com.bigdata.rdf.lexicon.LexiconKeyOrder;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.ProxyTestCase;
import com.bigdata.relation.RelationSchema;
import com.bigdata.sparse.ITPS;
import com.bigdata.sparse.Schema;
import com.bigdata.sparse.SparseRowStore;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.openrdf.model.Value;

public class TestLocalTripleStoreDestroy
extends ProxyTestCase {
    public TestLocalTripleStoreDestroy() {
    }

    public TestLocalTripleStoreDestroy(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_destroyNoCommit() {
        String namespace = "kb";
        String namespaceLexiconRelation = "kb.lex";
        String namespaceSPORelation = "kb.spo";
        String lexiconRelationIndexName = "kb.lex." + LexiconKeyOrder.TERM2ID.getIndexName();
        String primaryStatementIndexName = "kb.spo." + SPOKeyOrder.SPO.getIndexName();
        Properties properties = new Properties();
        properties.setProperty(Options.CREATE_TEMP_FILE, "true");
        properties.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
        AbstractTripleStore store = this.getStore(properties);
        IIndexManager indexManager = store.getIndexManager();
        try {
            long lastCommitTime = store.getIndexManager().getLastCommitTime();
            TestLocalTripleStoreDestroy.assertEquals((Object[])new String[]{"kb"}, (Object[])TestLocalTripleStoreDestroy.getNamespaces(indexManager, 0L).toArray(new String[0]));
            TestLocalTripleStoreDestroy.assertEquals((Object[])new String[0], (Object[])TestLocalTripleStoreDestroy.getNamespaces(indexManager, lastCommitTime - 1L).toArray(new String[0]));
            TestLocalTripleStoreDestroy.assertTrue((store == indexManager.getResourceLocator().locate(store.getNamespace(), 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((store.getLexiconRelation() == indexManager.getResourceLocator().locate("kb.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((store.getSPORelation() == indexManager.getResourceLocator().locate("kb.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(lexiconRelationIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(primaryStatementIndexName, 0L));
            store.destroy();
            TestLocalTripleStoreDestroy.assertEquals((long)lastCommitTime, (long)store.getIndexManager().getLastCommitTime());
            TestLocalTripleStoreDestroy.assertTrue((boolean)TestLocalTripleStoreDestroy.getNamespaces(indexManager, 0L).isEmpty());
            TestLocalTripleStoreDestroy.assertFalse((boolean)TestLocalTripleStoreDestroy.getNamespaces(indexManager, lastCommitTime).isEmpty());
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(lexiconRelationIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(primaryStatementIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(primaryStatementIndexName, lastCommitTime));
            store.commit();
            TestLocalTripleStoreDestroy.assertTrue((boolean)TestLocalTripleStoreDestroy.getNamespaces(indexManager, store.getIndexManager().getLastCommitTime()).isEmpty());
        }
        finally {
            indexManager.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_destroyOne() {
        String namespace = "kb";
        String namespaceLexiconRelation = "kb.lex";
        String namespaceSPORelation = "kb.spo";
        String lexiconRelationIndexName = "kb.lex." + LexiconKeyOrder.TERM2ID.getIndexName();
        String primaryStatementIndexName = "kb.spo." + SPOKeyOrder.SPO.getIndexName();
        Properties properties = new Properties();
        properties.setProperty(Options.CREATE_TEMP_FILE, "true");
        properties.setProperty(AbstractTripleStore.Options.BUFFER_MODE, BufferMode.DiskWORM.toString());
        properties.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
        AbstractTripleStore store = this.getStore(properties);
        IIndexManager indexManager = store.getIndexManager();
        try {
            store.addTerm((Value)store.getValueFactory().createLiteral("bigdata"));
            Object[] namespaces = TestLocalTripleStoreDestroy.getNamespaces(indexManager, 0L).toArray(new String[0]);
            TestLocalTripleStoreDestroy.assertEquals((Object[])new String[]{"kb"}, (Object[])namespaces);
            TestLocalTripleStoreDestroy.assertTrue((store == indexManager.getResourceLocator().locate(store.getNamespace(), 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((store.getLexiconRelation() == indexManager.getResourceLocator().locate("kb.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((store.getSPORelation() == indexManager.getResourceLocator().locate("kb.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(lexiconRelationIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(primaryStatementIndexName, 0L));
            long commitTime = store.commit();
            TestLocalTripleStoreDestroy.assertTrue((commitTime > 0L ? 1 : 0) != 0);
            store.destroy();
            TestLocalTripleStoreDestroy.assertTrue((boolean)TestLocalTripleStoreDestroy.getNamespaces(indexManager, 0L).isEmpty());
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(lexiconRelationIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(primaryStatementIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getResourceLocator().locate("kb", commitTime - 1L));
            store.commit();
            TestLocalTripleStoreDestroy.assertTrue((boolean)TestLocalTripleStoreDestroy.getNamespaces(indexManager, 0L).isEmpty());
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(lexiconRelationIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(primaryStatementIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getResourceLocator().locate("kb", commitTime - 1L));
        }
        finally {
            indexManager.destroy();
        }
    }

    private static List<String> getNamespaces(IIndexManager indexManager, long timestamp) {
        LinkedList<String> namespaces = new LinkedList<String>();
        SparseRowStore grs = indexManager.getGlobalRowStore(timestamp);
        if (grs == null) {
            return namespaces;
        }
        Iterator itr = grs.rangeIterator((Schema)RelationSchema.INSTANCE);
        while (itr.hasNext()) {
            ITPS tps = (ITPS)itr.next();
            String namespace = (String)tps.getPrimaryKey();
            String className = (String)tps.get(RelationSchema.CLASS).getValue();
            if (className == null) continue;
            try {
                Class<?> cls = Class.forName(className);
                if (!AbstractTripleStore.class.isAssignableFrom(cls)) continue;
                namespaces.add(namespace);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return namespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_destroyTwo() {
        String namespace = "kb";
        String namespaceLexiconRelation = "kb.lex";
        String namespaceSPORelation = "kb.spo";
        String lexiconRelationIndexName = "kb.lex." + LexiconKeyOrder.TERM2ID.getIndexName();
        String primaryStatementIndexName = "kb.spo." + SPOKeyOrder.SPO.getIndexName();
        String namespace1 = "kb1";
        String namespaceLexiconRelation1 = "kb1.lex";
        String namespaceSPORelation1 = "kb1.spo";
        String lexiconRelationIndexName1 = "kb1.lex." + LexiconKeyOrder.TERM2ID.getIndexName();
        String primaryStatementIndexName1 = "kb1.spo." + SPOKeyOrder.SPO.getIndexName();
        Properties properties = new Properties();
        properties.setProperty(Options.CREATE_TEMP_FILE, "true");
        properties.setProperty(AbstractTripleStore.Options.BUFFER_MODE, BufferMode.DiskWORM.toString());
        properties.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
        AbstractTripleStore kb = this.getStore(properties);
        IIndexManager indexManager = kb.getIndexManager();
        try {
            TestLocalTripleStoreDestroy.assertEquals((String)"kb", (String)kb.getNamespace());
            LocalTripleStore kb1 = new LocalTripleStore(indexManager, "kb1", Long.valueOf(0L), properties);
            kb1.create();
            kb.addTerm((Value)kb.getValueFactory().createLiteral("bigdata"));
            kb1.addTerm((Value)kb.getValueFactory().createLiteral("bigdata"));
            Object[] namespaces = TestLocalTripleStoreDestroy.getNamespaces(indexManager, 0L).toArray(new String[0]);
            TestLocalTripleStoreDestroy.assertEquals((Object[])new String[]{"kb", "kb1"}, (Object[])namespaces);
            TestLocalTripleStoreDestroy.assertTrue((kb == indexManager.getResourceLocator().locate(kb.getNamespace(), 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((kb1 == indexManager.getResourceLocator().locate(kb1.getNamespace(), 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((kb.getLexiconRelation() == indexManager.getResourceLocator().locate("kb.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((kb1.getLexiconRelation() == indexManager.getResourceLocator().locate("kb1.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((kb.getSPORelation() == indexManager.getResourceLocator().locate("kb.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((kb1.getSPORelation() == indexManager.getResourceLocator().locate("kb1.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(lexiconRelationIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(lexiconRelationIndexName1, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(primaryStatementIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(primaryStatementIndexName1, 0L));
            long commitTime = kb.commit();
            TestLocalTripleStoreDestroy.assertTrue((commitTime > 0L ? 1 : 0) != 0);
            kb.destroy();
            Object[] namespaces2 = TestLocalTripleStoreDestroy.getNamespaces(indexManager, 0L).toArray(new String[0]);
            TestLocalTripleStoreDestroy.assertEquals((Object[])new String[]{"kb1"}, (Object[])namespaces2);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(lexiconRelationIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(primaryStatementIndexName, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getResourceLocator().locate("kb", commitTime - 1L));
            namespaces2 = TestLocalTripleStoreDestroy.getNamespaces(indexManager, 0L).toArray(new String[0]);
            TestLocalTripleStoreDestroy.assertEquals((Object[])new String[]{"kb1"}, (Object[])namespaces2);
            TestLocalTripleStoreDestroy.assertTrue((kb1 == indexManager.getResourceLocator().locate(kb1.getNamespace(), 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((kb1.getLexiconRelation() == indexManager.getResourceLocator().locate("kb1.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((kb1.getSPORelation() == indexManager.getResourceLocator().locate("kb1.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(lexiconRelationIndexName1, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getIndex(primaryStatementIndexName1, 0L));
            kb1.destroy();
            TestLocalTripleStoreDestroy.assertTrue((boolean)TestLocalTripleStoreDestroy.getNamespaces(indexManager, 0L).isEmpty());
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb1", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb1.lex", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertTrue((null == indexManager.getResourceLocator().locate("kb1.spo", 0L) ? 1 : 0) != 0);
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(lexiconRelationIndexName1, 0L));
            TestLocalTripleStoreDestroy.assertNull((Object)indexManager.getIndex(primaryStatementIndexName1, 0L));
            TestLocalTripleStoreDestroy.assertNotNull((Object)indexManager.getResourceLocator().locate("kb1", commitTime - 1L));
        }
        finally {
            indexManager.destroy();
        }
    }
}

