/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.ProxyTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.io.IOException;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestLocalTripleStoreTransactionSemantics
extends ProxyTestCase {
    public TestLocalTripleStoreTransactionSemantics() {
    }

    public TestLocalTripleStoreTransactionSemantics(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_commit1() {
        LocalTripleStore store = (LocalTripleStore)this.getStore();
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI s = f.createURI("http://www.bigdata.com/s");
            BigdataURI p = f.createURI("http://www.bigdata.com/p");
            BigdataURI o = f.createURI("http://www.bigdata.com/o");
            BigdataValue[] values = new BigdataValue[]{s, p, o};
            store.getLexiconRelation().addTerms(values, values.length, false);
            TestLocalTripleStoreTransactionSemantics.assertFalse((boolean)store.hasStatement(s.getIV(), p.getIV(), o.getIV()));
            store.addStatements((ISPO[])new SPO[]{new SPO(s.getIV(), p.getIV(), o.getIV(), StatementEnum.Explicit)}, 1);
            TestLocalTripleStoreTransactionSemantics.assertTrue((boolean)store.hasStatement(s.getIV(), p.getIV(), o.getIV()));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_abort() {
        class AbortException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            AbortException() {
            }
        }
        BigdataURI s = null;
        BigdataURI p = null;
        BigdataURI o = null;
        LocalTripleStore store = (LocalTripleStore)this.getStore();
        try {
            store.abort();
            BigdataValueFactory f = store.getValueFactory();
            s = f.createURI("http://www.bigdata.com/s");
            p = f.createURI("http://www.bigdata.com/p");
            o = f.createURI("http://www.bigdata.com/o");
            BigdataValue[] values = new BigdataValue[]{s, p, o};
            store.getLexiconRelation().addTerms(values, values.length, false);
            store.addStatements((ISPO[])new SPO[]{new SPO(s.getIV(), p.getIV(), o.getIV(), StatementEnum.Explicit)}, 1);
            TestLocalTripleStoreTransactionSemantics.assertTrue((boolean)store.hasStatement(s.getIV(), p.getIV(), o.getIV()));
            throw new AbortException();
        }
        catch (AbortException ex) {
            store.abort();
            TestLocalTripleStoreTransactionSemantics.assertFalse((boolean)store.hasStatement(s.getIV(), p.getIV(), o.getIV()));
            store.__tearDownUnitTest();
        }
        catch (Throwable t) {
            try {
                log.error((Object)t);
                store.abort();
                TestLocalTripleStoreTransactionSemantics.fail((String)("Unexpected exception: " + t), (Throwable)t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                store.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_txIsolation() throws IOException {
        Properties p = new Properties(this.getProperties());
        p.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        p.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        AbstractTripleStore initialKb = this.getStore(p);
        try {
            String namespace = initialKb.getNamespace() + "_test";
            IIndexManager indexManager = initialKb.getIndexManager();
            ITransactionService txService = ((Journal)indexManager).getTransactionManager().getTransactionService();
            long tx0 = txService.newTx(-1L);
            TestLocalTripleStoreTransactionSemantics.assertNull((Object)indexManager.getResourceLocator().locate(namespace, tx0));
            txService.abort(tx0);
            long txCreate = txService.newTx(0L);
            TestLocalTripleStoreTransactionSemantics.assertNull((Object)indexManager.getResourceLocator().locate(namespace, txCreate));
            LocalTripleStore txCreateView = new LocalTripleStore(indexManager, namespace, Long.valueOf(txCreate), p);
            txCreateView.create();
            txService.commit(txCreate);
            AbstractTripleStore unisolatedStore = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, 0L);
            BigdataValueFactory f = unisolatedStore.getValueFactory();
            BigdataURI john = f.createURI("http://www.bigdata.com/john");
            BigdataURI loves = f.createURI("http://www.bigdata.com/loves");
            BigdataURI mary = f.createURI("http://www.bigdata.com/mary");
            BigdataValue[] terms = new BigdataValue[]{john, loves, mary};
            unisolatedStore.getLexiconRelation().addTerms(terms, terms.length, false);
            long tx1 = txService.newTx(-1L);
            AbstractTripleStore tx1View = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, tx1);
            TestLocalTripleStoreTransactionSemantics.assertEquals((long)0L, (long)tx1View.getExplicitStatementCount(null));
            long tx2 = txService.newTx(0L);
            long tx3 = txService.newTx(0L);
            AbstractTripleStore tx2View = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, tx2);
            AbstractTripleStore tx3View = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, tx3);
            StatementBuffer sb = new StatementBuffer(tx2View, 10);
            sb.add((Resource)john, (URI)loves, (Value)mary);
            sb.flush();
            TestLocalTripleStoreTransactionSemantics.assertFalse((boolean)tx1View.hasStatement((Resource)john, (URI)loves, (Value)mary));
            TestLocalTripleStoreTransactionSemantics.assertFalse((boolean)tx3View.hasStatement((Resource)john, (URI)loves, (Value)mary));
            TestLocalTripleStoreTransactionSemantics.assertTrue((boolean)tx2View.hasStatement((Resource)john, (URI)loves, (Value)mary));
            txService.commit(tx2);
            TestLocalTripleStoreTransactionSemantics.assertFalse((boolean)tx1View.hasStatement((Resource)john, (URI)loves, (Value)mary));
            TestLocalTripleStoreTransactionSemantics.assertFalse((boolean)tx3View.hasStatement((Resource)john, (URI)loves, (Value)mary));
            long tx4 = txService.newTx(-1L);
            AbstractTripleStore tx4View = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, tx4);
            long tx5 = txService.newTx(-1L);
            AbstractTripleStore tx5View = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, tx5);
            TestLocalTripleStoreTransactionSemantics.assertTrue((boolean)tx4View.hasStatement((Resource)john, (URI)loves, (Value)mary));
            TestLocalTripleStoreTransactionSemantics.assertTrue((boolean)tx5View.hasStatement((Resource)john, (URI)loves, (Value)mary));
            StatementBuffer sb2 = new StatementBuffer(tx3View, 10);
            sb2.add((Resource)john, (URI)loves, (Value)mary);
            sb2.flush();
            txService.commit(tx3);
            txService.abort(tx1);
            txService.abort(tx4);
            txService.abort(tx5);
        }
        finally {
            initialKb.__tearDownUnitTest();
        }
    }
}

