/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.Options;
import com.bigdata.rdf.rules.TestAll;
import com.bigdata.rdf.store.AbstractTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.TestLocalTripleStoreTransactionSemantics;
import com.bigdata.rdf.store.TestTripleStoreBasics;
import java.io.File;
import java.util.Properties;
import junit.extensions.proxy.ProxyTestSuite;
import junit.framework.Test;

public class TestLocalTripleStoreWithoutStatementIdentifiers
extends AbstractTestCase {
    public TestLocalTripleStoreWithoutStatementIdentifiers() {
    }

    public TestLocalTripleStoreWithoutStatementIdentifiers(String name) {
        super(name);
    }

    public static Test suite() {
        TestLocalTripleStoreWithoutStatementIdentifiers delegate = new TestLocalTripleStoreWithoutStatementIdentifiers();
        ProxyTestSuite suite = new ProxyTestSuite((Test)delegate, "Local Triple Store Without Statement Identifiers");
        suite.addTestSuite(TestLocalTripleStoreTransactionSemantics.class);
        suite.addTest(TestTripleStoreBasics.suite());
        suite.addTest(TestAll.suite());
        return suite;
    }

    @Override
    public Properties getProperties() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "false");
        properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
        return properties;
    }

    @Override
    protected AbstractTripleStore getStore(Properties properties) {
        return LocalTripleStore.getInstance((Properties)properties);
    }

    @Override
    protected AbstractTripleStore reopenStore(AbstractTripleStore store) {
        store.close();
        if (!store.isStable()) {
            throw new UnsupportedOperationException("The backing store is not stable");
        }
        Properties properties = (Properties)this.getProperties().clone();
        properties.setProperty(Options.CREATE_TEMP_FILE, "false");
        File file = ((LocalTripleStore)store).getIndexManager().getFile();
        TestLocalTripleStoreWithoutStatementIdentifiers.assertNotNull((Object)file);
        properties.setProperty(Options.FILE, file.toString());
        return LocalTripleStore.getInstance((Properties)properties);
    }
}

