/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.striterator.IKeyOrder;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestRestartSafe
extends AbstractTripleStoreTestCase {
    public TestRestartSafe() {
    }

    public TestRestartSafe(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_restartSafe() throws IOException {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI x = f.createURI("http://www.foo.org/x");
            BigdataURI y = f.createURI("http://www.foo.org/y");
            BigdataURI z = f.createURI("http://www.foo.org/z");
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI rdfsSubClassOf = f.asValue(RDFS.SUBCLASSOF);
            BigdataLiteral lit1 = f.createLiteral("abc");
            BigdataLiteral lit2 = f.createLiteral("abc", (URI)A);
            BigdataLiteral lit3 = f.createLiteral("abc", "en");
            BigdataBNode bn1 = f.createBNode(UUID.randomUUID().toString());
            BigdataBNode bn2 = f.createBNode("a12");
            store.addStatement((Resource)x, (URI)rdfType, (Value)C2);
            store.addStatement((Resource)y, (URI)rdfType, (Value)B);
            store.addStatement((Resource)z, (URI)rdfType, (Value)A);
            store.addStatement((Resource)B, (URI)rdfsSubClassOf, (Value)A);
            store.addStatement((Resource)C2, (URI)rdfsSubClassOf, (Value)B);
            IV x_id = store.getIV((Value)x);
            TestRestartSafe.assertTrue((x_id != this.NULL ? 1 : 0) != 0);
            IV y_id = store.getIV((Value)y);
            TestRestartSafe.assertTrue((y_id != this.NULL ? 1 : 0) != 0);
            IV z_id = store.getIV((Value)z);
            TestRestartSafe.assertTrue((z_id != this.NULL ? 1 : 0) != 0);
            IV A_id = store.getIV((Value)A);
            TestRestartSafe.assertTrue((A_id != this.NULL ? 1 : 0) != 0);
            IV B_id = store.getIV((Value)B);
            TestRestartSafe.assertTrue((B_id != this.NULL ? 1 : 0) != 0);
            IV C_id = store.getIV((Value)C2);
            TestRestartSafe.assertTrue((C_id != this.NULL ? 1 : 0) != 0);
            IV rdfType_id = store.getIV((Value)rdfType);
            TestRestartSafe.assertTrue((rdfType_id != this.NULL ? 1 : 0) != 0);
            IV rdfsSubClassOf_id = store.getIV((Value)rdfsSubClassOf);
            TestRestartSafe.assertTrue((rdfsSubClassOf_id != this.NULL ? 1 : 0) != 0);
            IV lit1_id = store.addTerm((Value)lit1);
            TestRestartSafe.assertTrue((lit1_id != this.NULL ? 1 : 0) != 0);
            IV lit2_id = store.addTerm((Value)lit2);
            TestRestartSafe.assertTrue((lit2_id != this.NULL ? 1 : 0) != 0);
            IV lit3_id = store.addTerm((Value)lit3);
            TestRestartSafe.assertTrue((lit3_id != this.NULL ? 1 : 0) != 0);
            IV bn1_id = store.addTerm((Value)bn1);
            TestRestartSafe.assertTrue((bn1_id != this.NULL ? 1 : 0) != 0);
            IV bn2_id = store.addTerm((Value)bn2);
            TestRestartSafe.assertTrue((bn2_id != this.NULL ? 1 : 0) != 0);
            store.commit();
            TestRestartSafe.assertEquals((Object)x_id, (Object)store.getIV((Value)x));
            TestRestartSafe.assertEquals((Object)y_id, (Object)store.getIV((Value)y));
            TestRestartSafe.assertEquals((Object)z_id, (Object)store.getIV((Value)z));
            TestRestartSafe.assertEquals((Object)A_id, (Object)store.getIV((Value)A));
            TestRestartSafe.assertEquals((Object)B_id, (Object)store.getIV((Value)B));
            TestRestartSafe.assertEquals((Object)C_id, (Object)store.getIV((Value)C2));
            TestRestartSafe.assertEquals((Object)rdfType_id, (Object)store.getIV((Value)rdfType));
            TestRestartSafe.assertEquals((Object)rdfsSubClassOf_id, (Object)store.getIV((Value)rdfsSubClassOf));
            Iterator itr = store.getSPORelation().statementKeyOrderIterator();
            while (itr.hasNext()) {
                TestRestartSafe.assertEquals((String)"statementCount", (long)5L, (long)store.getSPORelation().getIndex((IKeyOrder)itr.next()).rangeCount(null, null));
            }
            TestRestartSafe.assertTrue((boolean)store.hasStatement((Resource)x, (URI)rdfType, (Value)C2));
            TestRestartSafe.assertTrue((boolean)store.hasStatement((Resource)y, (URI)rdfType, (Value)B));
            TestRestartSafe.assertTrue((boolean)store.hasStatement((Resource)z, (URI)rdfType, (Value)A));
            TestRestartSafe.assertTrue((boolean)store.hasStatement((Resource)B, (URI)rdfsSubClassOf, (Value)A));
            TestRestartSafe.assertTrue((boolean)store.hasStatement((Resource)C2, (URI)rdfsSubClassOf, (Value)B));
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
            }
            store.commit();
            if (store.isStable()) {
                store = this.reopenStore(store);
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + store.dumpStore()));
                }
                TestRestartSafe.assertEquals((Object)x_id, (Object)store.getIV((Value)x));
                TestRestartSafe.assertEquals((Object)y_id, (Object)store.getIV((Value)y));
                TestRestartSafe.assertEquals((Object)z_id, (Object)store.getIV((Value)z));
                TestRestartSafe.assertEquals((Object)A_id, (Object)store.getIV((Value)A));
                TestRestartSafe.assertEquals((Object)B_id, (Object)store.getIV((Value)B));
                TestRestartSafe.assertEquals((Object)C_id, (Object)store.getIV((Value)C2));
                TestRestartSafe.assertEquals((Object)rdfType_id, (Object)store.getIV((Value)rdfType));
                TestRestartSafe.assertEquals((Object)rdfsSubClassOf_id, (Object)store.getIV((Value)rdfsSubClassOf));
                itr = store.getSPORelation().statementKeyOrderIterator();
                while (itr.hasNext()) {
                    TestRestartSafe.assertEquals((String)"statementCount", (long)5L, (long)store.getSPORelation().getIndex((IKeyOrder)itr.next()).rangeCount(null, null));
                }
                TestRestartSafe.assertEquals((Object)x, (Object)store.getTerm(x_id));
                TestRestartSafe.assertEquals((Object)y, (Object)store.getTerm(y_id));
                TestRestartSafe.assertEquals((Object)z, (Object)store.getTerm(z_id));
                TestRestartSafe.assertEquals((Object)A, (Object)store.getTerm(A_id));
                TestRestartSafe.assertEquals((Object)B, (Object)store.getTerm(B_id));
                TestRestartSafe.assertEquals((Object)C2, (Object)store.getTerm(C_id));
                TestRestartSafe.assertEquals((Object)rdfType, (Object)store.getTerm(rdfType_id));
                TestRestartSafe.assertEquals((Object)rdfsSubClassOf, (Object)store.getTerm(rdfsSubClassOf_id));
                TestRestartSafe.assertEquals((Object)lit1, (Object)store.getTerm(lit1_id));
                TestRestartSafe.assertEquals((Object)lit2, (Object)store.getTerm(lit2_id));
                TestRestartSafe.assertEquals((Object)lit3, (Object)store.getTerm(lit3_id));
                TestRestartSafe.assertTrue((store.getTerm(bn1_id) != null ? 1 : 0) != 0);
                TestRestartSafe.assertTrue((boolean)(store.getTerm(bn1_id) instanceof BNode));
                TestRestartSafe.assertTrue((store.getTerm(bn2_id) != null ? 1 : 0) != 0);
                TestRestartSafe.assertTrue((boolean)(store.getTerm(bn2_id) instanceof BNode));
                TestRestartSafe.assertTrue((store.getTerm(bn1_id) != store.getTerm(bn2_id) ? 1 : 0) != 0);
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

