/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Options;
import com.bigdata.rdf.rules.TestAll;
import com.bigdata.rdf.store.AbstractTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.ProxyTestCase;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.rdf.store.TestTripleStoreBasics;
import com.bigdata.service.DataService;
import com.bigdata.service.EmbeddedClient;
import com.bigdata.service.EmbeddedFederation;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import junit.extensions.proxy.ProxyTestSuite;
import junit.framework.Test;

public class TestScaleOutTripleStoreWithEmbeddedFederation
extends AbstractTestCase {
    EmbeddedClient client;
    private AtomicInteger inc = new AtomicInteger();

    public TestScaleOutTripleStoreWithEmbeddedFederation() {
    }

    public TestScaleOutTripleStoreWithEmbeddedFederation(String name) {
        super(name);
    }

    public static Test suite() {
        TestScaleOutTripleStoreWithEmbeddedFederation delegate = new TestScaleOutTripleStoreWithEmbeddedFederation();
        ProxyTestSuite suite = new ProxyTestSuite((Test)delegate, "Scale-Out Triple Store Test Suite (embedded federation)");
        suite.addTest(TestTripleStoreBasics.suite());
        suite.addTest(TestAll.suite());
        return suite;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties(super.getProperties());
        properties.setProperty(DataService.Options.OVERFLOW_ENABLED, "false");
        properties.setProperty(EmbeddedClient.Options.COLLECT_PLATFORM_STATISTICS, "false");
        return properties;
    }

    @Override
    public void setUp(ProxyTestCase testCase) throws Exception {
        super.setUp(testCase);
        File dataDir = new File(testCase.getName());
        if (dataDir.exists() && dataDir.isDirectory()) {
            this.recursiveDelete(dataDir);
        }
        Properties properties = new Properties(this.getProperties());
        this.client = new EmbeddedClient(properties);
        this.client.connect();
    }

    @Override
    public void tearDown(ProxyTestCase testCase) throws Exception {
        if (this.client != null) {
            if (this.client.isConnected()) {
                this.client.getFederation().destroy();
            }
            this.client = null;
        }
        super.tearDown();
    }

    @Override
    protected AbstractTripleStore getStore(Properties properties) {
        String namespace = "test" + this.inc.incrementAndGet();
        ScaleOutTripleStore store = new ScaleOutTripleStore((IIndexManager)this.client.getFederation(), namespace, Long.valueOf(0L), properties);
        store.create();
        return store;
    }

    @Override
    protected AbstractTripleStore reopenStore(AbstractTripleStore store) {
        String namespace = store.getNamespace();
        Properties properties = new Properties(this.client.getProperties());
        this.client.disconnect(true);
        properties.setProperty(Options.CREATE_TEMP_FILE, "false");
        File file = ((EmbeddedFederation)((ScaleOutTripleStore)store).getIndexManager()).getDataDir();
        properties.setProperty(EmbeddedClient.Options.DATA_DIR, file.toString());
        this.client = new EmbeddedClient(properties);
        this.client.connect();
        return new ScaleOutTripleStore((IIndexManager)this.client.getFederation(), namespace, Long.valueOf(0L), store.getProperties()).init();
    }
}

