/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.store.TempTripleStore;
import java.util.Properties;
import java.util.Set;
import org.openrdf.model.Value;

public class TestSharedLexiconTempStore
extends AbstractTripleStoreTestCase {
    public TestSharedLexiconTempStore() {
    }

    public TestSharedLexiconTempStore(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_TempTripleStore_noLexicon() {
        String uriString1 = "http://www.bigdata.com/foo";
        String uriString3 = "http://www.bigdata.com/goo";
        AbstractTripleStore store = this.getStore();
        try {
            BigdataValueFactory vf = store.getValueFactory();
            BigdataURI uri1 = vf.createURI("http://www.bigdata.com/foo");
            BigdataURI uri3 = vf.createURI("http://www.bigdata.com/goo");
            store.addTerm((Value)uri1);
            TestSharedLexiconTempStore.assertNotNull((Object)store.getTerm(uri1.getIV()));
            Properties properties = new Properties();
            properties.setProperty(AbstractTripleStore.Options.LEXICON, "false");
            TempTripleStore tempTripleStore = new TempTripleStore(store.getIndexManager().getTempStore(), properties, store);
            try {
                TestSharedLexiconTempStore.assertNotNull((Object)store.getTerm(uri1.getIV()));
                TestSharedLexiconTempStore.assertFalse((boolean)tempTripleStore.lexicon);
                TestSharedLexiconTempStore.assertNull((Object)tempTripleStore.getLexiconRelation());
            }
            finally {
                tempTripleStore.destroy();
            }
            store.addTerm((Value)uri3);
            TestSharedLexiconTempStore.assertNotNull((Object)store.getTerm(uri3.getIV()));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_TempTripleStore_oneAccessPath() {
        AbstractTripleStore store = this.getStore();
        try {
            Properties properties = new Properties();
            properties.setProperty(AbstractTripleStore.Options.ONE_ACCESS_PATH, "true");
            TempTripleStore tempTripleStore = new TempTripleStore(store.getIndexManager().getTempStore(), properties, store);
            try {
                TestSharedLexiconTempStore.assertTrue((boolean)tempTripleStore.getSPORelation().oneAccessPath);
                Set names = tempTripleStore.getSPORelation().getIndexNames();
                int nexpected = tempTripleStore.isJustify() ? 2 : 1;
                TestSharedLexiconTempStore.assertEquals((int)nexpected, (int)names.size());
            }
            finally {
                tempTripleStore.destroy();
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

