/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rio.UnificationException;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOComparator;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.store.IRawTripleStore;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestStatementIdentifiers
extends AbstractTripleStoreTestCase {
    private static final transient Logger log = Logger.getLogger(TestStatementIdentifiers.class);

    public TestStatementIdentifiers() {
    }

    public TestStatementIdentifiers(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_statementIdentifiers() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            int i;
            SPO spo;
            int i2;
            if (!store.isStatementIdentifiers()) {
                log.warn((Object)"Statement identifiers are not enabled");
                return;
            }
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI x = f.createURI("http://www.foo.org/x");
            BigdataURI y = f.createURI("http://www.foo.org/y");
            BigdataURI z = f.createURI("http://www.foo.org/z");
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI rdfsLabel = f.asValue(RDFS.LABEL);
            BigdataURI rdfsSubClassOf = f.asValue(RDFS.SUBCLASSOF);
            BigdataLiteral lit1 = f.createLiteral("abc");
            BigdataLiteral lit2 = f.createLiteral("abc", (URI)A);
            BigdataLiteral lit3 = f.createLiteral("abc", "en");
            BigdataBNode bn1 = f.createBNode(UUID.randomUUID().toString());
            BigdataBNode bn2 = f.createBNode("a12");
            BigdataValue[] terms = new BigdataValue[]{x, y, z, A, B, C2, rdfType, rdfsLabel, rdfsSubClassOf, lit1, lit2, lit3, bn1, bn2};
            store.addTerms(terms);
            SPO[] stmts = new SPO[]{new SPO(x.getIV(), rdfType.getIV(), C2.getIV(), StatementEnum.Explicit), new SPO(y.getIV(), rdfType.getIV(), B.getIV(), StatementEnum.Explicit), new SPO(z.getIV(), rdfType.getIV(), A.getIV(), StatementEnum.Explicit), new SPO(A.getIV(), rdfsLabel.getIV(), lit1.getIV(), StatementEnum.Explicit), new SPO(B.getIV(), rdfsLabel.getIV(), lit2.getIV(), StatementEnum.Explicit), new SPO(C2.getIV(), rdfsLabel.getIV(), lit3.getIV(), StatementEnum.Explicit), new SPO(B.getIV(), rdfsSubClassOf.getIV(), A.getIV(), StatementEnum.Explicit), new SPO(C2.getIV(), rdfsSubClassOf.getIV(), B.getIV(), StatementEnum.Explicit), new SPO(bn1.getIV(), rdfsLabel.getIV(), lit1.getIV(), StatementEnum.Explicit), new SPO(bn2.getIV(), rdfsLabel.getIV(), lit2.getIV(), StatementEnum.Explicit)};
            store.addStatements((ISPO[])stmts, stmts.length);
            for (int i3 = 0; i3 < stmts.length; ++i3) {
                IV sid = stmts[i3].getStatementIdentifier();
                TestStatementIdentifiers.assertNotSame((Object)this.NULL, (Object)sid);
                TestStatementIdentifiers.assertTrue((boolean)sid.isStatement());
                TestStatementIdentifiers.assertFalse((boolean)sid.isLiteral());
                TestStatementIdentifiers.assertFalse((boolean)sid.isURI());
                TestStatementIdentifiers.assertFalse((boolean)sid.isBNode());
                if (!log.isInfoEnabled()) continue;
                log.info((Object)(stmts[i3].toString((IRawTripleStore)store) + " ::: " + stmts[i3].toString()));
            }
            try (IChunkedOrderedIterator itr = store.getAccessPath((IKeyOrder)SPOKeyOrder.SPO).iterator();){
                for (i2 = 0; i2 < stmts.length; ++i2) {
                    TestStatementIdentifiers.assertTrue((String)("expecting more elements: i=" + i2), (boolean)itr.hasNext());
                    SPO expected = stmts[i2];
                    ISPO actual = (ISPO)itr.next();
                    TestStatementIdentifiers.assertEquals((String)("S @ i=" + i2), (Object)expected.s, (Object)actual.s());
                    TestStatementIdentifiers.assertEquals((String)("P @ i=" + i2), (Object)expected.p, (Object)actual.p());
                    TestStatementIdentifiers.assertEquals((String)("O @ i=" + i2), (Object)expected.o, (Object)actual.o());
                    TestStatementIdentifiers.assertEquals((String)("TYPE @ i=" + i2), (Object)expected.getStatementType(), (Object)actual.getStatementType());
                    TestStatementIdentifiers.assertEquals((String)("SID @ i=" + i2), (Object)expected.getStatementIdentifier(), (Object)actual.getStatementIdentifier());
                }
            }
            SPO[] a = new SPO[stmts.length];
            for (i2 = 0; i2 < stmts.length; ++i2) {
                spo = stmts[i2];
                a[i2] = new SPO(spo.s, spo.p, spo.o, spo.getStatementType());
            }
            long nwritten = store.addStatements((ISPO[])a, a.length);
            for (i = 0; i < stmts.length; ++i) {
                TestStatementIdentifiers.assertEquals((String)("sid @ i=" + i), (Object)stmts[i].getStatementIdentifier(), (Object)a[i].getStatementIdentifier());
            }
            TestStatementIdentifiers.assertEquals((String)"#written", (long)0L, (long)nwritten);
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                this.assertSameSPOArray(store, stmts, stmts.length);
                a = new SPO[stmts.length];
                for (int i4 = 0; i4 < stmts.length; ++i4) {
                    spo = stmts[i4];
                    a[i4] = new SPO(spo.s, spo.p, spo.o, spo.getStatementType());
                }
                nwritten = store.addStatements((ISPO[])a, a.length);
                for (i = 0; i < stmts.length; ++i) {
                    TestStatementIdentifiers.assertEquals((String)("sid @ i=" + i), (Object)stmts[i].getStatementIdentifier(), (Object)a[i].getStatementIdentifier());
                }
                TestStatementIdentifiers.assertEquals((String)"#written", (long)0L, (long)nwritten);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_retractionOfStatementsAboutStatements() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            if (!store.isStatementIdentifiers()) {
                log.warn((Object)"Statement identifiers are not enabled");
                return;
            }
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI x = f.createURI("http://www.foo.org/x");
            BigdataURI y = f.createURI("http://www.foo.org/y");
            BigdataURI z = f.createURI("http://www.foo.org/z");
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI dcCreator = f.createURI("http://purl.org/dc/terms/creator");
            BigdataLiteral lit1 = f.createLiteral("bryan");
            BigdataLiteral lit2 = f.createLiteral("mike");
            BigdataValue[] terms = new BigdataValue[]{x, y, z, A, B, C2, rdfType, dcCreator, lit1, lit2};
            store.addTerms(terms);
            Object[] stmts1 = new SPO[]{new SPO(x.getIV(), rdfType.getIV(), A.getIV(), StatementEnum.Explicit)};
            TestStatementIdentifiers.assertEquals((long)1L, (long)store.addStatements((ISPO[])stmts1, stmts1.length));
            IV sid1 = stmts1[0].getStatementIdentifier();
            SPO[] stmts2 = new SPO[]{new SPO(sid1, dcCreator.getIV(), lit1.getIV(), StatementEnum.Explicit)};
            TestStatementIdentifiers.assertEquals((long)1L, (long)store.addStatements((ISPO[])stmts2, stmts2.length));
            TestStatementIdentifiers.assertEquals((long)2L, (long)store.getStatementCount(true));
            SPO[] all = new SPO[]{stmts1[0], stmts2[0]};
            this.assertSameSPOArray(store, all, all.length);
            store.removeStatements((IChunkedOrderedIterator)new ChunkedArrayIterator(stmts1.length, stmts1, null));
            this.assertSameSPOArray(store, new SPO[0], 0);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_retractionOfStatementsAboutStatements2() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            if (!store.isStatementIdentifiers()) {
                log.warn((Object)"Statement identifiers are not enabled");
                return;
            }
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI x = f.createURI("http://www.foo.org/x");
            BigdataURI y = f.createURI("http://www.foo.org/y");
            BigdataURI z = f.createURI("http://www.foo.org/z");
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI dcCreator = f.createURI("http://purl.org/dc/terms/creator");
            BigdataLiteral lit1 = f.createLiteral("bryan");
            BigdataLiteral lit2 = f.createLiteral("mike");
            BigdataValue[] terms = new BigdataValue[]{x, y, z, A, B, C2, rdfType, dcCreator, lit1, lit2};
            store.addTerms(terms);
            Object[] stmts1 = new SPO[]{new SPO(x.getIV(), rdfType.getIV(), A.getIV(), StatementEnum.Explicit)};
            TestStatementIdentifiers.assertEquals((long)1L, (long)store.addStatements((ISPO[])stmts1, stmts1.length));
            IV sid1 = stmts1[0].getStatementIdentifier();
            SPO[] stmts2 = new SPO[]{new SPO(sid1, dcCreator.getIV(), lit1.getIV(), StatementEnum.Explicit)};
            TestStatementIdentifiers.assertEquals((long)1L, (long)store.addStatements((ISPO[])stmts2, stmts2.length));
            TestStatementIdentifiers.assertEquals((long)2L, (long)store.getStatementCount(true));
            IV sid2 = stmts2[0].getStatementIdentifier();
            SPO[] stmts3 = new SPO[]{new SPO(sid2, dcCreator.getIV(), lit2.getIV(), StatementEnum.Explicit)};
            TestStatementIdentifiers.assertEquals((long)1L, (long)store.addStatements((ISPO[])stmts3, stmts3.length));
            TestStatementIdentifiers.assertEquals((long)3L, (long)store.getStatementCount(true));
            SPO[] all = new SPO[]{stmts1[0], stmts2[0], stmts3[0]};
            this.assertSameSPOArray(store, all, all.length);
            store.removeStatements((IChunkedOrderedIterator)new ChunkedArrayIterator(stmts1.length, stmts1, null));
            this.assertSameSPOArray(store, new SPO[0], 0);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertSameSPOArray(AbstractTripleStore store, SPO[] all, int numStmts) {
        Arrays.sort(all, 0, all.length, SPOComparator.INSTANCE);
        try (IChunkedOrderedIterator itr = store.getAccessPath((IKeyOrder)SPOKeyOrder.SPO).iterator();){
            for (int i = 0; i < all.length; ++i) {
                TestStatementIdentifiers.assertTrue((String)("i=" + i), (boolean)itr.hasNext());
                SPO expected = all[i];
                ISPO actual = (ISPO)itr.next();
                TestStatementIdentifiers.assertEquals((String)("S @ i=" + i), (Object)expected.s, (Object)actual.s());
                TestStatementIdentifiers.assertEquals((String)("P @ i=" + i), (Object)expected.p, (Object)actual.p());
                TestStatementIdentifiers.assertEquals((String)("O @ i=" + i), (Object)expected.o, (Object)actual.o());
                TestStatementIdentifiers.assertEquals((String)("TYPE @ i=" + i), (Object)expected.getStatementType(), (Object)actual.getStatementType());
                TestStatementIdentifiers.assertEquals((String)("SID @ i=" + i), (Object)expected.getStatementIdentifier(), (Object)actual.getStatementIdentifier());
            }
            TestStatementIdentifiers.assertFalse((String)("iterator is willing to visit more than " + numStmts + " statements"), (boolean)itr.hasNext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_correctRejection_cycles01() {
        AbstractTripleStore store = this.getStore();
        try {
            if (!store.isStatementIdentifiers()) {
                log.warn((Object)"Statement identifiers are not enabled");
                return;
            }
            BigdataValueFactory valueFactory = store.getValueFactory();
            BigdataURI A = valueFactory.createURI("http://www.foo.org/A");
            BigdataURI rdfType = valueFactory.createURI(RDF.TYPE.stringValue());
            BigdataBNode sid1 = valueFactory.createBNode("_S1");
            StatementBuffer buf = new StatementBuffer(store, 100);
            buf.add((Resource)sid1, RDF.TYPE, (Value)A);
            buf.add((Resource)sid1, RDF.SUBJECT, (Value)sid1);
            buf.add((Resource)sid1, RDF.PREDICATE, (Value)RDF.TYPE);
            buf.add((Resource)sid1, RDF.OBJECT, (Value)A);
            try {
                buf.flush();
                TestStatementIdentifiers.fail((String)("Expecting: " + UnificationException.class));
            }
            catch (UnificationException ex) {
                System.err.println("Ignoring expected exception: " + (Object)((Object)ex));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_correctRejection_cycles02() {
        AbstractTripleStore store = this.getStore();
        try {
            if (!store.isStatementIdentifiers()) {
                log.warn((Object)"Statement identifiers are not enabled");
                return;
            }
            BigdataValueFactory valueFactory = store.getValueFactory();
            BigdataURI B = valueFactory.createURI("http://www.foo.org/B");
            BigdataURI rdfType = valueFactory.createURI(RDF.TYPE.stringValue());
            BigdataBNode sid1 = valueFactory.createBNode("_S1");
            BigdataBNode sid2 = valueFactory.createBNode("_S2");
            StatementBuffer buf = new StatementBuffer(store, 100);
            try {
                buf.add((Resource)sid2, RDF.TYPE, (Value)B);
                buf.add((Resource)sid1, RDF.SUBJECT, (Value)sid2);
                buf.add((Resource)sid1, RDF.PREDICATE, (Value)RDF.TYPE);
                buf.add((Resource)sid1, RDF.OBJECT, (Value)B);
                buf.add((Resource)sid1, RDF.TYPE, (Value)B);
                buf.add((Resource)sid2, RDF.SUBJECT, (Value)sid1);
                buf.add((Resource)sid2, RDF.PREDICATE, (Value)RDF.TYPE);
                buf.add((Resource)sid2, RDF.OBJECT, (Value)B);
                buf.flush();
                TestStatementIdentifiers.fail((String)("Expecting: " + UnificationException.class));
            }
            catch (UnificationException ex) {
                System.err.println("Ignoring expected exception: " + (Object)((Object)ex));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_correctRejection_unificationError() {
        AbstractTripleStore store = this.getStore();
        try {
            if (!store.isStatementIdentifiers()) {
                log.warn((Object)"Statement identifiers are not enabled");
                return;
            }
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataBNode sid1 = f.createBNode("_S1");
            StatementBuffer buf = new StatementBuffer(store, 100);
            try {
                buf.add((Resource)A, RDF.TYPE, (Value)C2);
                buf.add((Resource)sid1, RDF.SUBJECT, (Value)A);
                buf.add((Resource)sid1, RDF.PREDICATE, (Value)RDF.TYPE);
                buf.add((Resource)sid1, RDF.OBJECT, (Value)C2);
                buf.add((Resource)B, RDF.TYPE, (Value)C2);
                buf.add((Resource)sid1, RDF.SUBJECT, (Value)B);
                buf.add((Resource)sid1, RDF.PREDICATE, (Value)RDF.TYPE);
                buf.add((Resource)sid1, RDF.OBJECT, (Value)C2);
                buf.flush();
                TestStatementIdentifiers.fail((String)("Expecting: " + UnificationException.class));
            }
            catch (UnificationException ex) {
                System.err.println("Ignoring expected exception: " + (Object)((Object)ex));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

