/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.btree.IIndex;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.store.BigdataTriplePattern;
import com.bigdata.rdf.util.DumpLexicon;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.FOAF;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;

public class TestTripleStore
extends AbstractTripleStoreTestCase {
    private static final Logger log = Logger.getLogger(TestTripleStore.class);

    public TestTripleStore() {
    }

    public TestTripleStore(String name) {
        super(name);
    }

    protected void doAddTermTest(AbstractTripleStore store, Value term) {
        TestTripleStore.assertEquals((Object)this.NULL, (Object)store.getIV(term));
        IV id = store.addTerm(term);
        TestTripleStore.assertNotSame((Object)this.NULL, (Object)id);
        if (term instanceof Literal) {
            TestTripleStore.assertTrue((String)"isLiteral()", (boolean)id.isLiteral());
            TestTripleStore.assertFalse((String)"isBNode()", (boolean)id.isBNode());
            TestTripleStore.assertFalse((String)"isURI()", (boolean)id.isURI());
            TestTripleStore.assertFalse((String)"isStatement()", (boolean)id.isStatement());
        } else if (term instanceof BNode) {
            TestTripleStore.assertFalse((String)"isLiteral()", (boolean)id.isLiteral());
            TestTripleStore.assertTrue((String)"isBNode()", (boolean)id.isBNode());
            TestTripleStore.assertFalse((String)"isURI()", (boolean)id.isURI());
            TestTripleStore.assertFalse((String)"isStatement()", (boolean)id.isStatement());
        } else if (term instanceof URI) {
            TestTripleStore.assertFalse((String)"isLiteral()", (boolean)id.isLiteral());
            TestTripleStore.assertFalse((String)"isBNode()", (boolean)id.isBNode());
            TestTripleStore.assertTrue((String)"isURI()", (boolean)id.isURI());
            TestTripleStore.assertFalse((String)"isStatement()", (boolean)id.isStatement());
        }
        if (store.getLexiconRelation().isStoreBlankNodes() || !(term instanceof BNode)) {
            IV actual = store.getIV(term);
            TestTripleStore.assertEquals((String)"forward mapping", (Object)id, (Object)actual);
        }
        if (!(term instanceof BNode)) {
            TestTripleStore.assertEquals((String)"reverse mapping", (Object)term, (Object)store.getTerm(id));
        }
        if (store.getLexiconRelation().isStoreBlankNodes() || !(term instanceof BNode)) {
            TestTripleStore.assertEquals((String)"add is not stable?", (Object)id, (Object)store.addTerm(term));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addTerm() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH, "0");
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doAddTermTest(store, (Value)new LiteralImpl("abc"));
            this.doAddTermTest(store, (Value)new LiteralImpl("abc", XMLSchema.STRING));
            this.doAddTermTest(store, (Value)new LiteralImpl("abc", "en"));
            this.doAddTermTest(store, (Value)new URIImpl("http://www.bigdata.com"));
            this.doAddTermTest(store, (Value)RDF.TYPE);
            this.doAddTermTest(store, (Value)RDFS.SUBCLASSOF);
            this.doAddTermTest(store, (Value)XMLSchema.DECIMAL);
            this.doAddTermTest(store, (Value)new BNodeImpl(UUID.randomUUID().toString()));
            this.doAddTermTest(store, (Value)new BNodeImpl("a12"));
            if (log.isInfoEnabled()) {
                log.info((Object)DumpLexicon.dump((LexiconRelation)store.getLexiconRelation()));
            }
            TestTripleStore.assertTrue((boolean)store.getIV((Value)new LiteralImpl("abc")).isLiteral());
            TestTripleStore.assertTrue((boolean)store.getIV((Value)new LiteralImpl("abc", XMLSchema.STRING)).isLiteral());
            TestTripleStore.assertTrue((boolean)store.getIV((Value)new LiteralImpl("abc", "en")).isLiteral());
            TestTripleStore.assertFalse((boolean)store.getIV((Value)new URIImpl("http://www.bigdata.com")).isLiteral());
            TestTripleStore.assertFalse((boolean)store.getIV((Value)RDF.TYPE).isLiteral());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addBadTerm() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.REJECT_INVALID_XSD_VALUES, "false");
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doAddTermTest(store, (Value)new LiteralImpl("abc", XMLSchema.DECIMAL));
            if (log.isInfoEnabled()) {
                log.info((Object)DumpLexicon.dump((LexiconRelation)store.getLexiconRelation()));
            }
            TestTripleStore.assertTrue((boolean)store.getIV((Value)new LiteralImpl("abc", XMLSchema.DECIMAL)).isLiteral());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_insertTerms() {
        AbstractTripleStore store = this.getStore();
        try {
            BigdataValueFactory valueFactory = store.getValueFactory();
            BigdataValue[] terms = new BigdataValue[]{valueFactory.createURI("http://www.bigdata.com"), valueFactory.createURI(RDF.TYPE.stringValue()), valueFactory.createURI(RDFS.SUBCLASSOF.stringValue()), valueFactory.createURI(XMLSchema.DECIMAL.stringValue()), valueFactory.createLiteral("abc"), valueFactory.createLiteral("abc", XMLSchema.STRING), valueFactory.createLiteral("abc", "en"), valueFactory.createBNode(UUID.randomUUID().toString()), valueFactory.createBNode("a12")};
            store.addTerms(terms);
            boolean storeBlankNodes = store.getLexiconRelation().isStoreBlankNodes();
            for (int i = 0; i < terms.length; ++i) {
                TestTripleStore.assertNotSame((Object)this.NULL, (Object)terms[i].getIV());
                IV termId = terms[i].getIV();
                terms[i].clearInternalValue();
                if (storeBlankNodes || !(terms[i] instanceof BNode)) {
                    TestTripleStore.assertEquals((String)"forward mapping", (Object)termId, (Object)store.getIV((Value)terms[i]));
                    TestTripleStore.assertEquals((Object)termId, (Object)terms[i].getIV());
                }
                if (terms[i] instanceof BNode) {
                    TestTripleStore.assertTrue((boolean)(store.getTerm(termId) instanceof BNode));
                    continue;
                }
                TestTripleStore.assertEquals((String)"reverse mapping", (Object)terms[i], (Object)store.getTerm(termId));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)DumpLexicon.dump((LexiconRelation)store.getLexiconRelation()));
            }
            TestTripleStore.assertTrue((boolean)store.getIV((Value)new LiteralImpl("abc")).isLiteral());
            TestTripleStore.assertTrue((boolean)store.getIV((Value)new LiteralImpl("abc", XMLSchema.STRING)).isLiteral());
            TestTripleStore.assertTrue((boolean)store.getIV((Value)new LiteralImpl("abc", "en")).isLiteral());
            TestTripleStore.assertFalse((boolean)store.getIV((Value)new URIImpl("http://www.bigdata.com")).isLiteral());
            TestTripleStore.assertFalse((boolean)store.getIV((Value)RDF.TYPE).isLiteral());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addTermsFiltersDuplicates() {
        AbstractTripleStore store = this.getStore();
        try {
            BigdataValueFactory valueFactory = store.getValueFactory();
            BigdataURI x = valueFactory.createURI("http://www.foo.org/x");
            BigdataURI y = valueFactory.createURI("http://www.foo.org/y");
            BigdataLiteral z = valueFactory.createLiteral("z");
            BigdataBNode b = valueFactory.createBNode();
            BigdataBNode c = valueFactory.createBNode("_c");
            store.addTerms(new BigdataValue[]{x, y, b, c, x, b, z, z, c, y, x});
            TestTripleStore.assertNotSame((Object)x.getIV(), (Object)this.NULL);
            TestTripleStore.assertNotSame((Object)y.getIV(), (Object)this.NULL);
            TestTripleStore.assertNotSame((Object)z.getIV(), (Object)this.NULL);
            TestTripleStore.assertNotSame((Object)b.getIV(), (Object)this.NULL);
            TestTripleStore.assertNotSame((Object)c.getIV(), (Object)this.NULL);
            TestTripleStore.assertNotSame((Object)x.getIV(), (Object)y.getIV());
            TestTripleStore.assertNotSame((Object)x.getIV(), (Object)z.getIV());
            TestTripleStore.assertNotSame((Object)x.getIV(), (Object)b.getIV());
            TestTripleStore.assertNotSame((Object)x.getIV(), (Object)c.getIV());
            TestTripleStore.assertNotSame((Object)y.getIV(), (Object)z.getIV());
            TestTripleStore.assertNotSame((Object)y.getIV(), (Object)b.getIV());
            TestTripleStore.assertNotSame((Object)y.getIV(), (Object)c.getIV());
            TestTripleStore.assertNotSame((Object)z.getIV(), (Object)b.getIV());
            TestTripleStore.assertNotSame((Object)z.getIV(), (Object)c.getIV());
            TestTripleStore.assertNotSame((Object)b.getIV(), (Object)c.getIV());
            TestTripleStore.assertTrue((boolean)x.getIV().isURI());
            TestTripleStore.assertTrue((boolean)y.getIV().isURI());
            TestTripleStore.assertTrue((boolean)z.getIV().isLiteral());
            TestTripleStore.assertTrue((boolean)b.getIV().isBNode());
            TestTripleStore.assertTrue((boolean)c.getIV().isBNode());
            TestTripleStore.assertEquals((Object)x, (Object)store.getTerm(x.getIV()));
            TestTripleStore.assertEquals((Object)y, (Object)store.getTerm(y.getIV()));
            TestTripleStore.assertEquals((Object)z, (Object)store.getTerm(z.getIV()));
            TestTripleStore.assertTrue((boolean)(store.getTerm(b.getIV()) instanceof BNode));
            TestTripleStore.assertTrue((boolean)(store.getTerm(c.getIV()) instanceof BNode));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addTermsFiltersAlreadyAssigned() {
        AbstractTripleStore store = this.getStore();
        try {
            BigdataValueFactory valueFactory = store.getValueFactory();
            BigdataURI x = valueFactory.createURI("http://www.foo.org/x");
            BigdataURI y = valueFactory.createURI("http://www.foo.org/y");
            BigdataLiteral z = valueFactory.createLiteral("z");
            store.addTerms(new BigdataValue[]{x, y, x, z, y, z});
            IV _x = x.getIV();
            IV _y = y.getIV();
            IV _z = z.getIV();
            TestTripleStore.assertNotSame((Object)x.getIV(), (Object)this.NULL);
            TestTripleStore.assertNotSame((Object)y.getIV(), (Object)this.NULL);
            TestTripleStore.assertNotSame((Object)z.getIV(), (Object)this.NULL);
            TestTripleStore.assertNotSame((Object)x.getIV(), (Object)y.getIV());
            TestTripleStore.assertNotSame((Object)x.getIV(), (Object)z.getIV());
            TestTripleStore.assertNotSame((Object)y.getIV(), (Object)z.getIV());
            TestTripleStore.assertTrue((boolean)x.getIV().isURI());
            TestTripleStore.assertTrue((boolean)y.getIV().isURI());
            TestTripleStore.assertTrue((boolean)z.getIV().isLiteral());
            TestTripleStore.assertEquals((Object)x, (Object)store.getTerm(x.getIV()));
            TestTripleStore.assertEquals((Object)y, (Object)store.getTerm(y.getIV()));
            TestTripleStore.assertEquals((Object)z, (Object)store.getTerm(z.getIV()));
            store.addTerms(new BigdataValue[]{x, y, x, z, y, z});
            TestTripleStore.assertEquals((Object)_x, (Object)x.getIV());
            TestTripleStore.assertEquals((Object)_y, (Object)y.getIV());
            TestTripleStore.assertEquals((Object)_z, (Object)z.getIV());
            BigdataURI x1 = valueFactory.createURI("http://www.foo.org/x");
            BigdataURI y1 = valueFactory.createURI("http://www.foo.org/y");
            BigdataLiteral z1 = valueFactory.createLiteral("z");
            store.addTerms(new BigdataValue[]{x1, y1, x1, z1, y1, z1});
            TestTripleStore.assertEquals((Object)_x, (Object)x1.getIV());
            TestTripleStore.assertEquals((Object)_y, (Object)y1.getIV());
            TestTripleStore.assertEquals((Object)_z, (Object)z1.getIV());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public void test_rangeCounts_toldBNodes() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH, "0");
        properties.setProperty(AbstractTripleStore.Options.INLINE_BNODES, "false");
        properties.setProperty(AbstractTripleStore.Options.INLINE_DATE_TIMES, "false");
        properties.setProperty(AbstractTripleStore.Options.STORE_BLANK_NODES, "true");
        this.doTestRangeCounts(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestRangeCounts(Properties properties) {
        AbstractTripleStore store = this.getStore(properties);
        try {
            boolean storeBlankNodes = store.getLexiconRelation().isStoreBlankNodes();
            int nuris = 9;
            URIImpl x = new URIImpl("http://www.foo.org/x");
            URIImpl y = new URIImpl("http://www.foo.org/y");
            URIImpl z = new URIImpl("http://www.foo.org/z");
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl B = new URIImpl("http://www.foo.org/B");
            URIImpl C2 = new URIImpl("http://www.foo.org/C");
            URI rdfType = RDF.TYPE;
            URI rdfsSubClassOf = RDFS.SUBCLASSOF;
            URIImpl big = new URIImpl(this.getVeryLargeURI());
            int nliterals = 4;
            LiteralImpl lit1 = new LiteralImpl("abc");
            LiteralImpl lit2 = new LiteralImpl("abc", (URI)A);
            LiteralImpl lit3 = new LiteralImpl("abc", "en");
            LiteralImpl lit5 = new LiteralImpl(this.getVeryLargeLiteral());
            int nbnodes = 3;
            BNodeImpl bn1 = new BNodeImpl(UUID.randomUUID().toString());
            BNodeImpl bn2 = new BNodeImpl("a12");
            BNodeImpl bn3 = new BNodeImpl(this.getVeryLargeLiteral());
            Value[] values = new Value[]{x, y, z, A, B, C2, big, rdfsSubClassOf, rdfType, lit1, lit2, lit3, lit5, bn1, bn2, bn3};
            BigdataValue[] terms = new BigdataValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                terms[i] = store.getLexiconRelation().getValueFactory().asValue(values[i]);
            }
            store.getLexiconRelation().addTerms(terms, terms.length, false);
            if (log.isInfoEnabled()) {
                log.info((Object)("#uris=" + store.getURICount()));
                log.info((Object)("#lits=" + store.getLiteralCount()));
                log.info((Object)("#bnds=" + store.getBNodeCount()));
                log.info((Object)("#vals=" + store.getTermCount()));
                log.info((Object)("\n" + DumpLexicon.dumpBlobs((String)store.getLexiconRelation().getNamespace(), (IIndex)store.getLexiconRelation().getBlobsIndex())));
            }
            TestTripleStore.assertEquals((String)"#uris", (long)9L, (long)store.getURICount());
            TestTripleStore.assertEquals((String)"#lits", (long)4L, (long)store.getLiteralCount());
            if (storeBlankNodes) {
                TestTripleStore.assertEquals((String)"#bnodes", (long)3L, (long)store.getBNodeCount());
            } else {
                TestTripleStore.assertEquals((String)"#bnodes", (long)0L, (long)store.getBNodeCount());
            }
            int nterms = 13 + (storeBlankNodes ? 3 : 0);
            TestTripleStore.assertEquals((String)"#terms", (long)nterms, (long)store.getTermCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_statements() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.STORE_BLANK_NODES, "false");
        AbstractTripleStore store = this.getStore(properties);
        try {
            boolean storeBlankNodes = store.getLexiconRelation().isStoreBlankNodes();
            URIImpl x = new URIImpl("http://www.foo.org/x");
            URIImpl y = new URIImpl("http://www.foo.org/y");
            URIImpl z = new URIImpl("http://www.foo.org/z");
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl B = new URIImpl("http://www.foo.org/B");
            URIImpl C2 = new URIImpl("http://www.foo.org/C");
            URI rdfType = RDF.TYPE;
            URI rdfsSubClassOf = RDFS.SUBCLASSOF;
            int nuris = 8;
            store.addStatement((Resource)x, rdfType, (Value)C2);
            store.addStatement((Resource)y, rdfType, (Value)B);
            store.addStatement((Resource)z, rdfType, (Value)A);
            store.addStatement((Resource)B, rdfsSubClassOf, (Value)A);
            store.addStatement((Resource)C2, rdfsSubClassOf, (Value)B);
            IV x_termId = store.getIV((Value)new URIImpl("http://www.foo.org/x"));
            TestTripleStore.assertTrue((x_termId != this.NULL ? 1 : 0) != 0);
            IV x_id = store.getIV((Value)x);
            TestTripleStore.assertTrue((x_id != this.NULL ? 1 : 0) != 0);
            TestTripleStore.assertEquals((Object)x_termId, (Object)x_id);
            IV y_id = store.getIV((Value)y);
            TestTripleStore.assertTrue((y_id != this.NULL ? 1 : 0) != 0);
            IV z_id = store.getIV((Value)z);
            TestTripleStore.assertTrue((z_id != this.NULL ? 1 : 0) != 0);
            IV A_id = store.getIV((Value)A);
            TestTripleStore.assertTrue((A_id != this.NULL ? 1 : 0) != 0);
            IV B_id = store.getIV((Value)B);
            TestTripleStore.assertTrue((B_id != this.NULL ? 1 : 0) != 0);
            IV C_id = store.getIV((Value)C2);
            TestTripleStore.assertTrue((C_id != this.NULL ? 1 : 0) != 0);
            IV rdfType_id = store.getIV((Value)rdfType);
            TestTripleStore.assertTrue((rdfType_id != this.NULL ? 1 : 0) != 0);
            IV rdfsSubClassOf_id = store.getIV((Value)rdfsSubClassOf);
            TestTripleStore.assertTrue((rdfsSubClassOf_id != this.NULL ? 1 : 0) != 0);
            LiteralImpl lit1 = new LiteralImpl("abc");
            LiteralImpl lit2 = new LiteralImpl("abc", (URI)A);
            LiteralImpl lit3 = new LiteralImpl("abc", "en");
            int nliterals = 3;
            IV lit1_id = store.addTerm((Value)lit1);
            TestTripleStore.assertTrue((lit1_id != this.NULL ? 1 : 0) != 0);
            IV lit2_id = store.addTerm((Value)lit2);
            TestTripleStore.assertTrue((lit2_id != this.NULL ? 1 : 0) != 0);
            IV lit3_id = store.addTerm((Value)lit3);
            TestTripleStore.assertTrue((lit3_id != this.NULL ? 1 : 0) != 0);
            BNodeImpl bn1 = new BNodeImpl(UUID.randomUUID().toString());
            BNodeImpl bn2 = new BNodeImpl("a12");
            int nbnodes = 2;
            IV bn1_id = store.addTerm((Value)bn1);
            TestTripleStore.assertTrue((bn1_id != this.NULL ? 1 : 0) != 0);
            IV bn2_id = store.addTerm((Value)bn2);
            TestTripleStore.assertTrue((bn2_id != this.NULL ? 1 : 0) != 0);
            if (log.isInfoEnabled()) {
                log.info((Object)bn1_id);
                log.info((Object)bn2_id);
                log.info((Object)storeBlankNodes);
            }
            TestTripleStore.assertEquals((Object)x_id, (Object)store.getIV((Value)x));
            TestTripleStore.assertEquals((Object)y_id, (Object)store.getIV((Value)y));
            TestTripleStore.assertEquals((Object)z_id, (Object)store.getIV((Value)z));
            TestTripleStore.assertEquals((Object)A_id, (Object)store.getIV((Value)A));
            TestTripleStore.assertEquals((Object)B_id, (Object)store.getIV((Value)B));
            TestTripleStore.assertEquals((Object)C_id, (Object)store.getIV((Value)C2));
            TestTripleStore.assertEquals((Object)rdfType_id, (Object)store.getIV((Value)rdfType));
            TestTripleStore.assertEquals((Object)rdfsSubClassOf_id, (Object)store.getIV((Value)rdfsSubClassOf));
            Iterator itr = store.getSPORelation().statementKeyOrderIterator();
            while (itr.hasNext()) {
                TestTripleStore.assertEquals((String)"statementCount", (long)5L, (long)store.getSPORelation().getIndex((IKeyOrder)itr.next()).rangeCount(null, null));
            }
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)x, rdfType, (Value)C2));
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)y, rdfType, (Value)B));
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)z, rdfType, (Value)A));
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)B, rdfsSubClassOf, (Value)A));
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)C2, rdfsSubClassOf, (Value)B));
            store.commit();
            itr = store.getSPORelation().statementKeyOrderIterator();
            while (itr.hasNext()) {
                TestTripleStore.assertEquals((String)"statementCount", (long)5L, (long)store.getSPORelation().getIndex((IKeyOrder)itr.next()).rangeCount(null, null));
            }
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)x, rdfType, (Value)C2));
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)y, rdfType, (Value)B));
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)z, rdfType, (Value)A));
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)B, rdfsSubClassOf, (Value)A));
            TestTripleStore.assertTrue((boolean)store.hasStatement((Resource)C2, rdfsSubClassOf, (Value)B));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addLookup_nativeAPI() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            TestTripleStore.assertSameIterator((Object[])new SPO[0], (Iterator)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            BigdataValueFactory valueFactory = store.getValueFactory();
            BigdataURI A = valueFactory.createURI("http://www.bigdata.com/A");
            BigdataURI B = valueFactory.createURI("http://www.bigdata.com/B");
            BigdataURI C2 = valueFactory.createURI("http://www.bigdata.com/C");
            BigdataURI rdfType = valueFactory.createURI(RDF.TYPE.stringValue());
            store.addTerms(new BigdataValue[]{A, B, C2, rdfType});
            store.addTerm((Value)A);
            store.addTerm((Value)B);
            store.addTerm((Value)C2);
            store.addTerm((Value)rdfType);
            SPO spo1 = new SPO((BigdataResource)A, rdfType, (BigdataValue)B, StatementEnum.Explicit);
            SPO spo2 = new SPO((BigdataResource)A, rdfType, (BigdataValue)C2, StatementEnum.Explicit);
            if (log.isInfoEnabled()) {
                log.info((Object)"adding statements");
                log.info((Object)("spo1: " + spo1));
                log.info((Object)("spo2: " + spo2));
            }
            TestTripleStore.assertEquals((String)"mutationCount", (long)2L, (long)store.addStatements((ISPO[])new SPO[]{spo1, spo2}, 2));
            TestTripleStore.assertEquals((String)"mutationCount", (long)0L, (long)store.addStatements((ISPO[])new SPO[]{spo1, spo2}, 2));
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
                log.info((Object)("\nSPO\n" + store.getSPORelation().dump((IKeyOrder)SPOKeyOrder.SPO)));
                log.info((Object)("\nPOS\n" + store.getSPORelation().dump((IKeyOrder)SPOKeyOrder.POS)));
                log.info((Object)("\nOSP\n" + store.getSPORelation().dump((IKeyOrder)SPOKeyOrder.OSP)));
            }
            TestTripleStore.assertEquals((long)2L, (long)store.getSPORelation().getIndex((IKeyOrder)SPOKeyOrder.SPO).rangeCount());
            TestTripleStore.assertEquals((long)2L, (long)store.getSPORelation().getIndex((IKeyOrder)SPOKeyOrder.POS).rangeCount());
            TestTripleStore.assertEquals((long)2L, (long)store.getSPORelation().getIndex((IKeyOrder)SPOKeyOrder.OSP).rangeCount());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{spo1, spo2}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(spo1.s, this.NULL, this.NULL).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{spo1, spo2}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, spo1.p, this.NULL).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{spo1}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, spo1.o).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{spo2}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, spo2.o).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{spo1, spo2}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            log.info((Object)"Removing 1st statement.");
            TestTripleStore.assertEquals((long)1L, (long)store.getAccessPath(spo1.s, spo1.p, spo1.o).removeAll());
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
                log.info((Object)("\nSPO\n" + store.getSPORelation().dump((IKeyOrder)SPOKeyOrder.SPO)));
                log.info((Object)("\nPOS\n" + store.getSPORelation().dump((IKeyOrder)SPOKeyOrder.POS)));
                log.info((Object)("\nOSP\n" + store.getSPORelation().dump((IKeyOrder)SPOKeyOrder.OSP)));
            }
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{spo2}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(spo1.s, this.NULL, this.NULL).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{spo2}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, spo1.p, this.NULL).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[0], (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, spo1.o).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{spo2}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            log.info((Object)"Removing all statements.");
            TestTripleStore.assertEquals((long)1L, (long)store.getAccessPath(this.NULL, this.NULL, this.NULL).removeAll());
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
                log.info((Object)("\nSPO\n" + store.getSPORelation().dump((IKeyOrder)SPOKeyOrder.SPO)));
                log.info((Object)("\nPOS\n" + store.getSPORelation().dump((IKeyOrder)SPOKeyOrder.POS)));
                log.info((Object)("\nOSP\n" + store.getSPORelation().dump((IKeyOrder)SPOKeyOrder.OSP)));
            }
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[0], (IChunkedOrderedIterator<ISPO>)store.getAccessPath(spo2.s, this.NULL, this.NULL).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[0], (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, spo2.p, this.NULL).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[0], (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, spo2.o).iterator());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[0], (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addRemove_nativeAPI() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            TestTripleStore.assertSameIterator((Object[])new SPO[0], (Iterator)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.bigdata.com/A");
            BigdataURI B = f.createURI("http://www.bigdata.com/B");
            BigdataURI C2 = f.createURI("http://www.bigdata.com/C");
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            store.addTerms(new BigdataValue[]{A, B, C2, rdfType});
            StatementBuffer buffer = new StatementBuffer(store, 2);
            buffer.add((Resource)A, (URI)rdfType, (Value)B);
            buffer.add((Resource)A, (URI)rdfType, (Value)C2);
            buffer.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
            }
            TestTripleStore.assertTrue((boolean)new SPO((BigdataResource)A, rdfType, (BigdataValue)B, StatementEnum.Explicit).isFullyBound());
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{new SPO((BigdataResource)A, rdfType, (BigdataValue)B, StatementEnum.Explicit), new SPO((BigdataResource)A, rdfType, (BigdataValue)C2, StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            TestTripleStore.assertEquals((long)1L, (long)store.getAccessPath(this.NULL, this.NULL, store.getIV((Value)B)).removeAll());
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
            }
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{new SPO((BigdataResource)A, rdfType, (BigdataValue)C2, StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addInferredExplicitAxiom() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI v1 = f.createURI("http://www.bigdata.com/1");
            BigdataURI v2 = f.createURI("http://www.bigdata.com/2");
            BigdataURI v3 = f.createURI("http://www.bigdata.com/3");
            store.addTerms(new BigdataValue[]{v1, v2, v3});
            SPO[] a = new SPO[]{new SPO((BigdataResource)v1, v2, (BigdataValue)v3, StatementEnum.Explicit), new SPO((BigdataResource)v2, v2, (BigdataValue)v3, StatementEnum.Inferred), new SPO((BigdataResource)v3, v2, (BigdataValue)v3, StatementEnum.Axiom)};
            store.addStatements((ISPO[])a, a.length);
            TestTripleStore.assertSameSPOs((ISPO[])new SPO[]{new SPO((BigdataResource)v1, v2, (BigdataValue)v3, StatementEnum.Explicit), new SPO((BigdataResource)v2, v2, (BigdataValue)v3, StatementEnum.Inferred), new SPO((BigdataResource)v3, v2, (BigdataValue)v3, StatementEnum.Axiom)}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addRemove_sesameAPI() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            TestTripleStore.assertSameIterator((Object[])new Statement[0], (Iterator)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.bigdata.com/A");
            BigdataURI B = f.createURI("http://www.bigdata.com/B");
            BigdataURI C2 = f.createURI("http://www.bigdata.com/C");
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)A, (URI)rdfType, (Value)B);
            buffer.add((Resource)A, (URI)rdfType, (Value)C2);
            buffer.flush();
            TestTripleStore.assertSameStatements(new Statement[]{new StatementImpl((Resource)A, RDF.TYPE, (Value)B), new StatementImpl((Resource)A, RDF.TYPE, (Value)C2)}, store.getStatements(null, null, null));
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
            }
            TestTripleStore.assertEquals((long)1L, (long)store.removeStatements(null, null, (Value)B));
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
            }
            TestTripleStore.assertSameStatements(new Statement[]{new StatementImpl((Resource)A, (URI)rdfType, (Value)C2)}, store.getStatements(null, null, null));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_removeStatements() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI x = f.createURI("http://www.foo.org/x1");
            BigdataURI y = f.createURI("http://www.foo.org/y2");
            BigdataURI z = f.createURI("http://www.foo.org/z3");
            store.addTerms(new BigdataValue[]{x, y, z});
            IV x1 = x.getIV();
            IV y2 = y.getIV();
            IV z3 = z.getIV();
            TestTripleStore.assertSameIterator((Object[])new Statement[0], (Iterator)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            SPO[] a = new SPO[]{new SPO(x1, y2, z3, StatementEnum.Explicit), new SPO(y2, y2, z3, StatementEnum.Explicit)};
            store.addStatements((ISPO[])a, a.length);
            TestTripleStore.assertTrue((boolean)store.hasStatement(x1, y2, z3));
            TestTripleStore.assertTrue((boolean)store.hasStatement(y2, y2, z3));
            TestTripleStore.assertEquals((long)2L, (long)store.getStatementCount());
            TestTripleStore.assertEquals((long)1L, (long)store.removeStatements((IChunkedOrderedIterator)new ChunkedArrayIterator(1, (Object[])new SPO[]{new SPO(x1, y2, z3, StatementEnum.Explicit)}, null), false));
            TestTripleStore.assertFalse((boolean)store.hasStatement(x1, y2, z3));
            TestTripleStore.assertTrue((boolean)store.hasStatement(y2, y2, z3));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getStatementsUsingTriplePatterns() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            TestTripleStore.assertSameIterator((Object[])new Statement[0], (Iterator)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.bigdata.com/A");
            BigdataURI B = f.createURI("http://www.bigdata.com/B");
            BigdataURI C2 = f.createURI("http://www.bigdata.com/C");
            BigdataURI Person = f.asValue(FOAF.PERSON);
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI foafKnows = f.asValue(FOAF.KNOWS);
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)A, (URI)rdfType, (Value)Person);
            buffer.add((Resource)B, (URI)rdfType, (Value)Person);
            buffer.add((Resource)C2, (URI)rdfType, (Value)Person);
            buffer.add((Resource)A, (URI)foafKnows, (Value)B);
            buffer.add((Resource)B, (URI)foafKnows, (Value)A);
            buffer.add((Resource)B, (URI)foafKnows, (Value)C2);
            buffer.add((Resource)C2, (URI)foafKnows, (Value)B);
            buffer.flush();
            Object[] triplePatterns = new BigdataTriplePattern[]{};
            TestTripleStore.assertSameStatements(new Statement[0], store.getStatements((IChunkedOrderedIterator)new ChunkedArrayIterator(triplePatterns)));
            triplePatterns = new BigdataTriplePattern[]{new BigdataTriplePattern((Resource)A, (URI)rdfType, null)};
            TestTripleStore.assertSameStatements(new Statement[]{new StatementImpl((Resource)A, (URI)rdfType, (Value)Person)}, store.getStatements((IChunkedOrderedIterator)new ChunkedArrayIterator(triplePatterns)));
            triplePatterns = new BigdataTriplePattern[]{new BigdataTriplePattern(null, (URI)rdfType, (Value)Person)};
            TestTripleStore.assertSameStatements(new Statement[]{new StatementImpl((Resource)A, (URI)rdfType, (Value)Person), new StatementImpl((Resource)B, (URI)rdfType, (Value)Person), new StatementImpl((Resource)C2, (URI)rdfType, (Value)Person)}, store.getStatements((IChunkedOrderedIterator)new ChunkedArrayIterator(triplePatterns)));
            triplePatterns = new BigdataTriplePattern[]{new BigdataTriplePattern((Resource)A, (URI)foafKnows, null), new BigdataTriplePattern(null, (URI)rdfType, (Value)Person)};
            TestTripleStore.assertSameIteratorAnyOrder((Object[])new Statement[]{new StatementImpl((Resource)A, (URI)foafKnows, (Value)B), new StatementImpl((Resource)A, (URI)rdfType, (Value)Person), new StatementImpl((Resource)B, (URI)rdfType, (Value)Person), new StatementImpl((Resource)C2, (URI)rdfType, (Value)Person)}, (Iterator)store.getStatements((IChunkedOrderedIterator)new ChunkedArrayIterator(triplePatterns)));
            triplePatterns = new BigdataTriplePattern[]{new BigdataTriplePattern((Resource)A, (URI)foafKnows, null), new BigdataTriplePattern(null, (URI)rdfType, (Value)Person), new BigdataTriplePattern((Resource)rdfType, (URI)foafKnows, null)};
            TestTripleStore.assertSameIteratorAnyOrder((Object[])new Statement[]{new StatementImpl((Resource)A, (URI)foafKnows, (Value)B), new StatementImpl((Resource)A, (URI)rdfType, (Value)Person), new StatementImpl((Resource)B, (URI)rdfType, (Value)Person), new StatementImpl((Resource)C2, (URI)rdfType, (Value)Person)}, (Iterator)store.getStatements((IChunkedOrderedIterator)new ChunkedArrayIterator(triplePatterns)));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    private String getVeryLargeURI() {
        int len = 1024000;
        StringBuilder sb = new StringBuilder(1024020);
        sb.append("http://www.bigdata.com/");
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        String s = sb.toString();
        return s;
    }

    private String getVeryLargeLiteral() {
        int len = 1024000;
        StringBuilder sb = new StringBuilder(1024000);
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        String s = sb.toString();
        return s;
    }
}

